/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.observability.action;

import java.io.IOException;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.ValidateActions;
import org.opensearch.common.Strings;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.io.stream.Writeable;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.ToXContentObject;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.common.xcontent.XContentParserUtils;
import org.opensearch.commons.utils.HelpersKt;
import org.opensearch.commons.utils.XContentHelpersKt;
import org.opensearch.observability.model.BaseObjectData;
import org.opensearch.observability.model.ObservabilityObjectDataProperties;
import org.opensearch.observability.model.ObservabilityObjectType;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u001e2\u00020\u00012\u00020\u0002:\u0001\u001eB\u001f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB\u000f\b\u0016\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u001c\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00142\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\n\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016R\u0013\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001f"}, d2={"Lorg/opensearch/observability/action/UpdateObservabilityObjectRequest;", "Lorg/opensearch/action/ActionRequest;", "Lorg/opensearch/common/xcontent/ToXContentObject;", "objectData", "Lorg/opensearch/observability/model/BaseObjectData;", "type", "Lorg/opensearch/observability/model/ObservabilityObjectType;", "objectId", "", "(Lorg/opensearch/observability/model/BaseObjectData;Lorg/opensearch/observability/model/ObservabilityObjectType;Ljava/lang/String;)V", "input", "Lorg/opensearch/common/io/stream/StreamInput;", "(Lorg/opensearch/common/io/stream/StreamInput;)V", "getObjectData", "()Lorg/opensearch/observability/model/BaseObjectData;", "getObjectId", "()Ljava/lang/String;", "getType", "()Lorg/opensearch/observability/model/ObservabilityObjectType;", "toXContent", "Lorg/opensearch/common/xcontent/XContentBuilder;", "builder", "params", "Lorg/opensearch/common/xcontent/ToXContent$Params;", "validate", "Lorg/opensearch/action/ActionRequestValidationException;", "writeTo", "", "output", "Lorg/opensearch/common/io/stream/StreamOutput;", "Companion", "opensearch-observability"})
public final class UpdateObservabilityObjectRequest
extends ActionRequest
implements ToXContentObject {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String objectId;
    @NotNull
    private final ObservabilityObjectType type;
    @Nullable
    private final BaseObjectData objectData;
    @NotNull
    private static final Lazy<Logger> log$delegate = HelpersKt.logger(UpdateObservabilityObjectRequest.class);
    @NotNull
    private static final Writeable.Reader<UpdateObservabilityObjectRequest> reader = UpdateObservabilityObjectRequest::reader$lambda-0;

    @NotNull
    public final String getObjectId() {
        return this.objectId;
    }

    @NotNull
    public final ObservabilityObjectType getType() {
        return this.type;
    }

    @Nullable
    public final BaseObjectData getObjectData() {
        return this.objectData;
    }

    @NotNull
    public XContentBuilder toXContent(@Nullable XContentBuilder builder, @Nullable ToXContent.Params params) {
        Intrinsics.checkNotNull((Object)builder);
        XContentBuilder xContentBuilder = builder.startObject();
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"builder.startObject()");
        XContentBuilder xContentBuilder2 = XContentHelpersKt.fieldIfNotNull((XContentBuilder)xContentBuilder, (String)"objectId", (Object)this.objectId).field(this.type.getTag(), (ToXContent)this.objectData).endObject();
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder2, (String)"builder.startObject()\n  \u2026\n            .endObject()");
        return xContentBuilder2;
    }

    public UpdateObservabilityObjectRequest(@NotNull BaseObjectData objectData, @NotNull ObservabilityObjectType type, @NotNull String objectId) {
        Intrinsics.checkNotNullParameter((Object)objectData, (String)"objectData");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)objectId, (String)"objectId");
        this.objectData = objectData;
        this.type = type;
        this.objectId = objectId;
    }

    public UpdateObservabilityObjectRequest(@NotNull StreamInput input) throws IOException {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        super(input);
        Object object = input.readString();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"input.readString()");
        this.objectId = object;
        object = input.readEnum(ObservabilityObjectType.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"input.readEnum(Observabi\u2026tyObjectType::class.java)");
        this.type = (ObservabilityObjectType)((Object)object);
        object = input.readEnum(ObservabilityObjectType.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"input.readEnum(\n        \u2026ss.java\n                )");
        this.objectData = (BaseObjectData)input.readOptionalWriteable(ObservabilityObjectDataProperties.INSTANCE.getReaderForObjectType((ObservabilityObjectType)((Object)object)));
    }

    public void writeTo(@NotNull StreamOutput output) throws IOException {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        super.writeTo(output);
        output.writeString(this.objectId);
        output.writeEnum((Enum)this.type);
        output.writeEnum((Enum)this.type);
        output.writeOptionalWriteable((Writeable)this.objectData);
    }

    @Nullable
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (Strings.isNullOrEmpty((String)this.objectId)) {
            validationException = ValidateActions.addValidationError((String)"objectId is null or empty", validationException);
        }
        return validationException;
    }

    private static final UpdateObservabilityObjectRequest reader$lambda-0(StreamInput it) {
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        return new UpdateObservabilityObjectRequest(it);
    }

    @JvmStatic
    @NotNull
    public static final UpdateObservabilityObjectRequest parse(@NotNull XContentParser parser, @Nullable String id) throws IOException {
        return Companion.parse(parser, id);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0007R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u001f\u0010\t\u001a\u0010\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0014"}, d2={"Lorg/opensearch/observability/action/UpdateObservabilityObjectRequest$Companion;", "", "()V", "log", "Lorg/apache/logging/log4j/Logger;", "getLog", "()Lorg/apache/logging/log4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "reader", "Lorg/opensearch/common/io/stream/Writeable$Reader;", "Lorg/opensearch/observability/action/UpdateObservabilityObjectRequest;", "kotlin.jvm.PlatformType", "getReader", "()Lorg/opensearch/common/io/stream/Writeable$Reader;", "parse", "parser", "Lorg/opensearch/common/xcontent/XContentParser;", "id", "", "opensearch-observability"})
    public static final class Companion {
        private Companion() {
        }

        private final Logger getLog() {
            Lazy lazy = log$delegate;
            return (Logger)lazy.getValue();
        }

        @NotNull
        public final Writeable.Reader<UpdateObservabilityObjectRequest> getReader() {
            return reader;
        }

        @JvmStatic
        @NotNull
        public final UpdateObservabilityObjectRequest parse(@NotNull XContentParser parser, @Nullable String id) throws IOException {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            String objectId = id;
            ObservabilityObjectType type = null;
            BaseObjectData baseObjectData = null;
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
            while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                String fieldName = parser.currentName();
                parser.nextToken();
                if (Intrinsics.areEqual((Object)fieldName, (Object)"objectId")) {
                    objectId = parser.text();
                    continue;
                }
                Intrinsics.checkNotNullExpressionValue((Object)fieldName, (String)"fieldName");
                ObservabilityObjectType objectTypeForTag = ObservabilityObjectType.Companion.fromTagOrDefault(fieldName);
                if (objectTypeForTag != ObservabilityObjectType.NONE && baseObjectData == null) {
                    baseObjectData = ObservabilityObjectDataProperties.INSTANCE.createObjectData(objectTypeForTag, parser);
                    type = objectTypeForTag;
                    continue;
                }
                parser.skipChildren();
                this.getLog().info("Unexpected field: " + fieldName + ", while parsing CreateObservabilityObjectRequest");
            }
            if (objectId == null) {
                throw new IllegalArgumentException("objectId field absent");
            }
            if (type == null) {
                throw new IllegalArgumentException("Object type field absent");
            }
            if (baseObjectData == null) {
                throw new IllegalArgumentException("Object data field absent");
            }
            return new UpdateObservabilityObjectRequest(baseObjectData, type, objectId);
        }

        public static /* synthetic */ UpdateObservabilityObjectRequest parse$default(Companion companion, XContentParser xContentParser, String string, int n, Object object) throws IOException {
            if ((n & 2) != 0) {
                string = null;
            }
            return companion.parse(xContentParser, string);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

