/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.painless.phase;

import java.lang.constant.Constable;
import java.lang.reflect.Modifier;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.opensearch.painless.AnalyzerCaster;
import org.opensearch.painless.CompilerSettings;
import org.opensearch.painless.FunctionRef;
import org.opensearch.painless.Location;
import org.opensearch.painless.Operation;
import org.opensearch.painless.lookup.PainlessCast;
import org.opensearch.painless.lookup.PainlessClassBinding;
import org.opensearch.painless.lookup.PainlessConstructor;
import org.opensearch.painless.lookup.PainlessField;
import org.opensearch.painless.lookup.PainlessInstanceBinding;
import org.opensearch.painless.lookup.PainlessLookupUtility;
import org.opensearch.painless.lookup.PainlessMethod;
import org.opensearch.painless.lookup.def;
import org.opensearch.painless.node.AExpression;
import org.opensearch.painless.node.ANode;
import org.opensearch.painless.node.AStatement;
import org.opensearch.painless.node.EAssignment;
import org.opensearch.painless.node.EBinary;
import org.opensearch.painless.node.EBooleanComp;
import org.opensearch.painless.node.EBooleanConstant;
import org.opensearch.painless.node.EBrace;
import org.opensearch.painless.node.ECall;
import org.opensearch.painless.node.ECallLocal;
import org.opensearch.painless.node.EComp;
import org.opensearch.painless.node.EConditional;
import org.opensearch.painless.node.EDecimal;
import org.opensearch.painless.node.EDot;
import org.opensearch.painless.node.EElvis;
import org.opensearch.painless.node.EExplicit;
import org.opensearch.painless.node.EFunctionRef;
import org.opensearch.painless.node.EInstanceof;
import org.opensearch.painless.node.ELambda;
import org.opensearch.painless.node.EListInit;
import org.opensearch.painless.node.EMapInit;
import org.opensearch.painless.node.ENewArray;
import org.opensearch.painless.node.ENewArrayFunctionRef;
import org.opensearch.painless.node.ENewObj;
import org.opensearch.painless.node.ENull;
import org.opensearch.painless.node.ENumeric;
import org.opensearch.painless.node.ERegex;
import org.opensearch.painless.node.EString;
import org.opensearch.painless.node.ESymbol;
import org.opensearch.painless.node.EUnary;
import org.opensearch.painless.node.SBlock;
import org.opensearch.painless.node.SBreak;
import org.opensearch.painless.node.SCatch;
import org.opensearch.painless.node.SClass;
import org.opensearch.painless.node.SContinue;
import org.opensearch.painless.node.SDeclBlock;
import org.opensearch.painless.node.SDeclaration;
import org.opensearch.painless.node.SDo;
import org.opensearch.painless.node.SEach;
import org.opensearch.painless.node.SExpression;
import org.opensearch.painless.node.SFor;
import org.opensearch.painless.node.SFunction;
import org.opensearch.painless.node.SIf;
import org.opensearch.painless.node.SIfElse;
import org.opensearch.painless.node.SReturn;
import org.opensearch.painless.node.SThrow;
import org.opensearch.painless.node.STry;
import org.opensearch.painless.node.SWhile;
import org.opensearch.painless.phase.UserTreeBaseVisitor;
import org.opensearch.painless.spi.annotation.NonDeterministicAnnotation;
import org.opensearch.painless.symbol.Decorations;
import org.opensearch.painless.symbol.FunctionTable;
import org.opensearch.painless.symbol.ScriptScope;
import org.opensearch.painless.symbol.SemanticScope;

public class DefaultSemanticAnalysisPhase
extends UserTreeBaseVisitor<SemanticScope> {
    public void decorateWithCast(AExpression userExpressionNode, SemanticScope semanticScope) {
        boolean isInternalCast;
        boolean isExplicitCast;
        Class<?> targetType;
        Class<?> valueType;
        Location location = userExpressionNode.getLocation();
        PainlessCast painlessCast = AnalyzerCaster.getLegalCast(location, valueType = semanticScope.getDecoration(userExpressionNode, Decorations.ValueType.class).getValueType(), targetType = semanticScope.getDecoration(userExpressionNode, Decorations.TargetType.class).getTargetType(), isExplicitCast = semanticScope.getCondition(userExpressionNode, Decorations.Explicit.class), isInternalCast = semanticScope.getCondition(userExpressionNode, Decorations.Internal.class));
        if (painlessCast != null) {
            semanticScope.putDecoration(userExpressionNode, new Decorations.ExpressionPainlessCast(painlessCast));
        }
    }

    public void visit(ANode userNode, SemanticScope semanticScope) {
        if (userNode != null) {
            userNode.visit(this, semanticScope);
        }
    }

    public void checkedVisit(AExpression userExpressionNode, SemanticScope semanticScope) {
        if (userExpressionNode != null) {
            userExpressionNode.visit(this, semanticScope);
            if (semanticScope.hasDecoration(userExpressionNode, Decorations.PartialCanonicalTypeName.class)) {
                throw userExpressionNode.createError(new IllegalArgumentException("cannot resolve symbol [" + semanticScope.getDecoration(userExpressionNode, Decorations.PartialCanonicalTypeName.class).getPartialCanonicalTypeName() + "]"));
            }
            if (semanticScope.hasDecoration(userExpressionNode, Decorations.StaticType.class)) {
                throw userExpressionNode.createError(new IllegalArgumentException("value required: instead found unexpected type [" + semanticScope.getDecoration(userExpressionNode, Decorations.StaticType.class).getStaticCanonicalTypeName() + "]"));
            }
            if (!semanticScope.hasDecoration(userExpressionNode, Decorations.ValueType.class)) {
                throw userExpressionNode.createError(new IllegalStateException("value required: instead found no value"));
            }
        }
    }

    @Override
    public void visitClass(SClass userClassNode, ScriptScope scriptScope) {
        for (SFunction userFunctionNode : userClassNode.getFunctionNodes()) {
            this.visitFunction(userFunctionNode, scriptScope);
        }
    }

    @Override
    public void visitFunction(SFunction userFunctionNode, ScriptScope scriptScope) {
        String functionName = userFunctionNode.getFunctionName();
        FunctionTable.LocalFunction localFunction = scriptScope.getFunctionTable().getFunction(functionName, userFunctionNode.getCanonicalTypeNameParameters().size());
        Class<?> returnType = localFunction.getReturnType();
        List<Class<?>> typeParameters = localFunction.getTypeParameters();
        SemanticScope.FunctionScope functionScope = SemanticScope.newFunctionScope(scriptScope, localFunction.getReturnType());
        for (int index = 0; index < localFunction.getTypeParameters().size(); ++index) {
            Class<?> typeParameter = localFunction.getTypeParameters().get(index);
            String parameterName = userFunctionNode.getParameterNames().get(index);
            functionScope.defineVariable(userFunctionNode.getLocation(), typeParameter, parameterName, false);
        }
        SBlock userBlockNode = userFunctionNode.getBlockNode();
        if (userBlockNode.getStatementNodes().isEmpty()) {
            throw userFunctionNode.createError(new IllegalArgumentException("invalid function definition: found no statements for function [" + functionName + "] with [" + typeParameters.size() + "] parameters"));
        }
        functionScope.setCondition(userBlockNode, Decorations.LastSource.class);
        this.visit(userBlockNode, functionScope.newLocalScope());
        boolean methodEscape = functionScope.getCondition(userBlockNode, Decorations.MethodEscape.class);
        boolean isAutoReturnEnabled = userFunctionNode.isAutoReturnEnabled();
        if (!methodEscape && !isAutoReturnEnabled && returnType != Void.TYPE) {
            throw userFunctionNode.createError(new IllegalArgumentException("invalid function definition: not all paths provide a return value for function [" + functionName + "] with [" + typeParameters.size() + "] parameters"));
        }
        if (methodEscape) {
            functionScope.setCondition(userFunctionNode, Decorations.MethodEscape.class);
        }
    }

    @Override
    public void visitBlock(SBlock userBlockNode, SemanticScope semanticScope) {
        List<AStatement> userStatementNodes = userBlockNode.getStatementNodes();
        if (userStatementNodes.isEmpty()) {
            throw userBlockNode.createError(new IllegalArgumentException("invalid block: found no statements"));
        }
        AStatement lastUserStatement = userStatementNodes.get(userStatementNodes.size() - 1);
        boolean lastSource = semanticScope.getCondition(userBlockNode, Decorations.LastSource.class);
        boolean beginLoop = semanticScope.getCondition(userBlockNode, Decorations.BeginLoop.class);
        boolean inLoop = semanticScope.getCondition(userBlockNode, Decorations.InLoop.class);
        boolean lastLoop = semanticScope.getCondition(userBlockNode, Decorations.LastLoop.class);
        boolean anyContinue = false;
        boolean anyBreak = false;
        for (AStatement userStatementNode : userStatementNodes) {
            if (inLoop) {
                semanticScope.setCondition(userStatementNode, Decorations.InLoop.class);
            }
            if (userStatementNode == lastUserStatement) {
                if (beginLoop || lastLoop) {
                    semanticScope.setCondition(userStatementNode, Decorations.LastLoop.class);
                }
                if (lastSource) {
                    semanticScope.setCondition(userStatementNode, Decorations.LastSource.class);
                }
            }
            this.visit(userStatementNode, semanticScope);
            boolean allEscape = semanticScope.getCondition(userStatementNode, Decorations.AllEscape.class);
            if (userStatementNode == lastUserStatement) {
                semanticScope.replicateCondition(userStatementNode, userBlockNode, Decorations.MethodEscape.class);
                semanticScope.replicateCondition(userStatementNode, userBlockNode, Decorations.LoopEscape.class);
                if (allEscape) {
                    semanticScope.setCondition(userBlockNode, Decorations.AllEscape.class);
                }
            } else if (allEscape) {
                throw userBlockNode.createError(new IllegalArgumentException("invalid block: unreachable statement"));
            }
            anyContinue |= semanticScope.getCondition(userStatementNode, Decorations.AnyContinue.class);
            anyBreak |= semanticScope.getCondition(userStatementNode, Decorations.AnyBreak.class);
        }
        if (anyContinue) {
            semanticScope.setCondition(userBlockNode, Decorations.AnyContinue.class);
        }
        if (anyBreak) {
            semanticScope.setCondition(userBlockNode, Decorations.AnyBreak.class);
        }
    }

    @Override
    public void visitIf(SIf userIfNode, SemanticScope semanticScope) {
        AExpression userConditionNode = userIfNode.getConditionNode();
        semanticScope.setCondition(userConditionNode, Decorations.Read.class);
        semanticScope.putDecoration(userConditionNode, new Decorations.TargetType(Boolean.TYPE));
        this.checkedVisit(userConditionNode, semanticScope);
        this.decorateWithCast(userConditionNode, semanticScope);
        SBlock userIfBlockNode = userIfNode.getIfBlockNode();
        if (userConditionNode instanceof EBooleanConstant || userIfBlockNode == null) {
            throw userIfNode.createError(new IllegalArgumentException("extraneous if block"));
        }
        semanticScope.replicateCondition(userIfNode, userIfBlockNode, Decorations.LastSource.class);
        semanticScope.replicateCondition(userIfNode, userIfBlockNode, Decorations.InLoop.class);
        semanticScope.replicateCondition(userIfNode, userIfBlockNode, Decorations.LastLoop.class);
        this.visit(userIfBlockNode, semanticScope.newLocalScope());
        semanticScope.replicateCondition(userIfBlockNode, userIfNode, Decorations.AnyContinue.class);
        semanticScope.replicateCondition(userIfBlockNode, userIfNode, Decorations.AnyBreak.class);
    }

    @Override
    public void visitIfElse(SIfElse userIfElseNode, SemanticScope semanticScope) {
        AExpression userConditionNode = userIfElseNode.getConditionNode();
        semanticScope.setCondition(userConditionNode, Decorations.Read.class);
        semanticScope.putDecoration(userConditionNode, new Decorations.TargetType(Boolean.TYPE));
        this.checkedVisit(userConditionNode, semanticScope);
        this.decorateWithCast(userConditionNode, semanticScope);
        SBlock userIfBlockNode = userIfElseNode.getIfBlockNode();
        if (userConditionNode instanceof EBooleanConstant || userIfBlockNode == null) {
            throw userIfElseNode.createError(new IllegalArgumentException("extraneous if block"));
        }
        semanticScope.replicateCondition(userIfElseNode, userIfBlockNode, Decorations.LastSource.class);
        semanticScope.replicateCondition(userIfElseNode, userIfBlockNode, Decorations.InLoop.class);
        semanticScope.replicateCondition(userIfElseNode, userIfBlockNode, Decorations.LastLoop.class);
        this.visit(userIfBlockNode, semanticScope.newLocalScope());
        SBlock userElseBlockNode = userIfElseNode.getElseBlockNode();
        if (userElseBlockNode == null) {
            throw userIfElseNode.createError(new IllegalArgumentException("extraneous else block."));
        }
        semanticScope.replicateCondition(userIfElseNode, userElseBlockNode, Decorations.LastSource.class);
        semanticScope.replicateCondition(userIfElseNode, userElseBlockNode, Decorations.InLoop.class);
        semanticScope.replicateCondition(userIfElseNode, userElseBlockNode, Decorations.LastLoop.class);
        this.visit(userElseBlockNode, semanticScope.newLocalScope());
        if (semanticScope.getCondition(userIfBlockNode, Decorations.MethodEscape.class) && semanticScope.getCondition(userElseBlockNode, Decorations.MethodEscape.class)) {
            semanticScope.setCondition(userIfElseNode, Decorations.MethodEscape.class);
        }
        if (semanticScope.getCondition(userIfBlockNode, Decorations.LoopEscape.class) && semanticScope.getCondition(userElseBlockNode, Decorations.LoopEscape.class)) {
            semanticScope.setCondition(userIfElseNode, Decorations.LoopEscape.class);
        }
        if (semanticScope.getCondition(userIfBlockNode, Decorations.AllEscape.class) && semanticScope.getCondition(userElseBlockNode, Decorations.AllEscape.class)) {
            semanticScope.setCondition(userIfElseNode, Decorations.AllEscape.class);
        }
        if (semanticScope.getCondition(userIfBlockNode, Decorations.AnyContinue.class) || semanticScope.getCondition(userElseBlockNode, Decorations.AnyContinue.class)) {
            semanticScope.setCondition(userIfElseNode, Decorations.AnyContinue.class);
        }
        if (semanticScope.getCondition(userIfBlockNode, Decorations.AnyBreak.class) || semanticScope.getCondition(userElseBlockNode, Decorations.AnyBreak.class)) {
            semanticScope.setCondition(userIfElseNode, Decorations.AnyBreak.class);
        }
    }

    @Override
    public void visitWhile(SWhile userWhileNode, SemanticScope semanticScope) {
        semanticScope = semanticScope.newLocalScope();
        AExpression userConditionNode = userWhileNode.getConditionNode();
        semanticScope.setCondition(userConditionNode, Decorations.Read.class);
        semanticScope.putDecoration(userConditionNode, new Decorations.TargetType(Boolean.TYPE));
        this.checkedVisit(userConditionNode, semanticScope);
        this.decorateWithCast(userConditionNode, semanticScope);
        SBlock userBlockNode = userWhileNode.getBlockNode();
        boolean continuous = false;
        if (userConditionNode instanceof EBooleanConstant) {
            continuous = ((EBooleanConstant)userConditionNode).getBool();
            if (!continuous) {
                throw userWhileNode.createError(new IllegalArgumentException("extraneous while loop"));
            }
            semanticScope.setCondition(userWhileNode, Decorations.ContinuousLoop.class);
            if (userBlockNode == null) {
                throw userWhileNode.createError(new IllegalArgumentException("no paths escape from while loop"));
            }
        }
        if (userBlockNode != null) {
            semanticScope.setCondition(userBlockNode, Decorations.BeginLoop.class);
            semanticScope.setCondition(userBlockNode, Decorations.InLoop.class);
            this.visit(userBlockNode, semanticScope);
            if (semanticScope.getCondition(userBlockNode, Decorations.LoopEscape.class) && !semanticScope.getCondition(userBlockNode, Decorations.AnyContinue.class)) {
                throw userWhileNode.createError(new IllegalArgumentException("extraneous while loop"));
            }
            if (continuous && !semanticScope.getCondition(userBlockNode, Decorations.AnyBreak.class)) {
                semanticScope.setCondition(userWhileNode, Decorations.MethodEscape.class);
                semanticScope.setCondition(userWhileNode, Decorations.AllEscape.class);
            }
        }
    }

    @Override
    public void visitDo(SDo userDoNode, SemanticScope semanticScope) {
        semanticScope = semanticScope.newLocalScope();
        SBlock userBlockNode = userDoNode.getBlockNode();
        if (userBlockNode == null) {
            throw userDoNode.createError(new IllegalArgumentException("extraneous do-while loop"));
        }
        semanticScope.setCondition(userBlockNode, Decorations.BeginLoop.class);
        semanticScope.setCondition(userBlockNode, Decorations.InLoop.class);
        this.visit(userBlockNode, semanticScope);
        if (semanticScope.getCondition(userBlockNode, Decorations.LoopEscape.class) && !semanticScope.getCondition(userBlockNode, Decorations.AnyContinue.class)) {
            throw userDoNode.createError(new IllegalArgumentException("extraneous do-while loop"));
        }
        AExpression userConditionNode = userDoNode.getConditionNode();
        semanticScope.setCondition(userConditionNode, Decorations.Read.class);
        semanticScope.putDecoration(userConditionNode, new Decorations.TargetType(Boolean.TYPE));
        this.checkedVisit(userConditionNode, semanticScope);
        this.decorateWithCast(userConditionNode, semanticScope);
        if (userConditionNode instanceof EBooleanConstant) {
            boolean continuous = ((EBooleanConstant)userConditionNode).getBool();
            if (!continuous) {
                throw userDoNode.createError(new IllegalArgumentException("extraneous do-while loop"));
            }
            semanticScope.setCondition(userDoNode, Decorations.ContinuousLoop.class);
            if (!semanticScope.getCondition(userBlockNode, Decorations.AnyBreak.class)) {
                semanticScope.setCondition(userDoNode, Decorations.MethodEscape.class);
                semanticScope.setCondition(userDoNode, Decorations.AllEscape.class);
            }
        }
    }

    @Override
    public void visitFor(SFor userForNode, SemanticScope semanticScope) {
        AExpression userAfterthoughtNode;
        semanticScope = semanticScope.newLocalScope();
        ANode userInitializerNode = userForNode.getInitializerNode();
        if (userInitializerNode != null) {
            if (userInitializerNode instanceof SDeclBlock) {
                this.visit(userInitializerNode, semanticScope);
            } else if (userInitializerNode instanceof AExpression) {
                this.checkedVisit((AExpression)userInitializerNode, semanticScope);
            } else {
                throw userForNode.createError(new IllegalStateException("illegal tree structure"));
            }
        }
        AExpression userConditionNode = userForNode.getConditionNode();
        SBlock userBlockNode = userForNode.getBlockNode();
        boolean continuous = false;
        if (userConditionNode != null) {
            semanticScope.setCondition(userConditionNode, Decorations.Read.class);
            semanticScope.putDecoration(userConditionNode, new Decorations.TargetType(Boolean.TYPE));
            this.checkedVisit(userConditionNode, semanticScope);
            this.decorateWithCast(userConditionNode, semanticScope);
            if (userConditionNode instanceof EBooleanConstant) {
                continuous = ((EBooleanConstant)userConditionNode).getBool();
                if (!continuous) {
                    throw userForNode.createError(new IllegalArgumentException("extraneous for loop"));
                }
                if (userBlockNode == null) {
                    throw userForNode.createError(new IllegalArgumentException("no paths escape from for loop"));
                }
            }
        } else {
            continuous = true;
        }
        if ((userAfterthoughtNode = userForNode.getAfterthoughtNode()) != null) {
            this.checkedVisit(userAfterthoughtNode, semanticScope);
        }
        if (userBlockNode != null) {
            semanticScope.setCondition(userBlockNode, Decorations.BeginLoop.class);
            semanticScope.setCondition(userBlockNode, Decorations.InLoop.class);
            this.visit(userBlockNode, semanticScope);
            if (semanticScope.getCondition(userBlockNode, Decorations.LoopEscape.class) && !semanticScope.getCondition(userBlockNode, Decorations.AnyContinue.class)) {
                throw userForNode.createError(new IllegalArgumentException("extraneous for loop"));
            }
            if (continuous && !semanticScope.getCondition(userBlockNode, Decorations.AnyBreak.class)) {
                semanticScope.setCondition(userForNode, Decorations.MethodEscape.class);
                semanticScope.setCondition(userForNode, Decorations.AllEscape.class);
            }
        }
    }

    @Override
    public void visitEach(SEach userEachNode, SemanticScope semanticScope) {
        AExpression userIterableNode = userEachNode.getIterableNode();
        semanticScope.setCondition(userIterableNode, Decorations.Read.class);
        this.checkedVisit(userIterableNode, semanticScope);
        String canonicalTypeName = userEachNode.getCanonicalTypeName();
        Class<?> type = semanticScope.getScriptScope().getPainlessLookup().canonicalTypeNameToType(canonicalTypeName);
        if (type == null) {
            throw userEachNode.createError(new IllegalArgumentException("invalid foreach loop: type [" + canonicalTypeName + "] not found"));
        }
        semanticScope = semanticScope.newLocalScope();
        Location location = userEachNode.getLocation();
        String symbol = userEachNode.getSymbol();
        SemanticScope.Variable variable = semanticScope.defineVariable(location, type, symbol, true);
        semanticScope.putDecoration(userEachNode, new Decorations.SemanticVariable(variable));
        SBlock userBlockNode = userEachNode.getBlockNode();
        if (userBlockNode == null) {
            throw userEachNode.createError(new IllegalArgumentException("extraneous foreach loop"));
        }
        semanticScope.setCondition(userBlockNode, Decorations.BeginLoop.class);
        semanticScope.setCondition(userBlockNode, Decorations.InLoop.class);
        this.visit(userBlockNode, semanticScope);
        if (semanticScope.getCondition(userBlockNode, Decorations.LoopEscape.class) && !semanticScope.getCondition(userBlockNode, Decorations.AnyContinue.class)) {
            throw userEachNode.createError(new IllegalArgumentException("extraneous foreach loop"));
        }
        Class<?> iterableValueType = semanticScope.getDecoration(userIterableNode, Decorations.ValueType.class).getValueType();
        if (iterableValueType.isArray()) {
            PainlessCast painlessCast = AnalyzerCaster.getLegalCast(location, iterableValueType.getComponentType(), variable.getType(), true, true);
            if (painlessCast != null) {
                semanticScope.putDecoration(userEachNode, new Decorations.ExpressionPainlessCast(painlessCast));
            }
        } else if (iterableValueType == def.class || Iterable.class.isAssignableFrom(iterableValueType)) {
            PainlessCast painlessCast;
            if (iterableValueType != def.class) {
                PainlessMethod method = semanticScope.getScriptScope().getPainlessLookup().lookupPainlessMethod(iterableValueType, false, "iterator", 0);
                if (method == null) {
                    throw userEachNode.createError(new IllegalArgumentException("invalid foreach loop: method [" + PainlessLookupUtility.typeToCanonicalTypeName(iterableValueType) + ", iterator/0] not found"));
                }
                semanticScope.putDecoration(userEachNode, new Decorations.IterablePainlessMethod(method));
            }
            if ((painlessCast = AnalyzerCaster.getLegalCast(location, def.class, type, true, true)) != null) {
                semanticScope.putDecoration(userEachNode, new Decorations.ExpressionPainlessCast(painlessCast));
            }
        } else {
            throw userEachNode.createError(new IllegalArgumentException("invalid foreach loop: cannot iterate over type [" + PainlessLookupUtility.typeToCanonicalTypeName(iterableValueType) + "]."));
        }
    }

    @Override
    public void visitDeclBlock(SDeclBlock userDeclBlockNode, SemanticScope semanticScope) {
        for (SDeclaration userDeclarationNode : userDeclBlockNode.getDeclarationNodes()) {
            this.visit(userDeclarationNode, semanticScope);
        }
    }

    @Override
    public void visitDeclaration(SDeclaration userDeclarationNode, SemanticScope semanticScope) {
        ScriptScope scriptScope = semanticScope.getScriptScope();
        String symbol = userDeclarationNode.getSymbol();
        if (scriptScope.getPainlessLookup().isValidCanonicalClassName(symbol)) {
            throw userDeclarationNode.createError(new IllegalArgumentException("invalid declaration: type [" + symbol + "] cannot be a name"));
        }
        String canonicalTypeName = userDeclarationNode.getCanonicalTypeName();
        Class<?> type = scriptScope.getPainlessLookup().canonicalTypeNameToType(canonicalTypeName);
        if (type == null) {
            throw userDeclarationNode.createError(new IllegalArgumentException("invalid declaration: cannot resolve type [" + canonicalTypeName + "]"));
        }
        AExpression userValueNode = userDeclarationNode.getValueNode();
        if (userValueNode != null) {
            semanticScope.setCondition(userValueNode, Decorations.Read.class);
            semanticScope.putDecoration(userValueNode, new Decorations.TargetType(type));
            this.checkedVisit(userValueNode, semanticScope);
            this.decorateWithCast(userValueNode, semanticScope);
        }
        Location location = userDeclarationNode.getLocation();
        SemanticScope.Variable variable = semanticScope.defineVariable(location, type, symbol, false);
        semanticScope.putDecoration(userDeclarationNode, new Decorations.SemanticVariable(variable));
    }

    @Override
    public void visitReturn(SReturn userReturnNode, SemanticScope semanticScope) {
        AExpression userValueNode = userReturnNode.getValueNode();
        if (userValueNode == null) {
            if (semanticScope.getReturnType() != Void.TYPE) {
                throw userReturnNode.createError(new ClassCastException("cannot cast from [" + semanticScope.getReturnCanonicalTypeName() + "] to [" + PainlessLookupUtility.typeToCanonicalTypeName(Void.TYPE) + "]"));
            }
        } else {
            semanticScope.setCondition(userValueNode, Decorations.Read.class);
            semanticScope.putDecoration(userValueNode, new Decorations.TargetType(semanticScope.getReturnType()));
            semanticScope.setCondition(userValueNode, Decorations.Internal.class);
            this.checkedVisit(userValueNode, semanticScope);
            this.decorateWithCast(userValueNode, semanticScope);
        }
        semanticScope.setCondition(userReturnNode, Decorations.MethodEscape.class);
        semanticScope.setCondition(userReturnNode, Decorations.LoopEscape.class);
        semanticScope.setCondition(userReturnNode, Decorations.AllEscape.class);
    }

    @Override
    public void visitExpression(SExpression userExpressionNode, SemanticScope semanticScope) {
        boolean rtn;
        Class<?> rtnType = semanticScope.getReturnType();
        boolean isVoid = rtnType == Void.TYPE;
        boolean lastSource = semanticScope.getCondition(userExpressionNode, Decorations.LastSource.class);
        AExpression userStatementNode = userExpressionNode.getStatementNode();
        if (lastSource && !isVoid) {
            semanticScope.setCondition(userStatementNode, Decorations.Read.class);
        }
        this.checkedVisit(userStatementNode, semanticScope);
        Class<?> expressionValueType = semanticScope.getDecoration(userStatementNode, Decorations.ValueType.class).getValueType();
        boolean bl = rtn = lastSource && !isVoid && expressionValueType != Void.TYPE;
        if (rtn) {
            semanticScope.putDecoration(userStatementNode, new Decorations.TargetType(rtnType));
            semanticScope.setCondition(userStatementNode, Decorations.Internal.class);
            this.decorateWithCast(userStatementNode, semanticScope);
            semanticScope.setCondition(userExpressionNode, Decorations.MethodEscape.class);
            semanticScope.setCondition(userExpressionNode, Decorations.LoopEscape.class);
            semanticScope.setCondition(userExpressionNode, Decorations.AllEscape.class);
        }
    }

    @Override
    public void visitTry(STry userTryNode, SemanticScope semanticScope) {
        SBlock userBlockNode = userTryNode.getBlockNode();
        if (userBlockNode == null) {
            throw userTryNode.createError(new IllegalArgumentException("extraneous try statement"));
        }
        semanticScope.replicateCondition(userTryNode, userBlockNode, Decorations.LastSource.class);
        semanticScope.replicateCondition(userTryNode, userBlockNode, Decorations.InLoop.class);
        semanticScope.replicateCondition(userTryNode, userBlockNode, Decorations.LastLoop.class);
        this.visit(userBlockNode, semanticScope.newLocalScope());
        boolean methodEscape = semanticScope.getCondition(userBlockNode, Decorations.MethodEscape.class);
        boolean loopEscape = semanticScope.getCondition(userBlockNode, Decorations.LoopEscape.class);
        boolean allEscape = semanticScope.getCondition(userBlockNode, Decorations.AllEscape.class);
        boolean anyContinue = semanticScope.getCondition(userBlockNode, Decorations.AnyContinue.class);
        boolean anyBreak = semanticScope.getCondition(userBlockNode, Decorations.AnyBreak.class);
        for (SCatch userCatchNode : userTryNode.getCatchNodes()) {
            semanticScope.replicateCondition(userTryNode, userCatchNode, Decorations.LastSource.class);
            semanticScope.replicateCondition(userTryNode, userCatchNode, Decorations.InLoop.class);
            semanticScope.replicateCondition(userTryNode, userCatchNode, Decorations.LastLoop.class);
            this.visit(userCatchNode, semanticScope.newLocalScope());
            methodEscape &= semanticScope.getCondition(userCatchNode, Decorations.MethodEscape.class);
            loopEscape &= semanticScope.getCondition(userCatchNode, Decorations.LoopEscape.class);
            allEscape &= semanticScope.getCondition(userCatchNode, Decorations.AllEscape.class);
            anyContinue |= semanticScope.getCondition(userCatchNode, Decorations.AnyContinue.class);
            anyBreak |= semanticScope.getCondition(userCatchNode, Decorations.AnyBreak.class);
        }
        if (methodEscape) {
            semanticScope.setCondition(userTryNode, Decorations.MethodEscape.class);
        }
        if (loopEscape) {
            semanticScope.setCondition(userTryNode, Decorations.LoopEscape.class);
        }
        if (allEscape) {
            semanticScope.setCondition(userTryNode, Decorations.AllEscape.class);
        }
        if (anyContinue) {
            semanticScope.setCondition(userTryNode, Decorations.AnyContinue.class);
        }
        if (anyBreak) {
            semanticScope.setCondition(userTryNode, Decorations.AnyBreak.class);
        }
    }

    @Override
    public void visitCatch(SCatch userCatchNode, SemanticScope semanticScope) {
        ScriptScope scriptScope = semanticScope.getScriptScope();
        String symbol = userCatchNode.getSymbol();
        if (scriptScope.getPainlessLookup().isValidCanonicalClassName(symbol)) {
            throw userCatchNode.createError(new IllegalArgumentException("invalid catch declaration: type [" + symbol + "] cannot be a name"));
        }
        String canonicalTypeName = userCatchNode.getCanonicalTypeName();
        Class<?> type = scriptScope.getPainlessLookup().canonicalTypeNameToType(canonicalTypeName);
        if (type == null) {
            throw userCatchNode.createError(new IllegalArgumentException("invalid catch declaration: cannot resolve type [" + canonicalTypeName + "]"));
        }
        Location location = userCatchNode.getLocation();
        SemanticScope.Variable variable = semanticScope.defineVariable(location, type, symbol, false);
        semanticScope.putDecoration(userCatchNode, new Decorations.SemanticVariable(variable));
        Class<?> baseException = userCatchNode.getBaseException();
        if (!userCatchNode.getBaseException().isAssignableFrom(type)) {
            throw userCatchNode.createError(new ClassCastException("cannot cast from [" + PainlessLookupUtility.typeToCanonicalTypeName(type) + "] to [" + PainlessLookupUtility.typeToCanonicalTypeName(baseException) + "]"));
        }
        SBlock userBlockNode = userCatchNode.getBlockNode();
        if (userBlockNode != null) {
            semanticScope.replicateCondition(userCatchNode, userBlockNode, Decorations.LastSource.class);
            semanticScope.replicateCondition(userCatchNode, userBlockNode, Decorations.InLoop.class);
            semanticScope.replicateCondition(userCatchNode, userBlockNode, Decorations.LastLoop.class);
            this.visit(userBlockNode, semanticScope);
            semanticScope.replicateCondition(userBlockNode, userCatchNode, Decorations.MethodEscape.class);
            semanticScope.replicateCondition(userBlockNode, userCatchNode, Decorations.LoopEscape.class);
            semanticScope.replicateCondition(userBlockNode, userCatchNode, Decorations.AllEscape.class);
            semanticScope.replicateCondition(userBlockNode, userCatchNode, Decorations.AnyContinue.class);
            semanticScope.replicateCondition(userBlockNode, userCatchNode, Decorations.AnyBreak.class);
        }
    }

    @Override
    public void visitThrow(SThrow userThrowNode, SemanticScope semanticScope) {
        AExpression userExpressionNode = userThrowNode.getExpressionNode();
        semanticScope.setCondition(userExpressionNode, Decorations.Read.class);
        semanticScope.putDecoration(userExpressionNode, new Decorations.TargetType(Exception.class));
        this.checkedVisit(userExpressionNode, semanticScope);
        this.decorateWithCast(userExpressionNode, semanticScope);
        semanticScope.setCondition(userThrowNode, Decorations.MethodEscape.class);
        semanticScope.setCondition(userThrowNode, Decorations.LoopEscape.class);
        semanticScope.setCondition(userThrowNode, Decorations.AllEscape.class);
    }

    @Override
    public void visitContinue(SContinue userContinueNode, SemanticScope semanticScope) {
        if (!semanticScope.getCondition(userContinueNode, Decorations.InLoop.class)) {
            throw userContinueNode.createError(new IllegalArgumentException("invalid continue statement: not inside loop"));
        }
        if (semanticScope.getCondition(userContinueNode, Decorations.LastLoop.class)) {
            throw userContinueNode.createError(new IllegalArgumentException("extraneous continue statement"));
        }
        semanticScope.setCondition(userContinueNode, Decorations.AllEscape.class);
        semanticScope.setCondition(userContinueNode, Decorations.AnyContinue.class);
    }

    @Override
    public void visitBreak(SBreak userBreakNode, SemanticScope semanticScope) {
        if (!semanticScope.getCondition(userBreakNode, Decorations.InLoop.class)) {
            throw userBreakNode.createError(new IllegalArgumentException("invalid break statement: not inside loop"));
        }
        semanticScope.setCondition(userBreakNode, Decorations.AllEscape.class);
        semanticScope.setCondition(userBreakNode, Decorations.LoopEscape.class);
        semanticScope.setCondition(userBreakNode, Decorations.AnyBreak.class);
    }

    @Override
    public void visitAssignment(EAssignment userAssignmentNode, SemanticScope semanticScope) {
        AExpression userLeftNode = userAssignmentNode.getLeftNode();
        semanticScope.replicateCondition(userAssignmentNode, userLeftNode, Decorations.Read.class);
        semanticScope.setCondition(userLeftNode, Decorations.Write.class);
        this.checkedVisit(userLeftNode, semanticScope);
        Class<?> leftValueType = semanticScope.getDecoration(userLeftNode, Decorations.ValueType.class).getValueType();
        AExpression userRightNode = userAssignmentNode.getRightNode();
        semanticScope.setCondition(userRightNode, Decorations.Read.class);
        Operation operation = userAssignmentNode.getOperation();
        if (operation != null) {
            Class<?> compoundType;
            this.checkedVisit(userRightNode, semanticScope);
            Class<?> rightValueType = semanticScope.getDecoration(userRightNode, Decorations.ValueType.class).getValueType();
            boolean isConcatenation = false;
            Class<?> shiftType = null;
            boolean isShift = false;
            if (operation == Operation.MUL) {
                compoundType = AnalyzerCaster.promoteNumeric(leftValueType, rightValueType, true);
            } else if (operation == Operation.DIV) {
                compoundType = AnalyzerCaster.promoteNumeric(leftValueType, rightValueType, true);
            } else if (operation == Operation.REM) {
                compoundType = AnalyzerCaster.promoteNumeric(leftValueType, rightValueType, true);
            } else if (operation == Operation.ADD) {
                compoundType = AnalyzerCaster.promoteAdd(leftValueType, rightValueType);
                isConcatenation = compoundType == String.class;
            } else if (operation == Operation.SUB) {
                compoundType = AnalyzerCaster.promoteNumeric(leftValueType, rightValueType, true);
            } else if (operation == Operation.LSH) {
                compoundType = AnalyzerCaster.promoteNumeric(leftValueType, false);
                shiftType = AnalyzerCaster.promoteNumeric(rightValueType, false);
                isShift = true;
            } else if (operation == Operation.RSH) {
                compoundType = AnalyzerCaster.promoteNumeric(leftValueType, false);
                shiftType = AnalyzerCaster.promoteNumeric(rightValueType, false);
                isShift = true;
            } else if (operation == Operation.USH) {
                compoundType = AnalyzerCaster.promoteNumeric(leftValueType, false);
                shiftType = AnalyzerCaster.promoteNumeric(rightValueType, false);
                isShift = true;
            } else if (operation == Operation.BWAND) {
                compoundType = AnalyzerCaster.promoteXor(leftValueType, rightValueType);
            } else if (operation == Operation.XOR) {
                compoundType = AnalyzerCaster.promoteXor(leftValueType, rightValueType);
            } else if (operation == Operation.BWOR) {
                compoundType = AnalyzerCaster.promoteXor(leftValueType, rightValueType);
            } else {
                throw userAssignmentNode.createError(new IllegalStateException("illegal tree structure"));
            }
            if (compoundType == null || isShift && shiftType == null) {
                throw userAssignmentNode.createError(new ClassCastException("invalid compound assignment: cannot apply [" + operation.symbol + "=] to types [" + leftValueType + "] and [" + rightValueType + "]"));
            }
            if (isConcatenation) {
                semanticScope.putDecoration(userRightNode, new Decorations.TargetType(rightValueType));
            } else if (isShift) {
                if (compoundType == def.class) {
                    semanticScope.putDecoration(userRightNode, new Decorations.TargetType(def.class));
                } else if (shiftType == Long.TYPE) {
                    semanticScope.putDecoration(userRightNode, new Decorations.TargetType(Integer.TYPE));
                    semanticScope.setCondition(userRightNode, Decorations.Explicit.class);
                } else {
                    semanticScope.putDecoration(userRightNode, new Decorations.TargetType(shiftType));
                }
            } else {
                semanticScope.putDecoration(userRightNode, new Decorations.TargetType(compoundType));
            }
            this.decorateWithCast(userRightNode, semanticScope);
            Location location = userAssignmentNode.getLocation();
            PainlessCast upcast = AnalyzerCaster.getLegalCast(location, leftValueType, compoundType, false, false);
            PainlessCast downcast = AnalyzerCaster.getLegalCast(location, compoundType, leftValueType, true, false);
            semanticScope.putDecoration(userAssignmentNode, new Decorations.CompoundType(compoundType));
            if (upcast != null) {
                semanticScope.putDecoration(userAssignmentNode, new Decorations.UpcastPainlessCast(upcast));
            }
            if (downcast != null) {
                semanticScope.putDecoration(userAssignmentNode, new Decorations.DowncastPainlessCast(downcast));
            }
        } else if (semanticScope.getCondition(userLeftNode, Decorations.DefOptimized.class)) {
            this.checkedVisit(userRightNode, semanticScope);
            Class<?> rightValueType = semanticScope.getDecoration(userRightNode, Decorations.ValueType.class).getValueType();
            if (rightValueType == Void.TYPE) {
                throw userAssignmentNode.createError(new IllegalArgumentException("invalid assignment: cannot assign type [" + PainlessLookupUtility.typeToCanonicalTypeName(Void.TYPE) + "]"));
            }
            semanticScope.putDecoration(userLeftNode, new Decorations.ValueType(rightValueType));
            leftValueType = rightValueType;
        } else {
            semanticScope.putDecoration(userRightNode, new Decorations.TargetType(leftValueType));
            this.checkedVisit(userRightNode, semanticScope);
            this.decorateWithCast(userRightNode, semanticScope);
        }
        semanticScope.putDecoration(userAssignmentNode, new Decorations.ValueType(semanticScope.getCondition(userAssignmentNode, Decorations.Read.class) ? leftValueType : Void.TYPE));
    }

    @Override
    public void visitUnary(EUnary userUnaryNode, SemanticScope semanticScope) {
        Class<Boolean> valueType;
        Operation operation = userUnaryNode.getOperation();
        if (semanticScope.getCondition(userUnaryNode, Decorations.Write.class)) {
            throw userUnaryNode.createError(new IllegalArgumentException("invalid assignment: cannot assign a value to " + operation.name + " operation [" + operation.symbol + "]"));
        }
        if (!semanticScope.getCondition(userUnaryNode, Decorations.Read.class)) {
            throw userUnaryNode.createError(new IllegalArgumentException("not a statement: result not used from " + operation.name + " operation [" + operation.symbol + "]"));
        }
        AExpression userChildNode = userUnaryNode.getChildNode();
        Class<?> unaryType = null;
        if (operation == Operation.SUB && (userChildNode instanceof ENumeric || userChildNode instanceof EDecimal)) {
            semanticScope.setCondition(userChildNode, Decorations.Read.class);
            semanticScope.copyDecoration(userUnaryNode, userChildNode, Decorations.TargetType.class);
            semanticScope.replicateCondition(userUnaryNode, userChildNode, Decorations.Explicit.class);
            semanticScope.replicateCondition(userUnaryNode, userChildNode, Decorations.Internal.class);
            semanticScope.setCondition(userChildNode, Decorations.Negate.class);
            this.checkedVisit(userChildNode, semanticScope);
            if (semanticScope.hasDecoration(userUnaryNode, Decorations.TargetType.class)) {
                this.decorateWithCast(userChildNode, semanticScope);
            }
            valueType = semanticScope.getDecoration(userChildNode, Decorations.ValueType.class).getValueType();
        } else if (operation == Operation.NOT) {
            semanticScope.setCondition(userChildNode, Decorations.Read.class);
            semanticScope.putDecoration(userChildNode, new Decorations.TargetType(Boolean.TYPE));
            this.checkedVisit(userChildNode, semanticScope);
            this.decorateWithCast(userChildNode, semanticScope);
            valueType = Boolean.TYPE;
        } else if (operation == Operation.BWNOT || operation == Operation.ADD || operation == Operation.SUB) {
            semanticScope.setCondition(userChildNode, Decorations.Read.class);
            this.checkedVisit(userChildNode, semanticScope);
            Class<?> childValueType = semanticScope.getDecoration(userChildNode, Decorations.ValueType.class).getValueType();
            unaryType = AnalyzerCaster.promoteNumeric(childValueType, operation != Operation.BWNOT);
            if (unaryType == null) {
                throw userUnaryNode.createError(new ClassCastException("cannot apply the " + operation.name + " operator [" + operation.symbol + "] to the type [" + PainlessLookupUtility.typeToCanonicalTypeName(childValueType) + "]"));
            }
            semanticScope.putDecoration(userChildNode, new Decorations.TargetType(unaryType));
            this.decorateWithCast(userChildNode, semanticScope);
            Decorations.TargetType targetType = semanticScope.getDecoration(userUnaryNode, Decorations.TargetType.class);
            valueType = unaryType == def.class && targetType != null ? targetType.getTargetType() : unaryType;
        } else {
            throw userUnaryNode.createError(new IllegalStateException("unexpected unary operation [" + operation.name + "]"));
        }
        semanticScope.putDecoration(userUnaryNode, new Decorations.ValueType(valueType));
        if (unaryType != null) {
            semanticScope.putDecoration(userUnaryNode, new Decorations.UnaryType(unaryType));
        }
    }

    @Override
    public void visitBinary(EBinary userBinaryNode, SemanticScope semanticScope) {
        Class<Object> valueType;
        Class<Object> binaryType;
        Operation operation = userBinaryNode.getOperation();
        if (semanticScope.getCondition(userBinaryNode, Decorations.Write.class)) {
            throw userBinaryNode.createError(new IllegalArgumentException("invalid assignment: cannot assign a value to " + operation.name + " operation [" + operation.symbol + "]"));
        }
        if (!semanticScope.getCondition(userBinaryNode, Decorations.Read.class)) {
            throw userBinaryNode.createError(new IllegalArgumentException("not a statement: result not used from " + operation.name + " operation [" + operation.symbol + "]"));
        }
        AExpression userLeftNode = userBinaryNode.getLeftNode();
        semanticScope.setCondition(userLeftNode, Decorations.Read.class);
        this.checkedVisit(userLeftNode, semanticScope);
        Class<?> leftValueType = semanticScope.getDecoration(userLeftNode, Decorations.ValueType.class).getValueType();
        AExpression userRightNode = userBinaryNode.getRightNode();
        semanticScope.setCondition(userRightNode, Decorations.Read.class);
        this.checkedVisit(userRightNode, semanticScope);
        Class<?> rightValueType = semanticScope.getDecoration(userRightNode, Decorations.ValueType.class).getValueType();
        Class<?> shiftType = null;
        if (operation == Operation.FIND || operation == Operation.MATCH) {
            semanticScope.putDecoration(userLeftNode, new Decorations.TargetType(String.class));
            semanticScope.putDecoration(userRightNode, new Decorations.TargetType(Pattern.class));
            this.decorateWithCast(userLeftNode, semanticScope);
            this.decorateWithCast(userRightNode, semanticScope);
            binaryType = Boolean.TYPE;
            valueType = Boolean.TYPE;
        } else {
            if (operation == Operation.MUL || operation == Operation.DIV || operation == Operation.REM) {
                binaryType = AnalyzerCaster.promoteNumeric(leftValueType, rightValueType, true);
            } else if (operation == Operation.ADD) {
                binaryType = AnalyzerCaster.promoteAdd(leftValueType, rightValueType);
            } else if (operation == Operation.SUB) {
                binaryType = AnalyzerCaster.promoteNumeric(leftValueType, rightValueType, true);
            } else if (operation == Operation.LSH || operation == Operation.RSH || operation == Operation.USH) {
                binaryType = AnalyzerCaster.promoteNumeric(leftValueType, false);
                shiftType = AnalyzerCaster.promoteNumeric(rightValueType, false);
                if (shiftType == null) {
                    binaryType = null;
                }
            } else if (operation == Operation.BWOR || operation == Operation.BWAND) {
                binaryType = AnalyzerCaster.promoteNumeric(leftValueType, rightValueType, false);
            } else if (operation == Operation.XOR) {
                binaryType = AnalyzerCaster.promoteXor(leftValueType, rightValueType);
            } else {
                throw userBinaryNode.createError(new IllegalStateException("unexpected binary operation [" + operation.name + "]"));
            }
            if (binaryType == null) {
                throw userBinaryNode.createError(new ClassCastException("cannot apply the " + operation.name + " operator [" + operation.symbol + "] to the types [" + PainlessLookupUtility.typeToCanonicalTypeName(leftValueType) + "] and [" + PainlessLookupUtility.typeToCanonicalTypeName(rightValueType) + "]"));
            }
            valueType = binaryType;
            if (binaryType == def.class || shiftType == def.class) {
                Decorations.TargetType targetType = semanticScope.getDecoration(userBinaryNode, Decorations.TargetType.class);
                if (targetType != null) {
                    valueType = targetType.getTargetType();
                }
            } else if (operation != Operation.ADD || binaryType != String.class) {
                semanticScope.putDecoration(userLeftNode, new Decorations.TargetType(binaryType));
                if (operation == Operation.LSH || operation == Operation.RSH || operation == Operation.USH) {
                    if (shiftType == Long.TYPE) {
                        semanticScope.putDecoration(userRightNode, new Decorations.TargetType(Integer.TYPE));
                        semanticScope.setCondition(userRightNode, Decorations.Explicit.class);
                    } else {
                        semanticScope.putDecoration(userRightNode, new Decorations.TargetType(shiftType));
                    }
                } else {
                    semanticScope.putDecoration(userRightNode, new Decorations.TargetType(binaryType));
                }
                this.decorateWithCast(userLeftNode, semanticScope);
                this.decorateWithCast(userRightNode, semanticScope);
            }
        }
        semanticScope.putDecoration(userBinaryNode, new Decorations.ValueType(valueType));
        semanticScope.putDecoration(userBinaryNode, new Decorations.BinaryType(binaryType));
        if (shiftType != null) {
            semanticScope.putDecoration(userBinaryNode, new Decorations.ShiftType(shiftType));
        }
    }

    @Override
    public void visitBooleanComp(EBooleanComp userBooleanCompNode, SemanticScope semanticScope) {
        Operation operation = userBooleanCompNode.getOperation();
        if (semanticScope.getCondition(userBooleanCompNode, Decorations.Write.class)) {
            throw userBooleanCompNode.createError(new IllegalArgumentException("invalid assignment: cannot assign a value to " + operation.name + " operation [" + operation.symbol + "]"));
        }
        if (!semanticScope.getCondition(userBooleanCompNode, Decorations.Read.class)) {
            throw userBooleanCompNode.createError(new IllegalArgumentException("not a statement: result not used from " + operation.name + " operation [" + operation.symbol + "]"));
        }
        AExpression userLeftNode = userBooleanCompNode.getLeftNode();
        semanticScope.setCondition(userLeftNode, Decorations.Read.class);
        semanticScope.putDecoration(userLeftNode, new Decorations.TargetType(Boolean.TYPE));
        this.checkedVisit(userLeftNode, semanticScope);
        this.decorateWithCast(userLeftNode, semanticScope);
        AExpression userRightNode = userBooleanCompNode.getRightNode();
        semanticScope.setCondition(userRightNode, Decorations.Read.class);
        semanticScope.putDecoration(userRightNode, new Decorations.TargetType(Boolean.TYPE));
        this.checkedVisit(userRightNode, semanticScope);
        this.decorateWithCast(userRightNode, semanticScope);
        semanticScope.putDecoration(userBooleanCompNode, new Decorations.ValueType(Boolean.TYPE));
    }

    @Override
    public void visitComp(EComp userCompNode, SemanticScope semanticScope) {
        Class<?> promotedType;
        Operation operation = userCompNode.getOperation();
        if (semanticScope.getCondition(userCompNode, Decorations.Write.class)) {
            throw userCompNode.createError(new IllegalArgumentException("invalid assignment: cannot assign a value to " + operation.name + " operation [" + operation.symbol + "]"));
        }
        if (!semanticScope.getCondition(userCompNode, Decorations.Read.class)) {
            throw userCompNode.createError(new IllegalArgumentException("not a statement: result not used from " + operation.name + " operation [" + operation.symbol + "]"));
        }
        AExpression userLeftNode = userCompNode.getLeftNode();
        semanticScope.setCondition(userLeftNode, Decorations.Read.class);
        this.checkedVisit(userLeftNode, semanticScope);
        Class<?> leftValueType = semanticScope.getDecoration(userLeftNode, Decorations.ValueType.class).getValueType();
        AExpression userRightNode = userCompNode.getRightNode();
        semanticScope.setCondition(userRightNode, Decorations.Read.class);
        this.checkedVisit(userRightNode, semanticScope);
        Class<?> rightValueType = semanticScope.getDecoration(userRightNode, Decorations.ValueType.class).getValueType();
        if (operation == Operation.EQ || operation == Operation.EQR || operation == Operation.NE || operation == Operation.NER) {
            promotedType = AnalyzerCaster.promoteEquality(leftValueType, rightValueType);
        } else if (operation == Operation.GT || operation == Operation.GTE || operation == Operation.LT || operation == Operation.LTE) {
            promotedType = AnalyzerCaster.promoteNumeric(leftValueType, rightValueType, true);
        } else {
            throw userCompNode.createError(new IllegalStateException("unexpected binary operation [" + operation.name + "]"));
        }
        if (promotedType == null) {
            throw userCompNode.createError(new ClassCastException("cannot apply the " + operation.name + " operator [" + operation.symbol + "] to the types [" + PainlessLookupUtility.typeToCanonicalTypeName(leftValueType) + "] and [" + PainlessLookupUtility.typeToCanonicalTypeName(rightValueType) + "]"));
        }
        if ((operation == Operation.EQ || operation == Operation.EQR || operation == Operation.NE || operation == Operation.NER) && userLeftNode instanceof ENull && userRightNode instanceof ENull) {
            throw userCompNode.createError(new IllegalArgumentException("extraneous comparison of [null] constants"));
        }
        if (operation == Operation.EQR || operation == Operation.NER || promotedType != def.class) {
            semanticScope.putDecoration(userLeftNode, new Decorations.TargetType(promotedType));
            semanticScope.putDecoration(userRightNode, new Decorations.TargetType(promotedType));
            this.decorateWithCast(userLeftNode, semanticScope);
            this.decorateWithCast(userRightNode, semanticScope);
        }
        semanticScope.putDecoration(userCompNode, new Decorations.ValueType(Boolean.TYPE));
        semanticScope.putDecoration(userCompNode, new Decorations.ComparisonType(promotedType));
    }

    @Override
    public void visitExplicit(EExplicit userExplicitNode, SemanticScope semanticScope) {
        String canonicalTypeName = userExplicitNode.getCanonicalTypeName();
        if (semanticScope.getCondition(userExplicitNode, Decorations.Write.class)) {
            throw userExplicitNode.createError(new IllegalArgumentException("invalid assignment: cannot assign a value to an explicit cast with target type [" + canonicalTypeName + "]"));
        }
        if (!semanticScope.getCondition(userExplicitNode, Decorations.Read.class)) {
            throw userExplicitNode.createError(new IllegalArgumentException("not a statement: result not used from explicit cast with target type [" + canonicalTypeName + "]"));
        }
        Class<?> valueType = semanticScope.getScriptScope().getPainlessLookup().canonicalTypeNameToType(canonicalTypeName);
        if (valueType == null) {
            throw userExplicitNode.createError(new IllegalArgumentException("cannot resolve type [" + canonicalTypeName + "]"));
        }
        AExpression userChildNode = userExplicitNode.getChildNode();
        semanticScope.setCondition(userChildNode, Decorations.Read.class);
        semanticScope.putDecoration(userChildNode, new Decorations.TargetType(valueType));
        semanticScope.setCondition(userChildNode, Decorations.Explicit.class);
        this.checkedVisit(userChildNode, semanticScope);
        this.decorateWithCast(userChildNode, semanticScope);
        semanticScope.putDecoration(userExplicitNode, new Decorations.ValueType(valueType));
    }

    @Override
    public void visitInstanceof(EInstanceof userInstanceofNode, SemanticScope semanticScope) {
        String canonicalTypeName = userInstanceofNode.getCanonicalTypeName();
        if (semanticScope.getCondition(userInstanceofNode, Decorations.Write.class)) {
            throw userInstanceofNode.createError(new IllegalArgumentException("invalid assignment: cannot assign a value to instanceof with target type [" + canonicalTypeName + "]"));
        }
        if (!semanticScope.getCondition(userInstanceofNode, Decorations.Read.class)) {
            throw userInstanceofNode.createError(new IllegalArgumentException("not a statement: result not used from instanceof with target type [" + canonicalTypeName + "]"));
        }
        Class<?> instanceType = semanticScope.getScriptScope().getPainlessLookup().canonicalTypeNameToType(canonicalTypeName);
        if (instanceType == null) {
            throw userInstanceofNode.createError(new IllegalArgumentException("Not a type [" + canonicalTypeName + "]."));
        }
        AExpression userExpressionNode = userInstanceofNode.getExpressionNode();
        semanticScope.setCondition(userExpressionNode, Decorations.Read.class);
        this.checkedVisit(userExpressionNode, semanticScope);
        semanticScope.putDecoration(userInstanceofNode, new Decorations.ValueType(Boolean.TYPE));
        semanticScope.putDecoration(userInstanceofNode, new Decorations.InstanceType(instanceType));
    }

    @Override
    public void visitConditional(EConditional userConditionalNode, SemanticScope semanticScope) {
        Class<?> valueType;
        if (semanticScope.getCondition(userConditionalNode, Decorations.Write.class)) {
            throw userConditionalNode.createError(new IllegalArgumentException("invalid assignment: cannot assign a value to conditional operation [?:]"));
        }
        if (!semanticScope.getCondition(userConditionalNode, Decorations.Read.class)) {
            throw userConditionalNode.createError(new IllegalArgumentException("not a statement: result not used from conditional operation [?:]"));
        }
        AExpression userConditionNode = userConditionalNode.getConditionNode();
        semanticScope.setCondition(userConditionNode, Decorations.Read.class);
        semanticScope.putDecoration(userConditionNode, new Decorations.TargetType(Boolean.TYPE));
        this.checkedVisit(userConditionNode, semanticScope);
        this.decorateWithCast(userConditionNode, semanticScope);
        AExpression userTrueNode = userConditionalNode.getTrueNode();
        semanticScope.setCondition(userTrueNode, Decorations.Read.class);
        semanticScope.copyDecoration(userConditionalNode, userTrueNode, Decorations.TargetType.class);
        semanticScope.replicateCondition(userConditionalNode, userTrueNode, Decorations.Explicit.class);
        semanticScope.replicateCondition(userConditionalNode, userTrueNode, Decorations.Internal.class);
        this.checkedVisit(userTrueNode, semanticScope);
        Class<?> leftValueType = semanticScope.getDecoration(userTrueNode, Decorations.ValueType.class).getValueType();
        AExpression userFalseNode = userConditionalNode.getFalseNode();
        semanticScope.setCondition(userFalseNode, Decorations.Read.class);
        semanticScope.copyDecoration(userConditionalNode, userFalseNode, Decorations.TargetType.class);
        semanticScope.replicateCondition(userConditionalNode, userFalseNode, Decorations.Explicit.class);
        semanticScope.replicateCondition(userConditionalNode, userFalseNode, Decorations.Internal.class);
        this.checkedVisit(userFalseNode, semanticScope);
        Class<?> rightValueType = semanticScope.getDecoration(userFalseNode, Decorations.ValueType.class).getValueType();
        Decorations.TargetType targetType = semanticScope.getDecoration(userConditionalNode, Decorations.TargetType.class);
        if (targetType == null) {
            Class<?> promote = AnalyzerCaster.promoteConditional(leftValueType, rightValueType);
            if (promote == null) {
                throw userConditionalNode.createError(new ClassCastException("cannot apply the conditional operator [?:] to the types [" + PainlessLookupUtility.typeToCanonicalTypeName(leftValueType) + "] and [" + PainlessLookupUtility.typeToCanonicalTypeName(rightValueType) + "]"));
            }
            semanticScope.putDecoration(userTrueNode, new Decorations.TargetType(promote));
            semanticScope.putDecoration(userFalseNode, new Decorations.TargetType(promote));
            valueType = promote;
        } else {
            valueType = targetType.getTargetType();
        }
        this.decorateWithCast(userTrueNode, semanticScope);
        this.decorateWithCast(userFalseNode, semanticScope);
        semanticScope.putDecoration(userConditionalNode, new Decorations.ValueType(valueType));
    }

    @Override
    public void visitElvis(EElvis userElvisNode, SemanticScope semanticScope) {
        Class<?> valueType;
        if (semanticScope.getCondition(userElvisNode, Decorations.Write.class)) {
            throw userElvisNode.createError(new IllegalArgumentException("invalid assignment: cannot assign a value to elvis operation [?:]"));
        }
        if (!semanticScope.getCondition(userElvisNode, Decorations.Read.class)) {
            throw userElvisNode.createError(new IllegalArgumentException("not a statement: result not used from elvis operation [?:]"));
        }
        Decorations.TargetType targetType = semanticScope.getDecoration(userElvisNode, Decorations.TargetType.class);
        if (targetType != null && targetType.getTargetType().isPrimitive()) {
            throw userElvisNode.createError(new IllegalArgumentException("Elvis operator cannot return primitives"));
        }
        AExpression userLeftNode = userElvisNode.getLeftNode();
        semanticScope.setCondition(userLeftNode, Decorations.Read.class);
        semanticScope.copyDecoration(userElvisNode, userLeftNode, Decorations.TargetType.class);
        semanticScope.replicateCondition(userElvisNode, userLeftNode, Decorations.Explicit.class);
        semanticScope.replicateCondition(userElvisNode, userLeftNode, Decorations.Internal.class);
        this.checkedVisit(userLeftNode, semanticScope);
        Class<?> leftValueType = semanticScope.getDecoration(userLeftNode, Decorations.ValueType.class).getValueType();
        AExpression userRightNode = userElvisNode.getRightNode();
        semanticScope.setCondition(userRightNode, Decorations.Read.class);
        semanticScope.copyDecoration(userElvisNode, userRightNode, Decorations.TargetType.class);
        semanticScope.replicateCondition(userElvisNode, userRightNode, Decorations.Explicit.class);
        semanticScope.replicateCondition(userElvisNode, userRightNode, Decorations.Internal.class);
        this.checkedVisit(userRightNode, semanticScope);
        Class<?> rightValueType = semanticScope.getDecoration(userRightNode, Decorations.ValueType.class).getValueType();
        if (userLeftNode instanceof ENull) {
            throw userElvisNode.createError(new IllegalArgumentException("Extraneous elvis operator. LHS is null."));
        }
        if (userLeftNode instanceof EBooleanConstant || userLeftNode instanceof ENumeric || userLeftNode instanceof EDecimal || userLeftNode instanceof EString) {
            throw userElvisNode.createError(new IllegalArgumentException("Extraneous elvis operator. LHS is a constant."));
        }
        if (leftValueType.isPrimitive()) {
            throw userElvisNode.createError(new IllegalArgumentException("Extraneous elvis operator. LHS is a primitive."));
        }
        if (userRightNode instanceof ENull) {
            throw userElvisNode.createError(new IllegalArgumentException("Extraneous elvis operator. RHS is null."));
        }
        if (targetType == null) {
            Class<?> promote = AnalyzerCaster.promoteConditional(leftValueType, rightValueType);
            semanticScope.putDecoration(userLeftNode, new Decorations.TargetType(promote));
            semanticScope.putDecoration(userRightNode, new Decorations.TargetType(promote));
            valueType = promote;
        } else {
            valueType = targetType.getTargetType();
        }
        this.decorateWithCast(userLeftNode, semanticScope);
        this.decorateWithCast(userRightNode, semanticScope);
        semanticScope.putDecoration(userElvisNode, new Decorations.ValueType(valueType));
    }

    @Override
    public void visitListInit(EListInit userListInitNode, SemanticScope semanticScope) {
        if (semanticScope.getCondition(userListInitNode, Decorations.Write.class)) {
            throw userListInitNode.createError(new IllegalArgumentException("invalid assignment: cannot assign a value to list initializer"));
        }
        if (!semanticScope.getCondition(userListInitNode, Decorations.Read.class)) {
            throw userListInitNode.createError(new IllegalArgumentException("not a statement: result not used from list initializer"));
        }
        Class<ArrayList> valueType = ArrayList.class;
        PainlessConstructor constructor = semanticScope.getScriptScope().getPainlessLookup().lookupPainlessConstructor(valueType, 0);
        if (constructor == null) {
            throw userListInitNode.createError(new IllegalArgumentException("constructor [" + PainlessLookupUtility.typeToCanonicalTypeName(valueType) + ", <init>/0] not found"));
        }
        semanticScope.putDecoration(userListInitNode, new Decorations.StandardPainlessConstructor(constructor));
        PainlessMethod method = semanticScope.getScriptScope().getPainlessLookup().lookupPainlessMethod(valueType, false, "add", 1);
        if (method == null) {
            throw userListInitNode.createError(new IllegalArgumentException("method [" + PainlessLookupUtility.typeToCanonicalTypeName(valueType) + ", add/1] not found"));
        }
        semanticScope.putDecoration(userListInitNode, new Decorations.StandardPainlessMethod(method));
        for (AExpression userValueNode : userListInitNode.getValueNodes()) {
            semanticScope.setCondition(userValueNode, Decorations.Read.class);
            semanticScope.putDecoration(userValueNode, new Decorations.TargetType(def.class));
            semanticScope.setCondition(userValueNode, Decorations.Internal.class);
            this.checkedVisit(userValueNode, semanticScope);
            this.decorateWithCast(userValueNode, semanticScope);
        }
        semanticScope.putDecoration(userListInitNode, new Decorations.ValueType(valueType));
    }

    @Override
    public void visitMapInit(EMapInit userMapInitNode, SemanticScope semanticScope) {
        if (semanticScope.getCondition(userMapInitNode, Decorations.Write.class)) {
            throw userMapInitNode.createError(new IllegalArgumentException("invalid assignment: cannot assign a value to map initializer"));
        }
        if (!semanticScope.getCondition(userMapInitNode, Decorations.Read.class)) {
            throw userMapInitNode.createError(new IllegalArgumentException("not a statement: result not used from map initializer"));
        }
        Class<HashMap> valueType = HashMap.class;
        PainlessConstructor constructor = semanticScope.getScriptScope().getPainlessLookup().lookupPainlessConstructor(valueType, 0);
        if (constructor == null) {
            throw userMapInitNode.createError(new IllegalArgumentException("constructor [" + PainlessLookupUtility.typeToCanonicalTypeName(valueType) + ", <init>/0] not found"));
        }
        semanticScope.putDecoration(userMapInitNode, new Decorations.StandardPainlessConstructor(constructor));
        PainlessMethod method = semanticScope.getScriptScope().getPainlessLookup().lookupPainlessMethod(valueType, false, "put", 2);
        if (method == null) {
            throw userMapInitNode.createError(new IllegalArgumentException("method [" + PainlessLookupUtility.typeToCanonicalTypeName(valueType) + ", put/2] not found"));
        }
        semanticScope.putDecoration(userMapInitNode, new Decorations.StandardPainlessMethod(method));
        List<AExpression> userKeyNodes = userMapInitNode.getKeyNodes();
        List<AExpression> userValueNodes = userMapInitNode.getValueNodes();
        if (userKeyNodes.size() != userValueNodes.size()) {
            throw userMapInitNode.createError(new IllegalStateException("Illegal tree structure."));
        }
        for (int i = 0; i < userKeyNodes.size(); ++i) {
            AExpression userKeyNode = userKeyNodes.get(i);
            semanticScope.setCondition(userKeyNode, Decorations.Read.class);
            semanticScope.putDecoration(userKeyNode, new Decorations.TargetType(def.class));
            semanticScope.setCondition(userKeyNode, Decorations.Internal.class);
            this.checkedVisit(userKeyNode, semanticScope);
            this.decorateWithCast(userKeyNode, semanticScope);
            AExpression userValueNode = userValueNodes.get(i);
            semanticScope.setCondition(userValueNode, Decorations.Read.class);
            semanticScope.putDecoration(userValueNode, new Decorations.TargetType(def.class));
            semanticScope.setCondition(userValueNode, Decorations.Internal.class);
            this.checkedVisit(userValueNode, semanticScope);
            this.decorateWithCast(userValueNode, semanticScope);
        }
        semanticScope.putDecoration(userMapInitNode, new Decorations.ValueType(valueType));
    }

    @Override
    public void visitNewArray(ENewArray userNewArrayNode, SemanticScope semanticScope) {
        if (semanticScope.getCondition(userNewArrayNode, Decorations.Write.class)) {
            throw userNewArrayNode.createError(new IllegalArgumentException("invalid assignment: cannot assign a value to new array"));
        }
        if (!semanticScope.getCondition(userNewArrayNode, Decorations.Read.class)) {
            throw userNewArrayNode.createError(new IllegalArgumentException("not a statement: result not used from new array"));
        }
        String canonicalTypeName = userNewArrayNode.getCanonicalTypeName();
        Class<?> valueType = semanticScope.getScriptScope().getPainlessLookup().canonicalTypeNameToType(canonicalTypeName);
        if (valueType == null) {
            throw userNewArrayNode.createError(new IllegalArgumentException("Not a type [" + canonicalTypeName + "]."));
        }
        for (AExpression userValueNode : userNewArrayNode.getValueNodes()) {
            semanticScope.setCondition(userValueNode, Decorations.Read.class);
            semanticScope.putDecoration(userValueNode, new Decorations.TargetType(userNewArrayNode.isInitializer() ? valueType.getComponentType() : Integer.TYPE));
            semanticScope.setCondition(userValueNode, Decorations.Internal.class);
            this.checkedVisit(userValueNode, semanticScope);
            this.decorateWithCast(userValueNode, semanticScope);
        }
        semanticScope.putDecoration(userNewArrayNode, new Decorations.ValueType(valueType));
    }

    @Override
    public void visitNewObj(ENewObj userNewObjNode, SemanticScope semanticScope) {
        String canonicalTypeName = userNewObjNode.getCanonicalTypeName();
        List<AExpression> userArgumentNodes = userNewObjNode.getArgumentNodes();
        int userArgumentsSize = userArgumentNodes.size();
        if (semanticScope.getCondition(userNewObjNode, Decorations.Write.class)) {
            throw userNewObjNode.createError(new IllegalArgumentException("invalid assignment cannot assign a value to new object with constructor [" + canonicalTypeName + "/" + userArgumentsSize + "]"));
        }
        ScriptScope scriptScope = semanticScope.getScriptScope();
        Class<?> valueType = scriptScope.getPainlessLookup().canonicalTypeNameToType(canonicalTypeName);
        if (valueType == null) {
            throw userNewObjNode.createError(new IllegalArgumentException("Not a type [" + canonicalTypeName + "]."));
        }
        PainlessConstructor constructor = scriptScope.getPainlessLookup().lookupPainlessConstructor(valueType, userArgumentsSize);
        if (constructor == null) {
            throw userNewObjNode.createError(new IllegalArgumentException("constructor [" + PainlessLookupUtility.typeToCanonicalTypeName(valueType) + ", <init>/" + userArgumentsSize + "] not found"));
        }
        scriptScope.putDecoration(userNewObjNode, new Decorations.StandardPainlessConstructor(constructor));
        scriptScope.markNonDeterministic(constructor.annotations.containsKey(NonDeterministicAnnotation.class));
        Class[] types = new Class[constructor.typeParameters.size()];
        constructor.typeParameters.toArray(types);
        if (constructor.typeParameters.size() != userArgumentsSize) {
            throw userNewObjNode.createError(new IllegalArgumentException("When calling constructor on type [" + PainlessLookupUtility.typeToCanonicalTypeName(valueType) + "] expected [" + constructor.typeParameters.size() + "] arguments, but found [" + userArgumentsSize + "]."));
        }
        for (int i = 0; i < userArgumentsSize; ++i) {
            AExpression userArgumentNode = userArgumentNodes.get(i);
            semanticScope.setCondition(userArgumentNode, Decorations.Read.class);
            semanticScope.putDecoration(userArgumentNode, new Decorations.TargetType(types[i]));
            semanticScope.setCondition(userArgumentNode, Decorations.Internal.class);
            this.checkedVisit(userArgumentNode, semanticScope);
            this.decorateWithCast(userArgumentNode, semanticScope);
        }
        semanticScope.putDecoration(userNewObjNode, new Decorations.ValueType(valueType));
    }

    @Override
    public void visitCallLocal(ECallLocal userCallLocalNode, SemanticScope semanticScope) {
        Class<?> valueType;
        ArrayList typeParameters;
        String methodName = userCallLocalNode.getMethodName();
        List<AExpression> userArgumentNodes = userCallLocalNode.getArgumentNodes();
        int userArgumentsSize = userArgumentNodes.size();
        if (semanticScope.getCondition(userCallLocalNode, Decorations.Write.class)) {
            throw userCallLocalNode.createError(new IllegalArgumentException("invalid assignment: cannot assign a value to function call [" + methodName + "/" + userArgumentsSize + "]"));
        }
        ScriptScope scriptScope = semanticScope.getScriptScope();
        FunctionTable.LocalFunction localFunction = null;
        PainlessMethod importedMethod = null;
        PainlessClassBinding classBinding = null;
        int classBindingOffset = 0;
        PainlessInstanceBinding instanceBinding = null;
        localFunction = scriptScope.getFunctionTable().getFunction(methodName, userArgumentsSize);
        if (localFunction != null && localFunction.isInternal()) {
            localFunction = null;
        }
        if (localFunction == null && (importedMethod = scriptScope.getPainlessLookup().lookupImportedPainlessMethod(methodName, userArgumentsSize)) == null) {
            classBinding = scriptScope.getPainlessLookup().lookupPainlessClassBinding(methodName, userArgumentsSize);
            if (classBinding != null && !classBinding.typeParameters.isEmpty() && classBinding.typeParameters.get(0) == scriptScope.getScriptClassInfo().getBaseClass()) {
                classBinding = null;
            }
            if (classBinding == null) {
                classBinding = scriptScope.getPainlessLookup().lookupPainlessClassBinding(methodName, userArgumentsSize + 1);
                if (classBinding != null) {
                    if (!classBinding.typeParameters.isEmpty() && classBinding.typeParameters.get(0) == scriptScope.getScriptClassInfo().getBaseClass()) {
                        classBindingOffset = 1;
                    } else {
                        classBinding = null;
                    }
                }
                if (classBinding == null && (instanceBinding = scriptScope.getPainlessLookup().lookupPainlessInstanceBinding(methodName, userArgumentsSize)) == null) {
                    throw userCallLocalNode.createError(new IllegalArgumentException("Unknown call [" + methodName + "] with [" + userArgumentNodes + "] arguments."));
                }
            }
        }
        if (localFunction != null) {
            semanticScope.putDecoration(userCallLocalNode, new Decorations.StandardLocalFunction(localFunction));
            typeParameters = new ArrayList(localFunction.getTypeParameters());
            valueType = localFunction.getReturnType();
        } else if (importedMethod != null) {
            semanticScope.putDecoration(userCallLocalNode, new Decorations.StandardPainlessMethod(importedMethod));
            scriptScope.markNonDeterministic(importedMethod.annotations.containsKey(NonDeterministicAnnotation.class));
            typeParameters = new ArrayList(importedMethod.typeParameters);
            valueType = importedMethod.returnType;
        } else if (classBinding != null) {
            semanticScope.putDecoration(userCallLocalNode, new Decorations.StandardPainlessClassBinding(classBinding));
            semanticScope.putDecoration(userCallLocalNode, new Decorations.StandardConstant(classBindingOffset));
            scriptScope.markNonDeterministic(classBinding.annotations.containsKey(NonDeterministicAnnotation.class));
            typeParameters = new ArrayList(classBinding.typeParameters);
            valueType = classBinding.returnType;
        } else if (instanceBinding != null) {
            semanticScope.putDecoration(userCallLocalNode, new Decorations.StandardPainlessInstanceBinding(instanceBinding));
            typeParameters = new ArrayList(instanceBinding.typeParameters);
            valueType = instanceBinding.returnType;
        } else {
            throw new IllegalStateException("Illegal tree structure.");
        }
        for (int argument = 0; argument < userArgumentsSize; ++argument) {
            AExpression userArgumentNode = userArgumentNodes.get(argument);
            semanticScope.setCondition(userArgumentNode, Decorations.Read.class);
            semanticScope.putDecoration(userArgumentNode, new Decorations.TargetType((Class)typeParameters.get(argument + classBindingOffset)));
            semanticScope.setCondition(userArgumentNode, Decorations.Internal.class);
            this.checkedVisit(userArgumentNode, semanticScope);
            this.decorateWithCast(userArgumentNode, semanticScope);
        }
        semanticScope.putDecoration(userCallLocalNode, new Decorations.ValueType(valueType));
    }

    @Override
    public void visitBooleanConstant(EBooleanConstant userBooleanConstantNode, SemanticScope semanticScope) {
        boolean bool = userBooleanConstantNode.getBool();
        if (semanticScope.getCondition(userBooleanConstantNode, Decorations.Write.class)) {
            throw userBooleanConstantNode.createError(new IllegalArgumentException("invalid assignment: cannot assign a value to boolean constant [" + bool + "]"));
        }
        if (!semanticScope.getCondition(userBooleanConstantNode, Decorations.Read.class)) {
            throw userBooleanConstantNode.createError(new IllegalArgumentException("not a statement: boolean constant [" + bool + "] not used"));
        }
        semanticScope.putDecoration(userBooleanConstantNode, new Decorations.ValueType(Boolean.TYPE));
        semanticScope.putDecoration(userBooleanConstantNode, new Decorations.StandardConstant(bool));
    }

    @Override
    public void visitNumeric(ENumeric userNumericNode, SemanticScope semanticScope) {
        Class<Constable> valueType;
        Constable constant;
        Object numeric = userNumericNode.getNumeric();
        if (semanticScope.getCondition(userNumericNode, Decorations.Negate.class)) {
            numeric = "-" + (String)numeric;
        }
        if (semanticScope.getCondition(userNumericNode, Decorations.Write.class)) {
            throw userNumericNode.createError(new IllegalArgumentException("invalid assignment: cannot assign a value to numeric constant [" + (String)numeric + "]"));
        }
        if (!semanticScope.getCondition(userNumericNode, Decorations.Read.class)) {
            throw userNumericNode.createError(new IllegalArgumentException("not a statement: numeric constant [" + (String)numeric + "] not used"));
        }
        int radix = userNumericNode.getRadix();
        if (((String)numeric).endsWith("d") || ((String)numeric).endsWith("D")) {
            if (radix != 10) {
                throw userNumericNode.createError(new IllegalStateException("Illegal tree structure."));
            }
            try {
                constant = Double.parseDouble(((String)numeric).substring(0, ((String)numeric).length() - 1));
                valueType = Double.TYPE;
            }
            catch (NumberFormatException exception) {
                throw userNumericNode.createError(new IllegalArgumentException("Invalid double constant [" + (String)numeric + "]."));
            }
        }
        if (((String)numeric).endsWith("f") || ((String)numeric).endsWith("F")) {
            if (radix != 10) {
                throw userNumericNode.createError(new IllegalStateException("Illegal tree structure."));
            }
            try {
                constant = Float.valueOf(Float.parseFloat(((String)numeric).substring(0, ((String)numeric).length() - 1)));
                valueType = Float.TYPE;
            }
            catch (NumberFormatException exception) {
                throw userNumericNode.createError(new IllegalArgumentException("Invalid float constant [" + (String)numeric + "]."));
            }
        }
        if (((String)numeric).endsWith("l") || ((String)numeric).endsWith("L")) {
            try {
                constant = Long.parseLong(((String)numeric).substring(0, ((String)numeric).length() - 1), radix);
                valueType = Long.TYPE;
            }
            catch (NumberFormatException exception) {
                throw userNumericNode.createError(new IllegalArgumentException("Invalid long constant [" + (String)numeric + "]."));
            }
        }
        try {
            Decorations.TargetType targetType = semanticScope.getDecoration(userNumericNode, Decorations.TargetType.class);
            Class<Integer> sort = targetType == null ? Integer.TYPE : targetType.getTargetType();
            int integer = Integer.parseInt((String)numeric, radix);
            if (sort == Byte.TYPE && integer >= -128 && integer <= 127) {
                constant = (byte)integer;
                valueType = Byte.TYPE;
            } else if (sort == Character.TYPE && integer >= 0 && integer <= 65535) {
                constant = Character.valueOf((char)integer);
                valueType = Character.TYPE;
            } else if (sort == Short.TYPE && integer >= Short.MIN_VALUE && integer <= Short.MAX_VALUE) {
                constant = (short)integer;
                valueType = Short.TYPE;
            } else {
                constant = integer;
                valueType = Integer.TYPE;
            }
        }
        catch (NumberFormatException exception) {
            try {
                Long.parseLong((String)numeric, radix);
                throw userNumericNode.createError(new IllegalArgumentException("Invalid int constant [" + (String)numeric + "]. If you want a long constant then change it to [" + (String)numeric + "L]."));
            }
            catch (NumberFormatException numberFormatException) {
                throw userNumericNode.createError(new IllegalArgumentException("Invalid int constant [" + (String)numeric + "]."));
            }
        }
        semanticScope.putDecoration(userNumericNode, new Decorations.ValueType(valueType));
        semanticScope.putDecoration(userNumericNode, new Decorations.StandardConstant(constant));
    }

    @Override
    public void visitDecimal(EDecimal userDecimalNode, SemanticScope semanticScope) {
        Class<Number> valueType;
        Number constant;
        Object decimal = userDecimalNode.getDecimal();
        if (semanticScope.getCondition(userDecimalNode, Decorations.Negate.class)) {
            decimal = "-" + (String)decimal;
        }
        if (semanticScope.getCondition(userDecimalNode, Decorations.Write.class)) {
            throw userDecimalNode.createError(new IllegalArgumentException("invalid assignment: cannot assign a value to decimal constant [" + (String)decimal + "]"));
        }
        if (!semanticScope.getCondition(userDecimalNode, Decorations.Read.class)) {
            throw userDecimalNode.createError(new IllegalArgumentException("not a statement: decimal constant [" + (String)decimal + "] not used"));
        }
        if (((String)decimal).endsWith("f") || ((String)decimal).endsWith("F")) {
            try {
                constant = Float.valueOf(Float.parseFloat(((String)decimal).substring(0, ((String)decimal).length() - 1)));
                valueType = Float.TYPE;
            }
            catch (NumberFormatException exception) {
                throw userDecimalNode.createError(new IllegalArgumentException("Invalid float constant [" + (String)decimal + "]."));
            }
        }
        Object toParse = decimal;
        if (((String)toParse).endsWith("d") || ((String)decimal).endsWith("D")) {
            toParse = ((String)toParse).substring(0, ((String)decimal).length() - 1);
        }
        try {
            constant = Double.parseDouble((String)toParse);
            valueType = Double.TYPE;
        }
        catch (NumberFormatException exception) {
            throw userDecimalNode.createError(new IllegalArgumentException("Invalid double constant [" + (String)decimal + "]."));
        }
        semanticScope.putDecoration(userDecimalNode, new Decorations.ValueType(valueType));
        semanticScope.putDecoration(userDecimalNode, new Decorations.StandardConstant(constant));
    }

    @Override
    public void visitString(EString userStringNode, SemanticScope semanticScope) {
        String string = userStringNode.getString();
        if (semanticScope.getCondition(userStringNode, Decorations.Write.class)) {
            throw userStringNode.createError(new IllegalArgumentException("invalid assignment: cannot assign a value to string constant [" + string + "]"));
        }
        if (!semanticScope.getCondition(userStringNode, Decorations.Read.class)) {
            throw userStringNode.createError(new IllegalArgumentException("not a statement: string constant [" + string + "] not used"));
        }
        semanticScope.putDecoration(userStringNode, new Decorations.ValueType(String.class));
        semanticScope.putDecoration(userStringNode, new Decorations.StandardConstant(string));
    }

    @Override
    public void visitNull(ENull userNullNode, SemanticScope semanticScope) {
        Class valueType;
        if (semanticScope.getCondition(userNullNode, Decorations.Write.class)) {
            throw userNullNode.createError(new IllegalArgumentException("invalid assignment: cannot assign a value to null constant"));
        }
        if (!semanticScope.getCondition(userNullNode, Decorations.Read.class)) {
            throw userNullNode.createError(new IllegalArgumentException("not a statement: null constant not used"));
        }
        Decorations.TargetType targetType = semanticScope.getDecoration(userNullNode, Decorations.TargetType.class);
        if (targetType != null) {
            if (targetType.getTargetType().isPrimitive()) {
                throw userNullNode.createError(new IllegalArgumentException("Cannot cast null to a primitive type [" + targetType.getTargetCanonicalTypeName() + "]."));
            }
            valueType = targetType.getTargetType();
        } else {
            valueType = Object.class;
        }
        semanticScope.putDecoration(userNullNode, new Decorations.ValueType(valueType));
    }

    @Override
    public void visitRegex(ERegex userRegexNode, SemanticScope semanticScope) {
        String pattern = userRegexNode.getPattern();
        String flags = userRegexNode.getFlags();
        if (semanticScope.getCondition(userRegexNode, Decorations.Write.class)) {
            throw userRegexNode.createError(new IllegalArgumentException("invalid assignment: cannot assign a value to regex constant [" + pattern + "] with flags [" + flags + "]"));
        }
        if (!semanticScope.getCondition(userRegexNode, Decorations.Read.class)) {
            throw userRegexNode.createError(new IllegalArgumentException("not a statement: regex constant [" + pattern + "] with flags [" + flags + "] not used"));
        }
        if (semanticScope.getScriptScope().getCompilerSettings().areRegexesEnabled() == CompilerSettings.RegexEnabled.FALSE) {
            throw userRegexNode.createError(new IllegalStateException("Regexes are disabled. Set [script.painless.regex.enabled] to [true] in opensearch.yaml to allow them. Be careful though, regexes break out of Painless's protection against deep recursion and long loops."));
        }
        Location location = userRegexNode.getLocation();
        int constant = 0;
        block12: for (int i = 0; i < flags.length(); ++i) {
            char flag = flags.charAt(i);
            switch (flag) {
                case 'c': {
                    constant |= 0x80;
                    continue block12;
                }
                case 'i': {
                    constant |= 2;
                    continue block12;
                }
                case 'l': {
                    constant |= 0x10;
                    continue block12;
                }
                case 'm': {
                    constant |= 8;
                    continue block12;
                }
                case 's': {
                    constant |= 0x20;
                    continue block12;
                }
                case 'U': {
                    constant |= 0x100;
                    continue block12;
                }
                case 'u': {
                    constant |= 0x40;
                    continue block12;
                }
                case 'x': {
                    constant |= 4;
                    continue block12;
                }
                default: {
                    throw new IllegalArgumentException("invalid regular expression: unknown flag [" + flag + "]");
                }
            }
        }
        try {
            Pattern.compile(pattern, constant);
        }
        catch (PatternSyntaxException pse) {
            throw new Location(location.getSourceName(), location.getOffset() + 1 + pse.getIndex()).createError(new IllegalArgumentException("invalid regular expression: could not compile regex constant [" + pattern + "] with flags [" + flags + "]", pse));
        }
        semanticScope.putDecoration(userRegexNode, new Decorations.ValueType(Pattern.class));
        semanticScope.putDecoration(userRegexNode, new Decorations.StandardConstant(constant));
    }

    @Override
    public void visitLambda(ELambda userLambdaNode, SemanticScope semanticScope) {
        Class valueType;
        Class<?> typeParameter;
        ArrayList typeParameters;
        Class returnType;
        if (semanticScope.getCondition(userLambdaNode, Decorations.Write.class)) {
            throw userLambdaNode.createError(new IllegalArgumentException("invalid assignment: cannot assign a value to a lambda"));
        }
        if (!semanticScope.getCondition(userLambdaNode, Decorations.Read.class)) {
            throw userLambdaNode.createError(new IllegalArgumentException("not a statement: lambda not used"));
        }
        ScriptScope scriptScope = semanticScope.getScriptScope();
        Decorations.TargetType targetType = semanticScope.getDecoration(userLambdaNode, Decorations.TargetType.class);
        List<String> canonicalTypeNameParameters = userLambdaNode.getCanonicalTypeNameParameters();
        if (targetType == null) {
            returnType = def.class;
            typeParameters = new ArrayList(canonicalTypeNameParameters.size());
            for (String type : canonicalTypeNameParameters) {
                if (type == null) {
                    typeParameters.add(def.class);
                    continue;
                }
                typeParameter = scriptScope.getPainlessLookup().canonicalTypeNameToType(type);
                if (typeParameter == null) {
                    throw userLambdaNode.createError(new IllegalArgumentException("cannot resolve type [" + type + "]"));
                }
                typeParameters.add(typeParameter);
            }
        } else {
            PainlessMethod interfaceMethod = scriptScope.getPainlessLookup().lookupFunctionalInterfacePainlessMethod(targetType.getTargetType());
            if (interfaceMethod == null) {
                throw userLambdaNode.createError(new IllegalArgumentException("Cannot pass lambda to [" + targetType.getTargetCanonicalTypeName() + "], not a functional interface"));
            }
            if (interfaceMethod.typeParameters.size() != canonicalTypeNameParameters.size()) {
                throw new IllegalArgumentException("Incorrect number of parameters for [" + interfaceMethod.javaMethod.getName() + "] in [" + targetType.getTargetCanonicalTypeName() + "]");
            }
            returnType = interfaceMethod.returnType == Void.TYPE ? def.class : interfaceMethod.returnType;
            typeParameters = new ArrayList(canonicalTypeNameParameters.size());
            for (int i = 0; i < canonicalTypeNameParameters.size(); ++i) {
                String paramType = canonicalTypeNameParameters.get(i);
                if (paramType == null) {
                    typeParameters.add(interfaceMethod.typeParameters.get(i));
                    continue;
                }
                typeParameter = scriptScope.getPainlessLookup().canonicalTypeNameToType(paramType);
                if (typeParameter == null) {
                    throw userLambdaNode.createError(new IllegalArgumentException("cannot resolve type [" + paramType + "]"));
                }
                typeParameters.add(typeParameter);
            }
        }
        Location location = userLambdaNode.getLocation();
        List<String> parameterNames = userLambdaNode.getParameterNames();
        SemanticScope.LambdaScope lambdaScope = semanticScope.newLambdaScope(returnType);
        for (int index = 0; index < typeParameters.size(); ++index) {
            Class type = (Class)typeParameters.get(index);
            String parameterName = parameterNames.get(index);
            lambdaScope.defineVariable(location, type, parameterName, true);
        }
        SBlock userBlockNode = userLambdaNode.getBlockNode();
        if (userBlockNode.getStatementNodes().isEmpty()) {
            throw userLambdaNode.createError(new IllegalArgumentException("cannot generate empty lambda"));
        }
        semanticScope.setCondition(userBlockNode, Decorations.LastSource.class);
        this.visit(userBlockNode, lambdaScope);
        if (!semanticScope.getCondition(userBlockNode, Decorations.MethodEscape.class)) {
            throw userLambdaNode.createError(new IllegalArgumentException("not all paths return a value for lambda"));
        }
        ArrayList<SemanticScope.Variable> capturedVariables = new ArrayList<SemanticScope.Variable>(lambdaScope.getCaptures());
        ArrayList typeParametersWithCaptures = new ArrayList(capturedVariables.size() + typeParameters.size());
        ArrayList<String> parameterNamesWithCaptures = new ArrayList<String>(capturedVariables.size() + parameterNames.size());
        for (SemanticScope.Variable capturedVariable : capturedVariables) {
            typeParametersWithCaptures.add(capturedVariable.getType());
            parameterNamesWithCaptures.add(capturedVariable.getName());
        }
        typeParametersWithCaptures.addAll(typeParameters);
        parameterNamesWithCaptures.addAll(parameterNames);
        String name = scriptScope.getNextSyntheticName("lambda");
        scriptScope.getFunctionTable().addFunction(name, returnType, typeParametersWithCaptures, true, true);
        if (targetType == null) {
            String defReferenceEncoding = "Sthis." + name + "," + capturedVariables.size();
            valueType = String.class;
            semanticScope.putDecoration(userLambdaNode, new Decorations.EncodingDecoration(defReferenceEncoding));
        } else {
            FunctionRef ref = FunctionRef.create(scriptScope.getPainlessLookup(), scriptScope.getFunctionTable(), location, targetType.getTargetType(), "this", name, capturedVariables.size(), scriptScope.getCompilerSettings().asMap());
            valueType = targetType.getTargetType();
            semanticScope.putDecoration(userLambdaNode, new Decorations.ReferenceDecoration(ref));
        }
        semanticScope.putDecoration(userLambdaNode, new Decorations.ValueType(valueType));
        semanticScope.putDecoration(userLambdaNode, new Decorations.MethodNameDecoration(name));
        semanticScope.putDecoration(userLambdaNode, new Decorations.ReturnType(returnType));
        semanticScope.putDecoration(userLambdaNode, new Decorations.TypeParameters(typeParametersWithCaptures));
        semanticScope.putDecoration(userLambdaNode, new Decorations.ParameterNames(parameterNamesWithCaptures));
        semanticScope.putDecoration(userLambdaNode, new Decorations.CapturesDecoration(capturedVariables));
    }

    @Override
    public void visitFunctionRef(EFunctionRef userFunctionRefNode, SemanticScope semanticScope) {
        Class valueType;
        ScriptScope scriptScope = semanticScope.getScriptScope();
        Location location = userFunctionRefNode.getLocation();
        String symbol = userFunctionRefNode.getSymbol();
        String methodName = userFunctionRefNode.getMethodName();
        boolean read = semanticScope.getCondition(userFunctionRefNode, Decorations.Read.class);
        Class<?> type = scriptScope.getPainlessLookup().canonicalTypeNameToType(symbol);
        Decorations.TargetType targetType = semanticScope.getDecoration(userFunctionRefNode, Decorations.TargetType.class);
        if (symbol.equals("this") || type != null) {
            if (semanticScope.getCondition(userFunctionRefNode, Decorations.Write.class)) {
                throw userFunctionRefNode.createError(new IllegalArgumentException("invalid assignment: cannot assign a value to function reference [" + symbol + ":" + methodName + "]"));
            }
            if (!read) {
                throw userFunctionRefNode.createError(new IllegalArgumentException("not a statement: function reference [" + symbol + ":" + methodName + "] not used"));
            }
            if (targetType == null) {
                valueType = String.class;
                String defReferenceEncoding = "S" + symbol + "." + methodName + ",0";
                semanticScope.putDecoration(userFunctionRefNode, new Decorations.EncodingDecoration(defReferenceEncoding));
            } else {
                FunctionRef ref = FunctionRef.create(scriptScope.getPainlessLookup(), scriptScope.getFunctionTable(), location, targetType.getTargetType(), symbol, methodName, 0, scriptScope.getCompilerSettings().asMap());
                valueType = targetType.getTargetType();
                semanticScope.putDecoration(userFunctionRefNode, new Decorations.ReferenceDecoration(ref));
            }
        } else {
            if (semanticScope.getCondition(userFunctionRefNode, Decorations.Write.class)) {
                throw userFunctionRefNode.createError(new IllegalArgumentException("invalid assignment: cannot assign a value to capturing function reference [" + symbol + ":" + methodName + "]"));
            }
            if (!read) {
                throw userFunctionRefNode.createError(new IllegalArgumentException("not a statement: capturing function reference [" + symbol + ":" + methodName + "] not used"));
            }
            SemanticScope.Variable captured = semanticScope.getVariable(location, symbol);
            semanticScope.putDecoration(userFunctionRefNode, new Decorations.CapturesDecoration(Collections.singletonList(captured)));
            if (targetType == null) {
                String defReferenceEncoding = captured.getType() == def.class ? "D" + symbol + "." + methodName + ",1" : "S" + captured.getCanonicalTypeName() + "." + methodName + ",1";
                valueType = String.class;
                semanticScope.putDecoration(userFunctionRefNode, new Decorations.EncodingDecoration(defReferenceEncoding));
            } else {
                valueType = targetType.getTargetType();
                if (captured.getType() != def.class) {
                    FunctionRef ref = FunctionRef.create(scriptScope.getPainlessLookup(), scriptScope.getFunctionTable(), location, targetType.getTargetType(), captured.getCanonicalTypeName(), methodName, 1, scriptScope.getCompilerSettings().asMap());
                    semanticScope.putDecoration(userFunctionRefNode, new Decorations.ReferenceDecoration(ref));
                }
            }
        }
        semanticScope.putDecoration(userFunctionRefNode, new Decorations.ValueType(valueType));
    }

    @Override
    public void visitNewArrayFunctionRef(ENewArrayFunctionRef userNewArrayFunctionRefNode, SemanticScope semanticScope) {
        Class valueType;
        String canonicalTypeName = userNewArrayFunctionRefNode.getCanonicalTypeName();
        if (semanticScope.getCondition(userNewArrayFunctionRefNode, Decorations.Write.class)) {
            throw userNewArrayFunctionRefNode.createError(new IllegalArgumentException("cannot assign a value to new array function reference with target type [ + " + canonicalTypeName + "]"));
        }
        if (!semanticScope.getCondition(userNewArrayFunctionRefNode, Decorations.Read.class)) {
            throw userNewArrayFunctionRefNode.createError(new IllegalArgumentException("not a statement: new array function reference with target type [" + canonicalTypeName + "] not used"));
        }
        ScriptScope scriptScope = semanticScope.getScriptScope();
        Decorations.TargetType targetType = semanticScope.getDecoration(userNewArrayFunctionRefNode, Decorations.TargetType.class);
        Class<?> clazz = scriptScope.getPainlessLookup().canonicalTypeNameToType(canonicalTypeName);
        semanticScope.putDecoration(userNewArrayFunctionRefNode, new Decorations.ReturnType(clazz));
        if (clazz == null) {
            throw userNewArrayFunctionRefNode.createError(new IllegalArgumentException("Not a type [" + canonicalTypeName + "]."));
        }
        String name = scriptScope.getNextSyntheticName("newarray");
        scriptScope.getFunctionTable().addFunction(name, clazz, Collections.singletonList(Integer.TYPE), true, true);
        semanticScope.putDecoration(userNewArrayFunctionRefNode, new Decorations.MethodNameDecoration(name));
        if (targetType == null) {
            String defReferenceEncoding = "Sthis." + name + ",0";
            valueType = String.class;
            scriptScope.putDecoration(userNewArrayFunctionRefNode, new Decorations.EncodingDecoration(defReferenceEncoding));
        } else {
            FunctionRef ref = FunctionRef.create(scriptScope.getPainlessLookup(), scriptScope.getFunctionTable(), userNewArrayFunctionRefNode.getLocation(), targetType.getTargetType(), "this", name, 0, scriptScope.getCompilerSettings().asMap());
            valueType = targetType.getTargetType();
            semanticScope.putDecoration(userNewArrayFunctionRefNode, new Decorations.ReferenceDecoration(ref));
        }
        semanticScope.putDecoration(userNewArrayFunctionRefNode, new Decorations.ValueType(valueType));
    }

    @Override
    public void visitSymbol(ESymbol userSymbolNode, SemanticScope semanticScope) {
        boolean read = semanticScope.getCondition(userSymbolNode, Decorations.Read.class);
        boolean write = semanticScope.getCondition(userSymbolNode, Decorations.Write.class);
        String symbol = userSymbolNode.getSymbol();
        Class<?> staticType = semanticScope.getScriptScope().getPainlessLookup().canonicalTypeNameToType(symbol);
        if (staticType != null) {
            if (write) {
                throw userSymbolNode.createError(new IllegalArgumentException("invalid assignment: cannot write a value to a static type [" + PainlessLookupUtility.typeToCanonicalTypeName(staticType) + "]"));
            }
            if (!read) {
                throw userSymbolNode.createError(new IllegalArgumentException("not a statement: static type [" + PainlessLookupUtility.typeToCanonicalTypeName(staticType) + "] not used"));
            }
            semanticScope.putDecoration(userSymbolNode, new Decorations.StaticType(staticType));
        } else if (semanticScope.isVariableDefined(symbol)) {
            if (!read && !write) {
                throw userSymbolNode.createError(new IllegalArgumentException("not a statement: variable [" + symbol + "] not used"));
            }
            Location location = userSymbolNode.getLocation();
            SemanticScope.Variable variable = semanticScope.getVariable(location, symbol);
            if (write && variable.isFinal()) {
                throw userSymbolNode.createError(new IllegalArgumentException("Variable [" + variable.getName() + "] is read-only."));
            }
            Class<?> valueType = variable.getType();
            semanticScope.putDecoration(userSymbolNode, new Decorations.ValueType(valueType));
        } else {
            semanticScope.putDecoration(userSymbolNode, new Decorations.PartialCanonicalTypeName(symbol));
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void visitDot(EDot userDotNode, SemanticScope semanticScope) {
        void var11_23;
        boolean read = semanticScope.getCondition(userDotNode, Decorations.Read.class);
        boolean write = semanticScope.getCondition(userDotNode, Decorations.Write.class);
        if (!read && !write) {
            throw userDotNode.createError(new IllegalArgumentException("not a statement: result of dot operator [.] not used"));
        }
        ScriptScope scriptScope = semanticScope.getScriptScope();
        String index = userDotNode.getIndex();
        AExpression userPrefixNode = userDotNode.getPrefixNode();
        semanticScope.setCondition(userPrefixNode, Decorations.Read.class);
        this.visit(userPrefixNode, semanticScope);
        Decorations.ValueType prefixValueType = semanticScope.getDecoration(userPrefixNode, Decorations.ValueType.class);
        Decorations.StaticType prefixStaticType = semanticScope.getDecoration(userPrefixNode, Decorations.StaticType.class);
        if (prefixValueType != null && prefixStaticType != null) {
            throw userDotNode.createError(new IllegalStateException("cannot have both value [" + prefixValueType.getValueCanonicalTypeName() + "] and type [" + prefixStaticType.getStaticCanonicalTypeName() + "]"));
        }
        if (semanticScope.hasDecoration(userPrefixNode, Decorations.PartialCanonicalTypeName.class)) {
            if (prefixValueType != null) {
                throw userDotNode.createError(new IllegalArgumentException("value required: instead found unexpected type [" + prefixValueType.getValueCanonicalTypeName() + "]"));
            }
            if (prefixStaticType != null) {
                throw userDotNode.createError(new IllegalArgumentException("value required: instead found unexpected type [" + prefixStaticType.getStaticType() + "]"));
            }
            String canonicalTypeName = semanticScope.getDecoration(userPrefixNode, Decorations.PartialCanonicalTypeName.class).getPartialCanonicalTypeName() + "." + index;
            Class<?> clazz = scriptScope.getPainlessLookup().canonicalTypeNameToType(canonicalTypeName);
            if (clazz == null) {
                semanticScope.putDecoration(userDotNode, new Decorations.PartialCanonicalTypeName(canonicalTypeName));
                return;
            } else {
                if (write) {
                    throw userDotNode.createError(new IllegalArgumentException("invalid assignment: cannot write a value to a static type [" + PainlessLookupUtility.typeToCanonicalTypeName(clazz) + "]"));
                }
                semanticScope.putDecoration(userDotNode, new Decorations.StaticType(clazz));
            }
            return;
        }
        Class<?> staticType = null;
        if (prefixStaticType != null) {
            String string = prefixStaticType.getStaticCanonicalTypeName() + "." + userDotNode.getIndex();
            staticType = scriptScope.getPainlessLookup().canonicalTypeNameToType(string);
        }
        if (staticType != null) {
            if (write) {
                throw userDotNode.createError(new IllegalArgumentException("invalid assignment: cannot write a value to a static type [" + PainlessLookupUtility.typeToCanonicalTypeName(staticType) + "]"));
            }
            semanticScope.putDecoration(userDotNode, new Decorations.StaticType(staticType));
            return;
        }
        Object var11_14 = null;
        if (prefixValueType != null && prefixValueType.getValueType().isArray()) {
            if (!"length".equals(index)) throw userDotNode.createError(new IllegalArgumentException("Field [" + index + "] does not exist for type [" + prefixValueType.getValueCanonicalTypeName() + "]."));
            if (write) {
                throw userDotNode.createError(new IllegalArgumentException("invalid assignment: cannot assign a value write to read-only field [length] for an array."));
            }
            Class<Integer> clazz = Integer.TYPE;
        } else if (prefixValueType != null && prefixValueType.getValueType() == def.class) {
            Class<def> clazz;
            Decorations.TargetType targetType = userDotNode.isNullSafe() ? null : semanticScope.getDecoration(userDotNode, Decorations.TargetType.class);
            Class clazz2 = clazz = targetType == null || targetType.getTargetType() == ZonedDateTime.class || semanticScope.getCondition(userDotNode, Decorations.Explicit.class) ? def.class : targetType.getTargetType();
            if (write) {
                semanticScope.setCondition(userDotNode, Decorations.DefOptimized.class);
            }
        } else {
            boolean isStatic;
            String prefixCanonicalTypeName;
            Class<?> prefixType;
            if (prefixValueType != null) {
                prefixType = prefixValueType.getValueType();
                prefixCanonicalTypeName = prefixValueType.getValueCanonicalTypeName();
                isStatic = false;
            } else {
                if (prefixStaticType == null) throw userDotNode.createError(new IllegalStateException("value required: instead found no value"));
                prefixType = prefixStaticType.getStaticType();
                prefixCanonicalTypeName = prefixStaticType.getStaticCanonicalTypeName();
                isStatic = true;
            }
            PainlessField field = semanticScope.getScriptScope().getPainlessLookup().lookupPainlessField(prefixType, isStatic, index);
            if (field == null) {
                void var11_21;
                PainlessMethod getter = scriptScope.getPainlessLookup().lookupPainlessMethod(prefixType, isStatic, "get" + Character.toUpperCase(index.charAt(0)) + index.substring(1), 0);
                if (getter == null) {
                    getter = scriptScope.getPainlessLookup().lookupPainlessMethod(prefixType, isStatic, "is" + Character.toUpperCase(index.charAt(0)) + index.substring(1), 0);
                }
                PainlessMethod setter = scriptScope.getPainlessLookup().lookupPainlessMethod(prefixType, isStatic, "set" + Character.toUpperCase(index.charAt(0)) + index.substring(1), 0);
                if (getter != null || setter != null) {
                    if (!(getter == null || getter.returnType != Void.TYPE && getter.typeParameters.isEmpty())) {
                        throw userDotNode.createError(new IllegalArgumentException("Illegal get shortcut on field [" + index + "] for type [" + prefixCanonicalTypeName + "]."));
                    }
                    if (setter != null && (setter.returnType != Void.TYPE || setter.typeParameters.size() != 1)) {
                        throw userDotNode.createError(new IllegalArgumentException("Illegal set shortcut on field [" + index + "] for type [" + prefixCanonicalTypeName + "]."));
                    }
                    if (getter != null && setter != null && setter.typeParameters.get(0) != getter.returnType) {
                        throw userDotNode.createError(new IllegalArgumentException("Shortcut argument types must match."));
                    }
                    if (read && getter == null || write && setter == null) {
                        throw userDotNode.createError(new IllegalArgumentException("Illegal shortcut on field [" + index + "] for type [" + prefixCanonicalTypeName + "]."));
                    }
                    Class<?> clazz = setter != null ? setter.typeParameters.get(0) : getter.returnType;
                    if (getter != null) {
                        semanticScope.putDecoration(userDotNode, new Decorations.GetterPainlessMethod(getter));
                    }
                    if (setter != null) {
                        semanticScope.putDecoration(userDotNode, new Decorations.SetterPainlessMethod(setter));
                    }
                    semanticScope.setCondition(userDotNode, Decorations.Shortcut.class);
                } else if (!isStatic) {
                    if (Map.class.isAssignableFrom(prefixValueType.getValueType())) {
                        getter = scriptScope.getPainlessLookup().lookupPainlessMethod(prefixType, false, "get", 1);
                        setter = scriptScope.getPainlessLookup().lookupPainlessMethod(prefixType, false, "put", 2);
                        if (getter != null && (getter.returnType == Void.TYPE || getter.typeParameters.size() != 1)) {
                            throw userDotNode.createError(new IllegalArgumentException("Illegal map get shortcut for type [" + prefixCanonicalTypeName + "]."));
                        }
                        if (setter != null && setter.typeParameters.size() != 2) {
                            throw userDotNode.createError(new IllegalArgumentException("Illegal map set shortcut for type [" + prefixCanonicalTypeName + "]."));
                        }
                        if (!(getter == null || setter == null || getter.typeParameters.get(0).equals(setter.typeParameters.get(0)) && getter.returnType.equals(setter.typeParameters.get(1)))) {
                            throw userDotNode.createError(new IllegalArgumentException("Shortcut argument types must match."));
                        }
                        if (read && getter == null || write && setter == null) {
                            throw userDotNode.createError(new IllegalArgumentException("Illegal map shortcut for type [" + prefixCanonicalTypeName + "]."));
                        }
                        Class<?> clazz = setter != null ? setter.typeParameters.get(1) : getter.returnType;
                        if (getter != null) {
                            semanticScope.putDecoration(userDotNode, new Decorations.GetterPainlessMethod(getter));
                        }
                        if (setter != null) {
                            semanticScope.putDecoration(userDotNode, new Decorations.SetterPainlessMethod(setter));
                        }
                        semanticScope.setCondition(userDotNode, Decorations.MapShortcut.class);
                    }
                    if (List.class.isAssignableFrom(prefixType)) {
                        try {
                            scriptScope.putDecoration(userDotNode, new Decorations.StandardConstant(Integer.parseInt(index)));
                        }
                        catch (NumberFormatException nfe) {
                            throw userDotNode.createError(new IllegalArgumentException("invalid list index [" + index + "]", nfe));
                        }
                        getter = scriptScope.getPainlessLookup().lookupPainlessMethod(prefixType, false, "get", 1);
                        setter = scriptScope.getPainlessLookup().lookupPainlessMethod(prefixType, false, "set", 2);
                        if (getter != null && (getter.returnType == Void.TYPE || getter.typeParameters.size() != 1 || getter.typeParameters.get(0) != Integer.TYPE)) {
                            throw userDotNode.createError(new IllegalArgumentException("Illegal list get shortcut for type [" + prefixCanonicalTypeName + "]."));
                        }
                        if (setter != null && (setter.typeParameters.size() != 2 || setter.typeParameters.get(0) != Integer.TYPE)) {
                            throw userDotNode.createError(new IllegalArgumentException("Illegal list set shortcut for type [" + prefixCanonicalTypeName + "]."));
                        }
                        if (!(getter == null || setter == null || getter.typeParameters.get(0).equals(setter.typeParameters.get(0)) && getter.returnType.equals(setter.typeParameters.get(1)))) {
                            throw userDotNode.createError(new IllegalArgumentException("Shortcut argument types must match."));
                        }
                        if (read && getter == null || write && setter == null) {
                            throw userDotNode.createError(new IllegalArgumentException("Illegal list shortcut for type [" + prefixCanonicalTypeName + "]."));
                        }
                        Class<?> clazz = setter != null ? setter.typeParameters.get(1) : getter.returnType;
                        if (getter != null) {
                            semanticScope.putDecoration(userDotNode, new Decorations.GetterPainlessMethod(getter));
                        }
                        if (setter != null) {
                            semanticScope.putDecoration(userDotNode, new Decorations.SetterPainlessMethod(setter));
                        }
                        semanticScope.setCondition(userDotNode, Decorations.ListShortcut.class);
                    }
                }
                if (var11_21 == null) {
                    if (prefixValueType == null) throw userDotNode.createError(new IllegalArgumentException("field [" + prefixStaticType.getStaticCanonicalTypeName() + ", " + index + "] not found"));
                    throw userDotNode.createError(new IllegalArgumentException("field [" + prefixValueType.getValueCanonicalTypeName() + ", " + index + "] not found"));
                }
            } else {
                if (write && Modifier.isFinal(field.javaField.getModifiers())) {
                    throw userDotNode.createError(new IllegalArgumentException("invalid assignment: cannot assign a value to read-only field [" + field.javaField.getName() + "]"));
                }
                semanticScope.putDecoration(userDotNode, new Decorations.StandardPainlessField(field));
                Class<?> clazz = field.typeParameter;
            }
        }
        semanticScope.putDecoration(userDotNode, new Decorations.ValueType((Class<?>)var11_23));
        if (!userDotNode.isNullSafe()) return;
        if (write) {
            throw userDotNode.createError(new IllegalArgumentException("invalid assignment: cannot assign a value to a null safe operation [?.]"));
        }
        if (!var11_23.isPrimitive()) return;
        throw new IllegalArgumentException("Result of null safe operator must be nullable");
    }

    @Override
    public void visitBrace(EBrace userBraceNode, SemanticScope semanticScope) {
        Class valueType;
        boolean read = semanticScope.getCondition(userBraceNode, Decorations.Read.class);
        boolean write = semanticScope.getCondition(userBraceNode, Decorations.Write.class);
        if (!read && !write) {
            throw userBraceNode.createError(new IllegalArgumentException("not a statement: result of brace operator not used"));
        }
        AExpression userPrefixNode = userBraceNode.getPrefixNode();
        semanticScope.setCondition(userPrefixNode, Decorations.Read.class);
        this.checkedVisit(userPrefixNode, semanticScope);
        Class<?> prefixValueType = semanticScope.getDecoration(userPrefixNode, Decorations.ValueType.class).getValueType();
        AExpression userIndexNode = userBraceNode.getIndexNode();
        if (prefixValueType.isArray()) {
            semanticScope.setCondition(userIndexNode, Decorations.Read.class);
            semanticScope.putDecoration(userIndexNode, new Decorations.TargetType(Integer.TYPE));
            this.checkedVisit(userIndexNode, semanticScope);
            this.decorateWithCast(userIndexNode, semanticScope);
            valueType = prefixValueType.getComponentType();
        } else if (prefixValueType == def.class) {
            semanticScope.setCondition(userIndexNode, Decorations.Read.class);
            this.checkedVisit(userIndexNode, semanticScope);
            Decorations.TargetType targetType = semanticScope.getDecoration(userBraceNode, Decorations.TargetType.class);
            Class clazz = valueType = targetType == null || targetType.getTargetType() == ZonedDateTime.class || semanticScope.getCondition(userBraceNode, Decorations.Explicit.class) ? def.class : targetType.getTargetType();
            if (write) {
                semanticScope.setCondition(userBraceNode, Decorations.DefOptimized.class);
            }
        } else if (Map.class.isAssignableFrom(prefixValueType)) {
            String canonicalClassName = PainlessLookupUtility.typeToCanonicalTypeName(prefixValueType);
            PainlessMethod getter = semanticScope.getScriptScope().getPainlessLookup().lookupPainlessMethod(prefixValueType, false, "get", 1);
            PainlessMethod setter = semanticScope.getScriptScope().getPainlessLookup().lookupPainlessMethod(prefixValueType, false, "put", 2);
            if (getter != null && (getter.returnType == Void.TYPE || getter.typeParameters.size() != 1)) {
                throw userBraceNode.createError(new IllegalArgumentException("Illegal map get shortcut for type [" + canonicalClassName + "]."));
            }
            if (setter != null && setter.typeParameters.size() != 2) {
                throw userBraceNode.createError(new IllegalArgumentException("Illegal map set shortcut for type [" + canonicalClassName + "]."));
            }
            if (!(getter == null || setter == null || getter.typeParameters.get(0).equals(setter.typeParameters.get(0)) && getter.returnType.equals(setter.typeParameters.get(1)))) {
                throw userBraceNode.createError(new IllegalArgumentException("Shortcut argument types must match."));
            }
            if (!(read && getter == null || write && setter == null)) {
                semanticScope.setCondition(userIndexNode, Decorations.Read.class);
                semanticScope.putDecoration(userIndexNode, new Decorations.TargetType(setter != null ? setter.typeParameters.get(0) : getter.typeParameters.get(0)));
                this.checkedVisit(userIndexNode, semanticScope);
                this.decorateWithCast(userIndexNode, semanticScope);
                Class<Object> clazz = valueType = setter != null ? setter.typeParameters.get(1) : getter.returnType;
                if (getter != null) {
                    semanticScope.putDecoration(userBraceNode, new Decorations.GetterPainlessMethod(getter));
                }
                if (setter != null) {
                    semanticScope.putDecoration(userBraceNode, new Decorations.SetterPainlessMethod(setter));
                }
            } else {
                throw userBraceNode.createError(new IllegalArgumentException("Illegal map shortcut for type [" + canonicalClassName + "]."));
            }
            semanticScope.setCondition(userBraceNode, Decorations.MapShortcut.class);
        } else if (List.class.isAssignableFrom(prefixValueType)) {
            String canonicalClassName = PainlessLookupUtility.typeToCanonicalTypeName(prefixValueType);
            PainlessMethod getter = semanticScope.getScriptScope().getPainlessLookup().lookupPainlessMethod(prefixValueType, false, "get", 1);
            PainlessMethod setter = semanticScope.getScriptScope().getPainlessLookup().lookupPainlessMethod(prefixValueType, false, "set", 2);
            if (getter != null && (getter.returnType == Void.TYPE || getter.typeParameters.size() != 1 || getter.typeParameters.get(0) != Integer.TYPE)) {
                throw userBraceNode.createError(new IllegalArgumentException("Illegal list get shortcut for type [" + canonicalClassName + "]."));
            }
            if (setter != null && (setter.typeParameters.size() != 2 || setter.typeParameters.get(0) != Integer.TYPE)) {
                throw userBraceNode.createError(new IllegalArgumentException("Illegal list set shortcut for type [" + canonicalClassName + "]."));
            }
            if (!(getter == null || setter == null || getter.typeParameters.get(0).equals(setter.typeParameters.get(0)) && getter.returnType.equals(setter.typeParameters.get(1)))) {
                throw userBraceNode.createError(new IllegalArgumentException("Shortcut argument types must match."));
            }
            if (!(read && getter == null || write && setter == null)) {
                semanticScope.setCondition(userIndexNode, Decorations.Read.class);
                semanticScope.putDecoration(userIndexNode, new Decorations.TargetType(Integer.TYPE));
                this.checkedVisit(userIndexNode, semanticScope);
                this.decorateWithCast(userIndexNode, semanticScope);
                Class<Object> clazz = valueType = setter != null ? setter.typeParameters.get(1) : getter.returnType;
                if (getter != null) {
                    semanticScope.putDecoration(userBraceNode, new Decorations.GetterPainlessMethod(getter));
                }
                if (setter != null) {
                    semanticScope.putDecoration(userBraceNode, new Decorations.SetterPainlessMethod(setter));
                }
            } else {
                throw userBraceNode.createError(new IllegalArgumentException("Illegal list shortcut for type [" + canonicalClassName + "]."));
            }
            semanticScope.setCondition(userBraceNode, Decorations.ListShortcut.class);
        } else {
            throw userBraceNode.createError(new IllegalArgumentException("Illegal array access on type [" + PainlessLookupUtility.typeToCanonicalTypeName(prefixValueType) + "]."));
        }
        semanticScope.putDecoration(userBraceNode, new Decorations.ValueType(valueType));
    }

    @Override
    public void visitCall(ECall userCallNode, SemanticScope semanticScope) {
        Class valueType;
        String methodName = userCallNode.getMethodName();
        List<AExpression> userArgumentNodes = userCallNode.getArgumentNodes();
        int userArgumentsSize = userArgumentNodes.size();
        if (semanticScope.getCondition(userCallNode, Decorations.Write.class)) {
            throw userCallNode.createError(new IllegalArgumentException("invalid assignment: cannot assign a value to method call [" + methodName + "/" + userArgumentsSize + "]"));
        }
        AExpression userPrefixNode = userCallNode.getPrefixNode();
        semanticScope.setCondition(userPrefixNode, Decorations.Read.class);
        this.visit(userPrefixNode, semanticScope);
        Decorations.ValueType prefixValueType = semanticScope.getDecoration(userPrefixNode, Decorations.ValueType.class);
        Decorations.StaticType prefixStaticType = semanticScope.getDecoration(userPrefixNode, Decorations.StaticType.class);
        if (prefixValueType != null && prefixStaticType != null) {
            throw userCallNode.createError(new IllegalStateException("cannot have both value [" + prefixValueType.getValueCanonicalTypeName() + "] and type [" + prefixStaticType.getStaticCanonicalTypeName() + "]"));
        }
        if (semanticScope.hasDecoration(userPrefixNode, Decorations.PartialCanonicalTypeName.class)) {
            throw userCallNode.createError(new IllegalArgumentException("cannot resolve symbol [" + semanticScope.getDecoration(userPrefixNode, Decorations.PartialCanonicalTypeName.class).getPartialCanonicalTypeName() + "]"));
        }
        if (prefixValueType != null && prefixValueType.getValueType() == def.class) {
            for (AExpression userArgumentNode : userArgumentNodes) {
                semanticScope.setCondition(userArgumentNode, Decorations.Read.class);
                semanticScope.setCondition(userArgumentNode, Decorations.Internal.class);
                this.checkedVisit(userArgumentNode, semanticScope);
                Class<?> argumentValueType = semanticScope.getDecoration(userArgumentNode, Decorations.ValueType.class).getValueType();
                if (argumentValueType != Void.TYPE) continue;
                throw userCallNode.createError(new IllegalArgumentException("Argument(s) cannot be of [void] type when calling method [" + methodName + "]."));
            }
            Decorations.TargetType targetType = userCallNode.isNullSafe() ? null : semanticScope.getDecoration(userCallNode, Decorations.TargetType.class);
            valueType = targetType == null || targetType.getTargetType() == ZonedDateTime.class || semanticScope.getCondition(userCallNode, Decorations.Explicit.class) ? def.class : targetType.getTargetType();
        } else {
            PainlessMethod method;
            if (prefixValueType != null) {
                method = semanticScope.getScriptScope().getPainlessLookup().lookupPainlessMethod(prefixValueType.getValueType(), false, methodName, userArgumentsSize);
                if (method == null) {
                    throw userCallNode.createError(new IllegalArgumentException("member method [" + prefixValueType.getValueCanonicalTypeName() + ", " + methodName + "/" + userArgumentsSize + "] not found"));
                }
            } else if (prefixStaticType != null) {
                method = semanticScope.getScriptScope().getPainlessLookup().lookupPainlessMethod(prefixStaticType.getStaticType(), true, methodName, userArgumentsSize);
                if (method == null) {
                    throw userCallNode.createError(new IllegalArgumentException("static method [" + prefixStaticType.getStaticCanonicalTypeName() + ", " + methodName + "/" + userArgumentsSize + "] not found"));
                }
            } else {
                throw userCallNode.createError(new IllegalStateException("value required: instead found no value"));
            }
            semanticScope.getScriptScope().markNonDeterministic(method.annotations.containsKey(NonDeterministicAnnotation.class));
            for (int argument = 0; argument < userArgumentsSize; ++argument) {
                AExpression userArgumentNode = userArgumentNodes.get(argument);
                semanticScope.setCondition(userArgumentNode, Decorations.Read.class);
                semanticScope.putDecoration(userArgumentNode, new Decorations.TargetType(method.typeParameters.get(argument)));
                semanticScope.setCondition(userArgumentNode, Decorations.Internal.class);
                this.checkedVisit(userArgumentNode, semanticScope);
                this.decorateWithCast(userArgumentNode, semanticScope);
            }
            semanticScope.putDecoration(userCallNode, new Decorations.StandardPainlessMethod(method));
            valueType = method.returnType;
        }
        if (userCallNode.isNullSafe() && valueType.isPrimitive()) {
            throw new IllegalArgumentException("Result of null safe operator must be nullable");
        }
        semanticScope.putDecoration(userCallNode, new Decorations.ValueType(valueType));
    }
}

