/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.backward_codecs.lucene40.blocktree;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.lucene.backward_codecs.lucene40.blocktree.FieldReader;
import org.apache.lucene.backward_codecs.store.EndiannessReverserUtil;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.codecs.PostingsReaderBase;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.Terms;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.fst.ByteSequenceOutputs;
import org.apache.lucene.util.fst.Outputs;

public final class Lucene40BlockTreeTermsReader
extends FieldsProducer {
    static final Outputs<BytesRef> FST_OUTPUTS = ByteSequenceOutputs.getSingleton();
    static final BytesRef NO_OUTPUT = (BytesRef)FST_OUTPUTS.getNoOutput();
    static final int OUTPUT_FLAGS_NUM_BITS = 2;
    static final int OUTPUT_FLAGS_MASK = 3;
    static final int OUTPUT_FLAG_IS_FLOOR = 1;
    static final int OUTPUT_FLAG_HAS_TERMS = 2;
    static final String TERMS_EXTENSION = "tim";
    static final String TERMS_CODEC_NAME = "BlockTreeTermsDict";
    public static final int VERSION_START = 3;
    public static final int VERSION_META_LONGS_REMOVED = 4;
    public static final int VERSION_COMPRESSED_SUFFIXES = 5;
    public static final int VERSION_META_FILE = 6;
    public static final int VERSION_CURRENT = 6;
    static final String TERMS_INDEX_EXTENSION = "tip";
    static final String TERMS_INDEX_CODEC_NAME = "BlockTreeTermsIndex";
    static final String TERMS_META_EXTENSION = "tmd";
    static final String TERMS_META_CODEC_NAME = "BlockTreeTermsMeta";
    final IndexInput termsIn;
    final IndexInput indexIn;
    final PostingsReaderBase postingsReader;
    private final Map<String, FieldReader> fieldMap;
    private final List<String> fieldList;
    final String segment;
    final int version;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Lucene40BlockTreeTermsReader(PostingsReaderBase postingsReader, SegmentReadState state) throws IOException {
        boolean success = false;
        this.postingsReader = postingsReader;
        this.segment = state.segmentInfo.name;
        try {
            long termsLength;
            long indexLength;
            HashMap<String, FieldReader> fieldMap;
            block34: {
                String termsName = IndexFileNames.segmentFileName((String)this.segment, (String)state.segmentSuffix, (String)TERMS_EXTENSION);
                this.termsIn = EndiannessReverserUtil.openInput(state.directory, termsName, state.context);
                this.version = CodecUtil.checkIndexHeader((DataInput)this.termsIn, (String)TERMS_CODEC_NAME, (int)3, (int)6, (byte[])state.segmentInfo.getId(), (String)state.segmentSuffix);
                String indexName = IndexFileNames.segmentFileName((String)this.segment, (String)state.segmentSuffix, (String)TERMS_INDEX_EXTENSION);
                this.indexIn = EndiannessReverserUtil.openInput(state.directory, indexName, state.context);
                CodecUtil.checkIndexHeader((DataInput)this.indexIn, (String)TERMS_INDEX_CODEC_NAME, (int)this.version, (int)this.version, (byte[])state.segmentInfo.getId(), (String)state.segmentSuffix);
                if (this.version < 6) {
                    postingsReader.init(this.termsIn, state);
                    CodecUtil.retrieveChecksum((IndexInput)this.indexIn);
                    CodecUtil.retrieveChecksum((IndexInput)this.termsIn);
                }
                String metaName = IndexFileNames.segmentFileName((String)this.segment, (String)state.segmentSuffix, (String)TERMS_META_EXTENSION);
                fieldMap = null;
                Throwable priorE = null;
                indexLength = -1L;
                termsLength = -1L;
                try (ChecksumIndexInput metaIn = this.version >= 6 ? EndiannessReverserUtil.openChecksumInput(state.directory, metaName, state.context) : null;){
                    block33: {
                        try {
                            IndexInput indexMetaIn;
                            IndexInput termsMetaIn;
                            if (this.version >= 6) {
                                CodecUtil.checkIndexHeader((DataInput)metaIn, (String)TERMS_META_CODEC_NAME, (int)this.version, (int)this.version, (byte[])state.segmentInfo.getId(), (String)state.segmentSuffix);
                                indexMetaIn = termsMetaIn = metaIn;
                                postingsReader.init((IndexInput)metaIn, state);
                            } else {
                                Lucene40BlockTreeTermsReader.seekDir(this.termsIn);
                                Lucene40BlockTreeTermsReader.seekDir(this.termsIn);
                                Lucene40BlockTreeTermsReader.seekDir(this.indexIn);
                                indexMetaIn = this.indexIn;
                                termsMetaIn = this.termsIn;
                            }
                            int numFields = termsMetaIn.readVInt();
                            if (numFields < 0) {
                                throw new CorruptIndexException("invalid numFields: " + numFields, (DataInput)termsMetaIn);
                            }
                            fieldMap = new HashMap<String, FieldReader>((int)((float)numFields / 0.75f) + 1);
                            for (int i = 0; i < numFields; ++i) {
                                int longsSize;
                                int field = termsMetaIn.readVInt();
                                long numTerms = termsMetaIn.readVLong();
                                if (numTerms <= 0L) {
                                    throw new CorruptIndexException("Illegal numTerms for field number: " + field, (DataInput)termsMetaIn);
                                }
                                BytesRef rootCode = Lucene40BlockTreeTermsReader.readBytesRef(termsMetaIn);
                                FieldInfo fieldInfo = state.fieldInfos.fieldInfo(field);
                                if (fieldInfo == null) {
                                    throw new CorruptIndexException("invalid field number: " + field, (DataInput)termsMetaIn);
                                }
                                long sumTotalTermFreq = termsMetaIn.readVLong();
                                long sumDocFreq = fieldInfo.getIndexOptions() == IndexOptions.DOCS ? sumTotalTermFreq : termsMetaIn.readVLong();
                                int docCount = termsMetaIn.readVInt();
                                if (this.version < 4 && (longsSize = termsMetaIn.readVInt()) < 0) {
                                    throw new CorruptIndexException("invalid longsSize for field: " + fieldInfo.name + ", longsSize=" + longsSize, (DataInput)termsMetaIn);
                                }
                                BytesRef minTerm = Lucene40BlockTreeTermsReader.readBytesRef(termsMetaIn);
                                BytesRef maxTerm = Lucene40BlockTreeTermsReader.readBytesRef(termsMetaIn);
                                if (docCount < 0 || docCount > state.segmentInfo.maxDoc()) {
                                    throw new CorruptIndexException("invalid docCount: " + docCount + " maxDoc: " + state.segmentInfo.maxDoc(), (DataInput)termsMetaIn);
                                }
                                if (sumDocFreq < (long)docCount) {
                                    throw new CorruptIndexException("invalid sumDocFreq: " + sumDocFreq + " docCount: " + docCount, (DataInput)termsMetaIn);
                                }
                                if (sumTotalTermFreq < sumDocFreq) {
                                    throw new CorruptIndexException("invalid sumTotalTermFreq: " + sumTotalTermFreq + " sumDocFreq: " + sumDocFreq, (DataInput)termsMetaIn);
                                }
                                long indexStartFP = indexMetaIn.readVLong();
                                FieldReader previous = fieldMap.put(fieldInfo.name, new FieldReader(this, fieldInfo, numTerms, rootCode, sumTotalTermFreq, sumDocFreq, docCount, indexStartFP, indexMetaIn, this.indexIn, minTerm, maxTerm));
                                if (previous == null) continue;
                                throw new CorruptIndexException("duplicate field: " + fieldInfo.name, (DataInput)termsMetaIn);
                            }
                            if (this.version >= 6) {
                                indexLength = metaIn.readLong();
                                termsLength = metaIn.readLong();
                            }
                            if (metaIn == null) break block33;
                        }
                        catch (Throwable exception) {
                            try {
                                priorE = exception;
                                break block34;
                            }
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                            finally {
                                if (metaIn != null) {
                                    CodecUtil.checkFooter((ChecksumIndexInput)metaIn, (Throwable)priorE);
                                } else if (priorE != null) {
                                    IOUtils.rethrowAlways((Throwable)priorE);
                                }
                            }
                        }
                        CodecUtil.checkFooter((ChecksumIndexInput)metaIn, (Throwable)priorE);
                        break block34;
                    }
                    if (priorE != null) {
                        IOUtils.rethrowAlways((Throwable)priorE);
                    }
                }
            }
            if (this.version >= 6) {
                CodecUtil.retrieveChecksum((IndexInput)this.indexIn, (long)indexLength);
                CodecUtil.retrieveChecksum((IndexInput)this.termsIn, (long)termsLength);
            } else {
                assert (indexLength == -1L) : indexLength;
                assert (termsLength == -1L) : termsLength;
            }
            ArrayList fieldList = new ArrayList(fieldMap.keySet());
            fieldList.sort(null);
            this.fieldMap = fieldMap;
            this.fieldList = Collections.unmodifiableList(fieldList);
            return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this});
            throw throwable;
        }
    }

    private static BytesRef readBytesRef(IndexInput in) throws IOException {
        int numBytes = in.readVInt();
        if (numBytes < 0) {
            throw new CorruptIndexException("invalid bytes length: " + numBytes, (DataInput)in);
        }
        BytesRef bytes = new BytesRef();
        bytes.length = numBytes;
        bytes.bytes = new byte[numBytes];
        in.readBytes(bytes.bytes, 0, numBytes);
        return bytes;
    }

    private static void seekDir(IndexInput input) throws IOException {
        input.seek(input.length() - (long)CodecUtil.footerLength() - 8L);
        long offset = input.readLong();
        input.seek(offset);
    }

    public void close() throws IOException {
        try {
            IOUtils.close((Closeable[])new Closeable[]{this.indexIn, this.termsIn, this.postingsReader});
        }
        finally {
            this.fieldMap.clear();
        }
    }

    public Iterator<String> iterator() {
        return this.fieldList.iterator();
    }

    public Terms terms(String field) throws IOException {
        assert (field != null);
        return this.fieldMap.get(field);
    }

    public int size() {
        return this.fieldMap.size();
    }

    String brToString(BytesRef b) {
        if (b == null) {
            return "null";
        }
        try {
            return b.utf8ToString() + " " + b;
        }
        catch (Throwable t) {
            return b.toString();
        }
    }

    public void checkIntegrity() throws IOException {
        CodecUtil.checksumEntireFile((IndexInput)this.indexIn);
        CodecUtil.checksumEntireFile((IndexInput)this.termsIn);
        this.postingsReader.checkIntegrity();
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "(fields=" + this.fieldMap.size() + ",delegate=" + this.postingsReader + ")";
    }
}

