/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.parameter;

import java.io.IOException;
import lombok.Generated;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.ml.common.annotation.MLAlgoOutput;
import org.opensearch.ml.common.dataframe.DataFrame;
import org.opensearch.ml.common.dataframe.DataFrameType;
import org.opensearch.ml.common.dataframe.DefaultDataFrame;
import org.opensearch.ml.common.parameter.MLOutput;
import org.opensearch.ml.common.parameter.MLOutputType;

@MLAlgoOutput(value=MLOutputType.PREDICTION)
public class MLPredictionOutput
extends MLOutput {
    private static final MLOutputType OUTPUT_TYPE = MLOutputType.PREDICTION;
    public static final String TASK_ID_FIELD = "task_id";
    public static final String STATUS_FIELD = "status";
    public static final String PREDICTION_RESULT_FIELD = "prediction_result";
    String taskId;
    String status;
    DataFrame predictionResult;

    public MLPredictionOutput(String taskId, String status, DataFrame predictionResult) {
        super(OUTPUT_TYPE);
        this.taskId = taskId;
        this.status = status;
        this.predictionResult = predictionResult;
    }

    public MLPredictionOutput(StreamInput in) throws IOException {
        super(OUTPUT_TYPE);
        this.taskId = in.readOptionalString();
        this.status = in.readOptionalString();
        if (in.readBoolean()) {
            DataFrameType dataFrameType = (DataFrameType)in.readEnum(DataFrameType.class);
            switch (dataFrameType) {
                default: 
            }
            this.predictionResult = new DefaultDataFrame(in);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalString(this.taskId);
        out.writeOptionalString(this.status);
        if (this.predictionResult != null) {
            out.writeBoolean(true);
            this.predictionResult.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.taskId != null) {
            builder.field(TASK_ID_FIELD, this.taskId);
        }
        if (this.status != null) {
            builder.field(STATUS_FIELD, this.status);
        }
        if (this.predictionResult != null) {
            builder.startObject(PREDICTION_RESULT_FIELD);
            this.predictionResult.toXContent(builder, params);
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    @Override
    public MLOutputType getType() {
        return OUTPUT_TYPE;
    }

    @Generated
    public static MLPredictionOutputBuilder builder() {
        return new MLPredictionOutputBuilder();
    }

    @Generated
    public String getTaskId() {
        return this.taskId;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public DataFrame getPredictionResult() {
        return this.predictionResult;
    }

    @Generated
    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public void setPredictionResult(DataFrame predictionResult) {
        this.predictionResult = predictionResult;
    }

    @Generated
    public String toString() {
        return "MLPredictionOutput(taskId=" + this.getTaskId() + ", status=" + this.getStatus() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MLPredictionOutput)) {
            return false;
        }
        MLPredictionOutput other = (MLPredictionOutput)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$taskId = this.getTaskId();
        String other$taskId = other.getTaskId();
        if (this$taskId == null ? other$taskId != null : !this$taskId.equals(other$taskId)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        DataFrame this$predictionResult = this.getPredictionResult();
        DataFrame other$predictionResult = other.getPredictionResult();
        return !(this$predictionResult == null ? other$predictionResult != null : !this$predictionResult.equals(other$predictionResult));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MLPredictionOutput;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $taskId = this.getTaskId();
        result = result * 59 + ($taskId == null ? 43 : $taskId.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        DataFrame $predictionResult = this.getPredictionResult();
        result = result * 59 + ($predictionResult == null ? 43 : $predictionResult.hashCode());
        return result;
    }

    @Generated
    public static class MLPredictionOutputBuilder {
        @Generated
        private String taskId;
        @Generated
        private String status;
        @Generated
        private DataFrame predictionResult;

        @Generated
        MLPredictionOutputBuilder() {
        }

        @Generated
        public MLPredictionOutputBuilder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        @Generated
        public MLPredictionOutputBuilder status(String status) {
            this.status = status;
            return this;
        }

        @Generated
        public MLPredictionOutputBuilder predictionResult(DataFrame predictionResult) {
            this.predictionResult = predictionResult;
            return this;
        }

        @Generated
        public MLPredictionOutput build() {
            return new MLPredictionOutput(this.taskId, this.status, this.predictionResult);
        }

        @Generated
        public String toString() {
            return "MLPredictionOutput.MLPredictionOutputBuilder(taskId=" + this.taskId + ", status=" + this.status + ", predictionResult=" + this.predictionResult + ")";
        }
    }
}

