/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.commons.utils;

import java.net.URL;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.CharRange;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000\"\n\u0000\n\u0002\u0010\"\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\u001a\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0006\u001a\u000e\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0006\u001a\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u000e\u0010\r\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\u0006\u001a\u000e\u0010\u000e\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u0006\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"VALID_ID_CHARS", "", "", "isValidEmail", "", "email", "", "isValidId", "idString", "isValidUrl", "urlString", "validateEmail", "", "validateId", "validateUrl", "common-utils"})
public final class ValidationHelpersKt {
    private static final Set<Character> VALID_ID_CHARS;

    public static final void validateUrl(@NotNull String urlString) {
        Intrinsics.checkNotNullParameter((Object)urlString, (String)"urlString");
        boolean bl = ValidationHelpersKt.isValidUrl(urlString);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Invalid URL or unsupported";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        URL url = new URL(urlString);
        bl2 = Intrinsics.areEqual((Object)"https", (Object)url.getProtocol());
        bl3 = false;
        boolean bl5 = false;
        bl5 = false;
        boolean bl6 = false;
        if (!bl2) {
            boolean bl7 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    public static final void validateEmail(@NotNull String email) {
        Intrinsics.checkNotNullParameter((Object)email, (String)"email");
        boolean bl = ValidationHelpersKt.isValidEmail(email);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Invalid email address";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void validateId(@NotNull String idString) {
        Intrinsics.checkNotNullParameter((Object)idString, (String)"idString");
        boolean bl = ValidationHelpersKt.isValidId(idString);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            void $this$filterNotTo$iv$iv;
            void $this$filterNot$iv;
            boolean bl4 = false;
            String string = idString;
            StringBuilder stringBuilder = new StringBuilder().append("Invalid characters in id : ");
            boolean $i$f$filterNot = false;
            CharSequence charSequence = (CharSequence)$this$filterNot$iv;
            Appendable destination$iv$iv = new StringBuilder();
            boolean $i$f$filterNotTo = false;
            void var11_12 = $this$filterNotTo$iv$iv;
            for (int i = 0; i < var11_12.length(); ++i) {
                char element$iv$iv;
                char it = element$iv$iv = var11_12.charAt(i);
                boolean bl5 = false;
                if (VALID_ID_CHARS.contains(Character.valueOf(it))) continue;
                destination$iv$iv.append(element$iv$iv);
            }
            String string2 = ((StringBuilder)destination$iv$iv).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"filterNotTo(StringBuilder(), predicate).toString()");
            String string3 = string2;
            String string4 = stringBuilder.append(string3).toString();
            throw (Throwable)new IllegalArgumentException(string4.toString());
        }
    }

    public static final boolean isValidUrl(@NotNull String urlString) {
        Intrinsics.checkNotNullParameter((Object)urlString, (String)"urlString");
        URL url = new URL(urlString);
        return Intrinsics.areEqual((Object)"https", (Object)url.getProtocol());
    }

    public static final boolean isValidEmail(@NotNull String email) {
        Intrinsics.checkNotNullParameter((Object)email, (String)"email");
        Regex validEmailPattern = new Regex("(?:[a-z0-9!#$%&'*+\\/=?^_`{|}~-]+(?:\\.[a-z0-9!#$%&'*+\\/=?^_`{|}~-]+)*|\"(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21\\x23-\\x5b\\x5d-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])*\")@(?:(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?|\\[(?:(?:(2(5[0-5]|[0-4][0-9])|1[0-9][0-9]|[1-9]?[0-9]))\\.){3}(?:(2(5[0-5]|[0-4][0-9])|1[0-9][0-9]|[1-9]?[0-9])|[a-z0-9-]*[a-z0-9]:(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21-\\x5a\\x53-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])+)\\])", RegexOption.IGNORE_CASE);
        return validEmailPattern.matches((CharSequence)email);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isValidId(@NotNull String idString) {
        Intrinsics.checkNotNullParameter((Object)idString, (String)"idString");
        CharSequence charSequence = idString;
        boolean bl = false;
        if (StringsKt.isBlank((CharSequence)charSequence)) return false;
        boolean bl2 = true;
        if (!bl2) return false;
        CharSequence $this$all$iv = idString;
        boolean $i$f$all = false;
        CharSequence charSequence2 = $this$all$iv;
        int n = 0;
        while (n < charSequence2.length()) {
            char element$iv;
            char it = element$iv = charSequence2.charAt(n);
            boolean bl3 = false;
            if (!VALID_ID_CHARS.contains(Character.valueOf(it))) {
                return false;
            }
            ++n;
        }
        return true;
    }

    static {
        char c = 'a';
        CharRange charRange = new CharRange(c, 'z');
        c = 'A';
        CharRange charRange2 = new CharRange(c, 'Z');
        c = '0';
        VALID_ID_CHARS = CollectionsKt.toSet((Iterable)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Iterable)((Iterable)charRange), (Iterable)((Iterable)charRange2)), (Iterable)((Iterable)new CharRange(c, '9'))), (Object)Character.valueOf('+')), (Object)Character.valueOf('/')), (Object)Character.valueOf('_')), (Object)Character.valueOf('-')));
    }
}

