/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.commons.notifications.model;

import java.io.IOException;
import java.time.Instant;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.common.Strings;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.io.stream.Writeable;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.common.xcontent.XContentParserUtils;
import org.opensearch.commons.notifications.model.BaseModel;
import org.opensearch.commons.notifications.model.NotificationEvent;
import org.opensearch.commons.notifications.model.NotificationEventInfo;
import org.opensearch.commons.utils.HelpersKt;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u0000 ,2\u00020\u0001:\u0001,B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B-\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\u0006\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\t\u0010\u0016\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\bH\u00c6\u0003J\t\u0010\u0018\u001a\u00020\bH\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\fH\u00c6\u0003J;\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\b2\b\b\u0002\u0010\n\u001a\u00020\u00062\b\b\u0002\u0010\u000b\u001a\u00020\fH\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u00d6\u0003J\t\u0010 \u001a\u00020!H\u00d6\u0001J\t\u0010\"\u001a\u00020\u0006H\u00d6\u0001J\u001c\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010$2\b\u0010&\u001a\u0004\u0018\u00010'H\u0016J\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0016R\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000fR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\n\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0011\u00a8\u0006-"}, d2={"Lorg/opensearch/commons/notifications/model/NotificationEventInfo;", "Lorg/opensearch/commons/notifications/model/BaseModel;", "input", "Lorg/opensearch/common/io/stream/StreamInput;", "(Lorg/opensearch/common/io/stream/StreamInput;)V", "eventId", "", "lastUpdatedTime", "Ljava/time/Instant;", "createdTime", "tenant", "notificationEvent", "Lorg/opensearch/commons/notifications/model/NotificationEvent;", "(Ljava/lang/String;Ljava/time/Instant;Ljava/time/Instant;Ljava/lang/String;Lorg/opensearch/commons/notifications/model/NotificationEvent;)V", "getCreatedTime", "()Ljava/time/Instant;", "getEventId", "()Ljava/lang/String;", "getLastUpdatedTime", "getNotificationEvent", "()Lorg/opensearch/commons/notifications/model/NotificationEvent;", "getTenant", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "", "hashCode", "", "toString", "toXContent", "Lorg/opensearch/common/xcontent/XContentBuilder;", "builder", "params", "Lorg/opensearch/common/xcontent/ToXContent$Params;", "writeTo", "", "output", "Lorg/opensearch/common/io/stream/StreamOutput;", "Companion", "common-utils"})
public final class NotificationEventInfo
implements BaseModel {
    @NotNull
    private final String eventId;
    @NotNull
    private final Instant lastUpdatedTime;
    @NotNull
    private final Instant createdTime;
    @NotNull
    private final String tenant;
    @NotNull
    private final NotificationEvent notificationEvent;
    private static final Lazy log$delegate;
    @NotNull
    private static final Writeable.Reader<NotificationEventInfo> reader;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public XContentBuilder toXContent(@Nullable XContentBuilder builder, @Nullable ToXContent.Params params) {
        Intrinsics.checkNotNull((Object)builder);
        XContentBuilder xContentBuilder = builder.startObject().field("event_id", this.eventId).field("last_updated_time_ms", this.lastUpdatedTime.toEpochMilli()).field("created_time_ms", this.createdTime.toEpochMilli()).field("tenant", this.tenant).field("event", (ToXContent)this.notificationEvent).endObject();
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"builder.startObject()\n  \u2026\n            .endObject()");
        return xContentBuilder;
    }

    public void writeTo(@NotNull StreamOutput output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        output.writeString(this.eventId);
        output.writeInstant(this.lastUpdatedTime);
        output.writeInstant(this.createdTime);
        output.writeString(this.tenant);
        this.notificationEvent.writeTo(output);
    }

    @NotNull
    public final String getEventId() {
        return this.eventId;
    }

    @NotNull
    public final Instant getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    @NotNull
    public final Instant getCreatedTime() {
        return this.createdTime;
    }

    @NotNull
    public final String getTenant() {
        return this.tenant;
    }

    @NotNull
    public final NotificationEvent getNotificationEvent() {
        return this.notificationEvent;
    }

    public NotificationEventInfo(@NotNull String eventId, @NotNull Instant lastUpdatedTime, @NotNull Instant createdTime, @NotNull String tenant, @NotNull NotificationEvent notificationEvent) {
        Intrinsics.checkNotNullParameter((Object)eventId, (String)"eventId");
        Intrinsics.checkNotNullParameter((Object)lastUpdatedTime, (String)"lastUpdatedTime");
        Intrinsics.checkNotNullParameter((Object)createdTime, (String)"createdTime");
        Intrinsics.checkNotNullParameter((Object)tenant, (String)"tenant");
        Intrinsics.checkNotNullParameter((Object)notificationEvent, (String)"notificationEvent");
        this.eventId = eventId;
        this.lastUpdatedTime = lastUpdatedTime;
        this.createdTime = createdTime;
        this.tenant = tenant;
        this.notificationEvent = notificationEvent;
        boolean bl = !Strings.isNullOrEmpty((String)this.eventId);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "event id is null or empty";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    public NotificationEventInfo(@NotNull StreamInput input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        String string = input.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"input.readString()");
        Instant instant = input.readInstant();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"input.readInstant()");
        Instant instant2 = input.readInstant();
        Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"input.readInstant()");
        String string2 = input.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"input.readString()");
        Object object = NotificationEvent.Companion.getReader().read(input);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"NotificationEvent.reader.read(input)");
        this(string, instant, instant2, string2, (NotificationEvent)object);
    }

    static {
        Companion = new Companion(null);
        log$delegate = HelpersKt.logger(NotificationEventInfo.class);
        reader = Companion.reader.1.INSTANCE;
    }

    @NotNull
    public final String component1() {
        return this.eventId;
    }

    @NotNull
    public final Instant component2() {
        return this.lastUpdatedTime;
    }

    @NotNull
    public final Instant component3() {
        return this.createdTime;
    }

    @NotNull
    public final String component4() {
        return this.tenant;
    }

    @NotNull
    public final NotificationEvent component5() {
        return this.notificationEvent;
    }

    @NotNull
    public final NotificationEventInfo copy(@NotNull String eventId, @NotNull Instant lastUpdatedTime, @NotNull Instant createdTime, @NotNull String tenant, @NotNull NotificationEvent notificationEvent) {
        Intrinsics.checkNotNullParameter((Object)eventId, (String)"eventId");
        Intrinsics.checkNotNullParameter((Object)lastUpdatedTime, (String)"lastUpdatedTime");
        Intrinsics.checkNotNullParameter((Object)createdTime, (String)"createdTime");
        Intrinsics.checkNotNullParameter((Object)tenant, (String)"tenant");
        Intrinsics.checkNotNullParameter((Object)notificationEvent, (String)"notificationEvent");
        return new NotificationEventInfo(eventId, lastUpdatedTime, createdTime, tenant, notificationEvent);
    }

    public static /* synthetic */ NotificationEventInfo copy$default(NotificationEventInfo notificationEventInfo, String string, Instant instant, Instant instant2, String string2, NotificationEvent notificationEvent, int n, Object object) {
        if ((n & 1) != 0) {
            string = notificationEventInfo.eventId;
        }
        if ((n & 2) != 0) {
            instant = notificationEventInfo.lastUpdatedTime;
        }
        if ((n & 4) != 0) {
            instant2 = notificationEventInfo.createdTime;
        }
        if ((n & 8) != 0) {
            string2 = notificationEventInfo.tenant;
        }
        if ((n & 0x10) != 0) {
            notificationEvent = notificationEventInfo.notificationEvent;
        }
        return notificationEventInfo.copy(string, instant, instant2, string2, notificationEvent);
    }

    @NotNull
    public String toString() {
        return "NotificationEventInfo(eventId=" + this.eventId + ", lastUpdatedTime=" + this.lastUpdatedTime + ", createdTime=" + this.createdTime + ", tenant=" + this.tenant + ", notificationEvent=" + this.notificationEvent + ")";
    }

    public int hashCode() {
        String string = this.eventId;
        Instant instant = this.lastUpdatedTime;
        Instant instant2 = this.createdTime;
        String string2 = this.tenant;
        NotificationEvent notificationEvent = this.notificationEvent;
        return ((((string != null ? string.hashCode() : 0) * 31 + (instant != null ? ((Object)instant).hashCode() : 0)) * 31 + (instant2 != null ? ((Object)instant2).hashCode() : 0)) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (notificationEvent != null ? ((Object)notificationEvent).hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof NotificationEventInfo)) break block3;
                NotificationEventInfo notificationEventInfo = (NotificationEventInfo)object;
                if (!Intrinsics.areEqual((Object)this.eventId, (Object)notificationEventInfo.eventId) || !Intrinsics.areEqual((Object)this.lastUpdatedTime, (Object)notificationEventInfo.lastUpdatedTime) || !Intrinsics.areEqual((Object)this.createdTime, (Object)notificationEventInfo.createdTime) || !Intrinsics.areEqual((Object)this.tenant, (Object)notificationEventInfo.tenant) || !Intrinsics.areEqual((Object)this.notificationEvent, (Object)notificationEventInfo.notificationEvent)) break block3;
            }
            return true;
        }
        return false;
    }

    @JvmStatic
    @NotNull
    public static final NotificationEventInfo parse(@NotNull XContentParser parser) throws IOException {
        return Companion.parse(parser);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u001f\u0010\t\u001a\u0010\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0012"}, d2={"Lorg/opensearch/commons/notifications/model/NotificationEventInfo$Companion;", "", "()V", "log", "Lorg/apache/logging/log4j/Logger;", "getLog", "()Lorg/apache/logging/log4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "reader", "Lorg/opensearch/common/io/stream/Writeable$Reader;", "Lorg/opensearch/commons/notifications/model/NotificationEventInfo;", "kotlin.jvm.PlatformType", "getReader", "()Lorg/opensearch/common/io/stream/Writeable$Reader;", "parse", "parser", "Lorg/opensearch/common/xcontent/XContentParser;", "common-utils"})
    public static final class Companion {
        private final Logger getLog() {
            Lazy lazy = log$delegate;
            Companion companion = Companion;
            Object var3_3 = null;
            boolean bl = false;
            return (Logger)lazy.getValue();
        }

        @NotNull
        public final Writeable.Reader<NotificationEventInfo> getReader() {
            return reader;
        }

        @JvmStatic
        @NotNull
        public final NotificationEventInfo parse(@NotNull XContentParser parser) throws IOException {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            String eventId = null;
            Instant lastUpdatedTime = null;
            Instant createdTime = null;
            String tenant = null;
            NotificationEvent notificationEvent = null;
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
            block14: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                String fieldName = parser.currentName();
                parser.nextToken();
                if (fieldName != null) {
                    String string;
                    int n = -1;
                    switch (string.hashCode()) {
                        case 786082091: {
                            if (!string.equals("last_updated_time_ms")) break;
                            n = 1;
                            break;
                        }
                        case 1513344513: {
                            if (!string.equals("created_time_ms")) break;
                            n = 2;
                            break;
                        }
                        case 278118624: {
                            if (!string.equals("event_id")) break;
                            n = 3;
                            break;
                        }
                        case 96891546: {
                            if (!string.equals("event")) break;
                            n = 4;
                            break;
                        }
                        case -877336406: {
                            if (!string.equals("tenant")) break;
                            n = 5;
                            break;
                        }
                    }
                    switch (n) {
                        case 3: {
                            eventId = parser.text();
                            continue block14;
                        }
                        case 1: {
                            lastUpdatedTime = Instant.ofEpochMilli(parser.longValue());
                            continue block14;
                        }
                        case 2: {
                            createdTime = Instant.ofEpochMilli(parser.longValue());
                            continue block14;
                        }
                        case 5: {
                            tenant = parser.text();
                            continue block14;
                        }
                        case 4: {
                            notificationEvent = NotificationEvent.Companion.parse(parser);
                            continue block14;
                        }
                    }
                }
                parser.skipChildren();
                this.getLog().info("Unexpected field: " + fieldName + ", while parsing event info");
            }
            if (eventId == null) {
                throw (Throwable)new IllegalArgumentException("event_id field absent");
            }
            if (lastUpdatedTime == null) {
                throw (Throwable)new IllegalArgumentException("last_updated_time_ms field absent");
            }
            if (createdTime == null) {
                throw (Throwable)new IllegalArgumentException("created_time_ms field absent");
            }
            String string = tenant;
            if (string == null) {
                string = tenant = "";
            }
            if (notificationEvent == null) {
                throw (Throwable)new IllegalArgumentException("event field absent");
            }
            return new NotificationEventInfo(eventId, lastUpdatedTime, createdTime, tenant, notificationEvent);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

