/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.commons.notifications.model;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.common.Strings;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.io.stream.Writeable;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.common.xcontent.XContentParserUtils;
import org.opensearch.commons.notifications.model.BaseConfigData;
import org.opensearch.commons.notifications.model.Email;
import org.opensearch.commons.notifications.model.XParser;
import org.opensearch.commons.utils.HelpersKt;
import org.opensearch.commons.utils.ValidationHelpersKt;
import org.opensearch.commons.utils.XContentHelpersKt;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u0000 $2\u00020\u0001:\u0001$B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B)\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\b\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0010\u001a\u00020\u0006H\u00c6\u0003J\u000f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\bH\u00c6\u0003J\u000f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\bH\u00c6\u0003J3\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u00062\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b2\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\bH\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u0006H\u00d6\u0001J\u001c\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001c2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000e\u00a8\u0006%"}, d2={"Lorg/opensearch/commons/notifications/model/Email;", "Lorg/opensearch/commons/notifications/model/BaseConfigData;", "input", "Lorg/opensearch/common/io/stream/StreamInput;", "(Lorg/opensearch/common/io/stream/StreamInput;)V", "emailAccountID", "", "recipients", "", "emailGroupIds", "(Ljava/lang/String;Ljava/util/List;Ljava/util/List;)V", "getEmailAccountID", "()Ljava/lang/String;", "getEmailGroupIds", "()Ljava/util/List;", "getRecipients", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "toXContent", "Lorg/opensearch/common/xcontent/XContentBuilder;", "builder", "params", "Lorg/opensearch/common/xcontent/ToXContent$Params;", "writeTo", "", "output", "Lorg/opensearch/common/io/stream/StreamOutput;", "Companion", "common-utils"})
public final class Email
implements BaseConfigData {
    @NotNull
    private final String emailAccountID;
    @NotNull
    private final List<String> recipients;
    @NotNull
    private final List<String> emailGroupIds;
    private static final Lazy log$delegate;
    @NotNull
    private static final Writeable.Reader<Email> reader;
    @NotNull
    private static final XParser<Email> xParser;
    @NotNull
    public static final Companion Companion;

    public void writeTo(@NotNull StreamOutput output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        output.writeString(this.emailAccountID);
        output.writeStringCollection((Collection)this.recipients);
        output.writeStringCollection((Collection)this.emailGroupIds);
    }

    @NotNull
    public XContentBuilder toXContent(@Nullable XContentBuilder builder, @Nullable ToXContent.Params params) {
        Intrinsics.checkNotNull((Object)builder);
        XContentBuilder xContentBuilder = builder.startObject().field("email_account_id", this.emailAccountID).field("recipient_list", (Iterable)this.recipients).field("email_group_id_list", (Iterable)this.emailGroupIds).endObject();
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"builder.startObject()\n  \u2026\n            .endObject()");
        return xContentBuilder;
    }

    @NotNull
    public final String getEmailAccountID() {
        return this.emailAccountID;
    }

    @NotNull
    public final List<String> getRecipients() {
        return this.recipients;
    }

    @NotNull
    public final List<String> getEmailGroupIds() {
        return this.emailGroupIds;
    }

    public Email(@NotNull String emailAccountID, @NotNull List<String> recipients, @NotNull List<String> emailGroupIds) {
        Intrinsics.checkNotNullParameter((Object)emailAccountID, (String)"emailAccountID");
        Intrinsics.checkNotNullParameter(recipients, (String)"recipients");
        Intrinsics.checkNotNullParameter(emailGroupIds, (String)"emailGroupIds");
        this.emailAccountID = emailAccountID;
        this.recipients = recipients;
        this.emailGroupIds = emailGroupIds;
        boolean bl = !Strings.isNullOrEmpty((String)this.emailAccountID);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "emailAccountID is null or empty";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        Iterable $this$forEach$iv = this.recipients;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl5 = false;
            ValidationHelpersKt.validateEmail(it);
        }
    }

    public Email(@NotNull StreamInput input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        String string = input.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"input.readString()");
        List list = input.readStringList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"input.readStringList()");
        List list2 = input.readStringList();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"input.readStringList()");
        this(string, list, list2);
    }

    static {
        Companion = new Companion(null);
        log$delegate = HelpersKt.logger(Email.class);
        reader = Companion.reader.1.INSTANCE;
        xParser = Companion.xParser.1.INSTANCE;
    }

    @NotNull
    public final String component1() {
        return this.emailAccountID;
    }

    @NotNull
    public final List<String> component2() {
        return this.recipients;
    }

    @NotNull
    public final List<String> component3() {
        return this.emailGroupIds;
    }

    @NotNull
    public final Email copy(@NotNull String emailAccountID, @NotNull List<String> recipients, @NotNull List<String> emailGroupIds) {
        Intrinsics.checkNotNullParameter((Object)emailAccountID, (String)"emailAccountID");
        Intrinsics.checkNotNullParameter(recipients, (String)"recipients");
        Intrinsics.checkNotNullParameter(emailGroupIds, (String)"emailGroupIds");
        return new Email(emailAccountID, recipients, emailGroupIds);
    }

    public static /* synthetic */ Email copy$default(Email email, String string, List list, List list2, int n, Object object) {
        if ((n & 1) != 0) {
            string = email.emailAccountID;
        }
        if ((n & 2) != 0) {
            list = email.recipients;
        }
        if ((n & 4) != 0) {
            list2 = email.emailGroupIds;
        }
        return email.copy(string, list, list2);
    }

    @NotNull
    public String toString() {
        return "Email(emailAccountID=" + this.emailAccountID + ", recipients=" + this.recipients + ", emailGroupIds=" + this.emailGroupIds + ")";
    }

    public int hashCode() {
        String string = this.emailAccountID;
        List<String> list = this.recipients;
        List<String> list2 = this.emailGroupIds;
        return ((string != null ? string.hashCode() : 0) * 31 + (list != null ? ((Object)list).hashCode() : 0)) * 31 + (list2 != null ? ((Object)list2).hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof Email)) break block3;
                Email email = (Email)object;
                if (!Intrinsics.areEqual((Object)this.emailAccountID, (Object)email.emailAccountID) || !Intrinsics.areEqual(this.recipients, email.recipients) || !Intrinsics.areEqual(this.emailGroupIds, email.emailGroupIds)) break block3;
            }
            return true;
        }
        return false;
    }

    @JvmStatic
    @NotNull
    public static final Email parse(@NotNull XContentParser parser) throws IOException {
        return Companion.parse(parser);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0007R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u001f\u0010\t\u001a\u0010\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0016"}, d2={"Lorg/opensearch/commons/notifications/model/Email$Companion;", "", "()V", "log", "Lorg/apache/logging/log4j/Logger;", "getLog", "()Lorg/apache/logging/log4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "reader", "Lorg/opensearch/common/io/stream/Writeable$Reader;", "Lorg/opensearch/commons/notifications/model/Email;", "kotlin.jvm.PlatformType", "getReader", "()Lorg/opensearch/common/io/stream/Writeable$Reader;", "xParser", "Lorg/opensearch/commons/notifications/model/XParser;", "getXParser", "()Lorg/opensearch/commons/notifications/model/XParser;", "parse", "parser", "Lorg/opensearch/common/xcontent/XContentParser;", "common-utils"})
    public static final class Companion {
        private final Logger getLog() {
            Lazy lazy = log$delegate;
            Companion companion = Companion;
            Object var3_3 = null;
            boolean bl = false;
            return (Logger)lazy.getValue();
        }

        @NotNull
        public final Writeable.Reader<Email> getReader() {
            return reader;
        }

        @NotNull
        public final XParser<Email> getXParser() {
            return xParser;
        }

        /*
         * Unable to fully structure code
         */
        @JvmStatic
        @NotNull
        public final Email parse(@NotNull XContentParser parser) throws IOException {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            emailAccountID = null;
            var4_3 = false;
            recipients = CollectionsKt.emptyList();
            var5_6 = false;
            emailGroupIds = CollectionsKt.emptyList();
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
            block5: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                block7: {
                    block8: {
                        fieldName = parser.currentName();
                        parser.nextToken();
                        if (fieldName == null) break block7;
                        switch (var6_8.hashCode()) {
                            case -330539260: {
                                if (!var6_8.equals("recipient_list")) ** break;
                                break;
                            }
                            case 183738399: {
                                if (!var6_8.equals("email_group_id_list")) ** break;
                                break block8;
                            }
                            case -106033936: {
                                if (!var6_8.equals("email_account_id")) ** break;
                                emailAccountID = parser.text();
                                continue block5;
                            }
                        }
                        recipients = XContentHelpersKt.stringList(parser);
                        continue;
                    }
                    emailGroupIds = XContentHelpersKt.stringList(parser);
                    continue;
                }
                parser.skipChildren();
                this.getLog().info("Unexpected field: " + fieldName + ", while parsing Email");
            }
            if (emailAccountID == null) {
                throw (Throwable)new IllegalArgumentException("email_account_id field absent");
            }
            return new Email(emailAccountID, recipients, emailGroupIds);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

