/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.tree;

import com.amazon.randomcutforest.CommonUtils;
import com.amazon.randomcutforest.IMultiVisitorFactory;
import com.amazon.randomcutforest.IVisitorFactory;
import com.amazon.randomcutforest.MultiVisitor;
import com.amazon.randomcutforest.Visitor;
import com.amazon.randomcutforest.store.IPointStoreView;
import com.amazon.randomcutforest.tree.AbstractNodeStore;
import com.amazon.randomcutforest.tree.BoundingBox;
import com.amazon.randomcutforest.tree.Cut;
import com.amazon.randomcutforest.tree.ITree;
import java.util.Arrays;
import java.util.Optional;
import java.util.Random;
import java.util.Stack;

public class RandomCutTree
implements ITree<Integer, float[]> {
    private Random testRandom;
    protected boolean storeSequenceIndexesEnabled;
    protected boolean centerOfMassEnabled;
    private long randomSeed;
    protected int root;
    protected IPointStoreView<float[]> pointStoreView;
    protected int numberOfLeaves;
    protected AbstractNodeStore nodeStore;
    protected double boundingBoxCacheFraction;
    protected int outputAfter;
    protected int dimension;

    protected RandomCutTree(Builder<?> builder) {
        this.pointStoreView = builder.pointStoreView;
        this.numberOfLeaves = builder.capacity;
        this.randomSeed = builder.randomSeed;
        this.testRandom = builder.random;
        this.outputAfter = builder.outputAfter.orElse(this.numberOfLeaves / 4);
        this.dimension = builder.dimension != 0 ? builder.dimension : this.pointStoreView.getDimensions();
        this.nodeStore = builder.nodeStore != null ? builder.nodeStore : ((AbstractNodeStore.Builder)((AbstractNodeStore.Builder)((AbstractNodeStore.Builder)((AbstractNodeStore.Builder)((AbstractNodeStore.Builder)((AbstractNodeStore.Builder)AbstractNodeStore.builder().capacity(this.numberOfLeaves - 1)).dimensions(this.dimension)).boundingBoxCacheFraction(builder.boundingBoxCacheFraction)).pointStoreView(this.pointStoreView)).centerOfMassEnabled(builder.centerOfMassEnabled)).storeSequencesEnabled(builder.storeSequenceIndexesEnabled)).build();
        this.boundingBoxCacheFraction = builder.boundingBoxCacheFraction;
        this.storeSequenceIndexesEnabled = builder.storeSequenceIndexesEnabled;
        this.centerOfMassEnabled = builder.centerOfMassEnabled;
        this.root = builder.root;
    }

    @Override
    public <T> void setConfig(String name, T value, Class<T> clazz) {
        if (!"bounding_box_cache_fraction".equals(name)) {
            throw new IllegalArgumentException("Unsupported configuration setting: " + name);
        }
        CommonUtils.checkArgument(Double.class.isAssignableFrom(clazz), String.format("Setting '%s' must be a double value", name));
        this.setBoundingBoxCacheFraction((Double)value);
    }

    @Override
    public <T> T getConfig(String name, Class<T> clazz) {
        CommonUtils.checkNotNull(clazz, "clazz must not be null");
        if ("bounding_box_cache_fraction".equals(name)) {
            CommonUtils.checkArgument(clazz.isAssignableFrom(Double.class), String.format("Setting '%s' must be a double value", name));
            return clazz.cast(this.boundingBoxCacheFraction);
        }
        throw new IllegalArgumentException("Unsupported configuration setting: " + name);
    }

    public void setBoundingBoxCacheFraction(double fraction) {
        CommonUtils.checkArgument(0.0 <= fraction && fraction <= 1.0, "incorrect parameter");
        this.boundingBoxCacheFraction = fraction;
        this.nodeStore.resizeCache(fraction);
    }

    protected Cut randomCut(double factor, float[] point, BoundingBox box) {
        double range = 0.0;
        for (int i = 0; i < point.length; ++i) {
            float minValue = (float)box.getMinValue(i);
            float maxValue = (float)box.getMaxValue(i);
            if (point[i] < minValue) {
                minValue = point[i];
            } else if (point[i] > maxValue) {
                maxValue = point[i];
            }
            range += (double)(maxValue - minValue);
        }
        double breakPoint = factor * range;
        for (int i = 0; i < box.getDimensions(); ++i) {
            float minValue = (float)box.getMinValue(i);
            float maxValue = (float)box.getMaxValue(i);
            if (point[i] < minValue) {
                minValue = point[i];
            } else if (point[i] > maxValue) {
                maxValue = point[i];
            }
            double gap = maxValue - minValue;
            if (breakPoint <= gap) {
                float cutValue = (float)((double)minValue + breakPoint);
                if (cutValue >= maxValue && minValue < maxValue) {
                    cutValue = Math.nextAfter(maxValue, (double)minValue);
                }
                return new Cut(i, cutValue);
            }
            breakPoint -= gap;
        }
        throw new IllegalStateException("The break point did not lie inside the expected range");
    }

    @Override
    public Integer addPoint(Integer pointIndex, long sequenceIndex) {
        Random rng;
        int node;
        int leafSavedSibling;
        int savedParent;
        if (this.root == AbstractNodeStore.Null) {
            this.root = this.nodeStore.addLeaf(pointIndex, sequenceIndex);
            return pointIndex;
        }
        float[] point = this.pointStoreView.get(pointIndex);
        Stack<int[]> pathToRoot = this.nodeStore.getPath(this.root, point, false);
        int[] first = pathToRoot.pop();
        int leafNode = first[0];
        int n = savedParent = pathToRoot.size() == 0 ? AbstractNodeStore.Null : ((int[])pathToRoot.lastElement())[0];
        if (!this.nodeStore.isLeaf(leafNode)) {
            if (savedParent == AbstractNodeStore.Null) {
                this.root = pointIndex + this.numberOfLeaves;
            } else {
                this.nodeStore.addToPartialTree(pathToRoot, point, pointIndex);
                this.nodeStore.manageAncestorsAdd(pathToRoot, point, this.pointStoreView);
                this.nodeStore.addLeaf(pointIndex, sequenceIndex);
            }
            return pointIndex;
        }
        int sibling = leafSavedSibling = first[1];
        int leafPointIndex = this.nodeStore.getPointIndex(leafNode);
        float[] oldPoint = this.pointStoreView.get(leafPointIndex);
        Stack<int[]> parentPath = new Stack<int[]>();
        if (Arrays.equals(point, oldPoint)) {
            this.nodeStore.increaseLeafMass(leafNode);
            CommonUtils.checkArgument(!this.nodeStore.freeNodeManager.isEmpty(), "incorrect/impossible state");
            this.nodeStore.manageAncestorsAdd(pathToRoot, point, this.pointStoreView);
            this.nodeStore.addLeaf(leafPointIndex, sequenceIndex);
            return leafPointIndex;
        }
        int savedNode = node = leafNode;
        int parent = savedParent;
        float savedCutValue = 0.0f;
        BoundingBox currentBox = new BoundingBox(oldPoint, oldPoint);
        BoundingBox savedBox = currentBox.copy();
        int savedDim = Integer.MAX_VALUE;
        if (this.testRandom == null) {
            rng = new Random(this.randomSeed);
            this.randomSeed = rng.nextLong();
        } else {
            rng = this.testRandom;
        }
        while (true) {
            float value;
            double factor;
            Cut cut;
            int dim;
            boolean separation;
            boolean bl = separation = point[dim = (cut = this.randomCut(factor = rng.nextDouble(), point, currentBox)).getDimension()] <= (value = (float)cut.getValue()) && (double)value < currentBox.getMinValue(dim) || point[dim] > value && (double)value >= currentBox.getMaxValue(dim);
            if (separation) {
                savedCutValue = value;
                savedDim = dim;
                savedParent = parent;
                savedNode = node;
                savedBox = currentBox.copy();
                parentPath.clear();
            } else {
                parentPath.push(new int[]{node, sibling});
            }
            if (savedDim == Integer.MAX_VALUE) {
                this.randomCut(factor, point, currentBox);
                throw new IllegalStateException(" cut failed ");
            }
            if (currentBox.contains(point) || parent == AbstractNodeStore.Null) break;
            this.nodeStore.growNodeBox(currentBox, this.pointStoreView, parent, sibling);
            int[] next = pathToRoot.pop();
            node = next[0];
            sibling = next[1];
            if (pathToRoot.size() != 0) {
                parent = ((int[])pathToRoot.lastElement())[0];
                continue;
            }
            parent = AbstractNodeStore.Null;
        }
        if (savedParent != AbstractNodeStore.Null) {
            while (!parentPath.isEmpty()) {
                pathToRoot.push((int[])parentPath.pop());
            }
            assert (((int[])pathToRoot.lastElement())[0] == savedParent);
        }
        int mergedNode = this.nodeStore.addNode(pathToRoot, point, sequenceIndex, pointIndex, savedNode, savedDim, savedCutValue, savedBox);
        if (savedParent == AbstractNodeStore.Null) {
            this.root = mergedNode;
        }
        return pointIndex;
    }

    @Override
    public Integer deletePoint(Integer pointIndex, long sequenceIndex) {
        if (this.root == AbstractNodeStore.Null) {
            throw new IllegalStateException(" deleting from an empty tree");
        }
        float[] point = this.pointStoreView.get(pointIndex);
        Stack<int[]> pathToRoot = this.nodeStore.getPath(this.root, point, false);
        int[] first = pathToRoot.pop();
        int leafSavedSibling = first[1];
        int leafNode = first[0];
        int leafPointIndex = this.nodeStore.getPointIndex(leafNode);
        if (leafPointIndex != pointIndex && !this.pointStoreView.pointEquals(leafPointIndex, point)) {
            throw new IllegalStateException(" deleting wrong node " + leafPointIndex + " instead of " + pointIndex);
        }
        if (this.storeSequenceIndexesEnabled) {
            this.nodeStore.removeLeaf(leafPointIndex, sequenceIndex);
        }
        if (this.nodeStore.decreaseLeafMass(leafNode) == 0) {
            if (pathToRoot.size() == 0) {
                this.root = AbstractNodeStore.Null;
            } else {
                int parent = pathToRoot.pop()[0];
                if (pathToRoot.size() == 0) {
                    this.root = leafSavedSibling;
                    this.nodeStore.setRoot(this.root);
                } else {
                    int grandParent = ((int[])pathToRoot.lastElement())[0];
                    this.nodeStore.replaceParentBySibling(grandParent, parent, leafNode);
                    this.nodeStore.manageAncestorsDelete(pathToRoot, point, this.pointStoreView);
                }
                this.nodeStore.deleteInternalNode(parent);
            }
        } else {
            this.nodeStore.manageAncestorsDelete(pathToRoot, point, this.pointStoreView);
        }
        return leafPointIndex;
    }

    @Override
    public <R> R traverse(float[] point, IVisitorFactory<R> visitorFactory) {
        CommonUtils.checkState(this.root != AbstractNodeStore.Null, "this tree doesn't contain any nodes");
        Visitor<R> visitor = visitorFactory.newVisitor(this, point);
        this.nodeStore.traversePathToLeafAndVisitNodes(this.projectToTree(point), visitor, this.root, this.pointStoreView, this::liftFromTree);
        return visitorFactory.liftResult(this, visitor.getResult());
    }

    @Override
    public <R> R traverseMulti(float[] point, IMultiVisitorFactory<R> visitorFactory) {
        CommonUtils.checkNotNull(point, "point must not be null");
        CommonUtils.checkNotNull(visitorFactory, "visitor must not be null");
        CommonUtils.checkState(this.root != AbstractNodeStore.Null, "this tree doesn't contain any nodes");
        MultiVisitor<R> visitor = visitorFactory.newVisitor(this, point);
        this.nodeStore.traverseTreeMulti(this.projectToTree(point), visitor, this.root, this.pointStoreView, this::liftFromTree);
        return visitorFactory.liftResult(this, visitor.getResult());
    }

    @Override
    public int getMass() {
        return this.root == AbstractNodeStore.Null ? 0 : this.nodeStore.getMass(this.root);
    }

    public int getNumberOfLeaves() {
        return this.numberOfLeaves;
    }

    public boolean isCenterOfMassEnabled() {
        return this.centerOfMassEnabled;
    }

    public boolean isStoreSequenceIndexesEnabled() {
        return this.storeSequenceIndexesEnabled;
    }

    public double getBoundingBoxCacheFraction() {
        return this.boundingBoxCacheFraction;
    }

    public int getDimension() {
        return this.dimension;
    }

    public Integer getRoot() {
        return this.root;
    }

    public int getOutputAfter() {
        return this.outputAfter;
    }

    @Override
    public boolean isOutputReady() {
        return this.getMass() >= this.outputAfter;
    }

    @Override
    public float[] projectToTree(float[] point) {
        return Arrays.copyOf(point, point.length);
    }

    @Override
    public float[] liftFromTree(float[] result) {
        return Arrays.copyOf(result, result.length);
    }

    @Override
    public double[] liftFromTree(double[] result) {
        return Arrays.copyOf(result, result.length);
    }

    @Override
    public int[] projectMissingIndices(int[] list) {
        return Arrays.copyOf(list, list.length);
    }

    public long getRandomSeed() {
        return this.randomSeed;
    }

    public AbstractNodeStore getNodeStore() {
        return this.nodeStore;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder<T extends Builder<T>> {
        protected boolean storeSequenceIndexesEnabled = false;
        protected boolean centerOfMassEnabled = false;
        protected double boundingBoxCacheFraction = 1.0;
        protected long randomSeed = new Random().nextLong();
        protected Random random = null;
        protected int capacity = 256;
        protected Optional<Integer> outputAfter = Optional.empty();
        protected int dimension;
        protected IPointStoreView<float[]> pointStoreView;
        protected AbstractNodeStore nodeStore;
        protected int root = AbstractNodeStore.Null;

        public T capacity(int capacity) {
            this.capacity = capacity;
            return (T)this;
        }

        public T boundingBoxCacheFraction(double boundingBoxCacheFraction) {
            this.boundingBoxCacheFraction = boundingBoxCacheFraction;
            return (T)this;
        }

        public T pointStoreView(IPointStoreView<float[]> pointStoreView) {
            this.pointStoreView = pointStoreView;
            return (T)this;
        }

        public T nodeStore(AbstractNodeStore nodeStore) {
            this.nodeStore = nodeStore;
            return (T)this;
        }

        public T randomSeed(long randomSeed) {
            this.randomSeed = randomSeed;
            return (T)this;
        }

        public T random(Random random) {
            this.random = random;
            return (T)this;
        }

        public T outputAfter(int outputAfter) {
            this.outputAfter = Optional.of(outputAfter);
            return (T)this;
        }

        public T dimension(int dimension) {
            this.dimension = dimension;
            return (T)this;
        }

        public T setRoot(int root) {
            this.root = root;
            return (T)this;
        }

        public T storeSequenceIndexesEnabled(boolean storeSequenceIndexesEnabled) {
            this.storeSequenceIndexesEnabled = storeSequenceIndexesEnabled;
            return (T)this;
        }

        public T centerOfMassEnabled(boolean centerOfMassEnabled) {
            this.centerOfMassEnabled = centerOfMassEnabled;
            return (T)this;
        }

        public RandomCutTree build() {
            return new RandomCutTree(this);
        }
    }
}

