/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.returntypes;

import com.amazon.randomcutforest.CommonUtils;

public class SampleSummary {
    public float[][] summaryPoints;
    public float[] relativeWeight;
    public double weightOfSamples;
    public float[] mean;
    public float[] median;
    public float[] deviation;

    public SampleSummary(double weightOfSamples, float[][] typicalPoints, float[] relativeLikelihood, float[] median, float[] mean, float[] deviation) {
        CommonUtils.checkArgument(typicalPoints.length == relativeLikelihood.length, "incorrect lengths of fields");
        this.weightOfSamples = weightOfSamples;
        this.summaryPoints = typicalPoints;
        this.relativeWeight = relativeLikelihood;
        this.mean = mean;
        this.median = median;
        this.deviation = deviation;
    }

    public SampleSummary(int dimensions) {
        this.weightOfSamples = 0.0;
        this.summaryPoints = new float[1][];
        this.summaryPoints[0] = new float[dimensions];
        this.relativeWeight = new float[]{0.0f};
        this.median = new float[dimensions];
        this.mean = new float[dimensions];
        this.deviation = new float[dimensions];
    }

    public SampleSummary(double[] point) {
        this.weightOfSamples = 0.0;
        this.summaryPoints = new float[1][];
        this.summaryPoints[0] = new float[point.length];
        this.relativeWeight = new float[]{0.0f};
        this.median = CommonUtils.toFloatArray(point);
        this.mean = CommonUtils.toFloatArray(point);
        this.deviation = new float[point.length];
    }
}

