/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo;

import com.oracle.labs.mlrg.olcut.util.MutableLong;
import java.util.Map;
import org.tribuo.CategoricalInfo;
import org.tribuo.RealIDInfo;
import org.tribuo.VariableIDInfo;

public class CategoricalIDInfo
extends CategoricalInfo
implements VariableIDInfo {
    private static final long serialVersionUID = 2L;
    private final int id;

    public CategoricalIDInfo(CategoricalInfo info, int id) {
        super(info);
        this.id = id;
    }

    private CategoricalIDInfo(CategoricalIDInfo info, String newName) {
        super(info, newName);
        this.id = info.id;
    }

    @Override
    public int getID() {
        return this.id;
    }

    @Override
    public RealIDInfo generateRealInfo() {
        double mean;
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        double sum = 0.0;
        double sumSquares = 0.0;
        if (this.valueCounts != null) {
            double valCount;
            double value;
            for (Map.Entry e : this.valueCounts.entrySet()) {
                value = (Double)e.getKey();
                valCount = ((MutableLong)e.getValue()).longValue();
                if (value > max) {
                    max = value;
                }
                if (value < min) {
                    min = value;
                }
                sum += value * valCount;
            }
            mean = sum / (double)this.count;
            for (Map.Entry e : this.valueCounts.entrySet()) {
                value = (Double)e.getKey();
                valCount = ((MutableLong)e.getValue()).longValue();
                sumSquares += (value - mean) * (value - mean) * valCount;
            }
        } else {
            min = this.observedValue;
            max = this.observedValue;
            mean = this.observedValue;
            sumSquares = 0.0;
        }
        return new RealIDInfo(this.name, this.count, max, min, mean, sumSquares, this.id);
    }

    @Override
    public CategoricalIDInfo copy() {
        return new CategoricalIDInfo(this, this.name);
    }

    @Override
    public CategoricalIDInfo makeIDInfo(int id) {
        return new CategoricalIDInfo((CategoricalInfo)this, id);
    }

    @Override
    public CategoricalIDInfo rename(String newName) {
        return new CategoricalIDInfo(this, newName);
    }

    @Override
    public String toString() {
        if (this.valueCounts != null) {
            return "CategoricalFeature(name=" + this.name + ",id=" + this.id + ",count=" + this.count + ",map=" + this.valueCounts.toString() + ")";
        }
        return "CategoricalFeature(name=" + this.name + ",id=" + this.id + ",count=" + this.count + ",map={" + this.observedValue + "," + this.observedCount + "})";
    }
}

