/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.utils;

import java.io.IOException;
import lombok.Generated;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.common.bytes.BytesReference;
import org.opensearch.common.xcontent.DeprecationHandler;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.NamedXContentRegistry;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.ml.plugin.MachineLearningPlugin;

public final class MLNodeUtils {
    public static boolean isMLNode(DiscoveryNode node) {
        return node.getRoles().stream().anyMatch(role -> role.roleName().equalsIgnoreCase(MachineLearningPlugin.ML_ROLE.roleName()));
    }

    public static XContentParser createXContentParserFromRegistry(NamedXContentRegistry xContentRegistry, BytesReference bytesReference) throws IOException {
        return XContentHelper.createParser((NamedXContentRegistry)xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (BytesReference)bytesReference, (XContentType)XContentType.JSON);
    }

    @Generated
    private MLNodeUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

