/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.task;

import java.time.Instant;
import java.util.UUID;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionListener;
import org.opensearch.action.ActionListenerResponseHandler;
import org.opensearch.action.support.ThreadedActionListener;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.ml.common.MLTask;
import org.opensearch.ml.common.MLTaskState;
import org.opensearch.ml.common.MLTaskType;
import org.opensearch.ml.common.breaker.MLCircuitBreakerService;
import org.opensearch.ml.common.dataframe.DataFrame;
import org.opensearch.ml.common.dataset.DataFrameInputDataset;
import org.opensearch.ml.common.dataset.MLInputDataType;
import org.opensearch.ml.common.dataset.MLInputDataset;
import org.opensearch.ml.common.input.Input;
import org.opensearch.ml.common.input.MLInput;
import org.opensearch.ml.common.output.MLOutput;
import org.opensearch.ml.common.output.MLPredictionOutput;
import org.opensearch.ml.common.transport.MLTaskResponse;
import org.opensearch.ml.common.transport.training.MLTrainingTaskRequest;
import org.opensearch.ml.engine.MLEngine;
import org.opensearch.ml.indices.MLInputDatasetHandler;
import org.opensearch.ml.stats.ActionName;
import org.opensearch.ml.stats.MLStats;
import org.opensearch.ml.stats.StatNames;
import org.opensearch.ml.task.MLTaskDispatcher;
import org.opensearch.ml.task.MLTaskManager;
import org.opensearch.ml.task.MLTaskRunner;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportResponseHandler;

public class MLTrainAndPredictTaskRunner
extends MLTaskRunner<MLTrainingTaskRequest, MLTaskResponse> {
    @Generated
    private static final Logger log = LogManager.getLogger(MLTrainAndPredictTaskRunner.class);
    private final ThreadPool threadPool;
    private final ClusterService clusterService;
    private final Client client;
    private final MLInputDatasetHandler mlInputDatasetHandler;

    public MLTrainAndPredictTaskRunner(ThreadPool threadPool, ClusterService clusterService, Client client, MLTaskManager mlTaskManager, MLStats mlStats, MLInputDatasetHandler mlInputDatasetHandler, MLTaskDispatcher mlTaskDispatcher, MLCircuitBreakerService mlCircuitBreakerService) {
        super(mlTaskManager, mlStats, mlTaskDispatcher, mlCircuitBreakerService, clusterService);
        this.threadPool = threadPool;
        this.clusterService = clusterService;
        this.client = client;
        this.mlInputDatasetHandler = mlInputDatasetHandler;
    }

    @Override
    protected String getTransportActionName() {
        return "cluster:admin/opensearch/ml/trainAndPredict";
    }

    @Override
    protected TransportResponseHandler<MLTaskResponse> getResponseHandler(ActionListener<MLTaskResponse> listener) {
        return new ActionListenerResponseHandler(listener, MLTaskResponse::new);
    }

    @Override
    protected void executeTask(MLTrainingTaskRequest request, ActionListener<MLTaskResponse> listener) {
        MLInputDataType inputDataType = request.getMlInput().getInputDataset().getInputDataType();
        Instant now = Instant.now();
        MLTask mlTask = MLTask.builder().taskId(UUID.randomUUID().toString()).taskType(MLTaskType.TRAINING_AND_PREDICTION).inputType(inputDataType).functionName(request.getMlInput().getFunctionName()).state(MLTaskState.CREATED).workerNode(this.clusterService.localNode().getId()).createTime(now).lastUpdateTime(now).async(false).build();
        MLInput mlInput = request.getMlInput();
        if (mlInput.getInputDataset().getInputDataType().equals((Object)MLInputDataType.SEARCH_QUERY)) {
            ActionListener dataFrameActionListener = ActionListener.wrap(dataFrame -> this.trainAndPredict(mlTask, (DataFrame)dataFrame, request, listener), e -> {
                log.error("Failed to generate DataFrame from search query", (Throwable)e);
                this.handlePredictFailure(mlTask, listener, (Exception)e, false);
            });
            this.mlInputDatasetHandler.parseSearchQueryInput(mlInput.getInputDataset(), (ActionListener<DataFrame>)new ThreadedActionListener(log, this.threadPool, "OPENSEARCH_ML_TASK_THREAD_POOL", dataFrameActionListener, false));
        } else {
            DataFrame inputDataFrame = this.mlInputDatasetHandler.parseDataFrameInput(mlInput.getInputDataset());
            this.threadPool.executor("OPENSEARCH_ML_TASK_THREAD_POOL").execute(() -> this.trainAndPredict(mlTask, inputDataFrame, request, listener));
        }
    }

    private void trainAndPredict(MLTask mlTask, DataFrame inputDataFrame, MLTrainingTaskRequest request, ActionListener<MLTaskResponse> listener) {
        ActionListener<MLTaskResponse> internalListener = this.wrappedCleanupListener(listener, mlTask.getTaskId());
        this.mlStats.getStat(StatNames.ML_EXECUTING_TASK_COUNT).increment();
        this.mlStats.getStat(StatNames.ML_TOTAL_REQUEST_COUNT).increment();
        this.mlStats.createCounterStatIfAbsent(StatNames.requestCountStat(mlTask.getFunctionName(), ActionName.TRAIN_PREDICT)).increment();
        this.mlTaskManager.add(mlTask);
        MLInput mlInput = request.getMlInput();
        try {
            this.mlTaskManager.updateTaskState(mlTask.getTaskId(), MLTaskState.RUNNING, mlTask.isAsync());
            MLOutput output = MLEngine.trainAndPredict((Input)mlInput.toBuilder().inputDataset((MLInputDataset)new DataFrameInputDataset(inputDataFrame)).build());
            this.handleAsyncMLTaskComplete(mlTask);
            if (output instanceof MLPredictionOutput) {
                ((MLPredictionOutput)output).setStatus(MLTaskState.COMPLETED.name());
            }
            MLTaskResponse response = MLTaskResponse.builder().output(output).build();
            log.info("Train and predict task done for algorithm: {}, task id: {}", (Object)mlTask.getFunctionName(), (Object)mlTask.getTaskId());
            internalListener.onResponse((Object)response);
        }
        catch (Exception e) {
            log.error("Failed to train and predict " + mlInput.getAlgorithm(), (Throwable)e);
            this.handlePredictFailure(mlTask, listener, e, true);
            return;
        }
    }

    private void handlePredictFailure(MLTask mlTask, ActionListener<MLTaskResponse> listener, Exception e, boolean trackFailure) {
        if (trackFailure) {
            this.mlStats.createCounterStatIfAbsent(StatNames.failureCountStat(mlTask.getFunctionName(), ActionName.TRAIN_PREDICT)).increment();
            this.mlStats.getStat(StatNames.ML_TOTAL_FAILURE_COUNT).increment();
        }
        this.handleAsyncMLTaskFailure(mlTask, e);
        listener.onFailure(e);
    }
}

