/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.stats;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import lombok.Generated;
import org.opensearch.ml.stats.MLStat;
import org.opensearch.ml.stats.suppliers.CounterSupplier;

public class MLStats {
    private Map<String, MLStat<?>> stats;

    public MLStats(Map<String, MLStat<?>> stats) {
        this.stats = stats;
    }

    public MLStat<?> getStat(String key) throws IllegalArgumentException {
        if (!this.stats.keySet().contains(key)) {
            throw new IllegalArgumentException("Stat \"" + key + "\" does not exist");
        }
        return this.stats.get(key);
    }

    public MLStat<?> createCounterStatIfAbsent(String key) {
        return this.createStatIfAbsent(key, () -> new MLStat<Long>(false, new CounterSupplier()));
    }

    public synchronized MLStat<?> createStatIfAbsent(String key, Supplier<MLStat> supplier) {
        return this.stats.computeIfAbsent(key, k -> (MLStat)supplier.get());
    }

    public Map<String, MLStat<?>> getNodeStats() {
        return this.getClusterOrNodeStats(false);
    }

    public Map<String, MLStat<?>> getClusterStats() {
        return this.getClusterOrNodeStats(true);
    }

    private Map<String, MLStat<?>> getClusterOrNodeStats(Boolean getClusterStats) {
        HashMap statsMap = new HashMap();
        for (Map.Entry<String, MLStat<?>> entry : this.stats.entrySet()) {
            if (entry.getValue().isClusterLevel() != getClusterStats.booleanValue()) continue;
            statsMap.put(entry.getKey(), entry.getValue());
        }
        return statsMap;
    }

    @Generated
    public Map<String, MLStat<?>> getStats() {
        return this.stats;
    }
}

