/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.plugin;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionResponse;
import org.opensearch.action.ActionType;
import org.opensearch.client.Client;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.node.DiscoveryNodeRole;
import org.opensearch.cluster.node.DiscoveryNodes;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.io.stream.NamedWriteableRegistry;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.settings.IndexScopedSettings;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.settings.SettingsFilter;
import org.opensearch.common.xcontent.NamedXContentRegistry;
import org.opensearch.env.Environment;
import org.opensearch.env.NodeEnvironment;
import org.opensearch.ml.action.execute.TransportExecuteTaskAction;
import org.opensearch.ml.action.handler.MLSearchHandler;
import org.opensearch.ml.action.models.DeleteModelTransportAction;
import org.opensearch.ml.action.models.GetModelTransportAction;
import org.opensearch.ml.action.models.SearchModelTransportAction;
import org.opensearch.ml.action.prediction.TransportPredictionTaskAction;
import org.opensearch.ml.action.stats.MLStatsNodesAction;
import org.opensearch.ml.action.stats.MLStatsNodesTransportAction;
import org.opensearch.ml.action.tasks.DeleteTaskTransportAction;
import org.opensearch.ml.action.tasks.GetTaskTransportAction;
import org.opensearch.ml.action.tasks.SearchTaskTransportAction;
import org.opensearch.ml.action.training.TransportTrainingTaskAction;
import org.opensearch.ml.action.trainpredict.TransportTrainAndPredictionTaskAction;
import org.opensearch.ml.common.FunctionName;
import org.opensearch.ml.common.breaker.MLCircuitBreakerService;
import org.opensearch.ml.common.input.execute.anomalylocalization.AnomalyLocalizationInput;
import org.opensearch.ml.common.input.execute.samplecalculator.LocalSampleCalculatorInput;
import org.opensearch.ml.common.input.parameter.ad.AnomalyDetectionLibSVMParams;
import org.opensearch.ml.common.input.parameter.clustering.KMeansParams;
import org.opensearch.ml.common.input.parameter.rcf.BatchRCFParams;
import org.opensearch.ml.common.input.parameter.rcf.FitRCFParams;
import org.opensearch.ml.common.input.parameter.regression.LinearRegressionParams;
import org.opensearch.ml.common.input.parameter.sample.SampleAlgoParams;
import org.opensearch.ml.common.transport.execute.MLExecuteTaskAction;
import org.opensearch.ml.common.transport.model.MLModelDeleteAction;
import org.opensearch.ml.common.transport.model.MLModelGetAction;
import org.opensearch.ml.common.transport.model.MLModelSearchAction;
import org.opensearch.ml.common.transport.prediction.MLPredictionTaskAction;
import org.opensearch.ml.common.transport.task.MLTaskDeleteAction;
import org.opensearch.ml.common.transport.task.MLTaskGetAction;
import org.opensearch.ml.common.transport.task.MLTaskSearchAction;
import org.opensearch.ml.common.transport.training.MLTrainingTaskAction;
import org.opensearch.ml.common.transport.trainpredict.MLTrainAndPredictionTaskAction;
import org.opensearch.ml.engine.MLEngineClassLoader;
import org.opensearch.ml.engine.algorithms.anomalylocalization.AnomalyLocalizerImpl;
import org.opensearch.ml.engine.algorithms.sample.LocalSampleCalculator;
import org.opensearch.ml.indices.MLIndicesHandler;
import org.opensearch.ml.indices.MLInputDatasetHandler;
import org.opensearch.ml.rest.RestMLDeleteModelAction;
import org.opensearch.ml.rest.RestMLDeleteTaskAction;
import org.opensearch.ml.rest.RestMLExecuteAction;
import org.opensearch.ml.rest.RestMLGetModelAction;
import org.opensearch.ml.rest.RestMLGetTaskAction;
import org.opensearch.ml.rest.RestMLPredictionAction;
import org.opensearch.ml.rest.RestMLSearchModelAction;
import org.opensearch.ml.rest.RestMLSearchTaskAction;
import org.opensearch.ml.rest.RestMLTrainAndPredictAction;
import org.opensearch.ml.rest.RestMLTrainingAction;
import org.opensearch.ml.rest.RestStatsMLAction;
import org.opensearch.ml.stats.MLStat;
import org.opensearch.ml.stats.MLStats;
import org.opensearch.ml.stats.StatNames;
import org.opensearch.ml.stats.suppliers.CounterSupplier;
import org.opensearch.ml.task.MLExecuteTaskRunner;
import org.opensearch.ml.task.MLPredictTaskRunner;
import org.opensearch.ml.task.MLTaskDispatcher;
import org.opensearch.ml.task.MLTaskManager;
import org.opensearch.ml.task.MLTrainAndPredictTaskRunner;
import org.opensearch.ml.task.MLTrainingTaskRunner;
import org.opensearch.monitor.jvm.JvmService;
import org.opensearch.plugins.ActionPlugin;
import org.opensearch.plugins.Plugin;
import org.opensearch.repositories.RepositoriesService;
import org.opensearch.rest.RestController;
import org.opensearch.rest.RestHandler;
import org.opensearch.script.ScriptService;
import org.opensearch.threadpool.ExecutorBuilder;
import org.opensearch.threadpool.FixedExecutorBuilder;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.watcher.ResourceWatcherService;

public class MachineLearningPlugin
extends Plugin
implements ActionPlugin {
    public static final String TASK_THREAD_POOL = "OPENSEARCH_ML_TASK_THREAD_POOL";
    public static final String ML_BASE_URI = "/_plugins/_ml";
    private MLStats mlStats;
    private MLTaskManager mlTaskManager;
    private MLIndicesHandler mlIndicesHandler;
    private MLInputDatasetHandler mlInputDatasetHandler;
    private MLTrainingTaskRunner mlTrainingTaskRunner;
    private MLPredictTaskRunner mlPredictTaskRunner;
    private MLTrainAndPredictTaskRunner mlTrainAndPredictTaskRunner;
    private MLExecuteTaskRunner mlExecuteTaskRunner;
    private Client client;
    private ClusterService clusterService;
    private ThreadPool threadPool;
    public static final Setting<Boolean> IS_ML_NODE_SETTING = Setting.boolSetting((String)"node.ml", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final DiscoveryNodeRole ML_ROLE = new DiscoveryNodeRole("ml", "l"){

        public Setting<Boolean> legacySetting() {
            return IS_ML_NODE_SETTING;
        }
    };

    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        return ImmutableList.of((Object)new ActionPlugin.ActionHandler((ActionType)MLStatsNodesAction.INSTANCE, MLStatsNodesTransportAction.class, new Class[0]), (Object)new ActionPlugin.ActionHandler((ActionType)MLExecuteTaskAction.INSTANCE, TransportExecuteTaskAction.class, new Class[0]), (Object)new ActionPlugin.ActionHandler((ActionType)MLPredictionTaskAction.INSTANCE, TransportPredictionTaskAction.class, new Class[0]), (Object)new ActionPlugin.ActionHandler((ActionType)MLTrainingTaskAction.INSTANCE, TransportTrainingTaskAction.class, new Class[0]), (Object)new ActionPlugin.ActionHandler((ActionType)MLTrainAndPredictionTaskAction.INSTANCE, TransportTrainAndPredictionTaskAction.class, new Class[0]), (Object)new ActionPlugin.ActionHandler((ActionType)MLModelGetAction.INSTANCE, GetModelTransportAction.class, new Class[0]), (Object)new ActionPlugin.ActionHandler((ActionType)MLModelDeleteAction.INSTANCE, DeleteModelTransportAction.class, new Class[0]), (Object)new ActionPlugin.ActionHandler((ActionType)MLModelSearchAction.INSTANCE, SearchModelTransportAction.class, new Class[0]), (Object)new ActionPlugin.ActionHandler((ActionType)MLTaskGetAction.INSTANCE, GetTaskTransportAction.class, new Class[0]), (Object)new ActionPlugin.ActionHandler((ActionType)MLTaskDeleteAction.INSTANCE, DeleteTaskTransportAction.class, new Class[0]), (Object)new ActionPlugin.ActionHandler((ActionType)MLTaskSearchAction.INSTANCE, SearchTaskTransportAction.class, new Class[0]));
    }

    public Collection<Object> createComponents(Client client, ClusterService clusterService, ThreadPool threadPool, ResourceWatcherService resourceWatcherService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, Environment environment, NodeEnvironment nodeEnvironment, NamedWriteableRegistry namedWriteableRegistry, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<RepositoriesService> repositoriesServiceSupplier) {
        this.client = client;
        this.threadPool = threadPool;
        this.clusterService = clusterService;
        Settings settings = environment.settings();
        JvmService jvmService = new JvmService(environment.settings());
        MLCircuitBreakerService mlCircuitBreakerService = new MLCircuitBreakerService(jvmService).init();
        ConcurrentHashMap stats = new ConcurrentHashMap();
        stats.put(StatNames.ML_EXECUTING_TASK_COUNT, new MLStat<Long>(false, new CounterSupplier()));
        stats.put(StatNames.ML_TOTAL_REQUEST_COUNT, new MLStat<Long>(false, new CounterSupplier()));
        stats.put(StatNames.ML_TOTAL_FAILURE_COUNT, new MLStat<Long>(false, new CounterSupplier()));
        stats.put(StatNames.ML_TOTAL_MODEL_COUNT, new MLStat<Long>(false, new CounterSupplier()));
        stats.put(StatNames.ML_TOTAL_CIRCUIT_BREAKER_TRIGGER_COUNT, new MLStat<Long>(false, new CounterSupplier()));
        this.mlStats = new MLStats(stats);
        this.mlIndicesHandler = new MLIndicesHandler(clusterService, client);
        this.mlTaskManager = new MLTaskManager(client, this.mlIndicesHandler);
        this.mlInputDatasetHandler = new MLInputDatasetHandler(client);
        MLTaskDispatcher mlTaskDispatcher = new MLTaskDispatcher(clusterService, client);
        this.mlTrainingTaskRunner = new MLTrainingTaskRunner(threadPool, clusterService, client, this.mlTaskManager, this.mlStats, this.mlIndicesHandler, this.mlInputDatasetHandler, mlTaskDispatcher, mlCircuitBreakerService);
        this.mlPredictTaskRunner = new MLPredictTaskRunner(threadPool, clusterService, client, this.mlTaskManager, this.mlStats, this.mlInputDatasetHandler, mlTaskDispatcher, mlCircuitBreakerService, xContentRegistry);
        this.mlTrainAndPredictTaskRunner = new MLTrainAndPredictTaskRunner(threadPool, clusterService, client, this.mlTaskManager, this.mlStats, this.mlInputDatasetHandler, mlTaskDispatcher, mlCircuitBreakerService);
        this.mlExecuteTaskRunner = new MLExecuteTaskRunner(threadPool, clusterService, client, this.mlTaskManager, this.mlStats, this.mlInputDatasetHandler, mlTaskDispatcher, mlCircuitBreakerService);
        LocalSampleCalculator localSampleCalculator = new LocalSampleCalculator(client, settings);
        MLEngineClassLoader.register((Enum)FunctionName.LOCAL_SAMPLE_CALCULATOR, (Object)localSampleCalculator);
        AnomalyLocalizerImpl anomalyLocalizer = new AnomalyLocalizerImpl(client, settings);
        MLEngineClassLoader.register((Enum)FunctionName.ANOMALY_LOCALIZATION, (Object)anomalyLocalizer);
        MLSearchHandler mlSearchHandler = new MLSearchHandler(client, xContentRegistry);
        return ImmutableList.of((Object)this.mlStats, (Object)this.mlTaskManager, (Object)this.mlIndicesHandler, (Object)this.mlInputDatasetHandler, (Object)this.mlTrainingTaskRunner, (Object)this.mlPredictTaskRunner, (Object)this.mlTrainAndPredictTaskRunner, (Object)this.mlExecuteTaskRunner, (Object)mlSearchHandler);
    }

    public List<RestHandler> getRestHandlers(Settings settings, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        RestStatsMLAction restStatsMLAction = new RestStatsMLAction(this.mlStats);
        RestMLTrainingAction restMLTrainingAction = new RestMLTrainingAction();
        RestMLTrainAndPredictAction restMLTrainAndPredictAction = new RestMLTrainAndPredictAction();
        RestMLPredictionAction restMLPredictionAction = new RestMLPredictionAction();
        RestMLExecuteAction restMLExecuteAction = new RestMLExecuteAction();
        RestMLGetModelAction restMLGetModelAction = new RestMLGetModelAction();
        RestMLDeleteModelAction restMLDeleteModelAction = new RestMLDeleteModelAction();
        RestMLSearchModelAction restMLSearchModelAction = new RestMLSearchModelAction();
        RestMLGetTaskAction restMLGetTaskAction = new RestMLGetTaskAction();
        RestMLDeleteTaskAction restMLDeleteTaskAction = new RestMLDeleteTaskAction();
        RestMLSearchTaskAction restMLSearchTaskAction = new RestMLSearchTaskAction();
        return ImmutableList.of((Object)((Object)restStatsMLAction), (Object)((Object)restMLTrainingAction), (Object)((Object)restMLPredictionAction), (Object)((Object)restMLExecuteAction), (Object)((Object)restMLTrainAndPredictAction), (Object)((Object)restMLGetModelAction), (Object)((Object)restMLDeleteModelAction), (Object)((Object)restMLSearchModelAction), (Object)((Object)restMLGetTaskAction), (Object)((Object)restMLDeleteTaskAction), (Object)((Object)restMLSearchTaskAction));
    }

    public List<ExecutorBuilder<?>> getExecutorBuilders(Settings settings) {
        FixedExecutorBuilder ml = new FixedExecutorBuilder(settings, TASK_THREAD_POOL, 4, 4, "ml.task_thread_pool", false);
        return Collections.singletonList(ml);
    }

    public List<NamedXContentRegistry.Entry> getNamedXContent() {
        return ImmutableList.of((Object)KMeansParams.XCONTENT_REGISTRY, (Object)LinearRegressionParams.XCONTENT_REGISTRY, (Object)AnomalyDetectionLibSVMParams.XCONTENT_REGISTRY, (Object)SampleAlgoParams.XCONTENT_REGISTRY, (Object)FitRCFParams.XCONTENT_REGISTRY, (Object)BatchRCFParams.XCONTENT_REGISTRY, (Object)LocalSampleCalculatorInput.XCONTENT_REGISTRY, (Object)AnomalyLocalizationInput.XCONTENT_REGISTRY_ENTRY);
    }
}

