/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.indices;

import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionListener;
import org.opensearch.action.admin.indices.create.CreateIndexRequest;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.util.concurrent.ThreadContext;

public class MLIndicesHandler {
    @Generated
    private static final Logger log = LogManager.getLogger(MLIndicesHandler.class);
    public static final String ML_MODEL_INDEX = ".plugins-ml-model";
    public static final String ML_TASK_INDEX = ".plugins-ml-task";
    private static final String ML_MODEL_INDEX_MAPPING = "{\n    \"properties\": {\n      \"task_id\": { \"type\": \"keyword\" },\n      \"algorithm\": {\"type\": \"keyword\"},\n      \"model_name\" : { \"type\": \"keyword\"},\n      \"model_version\" : { \"type\": \"keyword\"},\n      \"model_content\" : { \"type\": \"binary\"}\n    }\n}";
    private static final String ML_TASK_INDEX_MAPPING = "{\n    \"properties\": {\n      \"model_id\": {\"type\": \"keyword\"},\n      \"task_type\": {\"type\": \"keyword\"},\n      \"function_name\": {\"type\": \"keyword\"},\n      \"state\": {\"type\": \"keyword\"},\n      \"input_type\": {\"type\": \"keyword\"},\n      \"progress\": {\"type\": \"float\"},\n      \"output_index\": {\"type\": \"keyword\"},\n      \"worker_node\": {\"type\": \"keyword\"},\n      \"create_time\": {\"type\": \"date\", \"format\": \"strict_date_time||epoch_millis\"},\n      \"last_update_time\": {\"type\": \"date\", \"format\": \"strict_date_time||epoch_millis\"},\n      \"error\": {\"type\": \"text\"},\n      \"user\": {\n        \"type\": \"nested\",\n        \"properties\": {\n          \"name\": {\"type\":\"text\", \"fields\":{\"keyword\":{\"type\":\"keyword\", \"ignore_above\":256}}},\n          \"backend_roles\": {\"type\":\"text\", \"fields\":{\"keyword\":{\"type\":\"keyword\"}}},\n          \"roles\": {\"type\":\"text\", \"fields\":{\"keyword\":{\"type\":\"keyword\"}}},\n          \"custom_attribute_names\": {\"type\":\"text\", \"fields\":{\"keyword\":{\"type\":\"keyword\"}}}\n        }\n      }\n    }\n}";
    private final ClusterService clusterService;
    private final Client client;

    public void initModelIndexIfAbsent() {
        this.initMLIndexIfAbsent(ML_MODEL_INDEX, ML_MODEL_INDEX_MAPPING);
    }

    public boolean doesModelIndexExist() {
        return this.clusterService.state().metadata().hasIndex(ML_MODEL_INDEX);
    }

    private void initMLIndexIfAbsent(String indexName, String mapping) {
        if (!this.clusterService.state().metadata().hasIndex(indexName)) {
            this.client.admin().indices().prepareCreate(indexName).get();
            log.info("create index:{}", (Object)indexName);
        } else {
            log.info("index:{} is already created", (Object)indexName);
        }
    }

    public void initModelIndexIfAbsent(ActionListener<Boolean> listener) {
        this.initMLIndexIfAbsent(ML_MODEL_INDEX, ML_MODEL_INDEX_MAPPING, listener);
    }

    public void initMLTaskIndex(ActionListener<Boolean> listener) {
        this.initMLIndexIfAbsent(ML_TASK_INDEX, ML_TASK_INDEX_MAPPING, listener);
    }

    public void initMLIndexIfAbsent(String indexName, String mapping, ActionListener<Boolean> listener) {
        if (!this.clusterService.state().metadata().hasIndex(indexName)) {
            try (ThreadContext.StoredContext threadContext = this.client.threadPool().getThreadContext().stashContext();){
                ActionListener actionListener = ActionListener.wrap(r -> {
                    if (r.isAcknowledged()) {
                        log.info("create index:{}", (Object)indexName);
                        listener.onResponse((Object)true);
                    } else {
                        listener.onResponse((Object)false);
                    }
                }, e -> {
                    log.error("Failed to create index " + indexName, (Throwable)e);
                    listener.onFailure(e);
                });
                CreateIndexRequest request = new CreateIndexRequest(indexName);
                this.client.admin().indices().create(request, ActionListener.runBefore((ActionListener)actionListener, () -> threadContext.restore()));
            }
            catch (Exception e2) {
                log.error("Failed to init index " + indexName, (Throwable)e2);
                listener.onFailure(e2);
            }
        } else {
            log.info("index:{} is already created", (Object)indexName);
            listener.onResponse((Object)true);
        }
    }

    @Generated
    public MLIndicesHandler(ClusterService clusterService, Client client) {
        this.clusterService = clusterService;
        this.client = client;
    }
}

