/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.action.stats;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.opensearch.action.FailedNodeException;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.nodes.TransportNodesAction;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.env.Environment;
import org.opensearch.ml.action.stats.MLStatsNodeRequest;
import org.opensearch.ml.action.stats.MLStatsNodeResponse;
import org.opensearch.ml.action.stats.MLStatsNodesAction;
import org.opensearch.ml.action.stats.MLStatsNodesRequest;
import org.opensearch.ml.action.stats.MLStatsNodesResponse;
import org.opensearch.ml.stats.InternalStatNames;
import org.opensearch.ml.stats.MLStats;
import org.opensearch.monitor.jvm.JvmService;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;

public class MLStatsNodesTransportAction
extends TransportNodesAction<MLStatsNodesRequest, MLStatsNodesResponse, MLStatsNodeRequest, MLStatsNodeResponse> {
    private MLStats mlStats;
    private final JvmService jvmService;

    @Inject
    public MLStatsNodesTransportAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, MLStats mlStats, Environment environment) {
        super(MLStatsNodesAction.NAME, threadPool, clusterService, transportService, actionFilters, MLStatsNodesRequest::new, MLStatsNodeRequest::new, "management", MLStatsNodeResponse.class);
        this.mlStats = mlStats;
        this.jvmService = new JvmService(environment.settings());
    }

    protected MLStatsNodesResponse newResponse(MLStatsNodesRequest request, List<MLStatsNodeResponse> responses, List<FailedNodeException> failures) {
        return new MLStatsNodesResponse(this.clusterService.getClusterName(), responses, failures);
    }

    protected MLStatsNodeRequest newNodeRequest(MLStatsNodesRequest request) {
        return new MLStatsNodeRequest(request);
    }

    protected MLStatsNodeResponse newNodeResponse(StreamInput in) throws IOException {
        return new MLStatsNodeResponse(in);
    }

    protected MLStatsNodeResponse nodeOperation(MLStatsNodeRequest request) {
        return this.createMLStatsNodeResponse(request.getMlStatsNodesRequest());
    }

    private MLStatsNodeResponse createMLStatsNodeResponse(MLStatsNodesRequest mlStatsNodesRequest) {
        HashMap<String, Object> statValues = new HashMap<String, Object>();
        Set<String> statsToBeRetrieved = mlStatsNodesRequest.getStatsToBeRetrieved();
        boolean retrieveAllStats = mlStatsNodesRequest.isRetrieveAllStats();
        if (retrieveAllStats || statsToBeRetrieved.contains(InternalStatNames.JVM_HEAP_USAGE.getName())) {
            long heapUsedPercent = this.jvmService.stats().getMem().getHeapUsedPercent();
            statValues.put(InternalStatNames.JVM_HEAP_USAGE.getName(), heapUsedPercent);
        }
        for (String statName : this.mlStats.getNodeStats().keySet()) {
            if (!retrieveAllStats && !statsToBeRetrieved.contains(statName)) continue;
            statValues.put(statName, this.mlStats.getStats().get(statName).getValue());
        }
        return new MLStatsNodeResponse(this.clusterService.localNode(), statValues);
    }
}

