/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.action.stats;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import org.opensearch.action.support.nodes.BaseNodesRequest;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;

public class MLStatsNodesRequest
extends BaseNodesRequest<MLStatsNodesRequest> {
    public static final String ALL_STATS_KEY = "_all";
    private Set<String> statsToBeRetrieved;
    private boolean retrieveAllStats = false;

    public MLStatsNodesRequest(StreamInput in) throws IOException {
        super(in);
        this.retrieveAllStats = in.readBoolean();
        this.statsToBeRetrieved = in.readSet(StreamInput::readString);
    }

    public MLStatsNodesRequest(String ... nodeIds) {
        super(nodeIds);
        this.statsToBeRetrieved = new HashSet<String>();
    }

    public MLStatsNodesRequest(DiscoveryNode ... nodes) {
        super(nodes);
        this.statsToBeRetrieved = new HashSet<String>();
    }

    public boolean isRetrieveAllStats() {
        return this.retrieveAllStats;
    }

    public void setRetrieveAllStats(boolean retrieveAllStats) {
        this.retrieveAllStats = retrieveAllStats;
    }

    public void addStat(String stat) {
        this.statsToBeRetrieved.add(stat);
    }

    public void addAll(Set<String> statsToBeAdded) {
        this.statsToBeRetrieved.addAll(statsToBeAdded);
    }

    public void clear() {
        this.statsToBeRetrieved.clear();
    }

    public void readFrom(StreamInput in) throws IOException {
        this.statsToBeRetrieved = in.readSet(StreamInput::readString);
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeBoolean(this.retrieveAllStats);
        out.writeStringCollection(this.statsToBeRetrieved);
    }

    @Generated
    public Set<String> getStatsToBeRetrieved() {
        return this.statsToBeRetrieved;
    }
}

