/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.action.handler;

import com.google.common.base.Throwables;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.ActionListener;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.client.Client;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.xcontent.NamedXContentRegistry;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.indices.InvalidIndexNameException;
import org.opensearch.ml.common.exception.MLException;
import org.opensearch.ml.common.exception.MLResourceNotFoundException;
import org.opensearch.rest.RestStatus;

public class MLSearchHandler {
    @Generated
    private static final Logger log = LogManager.getLogger(MLSearchHandler.class);
    private final Client client;
    private NamedXContentRegistry xContentRegistry;

    public MLSearchHandler(Client client, NamedXContentRegistry xContentRegistry) {
        this.client = client;
        this.xContentRegistry = xContentRegistry;
    }

    public void search(SearchRequest request, ActionListener<SearchResponse> actionListener) {
        ActionListener<SearchResponse> listener = MLSearchHandler.wrapRestActionListener(actionListener, "Fail to search");
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            this.client.search(request, listener);
        }
        catch (Exception e) {
            log.error("Failed to search", (Throwable)e);
            listener.onFailure(e);
        }
    }

    public static <T> ActionListener<T> wrapRestActionListener(ActionListener<T> actionListener, String generalErrorMessage) {
        return ActionListener.wrap(r -> actionListener.onResponse(r), e -> {
            log.error("Wrap exception before sending back to user", (Throwable)e);
            Throwable cause = Throwables.getRootCause((Throwable)e);
            if (MLSearchHandler.isProperExceptionToReturn(e)) {
                actionListener.onFailure(e);
            } else if (MLSearchHandler.isProperExceptionToReturn(cause)) {
                actionListener.onFailure((Exception)cause);
            } else {
                RestStatus status = MLSearchHandler.isBadRequest(e) ? RestStatus.BAD_REQUEST : RestStatus.INTERNAL_SERVER_ERROR;
                String errorMessage = generalErrorMessage;
                if (MLSearchHandler.isBadRequest(e) || e instanceof MLException) {
                    errorMessage = e.getMessage();
                } else if (cause != null && (MLSearchHandler.isBadRequest(cause) || cause instanceof MLException)) {
                    errorMessage = cause.getMessage();
                }
                actionListener.onFailure((Exception)new OpenSearchStatusException(errorMessage, status, new Object[0]));
            }
        });
    }

    public static boolean isProperExceptionToReturn(Throwable e) {
        return e instanceof OpenSearchStatusException || e instanceof IndexNotFoundException || e instanceof InvalidIndexNameException;
    }

    public static boolean isBadRequest(Throwable e) {
        return e instanceof IllegalArgumentException || e instanceof MLResourceNotFoundException;
    }
}

