/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression.function;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.expression.Expression;
import org.opensearch.sql.expression.FunctionExpression;
import org.opensearch.sql.expression.NamedArgumentExpression;
import org.opensearch.sql.expression.env.Environment;
import org.opensearch.sql.expression.function.BuiltinFunctionName;
import org.opensearch.sql.expression.function.BuiltinFunctionRepository;
import org.opensearch.sql.expression.function.FunctionBuilder;
import org.opensearch.sql.expression.function.FunctionName;
import org.opensearch.sql.expression.function.FunctionResolver;
import org.opensearch.sql.expression.function.FunctionSignature;

public final class OpenSearchFunctions {
    public static void register(BuiltinFunctionRepository repository) {
        repository.register(OpenSearchFunctions.match());
    }

    private static FunctionResolver match() {
        FunctionName funcName = BuiltinFunctionName.MATCH.getName();
        return new FunctionResolver(funcName, (Map<FunctionSignature, FunctionBuilder>)ImmutableMap.builder().put((Object)new FunctionSignature(funcName, (List<ExprType>)ImmutableList.of((Object)ExprCoreType.STRING, (Object)ExprCoreType.STRING)), args -> new OpenSearchFunction(funcName, args)).put((Object)new FunctionSignature(funcName, (List<ExprType>)ImmutableList.of((Object)ExprCoreType.STRING, (Object)ExprCoreType.STRING, (Object)ExprCoreType.STRING)), args -> new OpenSearchFunction(funcName, args)).put((Object)new FunctionSignature(funcName, (List<ExprType>)ImmutableList.of((Object)ExprCoreType.STRING, (Object)ExprCoreType.STRING, (Object)ExprCoreType.STRING, (Object)ExprCoreType.STRING)), args -> new OpenSearchFunction(funcName, args)).put((Object)new FunctionSignature(funcName, (List<ExprType>)ImmutableList.of((Object)ExprCoreType.STRING, (Object)ExprCoreType.STRING, (Object)ExprCoreType.STRING, (Object)ExprCoreType.STRING, (Object)ExprCoreType.STRING)), args -> new OpenSearchFunction(funcName, args)).put((Object)new FunctionSignature(funcName, (List<ExprType>)ImmutableList.of((Object)ExprCoreType.STRING, (Object)ExprCoreType.STRING, (Object)ExprCoreType.STRING, (Object)ExprCoreType.STRING, (Object)ExprCoreType.STRING, (Object)ExprCoreType.STRING)), args -> new OpenSearchFunction(funcName, args)).put((Object)new FunctionSignature(funcName, (List<ExprType>)ImmutableList.of((Object)ExprCoreType.STRING, (Object)ExprCoreType.STRING, (Object)ExprCoreType.STRING, (Object)ExprCoreType.STRING, (Object)ExprCoreType.STRING, (Object)ExprCoreType.STRING, (Object)ExprCoreType.STRING)), args -> new OpenSearchFunction(funcName, args)).put((Object)new FunctionSignature(funcName, (List<ExprType>)ImmutableList.of((Object)ExprCoreType.STRING, (Object)ExprCoreType.STRING, (Object)ExprCoreType.STRING, (Object)ExprCoreType.STRING, (Object)ExprCoreType.STRING, (Object)ExprCoreType.STRING, (Object)ExprCoreType.STRING, (Object)ExprCoreType.STRING)), args -> new OpenSearchFunction(funcName, args)).put((Object)new FunctionSignature(funcName, (List<ExprType>)ImmutableList.of((Object)ExprCoreType.STRING, (Object)ExprCoreType.STRING, (Object)ExprCoreType.STRING, (Object)ExprCoreType.STRING, (Object)ExprCoreType.STRING, (Object)ExprCoreType.STRING, (Object)ExprCoreType.STRING, (Object)ExprCoreType.STRING, (Object)ExprCoreType.STRING)), args -> new OpenSearchFunction(funcName, args)).put((Object)new FunctionSignature(funcName, (List<ExprType>)ImmutableList.of((Object)ExprCoreType.STRING, (Object)ExprCoreType.STRING, (Object)ExprCoreType.STRING, (Object)ExprCoreType.STRING, (Object)ExprCoreType.STRING, (Object)ExprCoreType.STRING, (Object)ExprCoreType.STRING, (Object)ExprCoreType.STRING, (Object)ExprCoreType.STRING, (Object)ExprCoreType.STRING)), args -> new OpenSearchFunction(funcName, args)).put((Object)new FunctionSignature(funcName, (List<ExprType>)ImmutableList.of((Object)ExprCoreType.STRING, (Object)ExprCoreType.STRING, (Object)ExprCoreType.STRING, (Object)ExprCoreType.STRING, (Object)ExprCoreType.STRING, (Object)ExprCoreType.STRING, (Object)ExprCoreType.STRING, (Object)ExprCoreType.STRING, (Object)ExprCoreType.STRING, (Object)ExprCoreType.STRING, (Object)ExprCoreType.STRING)), args -> new OpenSearchFunction(funcName, args)).put((Object)new FunctionSignature(funcName, (List<ExprType>)ImmutableList.of((Object)ExprCoreType.STRING, (Object)ExprCoreType.STRING, (Object)ExprCoreType.STRING, (Object)ExprCoreType.STRING, (Object)ExprCoreType.STRING, (Object)ExprCoreType.STRING, (Object)ExprCoreType.STRING, (Object)ExprCoreType.STRING, (Object)ExprCoreType.STRING, (Object)ExprCoreType.STRING, (Object)ExprCoreType.STRING, (Object)ExprCoreType.STRING, (Object[])new ExprType[0])), args -> new OpenSearchFunction(funcName, args)).put((Object)new FunctionSignature(funcName, (List<ExprType>)ImmutableList.of((Object)ExprCoreType.STRING, (Object)ExprCoreType.STRING, (Object)ExprCoreType.STRING, (Object)ExprCoreType.STRING, (Object)ExprCoreType.STRING, (Object)ExprCoreType.STRING, (Object)ExprCoreType.STRING, (Object)ExprCoreType.STRING, (Object)ExprCoreType.STRING, (Object)ExprCoreType.STRING, (Object)ExprCoreType.STRING, (Object)ExprCoreType.STRING, (Object[])new ExprType[]{ExprCoreType.STRING})), args -> new OpenSearchFunction(funcName, args)).put((Object)new FunctionSignature(funcName, (List<ExprType>)ImmutableList.of((Object)ExprCoreType.STRING, (Object)ExprCoreType.STRING, (Object)ExprCoreType.STRING, (Object)ExprCoreType.STRING, (Object)ExprCoreType.STRING, (Object)ExprCoreType.STRING, (Object)ExprCoreType.STRING, (Object)ExprCoreType.STRING, (Object)ExprCoreType.STRING, (Object)ExprCoreType.STRING, (Object)ExprCoreType.STRING, (Object)ExprCoreType.STRING, (Object[])new ExprType[]{ExprCoreType.STRING, ExprCoreType.STRING})), args -> new OpenSearchFunction(funcName, args)).build());
    }

    @Generated
    private OpenSearchFunctions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static class OpenSearchFunction
    extends FunctionExpression {
        private final FunctionName functionName;
        private final List<Expression> arguments;

        public OpenSearchFunction(FunctionName functionName, List<Expression> arguments) {
            super(functionName, arguments);
            this.functionName = functionName;
            this.arguments = arguments;
        }

        @Override
        public ExprValue valueOf(Environment<Expression, ExprValue> valueEnv) {
            throw new UnsupportedOperationException(String.format("OpenSearch defined function [%s] is only supported in WHERE and HAVING clause.", this.functionName));
        }

        @Override
        public ExprType type() {
            return ExprCoreType.BOOLEAN;
        }

        @Override
        public String toString() {
            List args = this.arguments.stream().map(arg -> String.format("%s=%s", ((NamedArgumentExpression)arg).getArgName(), ((NamedArgumentExpression)arg).getValue().toString())).collect(Collectors.toList());
            return String.format("%s(%s)", this.functionName, String.join((CharSequence)", ", args));
        }
    }
}

