/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression;

import org.opensearch.sql.expression.Expression;
import org.opensearch.sql.expression.FunctionExpression;
import org.opensearch.sql.expression.LiteralExpression;
import org.opensearch.sql.expression.NamedArgumentExpression;
import org.opensearch.sql.expression.NamedExpression;
import org.opensearch.sql.expression.ParseExpression;
import org.opensearch.sql.expression.ReferenceExpression;
import org.opensearch.sql.expression.aggregation.Aggregator;
import org.opensearch.sql.expression.aggregation.NamedAggregator;
import org.opensearch.sql.expression.conditional.cases.CaseClause;
import org.opensearch.sql.expression.conditional.cases.WhenClause;
import org.opensearch.sql.expression.function.FunctionImplementation;

public abstract class ExpressionNodeVisitor<T, C> {
    public T visitNode(Expression node, C context) {
        return null;
    }

    public T visitChildren(FunctionImplementation node, C context) {
        T result = this.defaultResult();
        for (Expression child : node.getArguments()) {
            Object childResult = child.accept(this, context);
            result = this.aggregateResult(result, childResult);
        }
        return result;
    }

    private T defaultResult() {
        return null;
    }

    private T aggregateResult(T aggregate, T nextResult) {
        return nextResult;
    }

    public T visitLiteral(LiteralExpression node, C context) {
        return this.visitNode(node, context);
    }

    public T visitNamed(NamedExpression node, C context) {
        return node.getDelegated().accept(this, context);
    }

    public T visitReference(ReferenceExpression node, C context) {
        return this.visitNode(node, context);
    }

    public T visitParse(ParseExpression node, C context) {
        return this.visitNode(node, context);
    }

    public T visitFunction(FunctionExpression node, C context) {
        return this.visitChildren(node, context);
    }

    public T visitAggregator(Aggregator<?> node, C context) {
        return this.visitChildren(node, context);
    }

    public T visitNamedAggregator(NamedAggregator node, C context) {
        return this.visitChildren(node, context);
    }

    public T visitCase(CaseClause node, C context) {
        return this.visitFunction(node, context);
    }

    public T visitWhen(WhenClause node, C context) {
        return this.visitFunction(node, context);
    }

    public T visitNamedArgument(NamedArgumentExpression node, C context) {
        return this.visitNode(node, context);
    }
}

