/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression;

import java.util.Arrays;
import java.util.Collections;
import lombok.Generated;
import org.opensearch.sql.ast.expression.SpanUnit;
import org.opensearch.sql.data.model.ExprShortValue;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.data.model.ExprValueUtils;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.expression.Expression;
import org.opensearch.sql.expression.FunctionExpression;
import org.opensearch.sql.expression.LiteralExpression;
import org.opensearch.sql.expression.NamedArgumentExpression;
import org.opensearch.sql.expression.NamedExpression;
import org.opensearch.sql.expression.ParseExpression;
import org.opensearch.sql.expression.ReferenceExpression;
import org.opensearch.sql.expression.aggregation.Aggregator;
import org.opensearch.sql.expression.aggregation.NamedAggregator;
import org.opensearch.sql.expression.conditional.cases.CaseClause;
import org.opensearch.sql.expression.conditional.cases.WhenClause;
import org.opensearch.sql.expression.function.BuiltinFunctionName;
import org.opensearch.sql.expression.function.BuiltinFunctionRepository;
import org.opensearch.sql.expression.span.SpanExpression;
import org.opensearch.sql.expression.window.ranking.RankingWindowFunction;

public class DSL {
    private final BuiltinFunctionRepository repository;

    public static LiteralExpression literal(Byte value) {
        return new LiteralExpression(ExprValueUtils.byteValue(value));
    }

    public static LiteralExpression literal(Short value) {
        return new LiteralExpression(new ExprShortValue(value));
    }

    public static LiteralExpression literal(Integer value) {
        return new LiteralExpression(ExprValueUtils.integerValue(value));
    }

    public static LiteralExpression literal(Long value) {
        return new LiteralExpression(ExprValueUtils.longValue(value));
    }

    public static LiteralExpression literal(Float value) {
        return new LiteralExpression(ExprValueUtils.floatValue(value));
    }

    public static LiteralExpression literal(Double value) {
        return new LiteralExpression(ExprValueUtils.doubleValue(value));
    }

    public static LiteralExpression literal(String value) {
        return new LiteralExpression(ExprValueUtils.stringValue(value));
    }

    public static LiteralExpression literal(Boolean value) {
        return new LiteralExpression(ExprValueUtils.booleanValue(value));
    }

    public static LiteralExpression literal(ExprValue value) {
        return new LiteralExpression(value);
    }

    public static LiteralExpression literal(Number value) {
        if (value instanceof Integer) {
            return new LiteralExpression(ExprValueUtils.integerValue(value.intValue()));
        }
        if (value instanceof Long) {
            return new LiteralExpression(ExprValueUtils.longValue(value.longValue()));
        }
        if (value instanceof Float) {
            return new LiteralExpression(ExprValueUtils.floatValue(Float.valueOf(value.floatValue())));
        }
        return new LiteralExpression(ExprValueUtils.doubleValue(value.doubleValue()));
    }

    public static ReferenceExpression ref(String ref, ExprType type) {
        return new ReferenceExpression(ref, type);
    }

    public static NamedExpression named(Expression expression) {
        if (expression instanceof NamedExpression) {
            return (NamedExpression)expression;
        }
        if (expression instanceof ParseExpression) {
            return DSL.named(((ParseExpression)expression).getIdentifier().valueOf(null).stringValue(), expression);
        }
        return DSL.named(expression.toString(), expression);
    }

    public static NamedExpression named(String name, Expression expression) {
        return new NamedExpression(name, expression);
    }

    public static NamedExpression named(String name, Expression expression, String alias) {
        return new NamedExpression(name, expression, alias);
    }

    public static NamedAggregator named(String name, Aggregator aggregator) {
        return new NamedAggregator(name, aggregator);
    }

    public NamedArgumentExpression namedArgument(String argName, Expression value) {
        return new NamedArgumentExpression(argName, value);
    }

    public static ParseExpression parsed(Expression expression, Expression pattern, Expression identifier) {
        return new ParseExpression(expression, pattern, identifier);
    }

    public static SpanExpression span(Expression field, Expression value, String unit) {
        return new SpanExpression(field, value, SpanUnit.of(unit));
    }

    public FunctionExpression abs(Expression ... expressions) {
        return this.function(BuiltinFunctionName.ABS, expressions);
    }

    public FunctionExpression ceil(Expression ... expressions) {
        return this.function(BuiltinFunctionName.CEIL, expressions);
    }

    public FunctionExpression ceiling(Expression ... expressions) {
        return this.function(BuiltinFunctionName.CEILING, expressions);
    }

    public FunctionExpression conv(Expression ... expressions) {
        return this.function(BuiltinFunctionName.CONV, expressions);
    }

    public FunctionExpression crc32(Expression ... expressions) {
        return this.function(BuiltinFunctionName.CRC32, expressions);
    }

    public FunctionExpression euler(Expression ... expressions) {
        return this.function(BuiltinFunctionName.E, expressions);
    }

    public FunctionExpression exp(Expression ... expressions) {
        return this.function(BuiltinFunctionName.EXP, expressions);
    }

    public FunctionExpression floor(Expression ... expressions) {
        return this.function(BuiltinFunctionName.FLOOR, expressions);
    }

    public FunctionExpression ln(Expression ... expressions) {
        return this.function(BuiltinFunctionName.LN, expressions);
    }

    public FunctionExpression log(Expression ... expressions) {
        return this.function(BuiltinFunctionName.LOG, expressions);
    }

    public FunctionExpression log10(Expression ... expressions) {
        return this.function(BuiltinFunctionName.LOG10, expressions);
    }

    public FunctionExpression log2(Expression ... expressions) {
        return this.function(BuiltinFunctionName.LOG2, expressions);
    }

    public FunctionExpression mod(Expression ... expressions) {
        return this.function(BuiltinFunctionName.MOD, expressions);
    }

    public FunctionExpression pi(Expression ... expressions) {
        return this.function(BuiltinFunctionName.PI, expressions);
    }

    public FunctionExpression pow(Expression ... expressions) {
        return this.function(BuiltinFunctionName.POW, expressions);
    }

    public FunctionExpression power(Expression ... expressions) {
        return this.function(BuiltinFunctionName.POWER, expressions);
    }

    public FunctionExpression rand(Expression ... expressions) {
        return this.function(BuiltinFunctionName.RAND, expressions);
    }

    public FunctionExpression round(Expression ... expressions) {
        return this.function(BuiltinFunctionName.ROUND, expressions);
    }

    public FunctionExpression sign(Expression ... expressions) {
        return this.function(BuiltinFunctionName.SIGN, expressions);
    }

    public FunctionExpression sqrt(Expression ... expressions) {
        return this.function(BuiltinFunctionName.SQRT, expressions);
    }

    public FunctionExpression truncate(Expression ... expressions) {
        return this.function(BuiltinFunctionName.TRUNCATE, expressions);
    }

    public FunctionExpression acos(Expression ... expressions) {
        return this.function(BuiltinFunctionName.ACOS, expressions);
    }

    public FunctionExpression asin(Expression ... expressions) {
        return this.function(BuiltinFunctionName.ASIN, expressions);
    }

    public FunctionExpression atan(Expression ... expressions) {
        return this.function(BuiltinFunctionName.ATAN, expressions);
    }

    public FunctionExpression atan2(Expression ... expressions) {
        return this.function(BuiltinFunctionName.ATAN2, expressions);
    }

    public FunctionExpression cos(Expression ... expressions) {
        return this.function(BuiltinFunctionName.COS, expressions);
    }

    public FunctionExpression cot(Expression ... expressions) {
        return this.function(BuiltinFunctionName.COT, expressions);
    }

    public FunctionExpression degrees(Expression ... expressions) {
        return this.function(BuiltinFunctionName.DEGREES, expressions);
    }

    public FunctionExpression radians(Expression ... expressions) {
        return this.function(BuiltinFunctionName.RADIANS, expressions);
    }

    public FunctionExpression sin(Expression ... expressions) {
        return this.function(BuiltinFunctionName.SIN, expressions);
    }

    public FunctionExpression tan(Expression ... expressions) {
        return this.function(BuiltinFunctionName.TAN, expressions);
    }

    public FunctionExpression add(Expression ... expressions) {
        return this.function(BuiltinFunctionName.ADD, expressions);
    }

    public FunctionExpression subtract(Expression ... expressions) {
        return this.function(BuiltinFunctionName.SUBTRACT, expressions);
    }

    public FunctionExpression multiply(Expression ... expressions) {
        return this.function(BuiltinFunctionName.MULTIPLY, expressions);
    }

    public FunctionExpression adddate(Expression ... expressions) {
        return this.function(BuiltinFunctionName.ADDDATE, expressions);
    }

    public FunctionExpression date(Expression ... expressions) {
        return this.function(BuiltinFunctionName.DATE, expressions);
    }

    public FunctionExpression date_add(Expression ... expressions) {
        return this.function(BuiltinFunctionName.DATE_ADD, expressions);
    }

    public FunctionExpression date_sub(Expression ... expressions) {
        return this.function(BuiltinFunctionName.DATE_SUB, expressions);
    }

    public FunctionExpression day(Expression ... expressions) {
        return this.function(BuiltinFunctionName.DAY, expressions);
    }

    public FunctionExpression dayname(Expression ... expressions) {
        return this.function(BuiltinFunctionName.DAYNAME, expressions);
    }

    public FunctionExpression dayofmonth(Expression ... expressions) {
        return this.function(BuiltinFunctionName.DAYOFMONTH, expressions);
    }

    public FunctionExpression dayofweek(Expression ... expressions) {
        return this.function(BuiltinFunctionName.DAYOFWEEK, expressions);
    }

    public FunctionExpression dayofyear(Expression ... expressions) {
        return this.function(BuiltinFunctionName.DAYOFYEAR, expressions);
    }

    public FunctionExpression from_days(Expression ... expressions) {
        return this.function(BuiltinFunctionName.FROM_DAYS, expressions);
    }

    public FunctionExpression hour(Expression ... expressions) {
        return this.function(BuiltinFunctionName.HOUR, expressions);
    }

    public FunctionExpression microsecond(Expression ... expressions) {
        return this.function(BuiltinFunctionName.MICROSECOND, expressions);
    }

    public FunctionExpression minute(Expression ... expressions) {
        return this.function(BuiltinFunctionName.MINUTE, expressions);
    }

    public FunctionExpression month(Expression ... expressions) {
        return this.function(BuiltinFunctionName.MONTH, expressions);
    }

    public FunctionExpression monthname(Expression ... expressions) {
        return this.function(BuiltinFunctionName.MONTHNAME, expressions);
    }

    public FunctionExpression quarter(Expression ... expressions) {
        return this.function(BuiltinFunctionName.QUARTER, expressions);
    }

    public FunctionExpression second(Expression ... expressions) {
        return this.function(BuiltinFunctionName.SECOND, expressions);
    }

    public FunctionExpression subdate(Expression ... expressions) {
        return this.function(BuiltinFunctionName.SUBDATE, expressions);
    }

    public FunctionExpression time(Expression ... expressions) {
        return this.function(BuiltinFunctionName.TIME, expressions);
    }

    public FunctionExpression time_to_sec(Expression ... expressions) {
        return this.function(BuiltinFunctionName.TIME_TO_SEC, expressions);
    }

    public FunctionExpression timestamp(Expression ... expressions) {
        return this.function(BuiltinFunctionName.TIMESTAMP, expressions);
    }

    public FunctionExpression date_format(Expression ... expressions) {
        return this.function(BuiltinFunctionName.DATE_FORMAT, expressions);
    }

    public FunctionExpression to_days(Expression ... expressions) {
        return this.function(BuiltinFunctionName.TO_DAYS, expressions);
    }

    public FunctionExpression week(Expression ... expressions) {
        return this.function(BuiltinFunctionName.WEEK, expressions);
    }

    public FunctionExpression year(Expression ... expressions) {
        return this.function(BuiltinFunctionName.YEAR, expressions);
    }

    public FunctionExpression divide(Expression ... expressions) {
        return this.function(BuiltinFunctionName.DIVIDE, expressions);
    }

    public FunctionExpression module(Expression ... expressions) {
        return this.function(BuiltinFunctionName.MODULES, expressions);
    }

    public FunctionExpression substr(Expression ... expressions) {
        return this.function(BuiltinFunctionName.SUBSTR, expressions);
    }

    public FunctionExpression substring(Expression ... expressions) {
        return this.function(BuiltinFunctionName.SUBSTR, expressions);
    }

    public FunctionExpression ltrim(Expression ... expressions) {
        return this.function(BuiltinFunctionName.LTRIM, expressions);
    }

    public FunctionExpression rtrim(Expression ... expressions) {
        return this.function(BuiltinFunctionName.RTRIM, expressions);
    }

    public FunctionExpression trim(Expression ... expressions) {
        return this.function(BuiltinFunctionName.TRIM, expressions);
    }

    public FunctionExpression upper(Expression ... expressions) {
        return this.function(BuiltinFunctionName.UPPER, expressions);
    }

    public FunctionExpression lower(Expression ... expressions) {
        return this.function(BuiltinFunctionName.LOWER, expressions);
    }

    public FunctionExpression regexp(Expression ... expressions) {
        return this.function(BuiltinFunctionName.REGEXP, expressions);
    }

    public FunctionExpression concat(Expression ... expressions) {
        return this.function(BuiltinFunctionName.CONCAT, expressions);
    }

    public FunctionExpression concat_ws(Expression ... expressions) {
        return this.function(BuiltinFunctionName.CONCAT_WS, expressions);
    }

    public FunctionExpression length(Expression ... expressions) {
        return this.function(BuiltinFunctionName.LENGTH, expressions);
    }

    public FunctionExpression strcmp(Expression ... expressions) {
        return this.function(BuiltinFunctionName.STRCMP, expressions);
    }

    public FunctionExpression right(Expression ... expressions) {
        return this.function(BuiltinFunctionName.RIGHT, expressions);
    }

    public FunctionExpression left(Expression ... expressions) {
        return this.function(BuiltinFunctionName.LEFT, expressions);
    }

    public FunctionExpression ascii(Expression ... expressions) {
        return this.function(BuiltinFunctionName.ASCII, expressions);
    }

    public FunctionExpression locate(Expression ... expressions) {
        return this.function(BuiltinFunctionName.LOCATE, expressions);
    }

    public FunctionExpression replace(Expression ... expressions) {
        return this.function(BuiltinFunctionName.REPLACE, expressions);
    }

    public FunctionExpression and(Expression ... expressions) {
        return this.function(BuiltinFunctionName.AND, expressions);
    }

    public FunctionExpression or(Expression ... expressions) {
        return this.function(BuiltinFunctionName.OR, expressions);
    }

    public FunctionExpression xor(Expression ... expressions) {
        return this.function(BuiltinFunctionName.XOR, expressions);
    }

    public FunctionExpression not(Expression ... expressions) {
        return this.function(BuiltinFunctionName.NOT, expressions);
    }

    public FunctionExpression equal(Expression ... expressions) {
        return this.function(BuiltinFunctionName.EQUAL, expressions);
    }

    public FunctionExpression notequal(Expression ... expressions) {
        return this.function(BuiltinFunctionName.NOTEQUAL, expressions);
    }

    public FunctionExpression less(Expression ... expressions) {
        return this.function(BuiltinFunctionName.LESS, expressions);
    }

    public FunctionExpression lte(Expression ... expressions) {
        return this.function(BuiltinFunctionName.LTE, expressions);
    }

    public FunctionExpression greater(Expression ... expressions) {
        return this.function(BuiltinFunctionName.GREATER, expressions);
    }

    public FunctionExpression gte(Expression ... expressions) {
        return this.function(BuiltinFunctionName.GTE, expressions);
    }

    public FunctionExpression like(Expression ... expressions) {
        return this.function(BuiltinFunctionName.LIKE, expressions);
    }

    public FunctionExpression notLike(Expression ... expressions) {
        return this.function(BuiltinFunctionName.NOT_LIKE, expressions);
    }

    public Aggregator avg(Expression ... expressions) {
        return this.aggregate(BuiltinFunctionName.AVG, expressions);
    }

    public Aggregator sum(Expression ... expressions) {
        return this.aggregate(BuiltinFunctionName.SUM, expressions);
    }

    public Aggregator count(Expression ... expressions) {
        return this.aggregate(BuiltinFunctionName.COUNT, expressions);
    }

    public Aggregator distinctCount(Expression ... expressions) {
        return this.count(expressions).distinct(true);
    }

    public Aggregator varSamp(Expression ... expressions) {
        return this.aggregate(BuiltinFunctionName.VARSAMP, expressions);
    }

    public Aggregator varPop(Expression ... expressions) {
        return this.aggregate(BuiltinFunctionName.VARPOP, expressions);
    }

    public Aggregator stddevSamp(Expression ... expressions) {
        return this.aggregate(BuiltinFunctionName.STDDEV_SAMP, expressions);
    }

    public Aggregator stddevPop(Expression ... expressions) {
        return this.aggregate(BuiltinFunctionName.STDDEV_POP, expressions);
    }

    public RankingWindowFunction rowNumber() {
        return (RankingWindowFunction)this.repository.compile(BuiltinFunctionName.ROW_NUMBER.getName(), Collections.emptyList());
    }

    public RankingWindowFunction rank() {
        return (RankingWindowFunction)this.repository.compile(BuiltinFunctionName.RANK.getName(), Collections.emptyList());
    }

    public RankingWindowFunction denseRank() {
        return (RankingWindowFunction)this.repository.compile(BuiltinFunctionName.DENSE_RANK.getName(), Collections.emptyList());
    }

    public Aggregator min(Expression ... expressions) {
        return this.aggregate(BuiltinFunctionName.MIN, expressions);
    }

    public Aggregator max(Expression ... expressions) {
        return this.aggregate(BuiltinFunctionName.MAX, expressions);
    }

    private FunctionExpression function(BuiltinFunctionName functionName, Expression ... expressions) {
        return (FunctionExpression)this.repository.compile(functionName.getName(), Arrays.asList(expressions));
    }

    private Aggregator aggregate(BuiltinFunctionName functionName, Expression ... expressions) {
        return (Aggregator)this.repository.compile(functionName.getName(), Arrays.asList(expressions));
    }

    public FunctionExpression isnull(Expression ... expressions) {
        return this.function(BuiltinFunctionName.ISNULL, expressions);
    }

    public FunctionExpression is_null(Expression ... expressions) {
        return this.function(BuiltinFunctionName.IS_NULL, expressions);
    }

    public FunctionExpression isnotnull(Expression ... expressions) {
        return this.function(BuiltinFunctionName.IS_NOT_NULL, expressions);
    }

    public FunctionExpression ifnull(Expression ... expressions) {
        return this.function(BuiltinFunctionName.IFNULL, expressions);
    }

    public FunctionExpression nullif(Expression ... expressions) {
        return this.function(BuiltinFunctionName.NULLIF, expressions);
    }

    public FunctionExpression iffunction(Expression ... expressions) {
        return this.function(BuiltinFunctionName.IF, expressions);
    }

    public static Expression cases(Expression defaultResult, WhenClause ... whenClauses) {
        return new CaseClause(Arrays.asList(whenClauses), defaultResult);
    }

    public static WhenClause when(Expression condition, Expression result) {
        return new WhenClause(condition, result);
    }

    public FunctionExpression interval(Expression value, Expression unit) {
        return (FunctionExpression)this.repository.compile(BuiltinFunctionName.INTERVAL.getName(), Arrays.asList(value, unit));
    }

    public FunctionExpression castString(Expression value) {
        return (FunctionExpression)this.repository.compile(BuiltinFunctionName.CAST_TO_STRING.getName(), Arrays.asList(value));
    }

    public FunctionExpression castByte(Expression value) {
        return (FunctionExpression)this.repository.compile(BuiltinFunctionName.CAST_TO_BYTE.getName(), Arrays.asList(value));
    }

    public FunctionExpression castShort(Expression value) {
        return (FunctionExpression)this.repository.compile(BuiltinFunctionName.CAST_TO_SHORT.getName(), Arrays.asList(value));
    }

    public FunctionExpression castInt(Expression value) {
        return (FunctionExpression)this.repository.compile(BuiltinFunctionName.CAST_TO_INT.getName(), Arrays.asList(value));
    }

    public FunctionExpression castLong(Expression value) {
        return (FunctionExpression)this.repository.compile(BuiltinFunctionName.CAST_TO_LONG.getName(), Arrays.asList(value));
    }

    public FunctionExpression castFloat(Expression value) {
        return (FunctionExpression)this.repository.compile(BuiltinFunctionName.CAST_TO_FLOAT.getName(), Arrays.asList(value));
    }

    public FunctionExpression castDouble(Expression value) {
        return (FunctionExpression)this.repository.compile(BuiltinFunctionName.CAST_TO_DOUBLE.getName(), Arrays.asList(value));
    }

    public FunctionExpression castBoolean(Expression value) {
        return (FunctionExpression)this.repository.compile(BuiltinFunctionName.CAST_TO_BOOLEAN.getName(), Arrays.asList(value));
    }

    public FunctionExpression castDate(Expression value) {
        return (FunctionExpression)this.repository.compile(BuiltinFunctionName.CAST_TO_DATE.getName(), Arrays.asList(value));
    }

    public FunctionExpression castTime(Expression value) {
        return (FunctionExpression)this.repository.compile(BuiltinFunctionName.CAST_TO_TIME.getName(), Arrays.asList(value));
    }

    public FunctionExpression castTimestamp(Expression value) {
        return (FunctionExpression)this.repository.compile(BuiltinFunctionName.CAST_TO_TIMESTAMP.getName(), Arrays.asList(value));
    }

    public FunctionExpression castDatetime(Expression value) {
        return (FunctionExpression)this.repository.compile(BuiltinFunctionName.CAST_TO_DATETIME.getName(), Arrays.asList(value));
    }

    public FunctionExpression match(Expression ... args) {
        return (FunctionExpression)this.repository.compile(BuiltinFunctionName.MATCH.getName(), Arrays.asList((Expression[])args.clone()));
    }

    @Generated
    public DSL(BuiltinFunctionRepository repository) {
        this.repository = repository;
    }
}

