/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.data.model;

import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.util.Objects;
import lombok.Generated;
import org.opensearch.sql.data.model.AbstractExprValue;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.exception.SemanticCheckException;

public class ExprTimeValue
extends AbstractExprValue {
    private final LocalTime time;
    private static final DateTimeFormatter FORMATTER_VARIABLE_NANOS = new DateTimeFormatterBuilder().appendPattern("HH:mm:ss").appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true).toFormatter();
    private static final int MIN_FRACTION_SECONDS = 0;
    private static final int MAX_FRACTION_SECONDS = 9;

    public ExprTimeValue(String time) {
        try {
            this.time = LocalTime.parse(time, FORMATTER_VARIABLE_NANOS);
        }
        catch (DateTimeParseException e) {
            throw new SemanticCheckException(String.format("time:%s in unsupported format, please use HH:mm:ss[.SSSSSSSSS]", time));
        }
    }

    @Override
    public String value() {
        return DateTimeFormatter.ISO_LOCAL_TIME.format(this.time);
    }

    @Override
    public ExprType type() {
        return ExprCoreType.TIME;
    }

    @Override
    public LocalTime timeValue() {
        return this.time;
    }

    public String toString() {
        return String.format("TIME '%s'", this.value());
    }

    @Override
    public int compare(ExprValue other) {
        return this.time.compareTo(other.timeValue());
    }

    @Override
    public boolean equal(ExprValue other) {
        return this.time.equals(other.timeValue());
    }

    public int hashCode() {
        return Objects.hashCode(this.time);
    }

    @Generated
    public ExprTimeValue(LocalTime time) {
        this.time = time;
    }
}

