/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.data.model;

import com.google.common.base.Objects;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import lombok.Generated;
import org.opensearch.sql.data.model.AbstractExprValue;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.exception.SemanticCheckException;

public class ExprDatetimeValue
extends AbstractExprValue {
    private final LocalDateTime datetime;
    private static final DateTimeFormatter FORMATTER_VARIABLE_NANOS = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd HH:mm:ss").appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true).toFormatter();
    private static final int MIN_FRACTION_SECONDS = 0;
    private static final int MAX_FRACTION_SECONDS = 9;

    public ExprDatetimeValue(String datetime) {
        try {
            this.datetime = LocalDateTime.parse(datetime, FORMATTER_VARIABLE_NANOS);
        }
        catch (DateTimeParseException e) {
            throw new SemanticCheckException(String.format("datetime:%s in unsupported format, please use yyyy-MM-dd HH:mm:ss[.SSSSSSSSS]", datetime));
        }
    }

    @Override
    public LocalDateTime datetimeValue() {
        return this.datetime;
    }

    @Override
    public LocalDate dateValue() {
        return this.datetime.toLocalDate();
    }

    @Override
    public LocalTime timeValue() {
        return this.datetime.toLocalTime();
    }

    @Override
    public Instant timestampValue() {
        return ZonedDateTime.of(this.datetime, ZoneId.of("UTC")).toInstant();
    }

    @Override
    public int compare(ExprValue other) {
        return this.datetime.compareTo(other.datetimeValue());
    }

    @Override
    public boolean equal(ExprValue other) {
        return this.datetime.equals(other.datetimeValue());
    }

    @Override
    public String value() {
        return String.format("%s %s", DateTimeFormatter.ISO_DATE.format(this.datetime), DateTimeFormatter.ISO_TIME.format(this.datetime.getNano() == 0 ? this.datetime.truncatedTo(ChronoUnit.SECONDS) : this.datetime));
    }

    @Override
    public ExprType type() {
        return ExprCoreType.DATETIME;
    }

    public String toString() {
        return String.format("DATETIME '%s'", this.value());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.datetime});
    }

    @Generated
    public ExprDatetimeValue(LocalDateTime datetime) {
        this.datetime = datetime;
    }
}

