/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.data.model;

import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.opensearch.sql.data.model.AbstractExprValue;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.data.type.ExprType;

public class ExprCollectionValue
extends AbstractExprValue {
    private final List<ExprValue> valueList;

    @Override
    public Object value() {
        ArrayList<Object> results = new ArrayList<Object>();
        for (ExprValue exprValue : this.valueList) {
            results.add(exprValue.value());
        }
        return results;
    }

    @Override
    public ExprType type() {
        return ExprCoreType.ARRAY;
    }

    @Override
    public List<ExprValue> collectionValue() {
        return this.valueList;
    }

    public String toString() {
        return this.valueList.stream().map(Object::toString).collect(Collectors.joining(",", "[", "]"));
    }

    @Override
    public boolean equal(ExprValue o) {
        if (!(o instanceof ExprCollectionValue)) {
            return false;
        }
        ExprCollectionValue other = (ExprCollectionValue)o;
        Iterator<ExprValue> thisIterator = this.valueList.iterator();
        Iterator<ExprValue> otherIterator = other.valueList.iterator();
        while (thisIterator.hasNext() && otherIterator.hasNext()) {
            ExprValue otherEntry;
            ExprValue thisEntry = thisIterator.next();
            if (thisEntry.equals(otherEntry = otherIterator.next())) continue;
            return false;
        }
        return !thisIterator.hasNext() && !otherIterator.hasNext();
    }

    @Override
    public int compare(ExprValue other) {
        return Integer.compare(this.valueList.size(), other.collectionValue().size());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.valueList});
    }

    @Generated
    public ExprCollectionValue(List<ExprValue> valueList) {
        this.valueList = valueList;
    }
}

