/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import org.jooq.Context;
import org.jooq.Field;
import org.jooq.Name;
import org.jooq.Record;
import org.jooq.Schema;
import org.jooq.Table;
import org.jooq.impl.AbstractTable;
import org.jooq.impl.DSL;
import org.jooq.impl.Fields;
import org.jooq.impl.RecordImpl;
import org.jooq.impl.TableAlias;

final class Dual
extends AbstractTable<Record> {
    private static final long serialVersionUID = -7492790780048090156L;
    private static final Table<Record> FORCED_DUAL = DSL.select(new Field[]{DSL.inline("X").as("DUMMY")}).asTable("DUAL");
    static final String DUAL_HSQLDB = "select 1 as dual from information_schema.system_users limit 1";
    private final boolean force;

    Dual() {
        this(false);
    }

    Dual(boolean force) {
        super("dual", (Schema)null);
        this.force = force;
    }

    @Override
    public final Class<? extends Record> getRecordType() {
        return RecordImpl.class;
    }

    @Override
    public final Table<Record> as(Name alias) {
        if (this.force) {
            return FORCED_DUAL.as(alias);
        }
        return new TableAlias<Record>(this, alias);
    }

    @Override
    public final Table<Record> as(Name alias, Name ... fieldAliases) {
        if (this.force) {
            return FORCED_DUAL.as(alias, fieldAliases);
        }
        return new TableAlias<Record>(this, alias, fieldAliases);
    }

    @Override
    public boolean declaresTables() {
        return true;
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (this.force) {
            ctx.visit(FORCED_DUAL);
        } else {
            switch (ctx.family()) {
                case H2: 
                case POSTGRES: 
                case SQLITE: {
                    break;
                }
                case FIREBIRD: {
                    ctx.literal("RDB$DATABASE");
                    break;
                }
                case HSQLDB: {
                    ctx.sql('(').sql(DUAL_HSQLDB).sql(") as dual");
                    break;
                }
                case CUBRID: {
                    ctx.literal("db_root");
                    break;
                }
                case DERBY: {
                    ctx.literal("SYSIBM").sql('.').literal("SYSDUMMY1");
                    break;
                }
                default: {
                    ctx.sql("dual");
                }
            }
        }
    }

    @Override
    final Fields<Record> fields0() {
        return new Fields<Record>(new Field[0]);
    }
}

