/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.profile.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.ScoreMode;
import org.opensearch.search.profile.query.CollectorResult;
import org.opensearch.search.profile.query.InternalProfileComponent;
import org.opensearch.search.profile.query.ProfileCollector;

public class InternalProfileCollector
implements Collector,
InternalProfileComponent {
    private final String collectorName;
    private final String reason;
    private final ProfileCollector collector;
    private final List<? extends InternalProfileComponent> children;

    public InternalProfileCollector(Collector collector, String reason, List<? extends InternalProfileComponent> children) {
        this.collector = new ProfileCollector(collector);
        this.reason = reason;
        this.collectorName = this.deriveCollectorName(collector);
        this.children = children;
    }

    @Override
    public long getTime() {
        return this.collector.getTime();
    }

    @Override
    public String getReason() {
        return this.reason;
    }

    @Override
    public String getName() {
        return this.collectorName;
    }

    public Collector getCollector() {
        return this.collector.getDelegate();
    }

    private String deriveCollectorName(Collector c) {
        Object s = c.getClass().getSimpleName();
        if (((String)s).equals("")) {
            s = c.getClass().getEnclosingClass().getSimpleName();
        }
        if (this.reason.equals("aggregation") || this.reason.equals("aggregation_global")) {
            s = (String)s + ": [" + c.toString() + "]";
        }
        return s;
    }

    public LeafCollector getLeafCollector(LeafReaderContext context) throws IOException {
        return this.collector.getLeafCollector(context);
    }

    public ScoreMode scoreMode() {
        return this.collector.scoreMode();
    }

    @Override
    public Collection<? extends InternalProfileComponent> children() {
        return this.children;
    }

    @Override
    public CollectorResult getCollectorTree() {
        return InternalProfileCollector.doGetCollectorTree(this);
    }

    static CollectorResult doGetCollectorTree(InternalProfileComponent collector) {
        ArrayList<CollectorResult> childResults = new ArrayList<CollectorResult>(collector.children().size());
        for (InternalProfileComponent internalProfileComponent : collector.children()) {
            CollectorResult result = InternalProfileCollector.doGetCollectorTree(internalProfileComponent);
            childResults.add(result);
        }
        return new CollectorResult(collector.getName(), collector.getReason(), collector.getTime(), childResults);
    }
}

