/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest.action.admin.indices;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.opensearch.action.admin.indices.template.put.PutComposableIndexTemplateAction;
import org.opensearch.client.node.NodeClient;
import org.opensearch.cluster.metadata.ComposableIndexTemplate;
import org.opensearch.common.logging.DeprecationLogger;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;

public class RestPutComposableIndexTemplateAction
extends BaseRestHandler {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(RestPutComposableIndexTemplateAction.class);

    @Override
    public List<RestHandler.Route> routes() {
        return Arrays.asList(new RestHandler.Route(RestRequest.Method.POST, "/_index_template/{name}"), new RestHandler.Route(RestRequest.Method.PUT, "/_index_template/{name}"));
    }

    @Override
    public String getName() {
        return "put_composable_index_template_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        PutComposableIndexTemplateAction.Request putRequest = new PutComposableIndexTemplateAction.Request(request.param("name"));
        putRequest.masterNodeTimeout(request.paramAsTime("cluster_manager_timeout", putRequest.masterNodeTimeout()));
        RestPutComposableIndexTemplateAction.parseDeprecatedMasterTimeoutParameter(putRequest, request, deprecationLogger, this.getName());
        putRequest.create(request.paramAsBoolean("create", false));
        putRequest.cause(request.param("cause", "api"));
        putRequest.indexTemplate(ComposableIndexTemplate.parse(request.contentParser()));
        return channel -> client.execute(PutComposableIndexTemplateAction.INSTANCE, putRequest, new RestToXContentListener((RestChannel)channel));
    }
}

