/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest.action.admin.cluster;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.opensearch.action.admin.cluster.repositories.delete.DeleteRepositoryRequest;
import org.opensearch.action.support.master.AcknowledgedResponse;
import org.opensearch.client.Requests;
import org.opensearch.client.node.NodeClient;
import org.opensearch.common.logging.DeprecationLogger;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;

public class RestDeleteRepositoryAction
extends BaseRestHandler {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(RestDeleteRepositoryAction.class);

    @Override
    public List<RestHandler.Route> routes() {
        return Collections.singletonList(new RestHandler.Route(RestRequest.Method.DELETE, "/_snapshot/{repository}"));
    }

    @Override
    public String getName() {
        return "delete_repository_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        DeleteRepositoryRequest deleteRepositoryRequest = Requests.deleteRepositoryRequest(request.param("repository"));
        deleteRepositoryRequest.timeout(request.paramAsTime("timeout", deleteRepositoryRequest.timeout()));
        deleteRepositoryRequest.masterNodeTimeout(request.paramAsTime("cluster_manager_timeout", deleteRepositoryRequest.masterNodeTimeout()));
        RestDeleteRepositoryAction.parseDeprecatedMasterTimeoutParameter(deleteRepositoryRequest, request, deprecationLogger, this.getName());
        return channel -> client.admin().cluster().deleteRepository(deleteRepositoryRequest, new RestToXContentListener<AcknowledgedResponse>((RestChannel)channel));
    }
}

