/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.lucene;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreCachingWrappingScorer;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.SimpleCollector;

public class MinimumScoreCollector
extends SimpleCollector {
    private final Collector collector;
    private final float minimumScore;
    private Scorable scorer;
    private LeafCollector leafCollector;

    public MinimumScoreCollector(Collector collector, float minimumScore) {
        this.collector = collector;
        this.minimumScore = minimumScore;
    }

    public void setScorer(Scorable scorer) throws IOException {
        if (!(scorer instanceof ScoreCachingWrappingScorer)) {
            scorer = ScoreCachingWrappingScorer.wrap((Scorable)scorer);
        }
        this.scorer = scorer;
        this.leafCollector.setScorer(scorer);
    }

    public void collect(int doc) throws IOException {
        if (this.scorer.score() >= this.minimumScore) {
            this.leafCollector.collect(doc);
        }
    }

    public void doSetNextReader(LeafReaderContext context) throws IOException {
        this.leafCollector = this.collector.getLeafCollector(context);
    }

    public ScoreMode scoreMode() {
        return this.collector.scoreMode() == ScoreMode.TOP_SCORES ? ScoreMode.TOP_SCORES : ScoreMode.COMPLETE;
    }
}

