/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.indices.rollover;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.opensearch.action.admin.indices.create.CreateIndexClusterStateUpdateRequest;
import org.opensearch.action.admin.indices.create.CreateIndexRequest;
import org.opensearch.action.admin.indices.rollover.Condition;
import org.opensearch.action.admin.indices.rollover.RolloverInfo;
import org.opensearch.action.support.ActiveShardCount;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.metadata.AliasAction;
import org.opensearch.cluster.metadata.AliasMetadata;
import org.opensearch.cluster.metadata.DataStream;
import org.opensearch.cluster.metadata.IndexAbstraction;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.metadata.IndexTemplateMetadata;
import org.opensearch.cluster.metadata.Metadata;
import org.opensearch.cluster.metadata.MetadataCreateDataStreamService;
import org.opensearch.cluster.metadata.MetadataCreateIndexService;
import org.opensearch.cluster.metadata.MetadataIndexAliasesService;
import org.opensearch.cluster.metadata.MetadataIndexTemplateService;
import org.opensearch.common.Nullable;
import org.opensearch.common.Strings;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.threadpool.ThreadPool;

public class MetadataRolloverService {
    private static final Pattern INDEX_NAME_PATTERN = Pattern.compile("^.*-\\d+$");
    private static final List<IndexAbstraction.Type> VALID_ROLLOVER_TARGETS = org.opensearch.common.collect.List.of((Object)((Object)IndexAbstraction.Type.ALIAS), (Object)((Object)IndexAbstraction.Type.DATA_STREAM));
    private final ThreadPool threadPool;
    private final MetadataCreateIndexService createIndexService;
    private final MetadataIndexAliasesService indexAliasesService;
    private final IndexNameExpressionResolver indexNameExpressionResolver;

    @Inject
    public MetadataRolloverService(ThreadPool threadPool, MetadataCreateIndexService createIndexService, MetadataIndexAliasesService indexAliasesService, IndexNameExpressionResolver indexNameExpressionResolver) {
        this.threadPool = threadPool;
        this.createIndexService = createIndexService;
        this.indexAliasesService = indexAliasesService;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
    }

    public RolloverResult rolloverClusterState(ClusterState currentState, String rolloverTarget, String newIndexName, CreateIndexRequest createIndexRequest, List<Condition<?>> metConditions, boolean silent, boolean onlyValidate) throws Exception {
        MetadataRolloverService.validate(currentState.metadata(), rolloverTarget, newIndexName, createIndexRequest);
        IndexAbstraction indexAbstraction = (IndexAbstraction)currentState.metadata().getIndicesLookup().get(rolloverTarget);
        switch (indexAbstraction.getType()) {
            case ALIAS: {
                return this.rolloverAlias(currentState, (IndexAbstraction.Alias)indexAbstraction, rolloverTarget, newIndexName, createIndexRequest, metConditions, silent, onlyValidate);
            }
            case DATA_STREAM: {
                return this.rolloverDataStream(currentState, (IndexAbstraction.DataStream)indexAbstraction, rolloverTarget, createIndexRequest, metConditions, silent, onlyValidate);
            }
        }
        throw new IllegalStateException("unable to roll over type [" + indexAbstraction.getType().getDisplayName() + "]");
    }

    private RolloverResult rolloverAlias(ClusterState currentState, IndexAbstraction.Alias alias, String aliasName, String newIndexName, CreateIndexRequest createIndexRequest, List<Condition<?>> metConditions, boolean silent, boolean onlyValidate) throws Exception {
        Metadata metadata = currentState.metadata();
        IndexMetadata writeIndex = alias.getWriteIndex();
        AliasMetadata aliasMetadata = writeIndex.getAliases().get(alias.getName());
        String sourceProvidedName = writeIndex.getSettings().get("index.provided_name", writeIndex.getIndex().getName());
        String sourceIndexName = writeIndex.getIndex().getName();
        String unresolvedName = newIndexName != null ? newIndexName : MetadataRolloverService.generateRolloverIndexName(sourceProvidedName, this.indexNameExpressionResolver);
        String rolloverIndexName = this.indexNameExpressionResolver.resolveDateMathExpression(unresolvedName);
        boolean explicitWriteIndex = Boolean.TRUE.equals(aliasMetadata.writeIndex());
        Boolean isHidden = IndexMetadata.INDEX_HIDDEN_SETTING.exists(createIndexRequest.settings()) ? IndexMetadata.INDEX_HIDDEN_SETTING.get(createIndexRequest.settings()) : null;
        this.createIndexService.validateIndexName(rolloverIndexName, currentState);
        MetadataRolloverService.checkNoDuplicatedAliasInIndexTemplate(metadata, rolloverIndexName, aliasName, isHidden);
        if (onlyValidate) {
            return new RolloverResult(rolloverIndexName, sourceIndexName, currentState);
        }
        CreateIndexClusterStateUpdateRequest createIndexClusterStateRequest = MetadataRolloverService.prepareCreateIndexRequest(unresolvedName, rolloverIndexName, createIndexRequest);
        ClusterState newState = this.createIndexService.applyCreateIndexRequest(currentState, createIndexClusterStateRequest, silent);
        newState = this.indexAliasesService.applyAliasActions(newState, MetadataRolloverService.rolloverAliasToNewIndex(sourceIndexName, rolloverIndexName, explicitWriteIndex, aliasMetadata.isHidden(), aliasName));
        RolloverInfo rolloverInfo = new RolloverInfo(aliasName, metConditions, this.threadPool.absoluteTimeInMillis());
        newState = ClusterState.builder(newState).metadata(Metadata.builder(newState.metadata()).put(IndexMetadata.builder(newState.metadata().index(sourceIndexName)).putRolloverInfo(rolloverInfo))).build();
        return new RolloverResult(rolloverIndexName, sourceIndexName, newState);
    }

    private RolloverResult rolloverDataStream(ClusterState currentState, IndexAbstraction.DataStream dataStream, String dataStreamName, CreateIndexRequest createIndexRequest, List<Condition<?>> metConditions, boolean silent, boolean onlyValidate) throws Exception {
        MetadataCreateDataStreamService.lookupTemplateForDataStream(dataStreamName, currentState.metadata());
        DataStream ds = dataStream.getDataStream();
        IndexMetadata originalWriteIndex = dataStream.getWriteIndex();
        String newWriteIndexName = DataStream.getDefaultBackingIndexName(ds.getName(), ds.getGeneration() + 1L);
        this.createIndexService.validateIndexName(newWriteIndexName, currentState);
        if (onlyValidate) {
            return new RolloverResult(newWriteIndexName, originalWriteIndex.getIndex().getName(), currentState);
        }
        CreateIndexClusterStateUpdateRequest createIndexClusterStateRequest = MetadataRolloverService.prepareDataStreamCreateIndexRequest(dataStreamName, newWriteIndexName, createIndexRequest);
        ClusterState newState = this.createIndexService.applyCreateIndexRequest(currentState, createIndexClusterStateRequest, silent, (builder, indexMetadata) -> builder.put(ds.rollover(indexMetadata.getIndex())));
        RolloverInfo rolloverInfo = new RolloverInfo(dataStreamName, metConditions, this.threadPool.absoluteTimeInMillis());
        newState = ClusterState.builder(newState).metadata(Metadata.builder(newState.metadata()).put(IndexMetadata.builder(newState.metadata().index(originalWriteIndex.getIndex())).putRolloverInfo(rolloverInfo))).build();
        return new RolloverResult(newWriteIndexName, originalWriteIndex.getIndex().getName(), newState);
    }

    static String generateRolloverIndexName(String sourceIndexName, IndexNameExpressionResolver indexNameExpressionResolver) {
        boolean isDateMath;
        String resolvedName = indexNameExpressionResolver.resolveDateMathExpression(sourceIndexName);
        boolean bl = isDateMath = !sourceIndexName.equals(resolvedName);
        if (INDEX_NAME_PATTERN.matcher(resolvedName).matches()) {
            int numberIndex = sourceIndexName.lastIndexOf("-");
            assert (numberIndex != -1) : "no separator '-' found";
            int counter = Integer.parseInt(sourceIndexName.substring(numberIndex + 1, isDateMath ? sourceIndexName.length() - 1 : sourceIndexName.length()));
            String newName = sourceIndexName.substring(0, numberIndex) + "-" + String.format(Locale.ROOT, "%06d", ++counter) + (isDateMath ? ">" : "");
            return newName;
        }
        throw new IllegalArgumentException("index name [" + sourceIndexName + "] does not match pattern '^.*-\\d+$'");
    }

    static CreateIndexClusterStateUpdateRequest prepareDataStreamCreateIndexRequest(String dataStreamName, String targetIndexName, CreateIndexRequest createIndexRequest) {
        Settings settings = Settings.builder().put("index.hidden", true).build();
        return MetadataRolloverService.prepareCreateIndexRequest(targetIndexName, targetIndexName, "rollover_data_stream", createIndexRequest, settings).dataStreamName(dataStreamName);
    }

    static CreateIndexClusterStateUpdateRequest prepareCreateIndexRequest(String providedIndexName, String targetIndexName, CreateIndexRequest createIndexRequest) {
        return MetadataRolloverService.prepareCreateIndexRequest(providedIndexName, targetIndexName, "rollover_index", createIndexRequest, null);
    }

    static CreateIndexClusterStateUpdateRequest prepareCreateIndexRequest(String providedIndexName, String targetIndexName, String cause, CreateIndexRequest createIndexRequest, Settings settings) {
        Settings.Builder b = Settings.builder().put(createIndexRequest.settings());
        if (settings != null) {
            b.put(settings);
        }
        return ((CreateIndexClusterStateUpdateRequest)((CreateIndexClusterStateUpdateRequest)new CreateIndexClusterStateUpdateRequest(cause, targetIndexName, providedIndexName).ackTimeout(createIndexRequest.timeout())).masterNodeTimeout(createIndexRequest.masterNodeTimeout())).settings(b.build()).aliases(createIndexRequest.aliases()).waitForActiveShards(ActiveShardCount.NONE).mappings(createIndexRequest.mappings());
    }

    static List<AliasAction> rolloverAliasToNewIndex(String oldIndex, String newIndex, boolean explicitWriteIndex, @Nullable Boolean isHidden, String alias) {
        if (explicitWriteIndex) {
            return Collections.unmodifiableList(Arrays.asList(new AliasAction.Add(newIndex, alias, null, null, null, true, isHidden), new AliasAction.Add(oldIndex, alias, null, null, null, false, isHidden)));
        }
        return Collections.unmodifiableList(Arrays.asList(new AliasAction.Add(newIndex, alias, null, null, null, null, isHidden), new AliasAction.Remove(oldIndex, alias, null)));
    }

    static void checkNoDuplicatedAliasInIndexTemplate(Metadata metadata, String rolloverIndexName, String rolloverRequestAlias, @Nullable Boolean isHidden) {
        List<IndexTemplateMetadata> matchedTemplates = MetadataIndexTemplateService.findV1Templates(metadata, rolloverIndexName, isHidden);
        for (IndexTemplateMetadata template : matchedTemplates) {
            if (!template.aliases().containsKey(rolloverRequestAlias)) continue;
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Rollover alias [%s] can point to multiple indices, found duplicated alias [%s] in index template [%s]", rolloverRequestAlias, template.aliases().keys(), template.name()));
        }
        String matchedV2Template = MetadataIndexTemplateService.findV2Template(metadata, rolloverIndexName, isHidden == null ? false : isHidden);
        if (matchedV2Template != null) {
            List<Map<String, AliasMetadata>> aliases = MetadataIndexTemplateService.resolveAliases(metadata, matchedV2Template);
            for (Map<String, AliasMetadata> aliasConfig : aliases) {
                if (!aliasConfig.containsKey(rolloverRequestAlias)) continue;
                throw new IllegalArgumentException(String.format(Locale.ROOT, "Rollover alias [%s] can point to multiple indices, found duplicated alias [%s] in index template [%s]", rolloverRequestAlias, aliasConfig.keySet(), matchedV2Template));
            }
        }
    }

    static void validate(Metadata metadata, String rolloverTarget, String newIndexName, CreateIndexRequest request) {
        IndexAbstraction indexAbstraction = (IndexAbstraction)metadata.getIndicesLookup().get(rolloverTarget);
        if (indexAbstraction == null) {
            throw new IllegalArgumentException("rollover target [" + rolloverTarget + "] does not exist");
        }
        if (!VALID_ROLLOVER_TARGETS.contains((Object)indexAbstraction.getType())) {
            throw new IllegalArgumentException("rollover target is a [" + indexAbstraction.getType().getDisplayName() + "] but one of [" + Strings.collectionToCommaDelimitedString(VALID_ROLLOVER_TARGETS.stream().map(IndexAbstraction.Type::getDisplayName).collect(Collectors.toList())) + "] was expected");
        }
        if (indexAbstraction.getWriteIndex() == null) {
            throw new IllegalArgumentException("rollover target [" + indexAbstraction.getName() + "] does not point to a write index");
        }
        if (indexAbstraction.getType() == IndexAbstraction.Type.DATA_STREAM) {
            if (!Strings.isNullOrEmpty(newIndexName)) {
                throw new IllegalArgumentException("new index name may not be specified when rolling over a data stream");
            }
            if (!request.settings().equals(Settings.EMPTY) || request.aliases().size() > 0 || !request.mappings().equals("{}")) {
                throw new IllegalArgumentException("aliases, mappings, and index settings may not be specified when rolling over a data stream");
            }
        }
    }

    public static class RolloverResult {
        public final String rolloverIndexName;
        public final String sourceIndexName;
        public final ClusterState clusterState;

        private RolloverResult(String rolloverIndexName, String sourceIndexName, ClusterState clusterState) {
            this.rolloverIndexName = rolloverIndexName;
            this.sourceIndexName = sourceIndexName;
            this.clusterState = clusterState;
        }
    }
}

