/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.cluster.state;

import java.io.IOException;
import java.util.Objects;
import org.opensearch.LegacyESVersion;
import org.opensearch.action.ActionResponse;
import org.opensearch.cluster.ClusterName;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.node.DiscoveryNodes;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.unit.ByteSizeValue;

public class ClusterStateResponse
extends ActionResponse {
    private ClusterName clusterName;
    private ClusterState clusterState;
    private boolean waitForTimedOut = false;

    public ClusterStateResponse(StreamInput in) throws IOException {
        super(in);
        this.clusterName = new ClusterName(in);
        this.clusterState = in.readOptionalWriteable(innerIn -> ClusterState.readFrom(innerIn, null));
        if (in.getVersion().before(LegacyESVersion.V_7_0_0)) {
            new ByteSizeValue(in);
        }
        this.waitForTimedOut = in.readBoolean();
    }

    public ClusterStateResponse(ClusterName clusterName, ClusterState clusterState, boolean waitForTimedOut) {
        this.clusterName = clusterName;
        this.clusterState = clusterState;
        this.waitForTimedOut = waitForTimedOut;
    }

    public ClusterState getState() {
        return this.clusterState;
    }

    public ClusterName getClusterName() {
        return this.clusterName;
    }

    public boolean isWaitForTimedOut() {
        return this.waitForTimedOut;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.clusterName.writeTo(out);
        out.writeOptionalWriteable(this.clusterState);
        if (out.getVersion().before(LegacyESVersion.V_7_0_0)) {
            ByteSizeValue.ZERO.writeTo(out);
        }
        out.writeBoolean(this.waitForTimedOut);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterStateResponse response = (ClusterStateResponse)o;
        return this.waitForTimedOut == response.waitForTimedOut && Objects.equals(this.clusterName, response.clusterName) && Objects.equals(ClusterStateResponse.getVersion(this.clusterState), ClusterStateResponse.getVersion(response.clusterState)) && Objects.equals(ClusterStateResponse.getMasterNodeId(this.clusterState), ClusterStateResponse.getMasterNodeId(response.clusterState));
    }

    public int hashCode() {
        return Objects.hash(this.clusterName, ClusterStateResponse.getVersion(this.clusterState), ClusterStateResponse.getMasterNodeId(this.clusterState), this.waitForTimedOut);
    }

    private static String getMasterNodeId(ClusterState clusterState) {
        if (clusterState == null) {
            return null;
        }
        DiscoveryNodes nodes = clusterState.getNodes();
        if (nodes != null) {
            return nodes.getMasterNodeId();
        }
        return null;
    }

    private static Long getVersion(ClusterState clusterState) {
        if (clusterState != null) {
            return clusterState.getVersion();
        }
        return null;
    }
}

