/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.cluster.snapshots.restore;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionListener;
import org.opensearch.action.admin.cluster.snapshots.restore.RestoreSnapshotResponse;
import org.opensearch.cluster.ClusterChangedEvent;
import org.opensearch.cluster.ClusterStateListener;
import org.opensearch.cluster.RestoreInProgress;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.collect.ImmutableOpenMap;
import org.opensearch.index.shard.ShardId;
import org.opensearch.snapshots.RestoreInfo;
import org.opensearch.snapshots.RestoreService;

public class RestoreClusterStateListener
implements ClusterStateListener {
    private static final Logger logger = LogManager.getLogger(RestoreClusterStateListener.class);
    private final ClusterService clusterService;
    private final String uuid;
    private final ActionListener<RestoreSnapshotResponse> listener;

    private RestoreClusterStateListener(ClusterService clusterService, RestoreService.RestoreCompletionResponse response, ActionListener<RestoreSnapshotResponse> listener) {
        this.clusterService = clusterService;
        this.uuid = response.getUuid();
        this.listener = listener;
    }

    @Override
    public void clusterChanged(ClusterChangedEvent changedEvent) {
        RestoreInProgress.Entry prevEntry = RestoreService.restoreInProgress(changedEvent.previousState(), this.uuid);
        RestoreInProgress.Entry newEntry = RestoreService.restoreInProgress(changedEvent.state(), this.uuid);
        if (prevEntry == null) {
            this.clusterService.removeListener(this);
            this.listener.onResponse(new RestoreSnapshotResponse((RestoreInfo)null));
        } else if (newEntry == null) {
            this.clusterService.removeListener(this);
            ImmutableOpenMap<ShardId, RestoreInProgress.ShardRestoreStatus> shards = prevEntry.shards();
            assert (prevEntry.state().completed()) : "expected completed snapshot state but was " + prevEntry.state();
            assert (RestoreService.completed(shards)) : "expected all restore entries to be completed";
            RestoreInfo ri = new RestoreInfo(prevEntry.snapshot().getSnapshotId().getName(), prevEntry.indices(), shards.size(), shards.size() - RestoreService.failedShards(shards));
            RestoreSnapshotResponse response = new RestoreSnapshotResponse(ri);
            logger.debug("restore of [{}] completed", (Object)prevEntry.snapshot().getSnapshotId());
            this.listener.onResponse(response);
        }
    }

    public static void createAndRegisterListener(ClusterService clusterService, RestoreService.RestoreCompletionResponse response, ActionListener<RestoreSnapshotResponse> listener) {
        clusterService.addListener(new RestoreClusterStateListener(clusterService, response, listener));
    }
}

