/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting.util;

import inet.ipaddr.IPAddressString;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.alerting.destination.message.BaseMessage;
import org.opensearch.alerting.model.AggregationResultBucket;
import org.opensearch.alerting.model.BucketLevelTriggerRunResult;
import org.opensearch.alerting.model.Monitor;
import org.opensearch.alerting.model.action.Action;
import org.opensearch.alerting.model.action.ActionExecutionPolicy;
import org.opensearch.alerting.model.destination.Destination;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0014\u0010\u0004\u001a\u0004\u0018\u00010\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a\n\u0010\t\u001a\u00020\u0003*\u00020\n\u001a\u0014\u0010\u000b\u001a\u00020\f*\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\f\u001a\u0018\u0010\u000e\u001a\u00020\u0001*\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\u0011\u001a\n\u0010\u0012\u001a\u00020\u0001*\u00020\b\u001a\u0018\u0010\u0013\u001a\u00020\u0001*\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00030\u0011\u00a8\u0006\u0016"}, d2={"isValidEmail", "", "email", "", "getActionExecutionPolicy", "Lorg/opensearch/alerting/model/action/ActionExecutionPolicy;", "Lorg/opensearch/alerting/model/action/Action;", "monitor", "Lorg/opensearch/alerting/model/Monitor;", "getBucketKeysHash", "Lorg/opensearch/alerting/model/AggregationResultBucket;", "getCombinedTriggerRunResult", "Lorg/opensearch/alerting/model/BucketLevelTriggerRunResult;", "prevTriggerRunResult", "isAllowed", "Lorg/opensearch/alerting/model/destination/Destination;", "allowList", "", "isBucketLevelMonitor", "isHostInDenylist", "Lorg/opensearch/alerting/destination/message/BaseMessage;", "networks", "opensearch-alerting"})
public final class AlertingUtilsKt {
    public static final boolean isValidEmail(@NotNull String email) {
        Intrinsics.checkNotNullParameter((Object)email, (String)"email");
        Regex validEmailPattern = new Regex("(?:[a-z0-9!#$%&'*+\\/=?^_`{|}~-]+(?:\\.[a-z0-9!#$%&'*+\\/=?^_`{|}~-]+)*|\"(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21\\x23-\\x5b\\x5d-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])*\")@(?:(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?|\\[(?:(?:(2(5[0-5]|[0-4][0-9])|1[0-9][0-9]|[1-9]?[0-9]))\\.){3}(?:(2(5[0-5]|[0-4][0-9])|1[0-9][0-9]|[1-9]?[0-9])|[a-z0-9-]*[a-z0-9]:(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21-\\x5a\\x53-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])+)\\])", RegexOption.IGNORE_CASE);
        return validEmailPattern.matches((CharSequence)email);
    }

    public static final boolean isAllowed(@NotNull Destination $this$isAllowed, @NotNull List<String> allowList) {
        Intrinsics.checkNotNullParameter((Object)$this$isAllowed, (String)"<this>");
        Intrinsics.checkNotNullParameter(allowList, (String)"allowList");
        return allowList.contains($this$isAllowed.getType().getValue());
    }

    public static final boolean isHostInDenylist(@NotNull BaseMessage $this$isHostInDenylist, @NotNull List<String> networks) {
        Intrinsics.checkNotNullParameter((Object)$this$isHostInDenylist, (String)"<this>");
        Intrinsics.checkNotNullParameter(networks, (String)"networks");
        if ($this$isHostInDenylist.getUrl() != null || $this$isHostInDenylist.getUri().getHost() != null) {
            IPAddressString ipStr = new IPAddressString($this$isHostInDenylist.getUri().getHost());
            for (String network : networks) {
                IPAddressString netStr = new IPAddressString(network);
                if (!netStr.contains(ipStr)) continue;
                return true;
            }
        }
        return false;
    }

    public static final boolean isBucketLevelMonitor(@NotNull Monitor $this$isBucketLevelMonitor) {
        Intrinsics.checkNotNullParameter((Object)$this$isBucketLevelMonitor, (String)"<this>");
        return $this$isBucketLevelMonitor.getMonitorType() == Monitor.MonitorType.BUCKET_LEVEL_MONITOR;
    }

    @NotNull
    public static final String getBucketKeysHash(@NotNull AggregationResultBucket $this$getBucketKeysHash) {
        Intrinsics.checkNotNullParameter((Object)$this$getBucketKeysHash, (String)"<this>");
        return CollectionsKt.joinToString$default((Iterable)$this$getBucketKeysHash.getBucketKeys(), (CharSequence)"#", null, null, (int)0, null, null, (int)62, null);
    }

    @Nullable
    public static final ActionExecutionPolicy getActionExecutionPolicy(@NotNull Action $this$getActionExecutionPolicy, @NotNull Monitor monitor) {
        Intrinsics.checkNotNullParameter((Object)$this$getActionExecutionPolicy, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)monitor, (String)"monitor");
        ActionExecutionPolicy actionExecutionPolicy = $this$getActionExecutionPolicy.getActionExecutionPolicy();
        return actionExecutionPolicy == null ? (AlertingUtilsKt.isBucketLevelMonitor(monitor) ? ActionExecutionPolicy.Companion.getDefaultConfigurationForBucketLevelMonitor() : (ActionExecutionPolicy)null) : actionExecutionPolicy;
    }

    @NotNull
    public static final BucketLevelTriggerRunResult getCombinedTriggerRunResult(@NotNull BucketLevelTriggerRunResult $this$getCombinedTriggerRunResult, @Nullable BucketLevelTriggerRunResult prevTriggerRunResult) {
        Intrinsics.checkNotNullParameter((Object)$this$getCombinedTriggerRunResult, (String)"<this>");
        if (prevTriggerRunResult == null) {
            return $this$getCombinedTriggerRunResult;
        }
        Map mergedAggregationResultBuckets = MapsKt.plus(prevTriggerRunResult.getAggregationResultBuckets(), $this$getCombinedTriggerRunResult.getAggregationResultBuckets());
        Map mergedActionResultsMap = MapsKt.toMutableMap((Map)MapsKt.plus(prevTriggerRunResult.getActionResultsMap(), $this$getCombinedTriggerRunResult.getActionResultsMap()));
        Exception exception = $this$getCombinedTriggerRunResult.getError();
        if (exception == null) {
            exception = prevTriggerRunResult.getError();
        }
        Exception error = exception;
        return BucketLevelTriggerRunResult.copy$default($this$getCombinedTriggerRunResult, null, error, mergedAggregationResultBuckets, mergedActionResultsMap, 1, null);
    }
}

