/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting.transport;

import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.lucene.search.TotalHits;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.OpenSearchSecurityException;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.ActionListener;
import org.opensearch.action.admin.indices.create.CreateIndexResponse;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.action.support.master.AcknowledgedResponse;
import org.opensearch.action.support.replication.ReplicationResponse;
import org.opensearch.alerting.action.IndexMonitorRequest;
import org.opensearch.alerting.action.IndexMonitorResponse;
import org.opensearch.alerting.core.ScheduledJobIndices;
import org.opensearch.alerting.core.model.Input;
import org.opensearch.alerting.core.model.ScheduledJob;
import org.opensearch.alerting.core.model.SearchInput;
import org.opensearch.alerting.model.Monitor;
import org.opensearch.alerting.model.Trigger;
import org.opensearch.alerting.model.action.Action;
import org.opensearch.alerting.settings.AlertingSettings;
import org.opensearch.alerting.settings.DestinationSettings;
import org.opensearch.alerting.transport.SecureTransportAction;
import org.opensearch.alerting.transport.TransportIndexMonitorActionKt;
import org.opensearch.alerting.util.AlertingException;
import org.opensearch.alerting.util.AnomalyDetectionUtilsKt;
import org.opensearch.alerting.util.IndexUtils;
import org.opensearch.client.Client;
import org.opensearch.client.IndicesAdminClient;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.bytes.BytesReference;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.xcontent.DeprecationHandler;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.NamedXContentRegistry;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.commons.authuser.User;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestStatus;
import org.opensearch.search.SearchHits;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u00020\u0004:\u0001;B?\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013J.\u00100\u001a\u0002012\u0006\u0010\u0007\u001a\u00020\b2\f\u00102\u001a\b\u0012\u0004\u0012\u00020\u0003032\u0006\u00104\u001a\u00020\u00022\b\u00105\u001a\u0004\u0018\u000106J.\u00107\u001a\u0002012\u0006\u0010\u0007\u001a\u00020\b2\f\u00102\u001a\b\u0012\u0004\u0012\u00020\u0003032\u0006\u00104\u001a\u00020\u00022\b\u00105\u001a\u0004\u0018\u000106J&\u00108\u001a\u0002012\u0006\u00109\u001a\u00020:2\u0006\u00104\u001a\u00020\u00022\f\u00102\u001a\b\u0012\u0004\u0012\u00020\u000303H\u0014R\"\u0010\u0014\u001a\u0016\u0012\u0004\u0012\u00020\u0016 \u0017*\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u00150\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR$\u0010\u001c\u001a\n \u0017*\u0004\u0018\u00010\u001d0\u001dX\u0096\u000e\u00a2\u0006\u0010\n\u0002\u0010\"\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u0016\u0010#\u001a\n \u0017*\u0004\u0018\u00010$0$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010%\u001a\n \u0017*\u0004\u0018\u00010$0$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010&\u001a\n \u0017*\u0004\u0018\u00010'0'X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010(R\u0016\u0010)\u001a\n \u0017*\u0004\u0018\u00010$0$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/\u00a8\u0006<"}, d2={"Lorg/opensearch/alerting/transport/TransportIndexMonitorAction;", "Lorg/opensearch/action/support/HandledTransportAction;", "Lorg/opensearch/alerting/action/IndexMonitorRequest;", "Lorg/opensearch/alerting/action/IndexMonitorResponse;", "Lorg/opensearch/alerting/transport/SecureTransportAction;", "transportService", "Lorg/opensearch/transport/TransportService;", "client", "Lorg/opensearch/client/Client;", "actionFilters", "Lorg/opensearch/action/support/ActionFilters;", "scheduledJobIndices", "Lorg/opensearch/alerting/core/ScheduledJobIndices;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "settings", "Lorg/opensearch/common/settings/Settings;", "xContentRegistry", "Lorg/opensearch/common/xcontent/NamedXContentRegistry;", "(Lorg/opensearch/transport/TransportService;Lorg/opensearch/client/Client;Lorg/opensearch/action/support/ActionFilters;Lorg/opensearch/alerting/core/ScheduledJobIndices;Lorg/opensearch/cluster/service/ClusterService;Lorg/opensearch/common/settings/Settings;Lorg/opensearch/common/xcontent/NamedXContentRegistry;)V", "allowList", "", "", "kotlin.jvm.PlatformType", "getClient", "()Lorg/opensearch/client/Client;", "getClusterService", "()Lorg/opensearch/cluster/service/ClusterService;", "filterByEnabled", "", "getFilterByEnabled", "()Ljava/lang/Boolean;", "setFilterByEnabled", "(Ljava/lang/Boolean;)V", "Ljava/lang/Boolean;", "indexTimeout", "Lorg/opensearch/common/unit/TimeValue;", "maxActionThrottle", "maxMonitors", "", "Ljava/lang/Integer;", "requestTimeout", "getScheduledJobIndices", "()Lorg/opensearch/alerting/core/ScheduledJobIndices;", "getSettings", "()Lorg/opensearch/common/settings/Settings;", "getXContentRegistry", "()Lorg/opensearch/common/xcontent/NamedXContentRegistry;", "checkAnomalyDetectorAndExecute", "", "actionListener", "Lorg/opensearch/action/ActionListener;", "request", "user", "Lorg/opensearch/commons/authuser/User;", "checkIndicesAndExecute", "doExecute", "task", "Lorg/opensearch/tasks/Task;", "IndexMonitorHandler", "opensearch-alerting"})
public final class TransportIndexMonitorAction
extends HandledTransportAction<IndexMonitorRequest, IndexMonitorResponse>
implements SecureTransportAction {
    @NotNull
    private final Client client;
    @NotNull
    private final ScheduledJobIndices scheduledJobIndices;
    @NotNull
    private final ClusterService clusterService;
    @NotNull
    private final Settings settings;
    @NotNull
    private final NamedXContentRegistry xContentRegistry;
    private volatile Integer maxMonitors;
    private volatile TimeValue requestTimeout;
    private volatile TimeValue indexTimeout;
    private volatile TimeValue maxActionThrottle;
    private volatile List<String> allowList;
    private volatile Boolean filterByEnabled;

    @Inject
    public TransportIndexMonitorAction(@NotNull TransportService transportService, @NotNull Client client, @NotNull ActionFilters actionFilters, @NotNull ScheduledJobIndices scheduledJobIndices, @NotNull ClusterService clusterService, @NotNull Settings settings, @NotNull NamedXContentRegistry xContentRegistry) {
        Intrinsics.checkNotNullParameter((Object)transportService, (String)"transportService");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)actionFilters, (String)"actionFilters");
        Intrinsics.checkNotNullParameter((Object)scheduledJobIndices, (String)"scheduledJobIndices");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)xContentRegistry, (String)"xContentRegistry");
        super("cluster:admin/opendistro/alerting/monitor/write", transportService, actionFilters, IndexMonitorRequest::new);
        this.client = client;
        this.scheduledJobIndices = scheduledJobIndices;
        this.clusterService = clusterService;
        this.settings = settings;
        this.xContentRegistry = xContentRegistry;
        this.maxMonitors = (Integer)AlertingSettings.Companion.getALERTING_MAX_MONITORS().get(this.settings);
        this.requestTimeout = (TimeValue)AlertingSettings.Companion.getREQUEST_TIMEOUT().get(this.settings);
        this.indexTimeout = (TimeValue)AlertingSettings.Companion.getINDEX_TIMEOUT().get(this.settings);
        this.maxActionThrottle = (TimeValue)AlertingSettings.Companion.getMAX_ACTION_THROTTLE_VALUE().get(this.settings);
        this.allowList = (List)DestinationSettings.Companion.getALLOW_LIST().get(this.settings);
        this.filterByEnabled = (Boolean)AlertingSettings.Companion.getFILTER_BY_BACKEND_ROLES().get(this.settings);
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(AlertingSettings.Companion.getALERTING_MAX_MONITORS(), arg_0 -> TransportIndexMonitorAction._init_$lambda-0(this, arg_0));
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(AlertingSettings.Companion.getREQUEST_TIMEOUT(), arg_0 -> TransportIndexMonitorAction._init_$lambda-1(this, arg_0));
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(AlertingSettings.Companion.getINDEX_TIMEOUT(), arg_0 -> TransportIndexMonitorAction._init_$lambda-2(this, arg_0));
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(AlertingSettings.Companion.getMAX_ACTION_THROTTLE_VALUE(), arg_0 -> TransportIndexMonitorAction._init_$lambda-3(this, arg_0));
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(DestinationSettings.Companion.getALLOW_LIST(), arg_0 -> TransportIndexMonitorAction._init_$lambda-4(this, arg_0));
        this.listenFilterBySettingChange(this.clusterService);
    }

    @NotNull
    public final Client getClient() {
        return this.client;
    }

    @NotNull
    public final ScheduledJobIndices getScheduledJobIndices() {
        return this.scheduledJobIndices;
    }

    @NotNull
    public final ClusterService getClusterService() {
        return this.clusterService;
    }

    @NotNull
    public final Settings getSettings() {
        return this.settings;
    }

    @NotNull
    public final NamedXContentRegistry getXContentRegistry() {
        return this.xContentRegistry;
    }

    public Boolean getFilterByEnabled() {
        return this.filterByEnabled;
    }

    public void setFilterByEnabled(Boolean bl) {
        this.filterByEnabled = bl;
    }

    protected void doExecute(@NotNull Task task, @NotNull IndexMonitorRequest request, @NotNull ActionListener<IndexMonitorResponse> actionListener) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        Intrinsics.checkNotNullParameter(actionListener, (String)"actionListener");
        User user = this.readUserFromThreadContext(this.client);
        if (!this.validateUserBackendRoles(user, actionListener)) {
            return;
        }
        if (!AnomalyDetectionUtilsKt.isADMonitor(request.getMonitor())) {
            this.checkIndicesAndExecute(this.client, actionListener, request, user);
        } else {
            this.checkAnomalyDetectorAndExecute(this.client, actionListener, request, user);
        }
    }

    public final void checkIndicesAndExecute(@NotNull Client client, @NotNull ActionListener<IndexMonitorResponse> actionListener, @NotNull IndexMonitorRequest request, @Nullable User user) {
        Iterator $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter(actionListener, (String)"actionListener");
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        List indices = new ArrayList();
        Iterable $this$filter$iv = request.getMonitor().getInputs();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv = iterator.next();
            Input it = (Input)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.name(), (Object)"search")) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List searchInputs = (List)destination$iv$iv;
        Iterable $this$forEach$iv = searchInputs;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Input it = (Input)element$iv;
            boolean bl = false;
            SearchInput searchInput = (SearchInput)it;
            indices.addAll(searchInput.getIndices());
        }
        Collection $this$toTypedArray$iv = indices;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        String[] stringArray2 = stringArray;
        SearchRequest searchRequest = new SearchRequest().indices(Arrays.copyOf(stringArray2, stringArray2.length)).source(SearchSourceBuilder.searchSource().size(1).query((QueryBuilder)QueryBuilders.matchAllQuery()));
        client.search(searchRequest, (ActionListener)new ActionListener<SearchResponse>(client, this, actionListener, request, user, (List<String>)indices){
            final /* synthetic */ Client $client;
            final /* synthetic */ TransportIndexMonitorAction this$0;
            final /* synthetic */ ActionListener<IndexMonitorResponse> $actionListener;
            final /* synthetic */ IndexMonitorRequest $request;
            final /* synthetic */ User $user;
            final /* synthetic */ List<String> $indices;
            {
                this.$client = $client;
                this.this$0 = $receiver;
                this.$actionListener = $actionListener;
                this.$request = $request;
                this.$user = $user;
                this.$indices = $indices;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onResponse(@NotNull SearchResponse searchResponse2) {
                Intrinsics.checkNotNullParameter((Object)searchResponse2, (String)"searchResponse");
                AutoCloseable autoCloseable = (AutoCloseable)this.$client.threadPool().getThreadContext().stashContext();
                TransportIndexMonitorAction transportIndexMonitorAction = this.this$0;
                Client client = this.$client;
                ActionListener<IndexMonitorResponse> actionListener = this.$actionListener;
                IndexMonitorRequest indexMonitorRequest = this.$request;
                User user = this.$user;
                Throwable throwable = null;
                try {
                    ThreadContext.StoredContext it = (ThreadContext.StoredContext)autoCloseable;
                    boolean bl = false;
                    transportIndexMonitorAction.new IndexMonitorHandler(client, actionListener, indexMonitorRequest, user).resolveUserAndStart();
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                }
            }

            public void onFailure(@NotNull Exception t) {
                Exception exception;
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                boolean bl = t instanceof OpenSearchSecurityException;
                if (bl) {
                    exception = (Exception)new OpenSearchStatusException("User doesn't have read permissions for one or more configured index " + this.$indices, RestStatus.FORBIDDEN, new Object[0]);
                } else if (!bl) {
                    exception = t;
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                this.$actionListener.onFailure((Exception)AlertingException.Companion.wrap(exception));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void checkAnomalyDetectorAndExecute(@NotNull Client client, @NotNull ActionListener<IndexMonitorResponse> actionListener, @NotNull IndexMonitorRequest request, @Nullable User user) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter(actionListener, (String)"actionListener");
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        AutoCloseable autoCloseable = (AutoCloseable)client.threadPool().getThreadContext().stashContext();
        Throwable throwable = null;
        try {
            ThreadContext.StoredContext it = (ThreadContext.StoredContext)autoCloseable;
            boolean bl = false;
            new IndexMonitorHandler(client, actionListener, request, user).resolveUserAndStartForAD();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    @Override
    public void listenFilterBySettingChange(@NotNull ClusterService clusterService) {
        SecureTransportAction.DefaultImpls.listenFilterBySettingChange(this, clusterService);
    }

    @Override
    @Nullable
    public User readUserFromThreadContext(@NotNull Client client) {
        return SecureTransportAction.DefaultImpls.readUserFromThreadContext(this, client);
    }

    @Override
    public boolean doFilterForUser(@Nullable User user) {
        return SecureTransportAction.DefaultImpls.doFilterForUser(this, user);
    }

    @Override
    public <T> boolean validateUserBackendRoles(@Nullable User user, @NotNull ActionListener<T> actionListener) {
        return SecureTransportAction.DefaultImpls.validateUserBackendRoles(this, user, actionListener);
    }

    @Override
    public <T> boolean checkUserPermissionsWithResource(@Nullable User requesterUser, @Nullable User resourceUser, @NotNull ActionListener<T> actionListener, @NotNull String resourceType, @NotNull String resourceId) {
        return SecureTransportAction.DefaultImpls.checkUserPermissionsWithResource(this, requesterUser, resourceUser, actionListener, resourceType, resourceId);
    }

    private static final void _init_$lambda-0(TransportIndexMonitorAction this$0, Integer it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.maxMonitors = it;
    }

    private static final void _init_$lambda-1(TransportIndexMonitorAction this$0, TimeValue it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.requestTimeout = it;
    }

    private static final void _init_$lambda-2(TransportIndexMonitorAction this$0, TimeValue it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.indexTimeout = it;
    }

    private static final void _init_$lambda-3(TransportIndexMonitorAction this$0, TimeValue it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.maxActionThrottle = it;
    }

    private static final void _init_$lambda-4(TransportIndexMonitorAction this$0, List it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.allowList = it;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u001aH\u0002J\b\u0010\u001b\u001a\u00020\u0011H\u0002J\u0006\u0010\u001c\u001a\u00020\u0011J\u0006\u0010\u001d\u001a\u00020\u0011J\u0006\u0010\u001e\u001a\u00020\u0011J\b\u0010\u001f\u001a\u00020\u0011H\u0002J \u0010 \u001a\u00020\u00112\u0006\u0010!\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/opensearch/alerting/transport/TransportIndexMonitorAction$IndexMonitorHandler;", "", "client", "Lorg/opensearch/client/Client;", "actionListener", "Lorg/opensearch/action/ActionListener;", "Lorg/opensearch/alerting/action/IndexMonitorResponse;", "request", "Lorg/opensearch/alerting/action/IndexMonitorRequest;", "user", "Lorg/opensearch/commons/authuser/User;", "(Lorg/opensearch/alerting/transport/TransportIndexMonitorAction;Lorg/opensearch/client/Client;Lorg/opensearch/action/ActionListener;Lorg/opensearch/alerting/action/IndexMonitorRequest;Lorg/opensearch/commons/authuser/User;)V", "checkShardsFailure", "", "response", "Lorg/opensearch/action/index/IndexResponse;", "indexMonitor", "", "onCreateMappingsResponse", "Lorg/opensearch/action/admin/indices/create/CreateIndexResponse;", "onGetResponse", "currentMonitor", "Lorg/opensearch/alerting/model/Monitor;", "onSearchResponse", "Lorg/opensearch/action/search/SearchResponse;", "onUpdateMappingsResponse", "Lorg/opensearch/action/support/master/AcknowledgedResponse;", "prepareMonitorIndexing", "resolveUserAndStart", "resolveUserAndStartForAD", "start", "updateMonitor", "validateActionThrottle", "monitor", "maxValue", "Lorg/opensearch/common/unit/TimeValue;", "minValue", "opensearch-alerting"})
    public final class IndexMonitorHandler {
        @NotNull
        private final Client client;
        @NotNull
        private final ActionListener<IndexMonitorResponse> actionListener;
        @NotNull
        private final IndexMonitorRequest request;
        @Nullable
        private final User user;

        public IndexMonitorHandler(@NotNull Client client, @NotNull ActionListener<IndexMonitorResponse> actionListener, @Nullable IndexMonitorRequest request, User user) {
            Intrinsics.checkNotNullParameter((Object)TransportIndexMonitorAction.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter(actionListener, (String)"actionListener");
            Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
            this.client = client;
            this.actionListener = actionListener;
            this.request = request;
            this.user = user;
        }

        public final void resolveUserAndStart() {
            if (this.user == null) {
                this.request.setMonitor(Monitor.copy$default(this.request.getMonitor(), null, 0L, null, false, null, null, null, null, new User("", CollectionsKt.emptyList(), CollectionsKt.emptyList(), CollectionsKt.emptyList()), 0, null, null, null, 7935, null));
                this.start();
            } else {
                this.request.setMonitor(Monitor.copy$default(this.request.getMonitor(), null, 0L, null, false, null, null, null, null, new User(this.user.getName(), this.user.getBackendRoles(), this.user.getRoles(), this.user.getCustomAttNames()), 0, null, null, null, 7935, null));
                this.start();
            }
        }

        public final void resolveUserAndStartForAD() {
            if (this.user == null) {
                this.request.setMonitor(Monitor.copy$default(this.request.getMonitor(), null, 0L, null, false, null, null, null, null, new User("", CollectionsKt.emptyList(), CollectionsKt.emptyList(), CollectionsKt.emptyList()), 0, null, null, null, 7935, null));
                this.start();
            } else {
                try {
                    this.request.setMonitor(Monitor.copy$default(this.request.getMonitor(), null, 0L, null, false, null, null, null, null, new User(this.user.getName(), this.user.getBackendRoles(), this.user.getRoles(), this.user.getCustomAttNames()), 0, null, null, null, 7935, null));
                    SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().size(0);
                    Intrinsics.checkNotNullExpressionValue((Object)searchSourceBuilder, (String)"searchSourceBuilder");
                    AnomalyDetectionUtilsKt.addUserBackendRolesFilter(this.user, searchSourceBuilder);
                    String[] stringArray = new String[]{".opendistro-anomaly-detectors"};
                    SearchRequest searchRequest = new SearchRequest().indices(stringArray).source(searchSourceBuilder);
                    this.client.search(searchRequest, (ActionListener)new ActionListener<SearchResponse>(this){
                        final /* synthetic */ IndexMonitorHandler this$0;
                        {
                            this.this$0 = $receiver;
                        }

                        public void onResponse(@Nullable SearchResponse response2) {
                            Long totalHits;
                            Long l;
                            SearchResponse searchResponse2 = response2;
                            if (searchResponse2 == null) {
                                l = null;
                            } else {
                                SearchHits searchHits = searchResponse2.getHits();
                                if (searchHits == null) {
                                    l = null;
                                } else {
                                    TotalHits totalHits2 = searchHits.getTotalHits();
                                    l = totalHits = totalHits2 == null ? null : Long.valueOf(totalHits2.value);
                                }
                            }
                            if (totalHits != null && totalHits > 0L) {
                                this.this$0.start();
                            } else {
                                IndexMonitorHandler.access$getActionListener$p(this.this$0).onFailure((Exception)AlertingException.Companion.wrap((Exception)new OpenSearchStatusException("User has no available detectors", RestStatus.NOT_FOUND, new Object[0])));
                            }
                        }

                        public void onFailure(@NotNull Exception t) {
                            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                            IndexMonitorHandler.access$getActionListener$p(this.this$0).onFailure((Exception)AlertingException.Companion.wrap(t));
                        }
                    });
                }
                catch (IOException ex) {
                    this.actionListener.onFailure((Exception)AlertingException.Companion.wrap(ex));
                }
            }
        }

        public final void start() {
            if (!TransportIndexMonitorAction.this.getScheduledJobIndices().scheduledJobIndexExists()) {
                TransportIndexMonitorAction.this.getScheduledJobIndices().initScheduledJobIndex((ActionListener)new ActionListener<CreateIndexResponse>(this){
                    final /* synthetic */ IndexMonitorHandler this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    public void onResponse(@NotNull CreateIndexResponse response2) {
                        Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                        IndexMonitorHandler.access$onCreateMappingsResponse(this.this$0, response2);
                    }

                    public void onFailure(@NotNull Exception t) {
                        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                        IndexMonitorHandler.access$getActionListener$p(this.this$0).onFailure((Exception)AlertingException.Companion.wrap(t));
                    }
                });
            } else if (!IndexUtils.Companion.getScheduledJobIndexUpdated()) {
                String string = ScheduledJobIndices.Companion.scheduledJobMappings();
                ClusterState clusterState = TransportIndexMonitorAction.this.getClusterService().state();
                Intrinsics.checkNotNullExpressionValue((Object)clusterState, (String)"clusterService.state()");
                ClusterState clusterState2 = clusterState;
                clusterState = this.client.admin().indices();
                Intrinsics.checkNotNullExpressionValue((Object)clusterState, (String)"client.admin().indices()");
                IndexUtils.Companion.updateIndexMapping(".opendistro-alerting-config", string, clusterState2, (IndicesAdminClient)clusterState, (ActionListener<AcknowledgedResponse>)((ActionListener)new ActionListener<AcknowledgedResponse>(this){
                    final /* synthetic */ IndexMonitorHandler this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    public void onResponse(@NotNull AcknowledgedResponse response2) {
                        Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                        IndexMonitorHandler.access$onUpdateMappingsResponse(this.this$0, response2);
                    }

                    public void onFailure(@NotNull Exception t) {
                        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                        IndexMonitorHandler.access$getActionListener$p(this.this$0).onFailure((Exception)AlertingException.Companion.wrap(t));
                    }
                }));
            } else {
                this.prepareMonitorIndexing();
            }
        }

        private final void prepareMonitorIndexing() {
            try {
                Monitor monitor = this.request.getMonitor();
                TimeValue timeValue = TransportIndexMonitorAction.this.maxActionThrottle;
                Intrinsics.checkNotNullExpressionValue((Object)timeValue, (String)"maxActionThrottle");
                TimeValue timeValue2 = timeValue;
                timeValue = TimeValue.timeValueMinutes((long)1L);
                Intrinsics.checkNotNullExpressionValue((Object)timeValue, (String)"timeValueMinutes(1)");
                this.validateActionThrottle(monitor, timeValue2, timeValue);
            }
            catch (RuntimeException e) {
                this.actionListener.onFailure((Exception)AlertingException.Companion.wrap(e));
                return;
            }
            if (this.request.getMethod() == RestRequest.Method.PUT) {
                this.updateMonitor();
                return;
            }
            BoolQueryBuilder query = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.termQuery((String)"monitor.type", (String)"monitor"));
            SearchSourceBuilder searchSource = new SearchSourceBuilder().query((QueryBuilder)query).timeout(TransportIndexMonitorAction.this.requestTimeout);
            String[] stringArray = new String[]{".opendistro-alerting-config"};
            SearchRequest searchRequest = new SearchRequest(stringArray).source(searchSource);
            this.client.search(searchRequest, (ActionListener)new ActionListener<SearchResponse>(this){
                final /* synthetic */ IndexMonitorHandler this$0;
                {
                    this.this$0 = $receiver;
                }

                public void onResponse(@NotNull SearchResponse searchResponse2) {
                    Intrinsics.checkNotNullParameter((Object)searchResponse2, (String)"searchResponse");
                    IndexMonitorHandler.access$onSearchResponse(this.this$0, searchResponse2);
                }

                public void onFailure(@NotNull Exception t) {
                    Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                    IndexMonitorHandler.access$getActionListener$p(this.this$0).onFailure((Exception)AlertingException.Companion.wrap(t));
                }
            });
        }

        private final void validateActionThrottle(Monitor monitor, TimeValue maxValue, TimeValue minValue) {
            Iterable $this$forEach$iv = monitor.getTriggers();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Trigger trigger = (Trigger)element$iv;
                boolean bl = false;
                Iterable $this$forEach$iv2 = trigger.getActions();
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    Action action = (Action)element$iv2;
                    boolean bl2 = false;
                    if (action.getThrottle() == null) continue;
                    if (!(new TimeValue(Duration.of(action.getThrottle().getValue(), action.getThrottle().getUnit()).toMillis()).compareTo(maxValue) <= 0)) {
                        boolean $i$a$-require-TransportIndexMonitorAction$IndexMonitorHandler$validateActionThrottle$1$1$32 = false;
                        String $i$a$-require-TransportIndexMonitorAction$IndexMonitorHandler$validateActionThrottle$1$1$32 = "Can only set throttle period less than or equal to " + maxValue;
                        throw new IllegalArgumentException($i$a$-require-TransportIndexMonitorAction$IndexMonitorHandler$validateActionThrottle$1$1$32.toString());
                    }
                    if (new TimeValue(Duration.of(action.getThrottle().getValue(), action.getThrottle().getUnit()).toMillis()).compareTo(minValue) >= 0) continue;
                    boolean bl3 = false;
                    String string = "Can only set throttle period greater than or equal to " + minValue;
                    throw new IllegalArgumentException(string.toString());
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        private final void onSearchResponse(SearchResponse response2) {
            Long totalHits;
            TotalHits totalHits2 = response2.getHits().getTotalHits();
            Long l = totalHits = totalHits2 == null ? null : Long.valueOf(totalHits2.value);
            if (totalHits != null) {
                Integer n = TransportIndexMonitorAction.this.maxMonitors;
                if (totalHits >= (n == null ? null : Long.valueOf(n.intValue()))) {
                    TransportIndexMonitorActionKt.access$getLog$p().error("This request would create more than the allowed monitors [" + TransportIndexMonitorAction.this.maxMonitors + "].");
                    this.actionListener.onFailure((Exception)AlertingException.Companion.wrap(new IllegalArgumentException("This request would create more than the allowed monitors [" + TransportIndexMonitorAction.this.maxMonitors + "].")));
                    return;
                }
            }
            this.indexMonitor();
        }

        private final void onCreateMappingsResponse(CreateIndexResponse response2) {
            if (response2.isAcknowledged()) {
                TransportIndexMonitorActionKt.access$getLog$p().info("Created .opendistro-alerting-config with mappings.");
                this.prepareMonitorIndexing();
                IndexUtils.Companion.scheduledJobIndexUpdated();
            } else {
                TransportIndexMonitorActionKt.access$getLog$p().error("Create .opendistro-alerting-config mappings call not acknowledged.");
                this.actionListener.onFailure((Exception)AlertingException.Companion.wrap((Exception)new OpenSearchStatusException("Create .opendistro-alerting-config mappings call not acknowledged", RestStatus.INTERNAL_SERVER_ERROR, new Object[0])));
            }
        }

        private final void onUpdateMappingsResponse(AcknowledgedResponse response2) {
            if (response2.isAcknowledged()) {
                TransportIndexMonitorActionKt.access$getLog$p().info("Updated  .opendistro-alerting-config with mappings.");
                IndexUtils.Companion.scheduledJobIndexUpdated();
                this.prepareMonitorIndexing();
            } else {
                TransportIndexMonitorActionKt.access$getLog$p().error("Update .opendistro-alerting-config mappings call not acknowledged.");
                this.actionListener.onFailure((Exception)AlertingException.Companion.wrap((Exception)new OpenSearchStatusException("Updated .opendistro-alerting-config mappings call not acknowledged.", RestStatus.INTERNAL_SERVER_ERROR, new Object[0])));
            }
        }

        private final void indexMonitor() {
            this.request.setMonitor(Monitor.copy$default(this.request.getMonitor(), null, 0L, null, false, null, null, null, null, null, IndexUtils.Companion.getScheduledJobIndexSchemaVersion(), null, null, null, 7679, null));
            IndexRequest indexRequest = (IndexRequest)new IndexRequest(".opendistro-alerting-config").setRefreshPolicy(this.request.getRefreshPolicy());
            Monitor monitor = this.request.getMonitor();
            XContentBuilder xContentBuilder = XContentFactory.jsonBuilder();
            Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"jsonBuilder()");
            IndexRequest indexRequest2 = (IndexRequest)indexRequest.source(monitor.toXContentWithUser(xContentBuilder, (ToXContent.Params)new ToXContent.MapParams(MapsKt.mapOf((Pair)TuplesKt.to((Object)"with_type", (Object)"true"))))).setIfSeqNo(this.request.getSeqNo()).setIfPrimaryTerm(this.request.getPrimaryTerm()).timeout(TransportIndexMonitorAction.this.indexTimeout);
            this.client.index(indexRequest2, (ActionListener)new ActionListener<IndexResponse>(this){
                final /* synthetic */ IndexMonitorHandler this$0;
                {
                    this.this$0 = $receiver;
                }

                public void onResponse(@NotNull IndexResponse response2) {
                    Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                    String failureReasons = IndexMonitorHandler.access$checkShardsFailure(this.this$0, response2);
                    if (failureReasons != null) {
                        IndexMonitorHandler.access$getActionListener$p(this.this$0).onFailure((Exception)AlertingException.Companion.wrap((Exception)new OpenSearchStatusException(failureReasons.toString(), response2.status(), new Object[0])));
                        return;
                    }
                    ActionListener actionListener = IndexMonitorHandler.access$getActionListener$p(this.this$0);
                    String string = response2.getId();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"response.id");
                    actionListener.onResponse((Object)((Object)new IndexMonitorResponse(string, response2.getVersion(), response2.getSeqNo(), response2.getPrimaryTerm(), RestStatus.CREATED, IndexMonitorHandler.access$getRequest$p(this.this$0).getMonitor())));
                }

                public void onFailure(@NotNull Exception t) {
                    Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                    IndexMonitorHandler.access$getActionListener$p(this.this$0).onFailure((Exception)AlertingException.Companion.wrap(t));
                }
            });
        }

        private final void updateMonitor() {
            GetRequest getRequest = new GetRequest(".opendistro-alerting-config", this.request.getMonitorId());
            this.client.get(getRequest, (ActionListener)new ActionListener<GetResponse>(this, TransportIndexMonitorAction.this){
                final /* synthetic */ IndexMonitorHandler this$0;
                final /* synthetic */ TransportIndexMonitorAction this$1;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                }

                public void onResponse(@NotNull GetResponse response2) {
                    Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                    if (!response2.isExists()) {
                        IndexMonitorHandler.access$getActionListener$p(this.this$0).onFailure((Exception)AlertingException.Companion.wrap((Exception)new OpenSearchStatusException("Monitor with " + IndexMonitorHandler.access$getRequest$p(this.this$0).getMonitorId() + " is not found", RestStatus.NOT_FOUND, new Object[0])));
                        return;
                    }
                    XContentParser xcp = XContentHelper.createParser((NamedXContentRegistry)this.this$1.getXContentRegistry(), (DeprecationHandler)((DeprecationHandler)LoggingDeprecationHandler.INSTANCE), (BytesReference)response2.getSourceAsBytesRef(), (XContentType)XContentType.JSON);
                    Intrinsics.checkNotNullExpressionValue((Object)xcp, (String)"xcp");
                    String string = response2.getId();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"response.id");
                    Monitor monitor = (Monitor)ScheduledJob.Companion.parse(xcp, string, response2.getVersion());
                    IndexMonitorHandler.access$onGetResponse(this.this$0, monitor);
                }

                public void onFailure(@NotNull Exception t) {
                    Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                    IndexMonitorHandler.access$getActionListener$p(this.this$0).onFailure((Exception)AlertingException.Companion.wrap(t));
                }
            });
        }

        private final void onGetResponse(Monitor currentMonitor) {
            if (!TransportIndexMonitorAction.this.checkUserPermissionsWithResource(this.user, currentMonitor.getUser(), this.actionListener, "monitor", this.request.getMonitorId())) {
                return;
            }
            if (this.request.getMonitor().getEnabled() && currentMonitor.getEnabled()) {
                this.request.setMonitor(Monitor.copy$default(this.request.getMonitor(), null, 0L, null, false, null, null, currentMonitor.getEnabledTime(), null, null, 0, null, null, null, 8127, null));
            }
            this.request.setMonitor(Monitor.copy$default(this.request.getMonitor(), null, 0L, null, false, null, null, null, null, null, IndexUtils.Companion.getScheduledJobIndexSchemaVersion(), null, null, null, 7679, null));
            IndexRequest indexRequest = (IndexRequest)new IndexRequest(".opendistro-alerting-config").setRefreshPolicy(this.request.getRefreshPolicy());
            Monitor monitor = this.request.getMonitor();
            XContentBuilder xContentBuilder = XContentFactory.jsonBuilder();
            Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"jsonBuilder()");
            IndexRequest indexRequest2 = (IndexRequest)indexRequest.source(monitor.toXContentWithUser(xContentBuilder, (ToXContent.Params)new ToXContent.MapParams(MapsKt.mapOf((Pair)TuplesKt.to((Object)"with_type", (Object)"true"))))).id(this.request.getMonitorId()).setIfSeqNo(this.request.getSeqNo()).setIfPrimaryTerm(this.request.getPrimaryTerm()).timeout(TransportIndexMonitorAction.this.indexTimeout);
            this.client.index(indexRequest2, (ActionListener)new ActionListener<IndexResponse>(this){
                final /* synthetic */ IndexMonitorHandler this$0;
                {
                    this.this$0 = $receiver;
                }

                public void onResponse(@NotNull IndexResponse response2) {
                    Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                    String failureReasons = IndexMonitorHandler.access$checkShardsFailure(this.this$0, response2);
                    if (failureReasons != null) {
                        IndexMonitorHandler.access$getActionListener$p(this.this$0).onFailure((Exception)AlertingException.Companion.wrap((Exception)new OpenSearchStatusException(failureReasons.toString(), response2.status(), new Object[0])));
                        return;
                    }
                    ActionListener actionListener = IndexMonitorHandler.access$getActionListener$p(this.this$0);
                    String string = response2.getId();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"response.id");
                    actionListener.onResponse((Object)((Object)new IndexMonitorResponse(string, response2.getVersion(), response2.getSeqNo(), response2.getPrimaryTerm(), RestStatus.CREATED, IndexMonitorHandler.access$getRequest$p(this.this$0).getMonitor())));
                }

                public void onFailure(@NotNull Exception t) {
                    Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                    IndexMonitorHandler.access$getActionListener$p(this.this$0).onFailure((Exception)AlertingException.Companion.wrap(t));
                }
            });
        }

        private final String checkShardsFailure(IndexResponse response2) {
            StringBuilder failureReasons = new StringBuilder();
            if (response2.getShardInfo().getFailed() > 0) {
                ReplicationResponse.ShardInfo.Failure[] failureArray = response2.getShardInfo().getFailures();
                Intrinsics.checkNotNullExpressionValue((Object)failureArray, (String)"response.shardInfo.failures");
                Object[] $this$forEach$iv = failureArray;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    ReplicationResponse.ShardInfo.Failure entry = (ReplicationResponse.ShardInfo.Failure)element$iv;
                    boolean bl = false;
                    failureReasons.append(entry.reason());
                }
                return failureReasons.toString();
            }
            return null;
        }

        public static final /* synthetic */ ActionListener access$getActionListener$p(IndexMonitorHandler $this) {
            return $this.actionListener;
        }

        public static final /* synthetic */ void access$onCreateMappingsResponse(IndexMonitorHandler $this, CreateIndexResponse response2) {
            $this.onCreateMappingsResponse(response2);
        }

        public static final /* synthetic */ void access$onUpdateMappingsResponse(IndexMonitorHandler $this, AcknowledgedResponse response2) {
            $this.onUpdateMappingsResponse(response2);
        }

        public static final /* synthetic */ void access$onSearchResponse(IndexMonitorHandler $this, SearchResponse response2) {
            $this.onSearchResponse(response2);
        }

        public static final /* synthetic */ String access$checkShardsFailure(IndexMonitorHandler $this, IndexResponse response2) {
            return $this.checkShardsFailure(response2);
        }

        public static final /* synthetic */ IndexMonitorRequest access$getRequest$p(IndexMonitorHandler $this) {
            return $this.request;
        }

        public static final /* synthetic */ void access$onGetResponse(IndexMonitorHandler $this, Monitor currentMonitor) {
            $this.onGetResponse(currentMonitor);
        }
    }
}

