/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting.transport;

import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.ActionListener;
import org.opensearch.action.admin.indices.create.CreateIndexResponse;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.action.support.master.AcknowledgedResponse;
import org.opensearch.action.support.replication.ReplicationResponse;
import org.opensearch.alerting.action.IndexEmailGroupRequest;
import org.opensearch.alerting.action.IndexEmailGroupResponse;
import org.opensearch.alerting.core.ScheduledJobIndices;
import org.opensearch.alerting.model.destination.email.EmailGroup;
import org.opensearch.alerting.settings.AlertingSettings;
import org.opensearch.alerting.settings.DestinationSettings;
import org.opensearch.alerting.transport.TransportIndexEmailGroupActionKt;
import org.opensearch.alerting.util.AlertingException;
import org.opensearch.alerting.util.DestinationType;
import org.opensearch.alerting.util.IndexUtils;
import org.opensearch.client.Client;
import org.opensearch.client.IndicesAdminClient;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.xcontent.NamedXContentRegistry;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestStatus;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001(B?\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J&\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u00022\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00030'H\u0014R\"\u0010\u0013\u001a\u0016\u0012\u0004\u0012\u00020\u0015 \u0016*\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u00140\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0016\u0010\u001b\u001a\n \u0016*\u0004\u0018\u00010\u001c0\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u00a8\u0006)"}, d2={"Lorg/opensearch/alerting/transport/TransportIndexEmailGroupAction;", "Lorg/opensearch/action/support/HandledTransportAction;", "Lorg/opensearch/alerting/action/IndexEmailGroupRequest;", "Lorg/opensearch/alerting/action/IndexEmailGroupResponse;", "transportService", "Lorg/opensearch/transport/TransportService;", "client", "Lorg/opensearch/client/Client;", "actionFilters", "Lorg/opensearch/action/support/ActionFilters;", "scheduledJobIndices", "Lorg/opensearch/alerting/core/ScheduledJobIndices;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "settings", "Lorg/opensearch/common/settings/Settings;", "xContentRegistry", "Lorg/opensearch/common/xcontent/NamedXContentRegistry;", "(Lorg/opensearch/transport/TransportService;Lorg/opensearch/client/Client;Lorg/opensearch/action/support/ActionFilters;Lorg/opensearch/alerting/core/ScheduledJobIndices;Lorg/opensearch/cluster/service/ClusterService;Lorg/opensearch/common/settings/Settings;Lorg/opensearch/common/xcontent/NamedXContentRegistry;)V", "allowList", "", "", "kotlin.jvm.PlatformType", "getClient", "()Lorg/opensearch/client/Client;", "getClusterService", "()Lorg/opensearch/cluster/service/ClusterService;", "indexTimeout", "Lorg/opensearch/common/unit/TimeValue;", "getScheduledJobIndices", "()Lorg/opensearch/alerting/core/ScheduledJobIndices;", "getXContentRegistry", "()Lorg/opensearch/common/xcontent/NamedXContentRegistry;", "doExecute", "", "task", "Lorg/opensearch/tasks/Task;", "request", "actionListener", "Lorg/opensearch/action/ActionListener;", "IndexEmailGroupHandler", "opensearch-alerting"})
public final class TransportIndexEmailGroupAction
extends HandledTransportAction<IndexEmailGroupRequest, IndexEmailGroupResponse> {
    @NotNull
    private final Client client;
    @NotNull
    private final ScheduledJobIndices scheduledJobIndices;
    @NotNull
    private final ClusterService clusterService;
    @NotNull
    private final NamedXContentRegistry xContentRegistry;
    private volatile TimeValue indexTimeout;
    private volatile List<String> allowList;

    @Inject
    public TransportIndexEmailGroupAction(@NotNull TransportService transportService, @NotNull Client client, @NotNull ActionFilters actionFilters, @NotNull ScheduledJobIndices scheduledJobIndices, @NotNull ClusterService clusterService, @NotNull Settings settings, @NotNull NamedXContentRegistry xContentRegistry) {
        Intrinsics.checkNotNullParameter((Object)transportService, (String)"transportService");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)actionFilters, (String)"actionFilters");
        Intrinsics.checkNotNullParameter((Object)scheduledJobIndices, (String)"scheduledJobIndices");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)xContentRegistry, (String)"xContentRegistry");
        super("cluster:admin/opendistro/alerting/destination/email_group/write", transportService, actionFilters, IndexEmailGroupRequest::new);
        this.client = client;
        this.scheduledJobIndices = scheduledJobIndices;
        this.clusterService = clusterService;
        this.xContentRegistry = xContentRegistry;
        this.indexTimeout = (TimeValue)AlertingSettings.Companion.getINDEX_TIMEOUT().get(settings);
        this.allowList = (List)DestinationSettings.Companion.getALLOW_LIST().get(settings);
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(AlertingSettings.Companion.getINDEX_TIMEOUT(), arg_0 -> TransportIndexEmailGroupAction._init_$lambda-0(this, arg_0));
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(DestinationSettings.Companion.getALLOW_LIST(), arg_0 -> TransportIndexEmailGroupAction._init_$lambda-1(this, arg_0));
    }

    @NotNull
    public final Client getClient() {
        return this.client;
    }

    @NotNull
    public final ScheduledJobIndices getScheduledJobIndices() {
        return this.scheduledJobIndices;
    }

    @NotNull
    public final ClusterService getClusterService() {
        return this.clusterService;
    }

    @NotNull
    public final NamedXContentRegistry getXContentRegistry() {
        return this.xContentRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExecute(@NotNull Task task, @NotNull IndexEmailGroupRequest request, @NotNull ActionListener<IndexEmailGroupResponse> actionListener) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        Intrinsics.checkNotNullParameter(actionListener, (String)"actionListener");
        AutoCloseable autoCloseable = (AutoCloseable)this.client.threadPool().getThreadContext().stashContext();
        Throwable throwable = null;
        try {
            ThreadContext.StoredContext it = (ThreadContext.StoredContext)autoCloseable;
            boolean bl = false;
            new IndexEmailGroupHandler(this.getClient(), actionListener, request).start();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    private static final void _init_$lambda-0(TransportIndexEmailGroupAction this$0, TimeValue it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.indexTimeout = it;
    }

    private static final void _init_$lambda-1(TransportIndexEmailGroupAction this$0, List it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.allowList = it;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0004\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0012\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u0017H\u0002J\b\u0010\u0018\u001a\u00020\u000fH\u0002J\u0006\u0010\u0019\u001a\u00020\u000fJ\b\u0010\u001a\u001a\u00020\u000fH\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/opensearch/alerting/transport/TransportIndexEmailGroupAction$IndexEmailGroupHandler;", "", "client", "Lorg/opensearch/client/Client;", "actionListener", "Lorg/opensearch/action/ActionListener;", "Lorg/opensearch/alerting/action/IndexEmailGroupResponse;", "request", "Lorg/opensearch/alerting/action/IndexEmailGroupRequest;", "(Lorg/opensearch/alerting/transport/TransportIndexEmailGroupAction;Lorg/opensearch/client/Client;Lorg/opensearch/action/ActionListener;Lorg/opensearch/alerting/action/IndexEmailGroupRequest;)V", "checkShardsFailure", "", "response", "Lorg/opensearch/action/index/IndexResponse;", "indexEmailGroup", "", "update", "", "onCreateMappingsResponse", "Lorg/opensearch/action/admin/indices/create/CreateIndexResponse;", "onGetResponse", "Lorg/opensearch/action/get/GetResponse;", "onUpdateMappingsResponse", "Lorg/opensearch/action/support/master/AcknowledgedResponse;", "prepareEmailGroupIndexing", "start", "updateEmailGroup", "opensearch-alerting"})
    public final class IndexEmailGroupHandler {
        @NotNull
        private final Client client;
        @NotNull
        private final ActionListener<IndexEmailGroupResponse> actionListener;
        @NotNull
        private final IndexEmailGroupRequest request;

        public IndexEmailGroupHandler(@NotNull Client client, @NotNull ActionListener<IndexEmailGroupResponse> actionListener, IndexEmailGroupRequest request) {
            Intrinsics.checkNotNullParameter((Object)((Object)TransportIndexEmailGroupAction.this), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter(actionListener, (String)"actionListener");
            Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
            this.client = client;
            this.actionListener = actionListener;
            this.request = request;
        }

        public final void start() {
            if (!TransportIndexEmailGroupAction.this.getScheduledJobIndices().scheduledJobIndexExists()) {
                TransportIndexEmailGroupAction.this.getScheduledJobIndices().initScheduledJobIndex((ActionListener)new ActionListener<CreateIndexResponse>(this){
                    final /* synthetic */ IndexEmailGroupHandler this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    public void onResponse(@NotNull CreateIndexResponse response2) {
                        Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                        IndexEmailGroupHandler.access$onCreateMappingsResponse(this.this$0, response2);
                    }

                    public void onFailure(@NotNull Exception e) {
                        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                        IndexEmailGroupHandler.access$getActionListener$p(this.this$0).onFailure(e);
                    }
                });
            } else if (!IndexUtils.Companion.getScheduledJobIndexUpdated()) {
                String string = ScheduledJobIndices.Companion.scheduledJobMappings();
                ClusterState clusterState = TransportIndexEmailGroupAction.this.getClusterService().state();
                Intrinsics.checkNotNullExpressionValue((Object)clusterState, (String)"clusterService.state()");
                ClusterState clusterState2 = clusterState;
                clusterState = this.client.admin().indices();
                Intrinsics.checkNotNullExpressionValue((Object)clusterState, (String)"client.admin().indices()");
                IndexUtils.Companion.updateIndexMapping(".opendistro-alerting-config", string, clusterState2, (IndicesAdminClient)clusterState, (ActionListener<AcknowledgedResponse>)((ActionListener)new ActionListener<AcknowledgedResponse>(this){
                    final /* synthetic */ IndexEmailGroupHandler this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    public void onResponse(@NotNull AcknowledgedResponse response2) {
                        Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                        IndexEmailGroupHandler.access$onUpdateMappingsResponse(this.this$0, response2);
                    }

                    public void onFailure(@NotNull Exception e) {
                        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                        IndexEmailGroupHandler.access$getActionListener$p(this.this$0).onFailure(e);
                    }
                }));
            } else {
                this.prepareEmailGroupIndexing();
            }
        }

        private final void prepareEmailGroupIndexing() {
            if (!TransportIndexEmailGroupAction.this.allowList.contains(DestinationType.EMAIL.getValue())) {
                this.actionListener.onFailure((Exception)AlertingException.Companion.wrap((Exception)new OpenSearchStatusException("This API is blocked since Destination type [" + DestinationType.EMAIL + "] is not allowed", RestStatus.FORBIDDEN, new Object[0])));
                return;
            }
            if (this.request.getMethod() == RestRequest.Method.PUT) {
                this.updateEmailGroup();
            } else {
                IndexEmailGroupHandler.indexEmailGroup$default(this, false, 1, null);
            }
        }

        private final void onCreateMappingsResponse(CreateIndexResponse response2) {
            if (response2.isAcknowledged()) {
                TransportIndexEmailGroupActionKt.access$getLog$p().info("Created .opendistro-alerting-config with mappings.");
                this.prepareEmailGroupIndexing();
                IndexUtils.Companion.scheduledJobIndexUpdated();
            } else {
                TransportIndexEmailGroupActionKt.access$getLog$p().error("Create .opendistro-alerting-config mappings call not acknowledged.");
                this.actionListener.onFailure((Exception)AlertingException.Companion.wrap((Exception)new OpenSearchStatusException("Create .opendistro-alerting-config mappings call not acknowledged.", RestStatus.INTERNAL_SERVER_ERROR, new Object[0])));
            }
        }

        private final void onUpdateMappingsResponse(AcknowledgedResponse response2) {
            if (response2.isAcknowledged()) {
                TransportIndexEmailGroupActionKt.access$getLog$p().info("Updated .opendistro-alerting-config with mappings.");
                IndexUtils.Companion.scheduledJobIndexUpdated();
                this.prepareEmailGroupIndexing();
            } else {
                TransportIndexEmailGroupActionKt.access$getLog$p().error("Update .opendistro-alerting-config mappings call not acknowledged.");
                this.actionListener.onFailure((Exception)AlertingException.Companion.wrap((Exception)new OpenSearchStatusException("Update .opendistro-alerting-config mappings call not acknowledged.", RestStatus.INTERNAL_SERVER_ERROR, new Object[0])));
            }
        }

        private final void indexEmailGroup(boolean update) {
            this.request.setEmailGroup(EmailGroup.copy$default(this.request.getEmailGroup(), null, 0L, IndexUtils.Companion.getScheduledJobIndexSchemaVersion(), null, null, 27, null));
            IndexRequest indexRequest = (IndexRequest)new IndexRequest(".opendistro-alerting-config").setRefreshPolicy(this.request.getRefreshPolicy());
            EmailGroup emailGroup = this.request.getEmailGroup();
            XContentBuilder xContentBuilder = XContentFactory.jsonBuilder();
            Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"jsonBuilder()");
            IndexRequest indexRequest2 = (IndexRequest)indexRequest.source(emailGroup.toXContent(xContentBuilder, (ToXContent.Params)new ToXContent.MapParams(MapsKt.mapOf((Pair)TuplesKt.to((Object)"with_type", (Object)"true"))))).setIfSeqNo(this.request.getSeqNo()).setIfPrimaryTerm(this.request.getPrimaryTerm()).timeout(TransportIndexEmailGroupAction.this.indexTimeout);
            if (update) {
                indexRequest2 = indexRequest2.id(this.request.getEmailGroupID());
            }
            this.client.index(indexRequest2, (ActionListener)new ActionListener<IndexResponse>(this){
                final /* synthetic */ IndexEmailGroupHandler this$0;
                {
                    this.this$0 = $receiver;
                }

                public void onResponse(@NotNull IndexResponse response2) {
                    Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                    String failureReasons = IndexEmailGroupHandler.access$checkShardsFailure(this.this$0, response2);
                    if (failureReasons != null) {
                        IndexEmailGroupHandler.access$getActionListener$p(this.this$0).onFailure((Exception)AlertingException.Companion.wrap((Exception)new OpenSearchStatusException(failureReasons.toString(), response2.status(), new Object[0])));
                        return;
                    }
                    ActionListener actionListener = IndexEmailGroupHandler.access$getActionListener$p(this.this$0);
                    String string = response2.getId();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"response.id");
                    actionListener.onResponse((Object)((Object)new IndexEmailGroupResponse(string, response2.getVersion(), response2.getSeqNo(), response2.getPrimaryTerm(), RestStatus.CREATED, IndexEmailGroupHandler.access$getRequest$p(this.this$0).getEmailGroup())));
                }

                public void onFailure(@NotNull Exception e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    IndexEmailGroupHandler.access$getActionListener$p(this.this$0).onFailure(e);
                }
            });
        }

        static /* synthetic */ void indexEmailGroup$default(IndexEmailGroupHandler indexEmailGroupHandler, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                bl = false;
            }
            indexEmailGroupHandler.indexEmailGroup(bl);
        }

        private final void updateEmailGroup() {
            GetRequest getRequest = new GetRequest(".opendistro-alerting-config", this.request.getEmailGroupID());
            this.client.get(getRequest, (ActionListener)new ActionListener<GetResponse>(this){
                final /* synthetic */ IndexEmailGroupHandler this$0;
                {
                    this.this$0 = $receiver;
                }

                public void onResponse(@NotNull GetResponse response2) {
                    Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                    IndexEmailGroupHandler.access$onGetResponse(this.this$0, response2);
                }

                public void onFailure(@NotNull Exception e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    IndexEmailGroupHandler.access$getActionListener$p(this.this$0).onFailure(e);
                }
            });
        }

        private final void onGetResponse(GetResponse response2) {
            if (!response2.isExists()) {
                this.actionListener.onFailure((Exception)AlertingException.Companion.wrap((Exception)new OpenSearchStatusException("EmailGroup with " + this.request.getEmailGroupID() + " was not found", RestStatus.NOT_FOUND, new Object[0])));
                return;
            }
            this.indexEmailGroup(true);
        }

        private final String checkShardsFailure(IndexResponse response2) {
            StringBuilder failureReasons = new StringBuilder();
            if (response2.getShardInfo().getFailed() > 0) {
                ReplicationResponse.ShardInfo.Failure[] failureArray = response2.getShardInfo().getFailures();
                Intrinsics.checkNotNullExpressionValue((Object)failureArray, (String)"response.shardInfo.failures");
                Object[] $this$forEach$iv = failureArray;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    ReplicationResponse.ShardInfo.Failure entry = (ReplicationResponse.ShardInfo.Failure)element$iv;
                    boolean bl = false;
                    failureReasons.append(entry.reason());
                }
                return failureReasons.toString();
            }
            return null;
        }

        public static final /* synthetic */ void access$onCreateMappingsResponse(IndexEmailGroupHandler $this, CreateIndexResponse response2) {
            $this.onCreateMappingsResponse(response2);
        }

        public static final /* synthetic */ ActionListener access$getActionListener$p(IndexEmailGroupHandler $this) {
            return $this.actionListener;
        }

        public static final /* synthetic */ void access$onUpdateMappingsResponse(IndexEmailGroupHandler $this, AcknowledgedResponse response2) {
            $this.onUpdateMappingsResponse(response2);
        }

        public static final /* synthetic */ String access$checkShardsFailure(IndexEmailGroupHandler $this, IndexResponse response2) {
            return $this.checkShardsFailure(response2);
        }

        public static final /* synthetic */ IndexEmailGroupRequest access$getRequest$p(IndexEmailGroupHandler $this) {
            return $this.request;
        }

        public static final /* synthetic */ void access$onGetResponse(IndexEmailGroupHandler $this, GetResponse response2) {
            $this.onGetResponse(response2);
        }
    }
}

