/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting.transport;

import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.lucene.search.TotalHits;
import org.jetbrains.annotations.NotNull;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.ActionListener;
import org.opensearch.action.admin.indices.create.CreateIndexResponse;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.action.support.master.AcknowledgedResponse;
import org.opensearch.action.support.replication.ReplicationResponse;
import org.opensearch.alerting.action.IndexEmailAccountRequest;
import org.opensearch.alerting.action.IndexEmailAccountResponse;
import org.opensearch.alerting.core.ScheduledJobIndices;
import org.opensearch.alerting.model.destination.email.EmailAccount;
import org.opensearch.alerting.settings.AlertingSettings;
import org.opensearch.alerting.settings.DestinationSettings;
import org.opensearch.alerting.transport.TransportIndexEmailAccountActionKt;
import org.opensearch.alerting.util.AlertingException;
import org.opensearch.alerting.util.DestinationType;
import org.opensearch.alerting.util.IndexUtils;
import org.opensearch.client.Client;
import org.opensearch.client.IndicesAdminClient;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.xcontent.NamedXContentRegistry;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestStatus;
import org.opensearch.search.SearchHit;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001)B?\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J&\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u00022\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00030(H\u0014R\"\u0010\u0013\u001a\u0016\u0012\u0004\u0012\u00020\u0015 \u0016*\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u00140\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0016\u0010\u001b\u001a\n \u0016*\u0004\u0018\u00010\u001c0\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001d\u001a\n \u0016*\u0004\u0018\u00010\u001c0\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!\u00a8\u0006*"}, d2={"Lorg/opensearch/alerting/transport/TransportIndexEmailAccountAction;", "Lorg/opensearch/action/support/HandledTransportAction;", "Lorg/opensearch/alerting/action/IndexEmailAccountRequest;", "Lorg/opensearch/alerting/action/IndexEmailAccountResponse;", "transportService", "Lorg/opensearch/transport/TransportService;", "client", "Lorg/opensearch/client/Client;", "actionFilters", "Lorg/opensearch/action/support/ActionFilters;", "scheduledJobIndices", "Lorg/opensearch/alerting/core/ScheduledJobIndices;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "settings", "Lorg/opensearch/common/settings/Settings;", "xContentRegistry", "Lorg/opensearch/common/xcontent/NamedXContentRegistry;", "(Lorg/opensearch/transport/TransportService;Lorg/opensearch/client/Client;Lorg/opensearch/action/support/ActionFilters;Lorg/opensearch/alerting/core/ScheduledJobIndices;Lorg/opensearch/cluster/service/ClusterService;Lorg/opensearch/common/settings/Settings;Lorg/opensearch/common/xcontent/NamedXContentRegistry;)V", "allowList", "", "", "kotlin.jvm.PlatformType", "getClient", "()Lorg/opensearch/client/Client;", "getClusterService", "()Lorg/opensearch/cluster/service/ClusterService;", "indexTimeout", "Lorg/opensearch/common/unit/TimeValue;", "requestTimeout", "getScheduledJobIndices", "()Lorg/opensearch/alerting/core/ScheduledJobIndices;", "getXContentRegistry", "()Lorg/opensearch/common/xcontent/NamedXContentRegistry;", "doExecute", "", "task", "Lorg/opensearch/tasks/Task;", "request", "actionListener", "Lorg/opensearch/action/ActionListener;", "IndexEmailAccountHandler", "opensearch-alerting"})
public final class TransportIndexEmailAccountAction
extends HandledTransportAction<IndexEmailAccountRequest, IndexEmailAccountResponse> {
    @NotNull
    private final Client client;
    @NotNull
    private final ScheduledJobIndices scheduledJobIndices;
    @NotNull
    private final ClusterService clusterService;
    @NotNull
    private final NamedXContentRegistry xContentRegistry;
    private volatile TimeValue requestTimeout;
    private volatile TimeValue indexTimeout;
    private volatile List<String> allowList;

    @Inject
    public TransportIndexEmailAccountAction(@NotNull TransportService transportService, @NotNull Client client, @NotNull ActionFilters actionFilters, @NotNull ScheduledJobIndices scheduledJobIndices, @NotNull ClusterService clusterService, @NotNull Settings settings, @NotNull NamedXContentRegistry xContentRegistry) {
        Intrinsics.checkNotNullParameter((Object)transportService, (String)"transportService");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)actionFilters, (String)"actionFilters");
        Intrinsics.checkNotNullParameter((Object)scheduledJobIndices, (String)"scheduledJobIndices");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)xContentRegistry, (String)"xContentRegistry");
        super("cluster:admin/opendistro/alerting/destination/email_account/write", transportService, actionFilters, IndexEmailAccountRequest::new);
        this.client = client;
        this.scheduledJobIndices = scheduledJobIndices;
        this.clusterService = clusterService;
        this.xContentRegistry = xContentRegistry;
        this.requestTimeout = (TimeValue)AlertingSettings.Companion.getREQUEST_TIMEOUT().get(settings);
        this.indexTimeout = (TimeValue)AlertingSettings.Companion.getINDEX_TIMEOUT().get(settings);
        this.allowList = (List)DestinationSettings.Companion.getALLOW_LIST().get(settings);
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(AlertingSettings.Companion.getREQUEST_TIMEOUT(), arg_0 -> TransportIndexEmailAccountAction._init_$lambda-0(this, arg_0));
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(AlertingSettings.Companion.getINDEX_TIMEOUT(), arg_0 -> TransportIndexEmailAccountAction._init_$lambda-1(this, arg_0));
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(DestinationSettings.Companion.getALLOW_LIST(), arg_0 -> TransportIndexEmailAccountAction._init_$lambda-2(this, arg_0));
    }

    @NotNull
    public final Client getClient() {
        return this.client;
    }

    @NotNull
    public final ScheduledJobIndices getScheduledJobIndices() {
        return this.scheduledJobIndices;
    }

    @NotNull
    public final ClusterService getClusterService() {
        return this.clusterService;
    }

    @NotNull
    public final NamedXContentRegistry getXContentRegistry() {
        return this.xContentRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExecute(@NotNull Task task, @NotNull IndexEmailAccountRequest request, @NotNull ActionListener<IndexEmailAccountResponse> actionListener) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        Intrinsics.checkNotNullParameter(actionListener, (String)"actionListener");
        AutoCloseable autoCloseable = (AutoCloseable)this.client.threadPool().getThreadContext().stashContext();
        Throwable throwable = null;
        try {
            ThreadContext.StoredContext it = (ThreadContext.StoredContext)autoCloseable;
            boolean bl = false;
            new IndexEmailAccountHandler(this.getClient(), actionListener, request).start();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    private static final void _init_$lambda-0(TransportIndexEmailAccountAction this$0, TimeValue it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.requestTimeout = it;
    }

    private static final void _init_$lambda-1(TransportIndexEmailAccountAction this$0, TimeValue it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.indexTimeout = it;
    }

    private static final void _init_$lambda-2(TransportIndexEmailAccountAction this$0, List it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.allowList = it;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0004\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0012\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u0019H\u0002J\b\u0010\u001a\u001a\u00020\u000fH\u0002J\u0006\u0010\u001b\u001a\u00020\u000fJ\b\u0010\u001c\u001a\u00020\u000fH\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/opensearch/alerting/transport/TransportIndexEmailAccountAction$IndexEmailAccountHandler;", "", "client", "Lorg/opensearch/client/Client;", "actionListener", "Lorg/opensearch/action/ActionListener;", "Lorg/opensearch/alerting/action/IndexEmailAccountResponse;", "request", "Lorg/opensearch/alerting/action/IndexEmailAccountRequest;", "(Lorg/opensearch/alerting/transport/TransportIndexEmailAccountAction;Lorg/opensearch/client/Client;Lorg/opensearch/action/ActionListener;Lorg/opensearch/alerting/action/IndexEmailAccountRequest;)V", "checkShardsFailure", "", "response", "Lorg/opensearch/action/index/IndexResponse;", "indexEmailAccount", "", "update", "", "onCreateMappingsResponse", "Lorg/opensearch/action/admin/indices/create/CreateIndexResponse;", "onGetResponse", "Lorg/opensearch/action/get/GetResponse;", "onSearchResponse", "Lorg/opensearch/action/search/SearchResponse;", "onUpdateMappingsResponse", "Lorg/opensearch/action/support/master/AcknowledgedResponse;", "prepareEmailAccountIndexing", "start", "updateEmailAccount", "opensearch-alerting"})
    public final class IndexEmailAccountHandler {
        @NotNull
        private final Client client;
        @NotNull
        private final ActionListener<IndexEmailAccountResponse> actionListener;
        @NotNull
        private final IndexEmailAccountRequest request;

        public IndexEmailAccountHandler(@NotNull Client client, @NotNull ActionListener<IndexEmailAccountResponse> actionListener, IndexEmailAccountRequest request) {
            Intrinsics.checkNotNullParameter((Object)((Object)TransportIndexEmailAccountAction.this), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter(actionListener, (String)"actionListener");
            Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
            this.client = client;
            this.actionListener = actionListener;
            this.request = request;
        }

        public final void start() {
            if (!TransportIndexEmailAccountAction.this.getScheduledJobIndices().scheduledJobIndexExists()) {
                TransportIndexEmailAccountAction.this.getScheduledJobIndices().initScheduledJobIndex((ActionListener)new ActionListener<CreateIndexResponse>(this){
                    final /* synthetic */ IndexEmailAccountHandler this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    public void onResponse(@NotNull CreateIndexResponse response2) {
                        Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                        IndexEmailAccountHandler.access$onCreateMappingsResponse(this.this$0, response2);
                    }

                    public void onFailure(@NotNull Exception e) {
                        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                        IndexEmailAccountHandler.access$getActionListener$p(this.this$0).onFailure(e);
                    }
                });
            } else if (!IndexUtils.Companion.getScheduledJobIndexUpdated()) {
                String string = ScheduledJobIndices.Companion.scheduledJobMappings();
                ClusterState clusterState = TransportIndexEmailAccountAction.this.getClusterService().state();
                Intrinsics.checkNotNullExpressionValue((Object)clusterState, (String)"clusterService.state()");
                ClusterState clusterState2 = clusterState;
                clusterState = this.client.admin().indices();
                Intrinsics.checkNotNullExpressionValue((Object)clusterState, (String)"client.admin().indices()");
                IndexUtils.Companion.updateIndexMapping(".opendistro-alerting-config", string, clusterState2, (IndicesAdminClient)clusterState, (ActionListener<AcknowledgedResponse>)((ActionListener)new ActionListener<AcknowledgedResponse>(this){
                    final /* synthetic */ IndexEmailAccountHandler this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    public void onResponse(@NotNull AcknowledgedResponse response2) {
                        Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                        IndexEmailAccountHandler.access$onUpdateMappingsResponse(this.this$0, response2);
                    }

                    public void onFailure(@NotNull Exception e) {
                        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                        IndexEmailAccountHandler.access$getActionListener$p(this.this$0).onFailure(e);
                    }
                }));
            } else {
                this.prepareEmailAccountIndexing();
            }
        }

        private final void prepareEmailAccountIndexing() {
            if (!TransportIndexEmailAccountAction.this.allowList.contains(DestinationType.EMAIL.getValue())) {
                this.actionListener.onFailure((Exception)AlertingException.Companion.wrap((Exception)new OpenSearchStatusException("This API is blocked since Destination type [" + DestinationType.EMAIL + "] is not allowed", RestStatus.FORBIDDEN, new Object[0])));
                return;
            }
            BoolQueryBuilder query = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)"email_account.name.keyword", (String)this.request.getEmailAccount().getName())).filter((QueryBuilder)QueryBuilders.existsQuery((String)"email_account"));
            SearchSourceBuilder searchSource = new SearchSourceBuilder().query((QueryBuilder)query).timeout(TransportIndexEmailAccountAction.this.requestTimeout);
            String[] stringArray = new String[]{".opendistro-alerting-config"};
            SearchRequest searchRequest = new SearchRequest(stringArray).source(searchSource);
            this.client.search(searchRequest, (ActionListener)new ActionListener<SearchResponse>(this){
                final /* synthetic */ IndexEmailAccountHandler this$0;
                {
                    this.this$0 = $receiver;
                }

                public void onResponse(@NotNull SearchResponse searchResponse2) {
                    Intrinsics.checkNotNullParameter((Object)searchResponse2, (String)"searchResponse");
                    IndexEmailAccountHandler.access$onSearchResponse(this.this$0, searchResponse2);
                }

                public void onFailure(@NotNull Exception e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    IndexEmailAccountHandler.access$getActionListener$p(this.this$0).onFailure(e);
                }
            });
        }

        private final void onSearchResponse(SearchResponse response2) {
            if (this.request.getMethod() == RestRequest.Method.POST) {
                Long totalHits;
                TotalHits totalHits2 = response2.getHits().getTotalHits();
                Long l = totalHits = totalHits2 == null ? null : Long.valueOf(totalHits2.value);
                if (totalHits != null && totalHits > 0L) {
                    TransportIndexEmailAccountActionKt.access$getLog$p().error("Unable to create email group with name=[" + this.request.getEmailAccount().getName() + "] because name is already in use.");
                    this.actionListener.onFailure((Exception)new IllegalArgumentException("Unable to create email group with name=[" + this.request.getEmailAccount().getName() + "] because name is already in use."));
                    return;
                }
                IndexEmailAccountHandler.indexEmailAccount$default(this, false, 1, null);
            } else {
                for (SearchHit hit : response2.getHits()) {
                    if (Intrinsics.areEqual((Object)hit.getId(), (Object)this.request.getEmailAccountID())) continue;
                    TransportIndexEmailAccountActionKt.access$getLog$p().error("Unable to update email group with name=[" + this.request.getEmailAccount().getName() + "] because name is already in use.");
                    this.actionListener.onFailure((Exception)new IllegalArgumentException("Unable to update email group with name=[" + this.request.getEmailAccount().getName() + "] because name is already in use."));
                    return;
                }
                this.updateEmailAccount();
            }
        }

        private final void onCreateMappingsResponse(CreateIndexResponse response2) {
            if (response2.isAcknowledged()) {
                TransportIndexEmailAccountActionKt.access$getLog$p().info("Created .opendistro-alerting-config with mappings.");
                this.prepareEmailAccountIndexing();
                IndexUtils.Companion.scheduledJobIndexUpdated();
            } else {
                TransportIndexEmailAccountActionKt.access$getLog$p().error("Create .opendistro-alerting-config mappings call not acknowledged.");
                this.actionListener.onFailure((Exception)AlertingException.Companion.wrap((Exception)new OpenSearchStatusException("Create .opendistro-alerting-config mappings call not acknowledged.", RestStatus.INTERNAL_SERVER_ERROR, new Object[0])));
            }
        }

        private final void onUpdateMappingsResponse(AcknowledgedResponse response2) {
            if (response2.isAcknowledged()) {
                TransportIndexEmailAccountActionKt.access$getLog$p().info("Updated .opendistro-alerting-config with mappings.");
                IndexUtils.Companion.scheduledJobIndexUpdated();
                this.prepareEmailAccountIndexing();
            } else {
                TransportIndexEmailAccountActionKt.access$getLog$p().error("Update .opendistro-alerting-config mappings call not acknowledged.");
                this.actionListener.onFailure((Exception)AlertingException.Companion.wrap((Exception)new OpenSearchStatusException("Update .opendistro-alerting-config mappings call not acknowledged.", RestStatus.INTERNAL_SERVER_ERROR, new Object[0])));
            }
        }

        private final void indexEmailAccount(boolean update) {
            this.request.setEmailAccount(EmailAccount.copy$default(this.request.getEmailAccount(), null, 0L, IndexUtils.Companion.getScheduledJobIndexSchemaVersion(), null, null, null, 0, null, null, null, 1019, null));
            IndexRequest indexRequest = (IndexRequest)new IndexRequest(".opendistro-alerting-config").setRefreshPolicy(this.request.getRefreshPolicy());
            EmailAccount emailAccount = this.request.getEmailAccount();
            XContentBuilder xContentBuilder = XContentFactory.jsonBuilder();
            Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"jsonBuilder()");
            IndexRequest indexRequest2 = (IndexRequest)indexRequest.source(emailAccount.toXContent(xContentBuilder, (ToXContent.Params)new ToXContent.MapParams(MapsKt.mapOf((Pair)TuplesKt.to((Object)"with_type", (Object)"true"))))).setIfSeqNo(this.request.getSeqNo()).setIfPrimaryTerm(this.request.getPrimaryTerm()).timeout(TransportIndexEmailAccountAction.this.indexTimeout);
            if (update) {
                indexRequest2 = indexRequest2.id(this.request.getEmailAccountID());
            }
            this.client.index(indexRequest2, (ActionListener)new ActionListener<IndexResponse>(this){
                final /* synthetic */ IndexEmailAccountHandler this$0;
                {
                    this.this$0 = $receiver;
                }

                public void onResponse(@NotNull IndexResponse response2) {
                    Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                    String failureReasons = IndexEmailAccountHandler.access$checkShardsFailure(this.this$0, response2);
                    if (failureReasons != null) {
                        IndexEmailAccountHandler.access$getActionListener$p(this.this$0).onFailure((Exception)AlertingException.Companion.wrap((Exception)new OpenSearchStatusException(failureReasons.toString(), response2.status(), new Object[0])));
                        return;
                    }
                    ActionListener actionListener = IndexEmailAccountHandler.access$getActionListener$p(this.this$0);
                    String string = response2.getId();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"response.id");
                    actionListener.onResponse((Object)((Object)new IndexEmailAccountResponse(string, response2.getVersion(), response2.getSeqNo(), response2.getPrimaryTerm(), RestStatus.CREATED, IndexEmailAccountHandler.access$getRequest$p(this.this$0).getEmailAccount())));
                }

                public void onFailure(@NotNull Exception e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    IndexEmailAccountHandler.access$getActionListener$p(this.this$0).onFailure(e);
                }
            });
        }

        static /* synthetic */ void indexEmailAccount$default(IndexEmailAccountHandler indexEmailAccountHandler, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                bl = false;
            }
            indexEmailAccountHandler.indexEmailAccount(bl);
        }

        private final void updateEmailAccount() {
            GetRequest getRequest = new GetRequest(".opendistro-alerting-config", this.request.getEmailAccountID());
            this.client.get(getRequest, (ActionListener)new ActionListener<GetResponse>(this){
                final /* synthetic */ IndexEmailAccountHandler this$0;
                {
                    this.this$0 = $receiver;
                }

                public void onResponse(@NotNull GetResponse response2) {
                    Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                    IndexEmailAccountHandler.access$onGetResponse(this.this$0, response2);
                }

                public void onFailure(@NotNull Exception e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    IndexEmailAccountHandler.access$getActionListener$p(this.this$0).onFailure(e);
                }
            });
        }

        private final void onGetResponse(GetResponse response2) {
            if (!response2.isExists()) {
                this.actionListener.onFailure((Exception)AlertingException.Companion.wrap((Exception)new OpenSearchStatusException("EmailAccount with " + this.request.getEmailAccountID() + " was not found", RestStatus.NOT_FOUND, new Object[0])));
                return;
            }
            this.indexEmailAccount(true);
        }

        private final String checkShardsFailure(IndexResponse response2) {
            StringBuilder failureReasons = new StringBuilder();
            if (response2.getShardInfo().getFailed() > 0) {
                ReplicationResponse.ShardInfo.Failure[] failureArray = response2.getShardInfo().getFailures();
                Intrinsics.checkNotNullExpressionValue((Object)failureArray, (String)"response.shardInfo.failures");
                Object[] $this$forEach$iv = failureArray;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    ReplicationResponse.ShardInfo.Failure entry = (ReplicationResponse.ShardInfo.Failure)element$iv;
                    boolean bl = false;
                    failureReasons.append(entry.reason());
                }
                return failureReasons.toString();
            }
            return null;
        }

        public static final /* synthetic */ void access$onCreateMappingsResponse(IndexEmailAccountHandler $this, CreateIndexResponse response2) {
            $this.onCreateMappingsResponse(response2);
        }

        public static final /* synthetic */ ActionListener access$getActionListener$p(IndexEmailAccountHandler $this) {
            return $this.actionListener;
        }

        public static final /* synthetic */ void access$onUpdateMappingsResponse(IndexEmailAccountHandler $this, AcknowledgedResponse response2) {
            $this.onUpdateMappingsResponse(response2);
        }

        public static final /* synthetic */ void access$onSearchResponse(IndexEmailAccountHandler $this, SearchResponse response2) {
            $this.onSearchResponse(response2);
        }

        public static final /* synthetic */ String access$checkShardsFailure(IndexEmailAccountHandler $this, IndexResponse response2) {
            return $this.checkShardsFailure(response2);
        }

        public static final /* synthetic */ IndexEmailAccountRequest access$getRequest$p(IndexEmailAccountHandler $this) {
            return $this.request;
        }

        public static final /* synthetic */ void access$onGetResponse(IndexEmailAccountHandler $this, GetResponse response2) {
            $this.onGetResponse(response2);
        }
    }
}

