/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting.transport;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.ActionListener;
import org.opensearch.action.delete.DeleteRequest;
import org.opensearch.action.delete.DeleteResponse;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.alerting.action.DeleteDestinationRequest;
import org.opensearch.alerting.model.destination.Destination;
import org.opensearch.alerting.settings.AlertingSettings;
import org.opensearch.alerting.transport.SecureTransportAction;
import org.opensearch.alerting.util.AlertingException;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.xcontent.DeprecationHandler;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.NamedXContentRegistry;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.common.xcontent.XContentParserUtils;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.commons.authuser.User;
import org.opensearch.rest.RestStatus;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u00020\u0004:\u0001'B7\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J&\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00022\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00030&H\u0014R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R$\u0010\u0016\u001a\n \u0018*\u0004\u0018\u00010\u00170\u0017X\u0096\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001d\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006("}, d2={"Lorg/opensearch/alerting/transport/TransportDeleteDestinationAction;", "Lorg/opensearch/action/support/HandledTransportAction;", "Lorg/opensearch/alerting/action/DeleteDestinationRequest;", "Lorg/opensearch/action/delete/DeleteResponse;", "Lorg/opensearch/alerting/transport/SecureTransportAction;", "transportService", "Lorg/opensearch/transport/TransportService;", "client", "Lorg/opensearch/client/Client;", "actionFilters", "Lorg/opensearch/action/support/ActionFilters;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "settings", "Lorg/opensearch/common/settings/Settings;", "xContentRegistry", "Lorg/opensearch/common/xcontent/NamedXContentRegistry;", "(Lorg/opensearch/transport/TransportService;Lorg/opensearch/client/Client;Lorg/opensearch/action/support/ActionFilters;Lorg/opensearch/cluster/service/ClusterService;Lorg/opensearch/common/settings/Settings;Lorg/opensearch/common/xcontent/NamedXContentRegistry;)V", "getClient", "()Lorg/opensearch/client/Client;", "getClusterService", "()Lorg/opensearch/cluster/service/ClusterService;", "filterByEnabled", "", "kotlin.jvm.PlatformType", "getFilterByEnabled", "()Ljava/lang/Boolean;", "setFilterByEnabled", "(Ljava/lang/Boolean;)V", "Ljava/lang/Boolean;", "getXContentRegistry", "()Lorg/opensearch/common/xcontent/NamedXContentRegistry;", "doExecute", "", "task", "Lorg/opensearch/tasks/Task;", "request", "actionListener", "Lorg/opensearch/action/ActionListener;", "DeleteDestinationHandler", "opensearch-alerting"})
public final class TransportDeleteDestinationAction
extends HandledTransportAction<DeleteDestinationRequest, DeleteResponse>
implements SecureTransportAction {
    @NotNull
    private final Client client;
    @NotNull
    private final ClusterService clusterService;
    @NotNull
    private final NamedXContentRegistry xContentRegistry;
    private volatile Boolean filterByEnabled;

    @Inject
    public TransportDeleteDestinationAction(@NotNull TransportService transportService, @NotNull Client client, @NotNull ActionFilters actionFilters, @NotNull ClusterService clusterService, @NotNull Settings settings, @NotNull NamedXContentRegistry xContentRegistry) {
        Intrinsics.checkNotNullParameter((Object)transportService, (String)"transportService");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)actionFilters, (String)"actionFilters");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)xContentRegistry, (String)"xContentRegistry");
        super("cluster:admin/opendistro/alerting/destination/delete", transportService, actionFilters, DeleteDestinationRequest::new);
        this.client = client;
        this.clusterService = clusterService;
        this.xContentRegistry = xContentRegistry;
        this.filterByEnabled = (Boolean)AlertingSettings.Companion.getFILTER_BY_BACKEND_ROLES().get(settings);
        this.listenFilterBySettingChange(this.clusterService);
    }

    @NotNull
    public final Client getClient() {
        return this.client;
    }

    @NotNull
    public final ClusterService getClusterService() {
        return this.clusterService;
    }

    @NotNull
    public final NamedXContentRegistry getXContentRegistry() {
        return this.xContentRegistry;
    }

    public Boolean getFilterByEnabled() {
        return this.filterByEnabled;
    }

    public void setFilterByEnabled(Boolean bl) {
        this.filterByEnabled = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExecute(@NotNull Task task, @NotNull DeleteDestinationRequest request, @NotNull ActionListener<DeleteResponse> actionListener) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        Intrinsics.checkNotNullParameter(actionListener, (String)"actionListener");
        User user = this.readUserFromThreadContext(this.client);
        DeleteRequest deleteRequest = (DeleteRequest)new DeleteRequest(".opendistro-alerting-config", request.getDestinationId()).setRefreshPolicy(request.getRefreshPolicy());
        if (!this.validateUserBackendRoles(user, actionListener)) {
            return;
        }
        AutoCloseable autoCloseable = (AutoCloseable)this.client.threadPool().getThreadContext().stashContext();
        Throwable throwable = null;
        try {
            ThreadContext.StoredContext it = (ThreadContext.StoredContext)autoCloseable;
            boolean bl = false;
            Client client = this.getClient();
            Intrinsics.checkNotNullExpressionValue((Object)deleteRequest, (String)"deleteRequest");
            new DeleteDestinationHandler(client, actionListener, deleteRequest, user, request.getDestinationId()).resolveUserAndStart();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    @Override
    public void listenFilterBySettingChange(@NotNull ClusterService clusterService) {
        SecureTransportAction.DefaultImpls.listenFilterBySettingChange(this, clusterService);
    }

    @Override
    @Nullable
    public User readUserFromThreadContext(@NotNull Client client) {
        return SecureTransportAction.DefaultImpls.readUserFromThreadContext(this, client);
    }

    @Override
    public boolean doFilterForUser(@Nullable User user) {
        return SecureTransportAction.DefaultImpls.doFilterForUser(this, user);
    }

    @Override
    public <T> boolean validateUserBackendRoles(@Nullable User user, @NotNull ActionListener<T> actionListener) {
        return SecureTransportAction.DefaultImpls.validateUserBackendRoles(this, user, actionListener);
    }

    @Override
    public <T> boolean checkUserPermissionsWithResource(@Nullable User requesterUser, @Nullable User resourceUser, @NotNull ActionListener<T> actionListener, @NotNull String resourceType, @NotNull String resourceId) {
        return SecureTransportAction.DefaultImpls.checkUserPermissionsWithResource(this, requesterUser, resourceUser, actionListener, resourceType, resourceId);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\b\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0006\u0010\u0013\u001a\u00020\u000fJ\u0006\u0010\u0014\u001a\u00020\u000fR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/opensearch/alerting/transport/TransportDeleteDestinationAction$DeleteDestinationHandler;", "", "client", "Lorg/opensearch/client/Client;", "actionListener", "Lorg/opensearch/action/ActionListener;", "Lorg/opensearch/action/delete/DeleteResponse;", "deleteRequest", "Lorg/opensearch/action/delete/DeleteRequest;", "user", "Lorg/opensearch/commons/authuser/User;", "destinationId", "", "(Lorg/opensearch/alerting/transport/TransportDeleteDestinationAction;Lorg/opensearch/client/Client;Lorg/opensearch/action/ActionListener;Lorg/opensearch/action/delete/DeleteRequest;Lorg/opensearch/commons/authuser/User;Ljava/lang/String;)V", "deleteDestination", "", "onGetResponse", "destination", "Lorg/opensearch/alerting/model/destination/Destination;", "resolveUserAndStart", "start", "opensearch-alerting"})
    public final class DeleteDestinationHandler {
        @NotNull
        private final Client client;
        @NotNull
        private final ActionListener<DeleteResponse> actionListener;
        @NotNull
        private final DeleteRequest deleteRequest;
        @Nullable
        private final User user;
        @NotNull
        private final String destinationId;

        public DeleteDestinationHandler(@NotNull Client client, @NotNull ActionListener<DeleteResponse> actionListener, @Nullable DeleteRequest deleteRequest, @NotNull User user, String destinationId) {
            Intrinsics.checkNotNullParameter((Object)TransportDeleteDestinationAction.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter(actionListener, (String)"actionListener");
            Intrinsics.checkNotNullParameter((Object)deleteRequest, (String)"deleteRequest");
            Intrinsics.checkNotNullParameter((Object)destinationId, (String)"destinationId");
            this.client = client;
            this.actionListener = actionListener;
            this.deleteRequest = deleteRequest;
            this.user = user;
            this.destinationId = destinationId;
        }

        public final void resolveUserAndStart() {
            if (this.user == null) {
                this.deleteDestination();
            } else if (!TransportDeleteDestinationAction.this.doFilterForUser(this.user)) {
                this.deleteDestination();
            } else {
                try {
                    this.start();
                }
                catch (IOException ex) {
                    this.actionListener.onFailure((Exception)AlertingException.Companion.wrap(ex));
                }
            }
        }

        public final void start() {
            GetRequest getRequest = new GetRequest(".opendistro-alerting-config", this.destinationId);
            this.client.get(getRequest, (ActionListener)new ActionListener<GetResponse>(this, TransportDeleteDestinationAction.this){
                final /* synthetic */ DeleteDestinationHandler this$0;
                final /* synthetic */ TransportDeleteDestinationAction this$1;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                }

                public void onResponse(@NotNull GetResponse response2) {
                    Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                    if (!response2.isExists()) {
                        DeleteDestinationHandler.access$getActionListener$p(this.this$0).onFailure((Exception)AlertingException.Companion.wrap((Exception)new OpenSearchStatusException("Destination with " + DeleteDestinationHandler.access$getDestinationId$p(this.this$0) + " is not found", RestStatus.NOT_FOUND, new Object[0])));
                        return;
                    }
                    String id = response2.getId();
                    long version = response2.getVersion();
                    int seqNo = (int)response2.getSeqNo();
                    int primaryTerm = (int)response2.getPrimaryTerm();
                    XContentParser xcp = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(this.this$1.getXContentRegistry(), (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, response2.getSourceAsString());
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.nextToken(), (XContentParser)xcp);
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.FIELD_NAME, (XContentParser.Token)xcp.nextToken(), (XContentParser)xcp);
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.nextToken(), (XContentParser)xcp);
                    Intrinsics.checkNotNullExpressionValue((Object)xcp, (String)"xcp");
                    Intrinsics.checkNotNullExpressionValue((Object)id, (String)"id");
                    Destination dest = Destination.Companion.parse(xcp, id, version, seqNo, primaryTerm);
                    DeleteDestinationHandler.access$onGetResponse(this.this$0, dest);
                }

                public void onFailure(@NotNull Exception t) {
                    Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                    DeleteDestinationHandler.access$getActionListener$p(this.this$0).onFailure((Exception)AlertingException.Companion.wrap(t));
                }
            });
        }

        private final void onGetResponse(Destination destination) {
            if (!TransportDeleteDestinationAction.this.checkUserPermissionsWithResource(this.user, destination.getUser(), this.actionListener, "destination", this.destinationId)) {
                return;
            }
            this.deleteDestination();
        }

        private final void deleteDestination() {
            this.client.delete(this.deleteRequest, (ActionListener)new ActionListener<DeleteResponse>(this){
                final /* synthetic */ DeleteDestinationHandler this$0;
                {
                    this.this$0 = $receiver;
                }

                public void onResponse(@NotNull DeleteResponse response2) {
                    Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                    DeleteDestinationHandler.access$getActionListener$p(this.this$0).onResponse((Object)response2);
                }

                public void onFailure(@NotNull Exception t) {
                    Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                    DeleteDestinationHandler.access$getActionListener$p(this.this$0).onFailure((Exception)AlertingException.Companion.wrap(t));
                }
            });
        }

        public static final /* synthetic */ ActionListener access$getActionListener$p(DeleteDestinationHandler $this) {
            return $this.actionListener;
        }

        public static final /* synthetic */ String access$getDestinationId$p(DeleteDestinationHandler $this) {
            return $this.destinationId;
        }

        public static final /* synthetic */ void access$onGetResponse(DeleteDestinationHandler $this, Destination destination) {
            $this.onGetResponse(destination);
        }
    }
}

