/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting.transport;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.opensearch.action.ActionListener;
import org.opensearch.action.bulk.BulkItemResponse;
import org.opensearch.action.bulk.BulkRequest;
import org.opensearch.action.bulk.BulkResponse;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.action.update.UpdateRequest;
import org.opensearch.alerting.action.AcknowledgeAlertRequest;
import org.opensearch.alerting.action.AcknowledgeAlertResponse;
import org.opensearch.alerting.model.Alert;
import org.opensearch.alerting.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.alerting.transport.TransportAcknowledgeAlertActionKt;
import org.opensearch.alerting.util.AlertingException;
import org.opensearch.client.Client;
import org.opensearch.common.bytes.BytesReference;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.xcontent.DeprecationHandler;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.NamedXContentRegistry;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.common.xcontent.XContentParserUtils;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.search.SearchHit;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u0018B'\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ&\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00022\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00030\u0017H\u0014R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0019"}, d2={"Lorg/opensearch/alerting/transport/TransportAcknowledgeAlertAction;", "Lorg/opensearch/action/support/HandledTransportAction;", "Lorg/opensearch/alerting/action/AcknowledgeAlertRequest;", "Lorg/opensearch/alerting/action/AcknowledgeAlertResponse;", "transportService", "Lorg/opensearch/transport/TransportService;", "client", "Lorg/opensearch/client/Client;", "actionFilters", "Lorg/opensearch/action/support/ActionFilters;", "xContentRegistry", "Lorg/opensearch/common/xcontent/NamedXContentRegistry;", "(Lorg/opensearch/transport/TransportService;Lorg/opensearch/client/Client;Lorg/opensearch/action/support/ActionFilters;Lorg/opensearch/common/xcontent/NamedXContentRegistry;)V", "getClient", "()Lorg/opensearch/client/Client;", "getXContentRegistry", "()Lorg/opensearch/common/xcontent/NamedXContentRegistry;", "doExecute", "", "task", "Lorg/opensearch/tasks/Task;", "request", "actionListener", "Lorg/opensearch/action/ActionListener;", "AcknowledgeHandler", "opensearch-alerting"})
public final class TransportAcknowledgeAlertAction
extends HandledTransportAction<AcknowledgeAlertRequest, AcknowledgeAlertResponse> {
    @NotNull
    private final Client client;
    @NotNull
    private final NamedXContentRegistry xContentRegistry;

    @Inject
    public TransportAcknowledgeAlertAction(@NotNull TransportService transportService, @NotNull Client client, @NotNull ActionFilters actionFilters, @NotNull NamedXContentRegistry xContentRegistry) {
        Intrinsics.checkNotNullParameter((Object)transportService, (String)"transportService");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)actionFilters, (String)"actionFilters");
        Intrinsics.checkNotNullParameter((Object)xContentRegistry, (String)"xContentRegistry");
        super("cluster:admin/opendistro/alerting/alerts/ack", transportService, actionFilters, AcknowledgeAlertRequest::new);
        this.client = client;
        this.xContentRegistry = xContentRegistry;
    }

    @NotNull
    public final Client getClient() {
        return this.client;
    }

    @NotNull
    public final NamedXContentRegistry getXContentRegistry() {
        return this.xContentRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExecute(@NotNull Task task, @NotNull AcknowledgeAlertRequest request, @NotNull ActionListener<AcknowledgeAlertResponse> actionListener) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        Intrinsics.checkNotNullParameter(actionListener, (String)"actionListener");
        AutoCloseable autoCloseable = (AutoCloseable)this.client.threadPool().getThreadContext().stashContext();
        Throwable throwable = null;
        try {
            ThreadContext.StoredContext it = (ThreadContext.StoredContext)autoCloseable;
            boolean bl = false;
            new AcknowledgeHandler(this.getClient(), actionListener, request).start();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0016H\u0002J\u0006\u0010\u0017\u001a\u00020\u0011R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/opensearch/alerting/transport/TransportAcknowledgeAlertAction$AcknowledgeHandler;", "", "client", "Lorg/opensearch/client/Client;", "actionListener", "Lorg/opensearch/action/ActionListener;", "Lorg/opensearch/alerting/action/AcknowledgeAlertResponse;", "request", "Lorg/opensearch/alerting/action/AcknowledgeAlertRequest;", "(Lorg/opensearch/alerting/transport/TransportAcknowledgeAlertAction;Lorg/opensearch/client/Client;Lorg/opensearch/action/ActionListener;Lorg/opensearch/alerting/action/AcknowledgeAlertRequest;)V", "alerts", "", "", "Lorg/opensearch/alerting/model/Alert;", "getAlerts", "()Ljava/util/Map;", "findActiveAlerts", "", "onBulkResponse", "response", "Lorg/opensearch/action/bulk/BulkResponse;", "onSearchResponse", "Lorg/opensearch/action/search/SearchResponse;", "start", "opensearch-alerting"})
    public final class AcknowledgeHandler {
        @NotNull
        private final Client client;
        @NotNull
        private final ActionListener<AcknowledgeAlertResponse> actionListener;
        @NotNull
        private final AcknowledgeAlertRequest request;
        @NotNull
        private final Map<String, Alert> alerts;

        public AcknowledgeHandler(@NotNull Client client, @NotNull ActionListener<AcknowledgeAlertResponse> actionListener, AcknowledgeAlertRequest request) {
            Intrinsics.checkNotNullParameter((Object)((Object)TransportAcknowledgeAlertAction.this), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter(actionListener, (String)"actionListener");
            Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
            this.client = client;
            this.actionListener = actionListener;
            this.request = request;
            this.alerts = new LinkedHashMap();
        }

        @NotNull
        public final Map<String, Alert> getAlerts() {
            return this.alerts;
        }

        public final void start() {
            this.findActiveAlerts();
        }

        private final void findActiveAlerts() {
            BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.termQuery((String)"monitor_id", (String)this.request.getMonitorId())).filter((QueryBuilder)QueryBuilders.termsQuery((String)"_id", (Collection)this.request.getAlertIds()));
            String[] stringArray = new String[]{".opendistro-alerting-alerts"};
            SearchRequest searchRequest = new SearchRequest().indices(stringArray).routing(this.request.getMonitorId()).source(new SearchSourceBuilder().query((QueryBuilder)queryBuilder).version(Boolean.valueOf(true)).seqNoAndPrimaryTerm(Boolean.valueOf(true)).size(this.request.getAlertIds().size()));
            this.client.search(searchRequest, (ActionListener)new ActionListener<SearchResponse>(this){
                final /* synthetic */ AcknowledgeHandler this$0;
                {
                    this.this$0 = $receiver;
                }

                public void onResponse(@NotNull SearchResponse response2) {
                    Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                    AcknowledgeHandler.access$onSearchResponse(this.this$0, response2);
                }

                public void onFailure(@NotNull Exception t) {
                    Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                    AcknowledgeHandler.access$getActionListener$p(this.this$0).onFailure((Exception)AlertingException.Companion.wrap(t));
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        private final void onSearchResponse(SearchResponse response2) {
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv;
            Object object = response2.getHits();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"response.hits");
            object = (Iterable)object;
            TransportAcknowledgeAlertAction transportAcknowledgeAlertAction = TransportAcknowledgeAlertAction.this;
            boolean $i$f$flatMap22 = false;
            void var6_7 = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                List list;
                SearchHit hit = (SearchHit)element$iv$iv;
                boolean bl = false;
                XContentParser xcp = XContentHelper.createParser((NamedXContentRegistry)transportAcknowledgeAlertAction.getXContentRegistry(), (DeprecationHandler)((DeprecationHandler)LoggingDeprecationHandler.INSTANCE), (BytesReference)hit.getSourceRef(), (XContentType)XContentType.JSON);
                XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.nextToken(), (XContentParser)xcp);
                Intrinsics.checkNotNullExpressionValue((Object)xcp, (String)"xcp");
                Object object2 = hit.getId();
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"hit.id");
                Alert alert = Alert.Companion.parse(xcp, (String)object2, hit.getVersion());
                object2 = this.getAlerts();
                String string = alert.getId();
                object2.put(string, alert);
                if (alert.getState() == Alert.State.ACTIVE) {
                    UpdateRequest updateRequest = new UpdateRequest(".opendistro-alerting-alerts", hit.getId()).routing(this.request.getMonitorId()).setIfSeqNo(hit.getSeqNo()).setIfPrimaryTerm(hit.getPrimaryTerm());
                    object2 = XContentFactory.jsonBuilder().startObject().field("state", Alert.State.ACKNOWLEDGED.toString());
                    Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"jsonBuilder().startObjec\u2026.ACKNOWLEDGED.toString())");
                    list = CollectionsKt.listOf((Object)updateRequest.doc(OpenSearchExtensionsKt.optionalTimeField((XContentBuilder)object2, (String)"acknowledged_time", (Instant)Instant.now()).endObject()));
                } else {
                    list = CollectionsKt.emptyList();
                }
                Iterable list$iv$iv = list;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            List updateRequests = (List)destination$iv$iv;
            $this$flatMap$iv = updateRequests;
            AcknowledgeAlertRequest acknowledgeAlertRequest = this.request;
            Logger logger = TransportAcknowledgeAlertActionKt.access$getLog$p();
            boolean $i$f$map = false;
            void $i$f$flatMap22 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Object element$iv$iv;
                element$iv$iv = (UpdateRequest)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl = false;
                collection.add(it.id());
            }
            collection = (List)destination$iv$iv2;
            logger.info("Acknowledging monitor: " + acknowledgeAlertRequest + ".monitorId, alerts: " + (List)collection);
            BulkRequest bulkRequest = new BulkRequest().add((Iterable)updateRequests).setRefreshPolicy(this.request.getRefreshPolicy());
            this.client.bulk(bulkRequest, (ActionListener)new ActionListener<BulkResponse>(this){
                final /* synthetic */ AcknowledgeHandler this$0;
                {
                    this.this$0 = $receiver;
                }

                public void onResponse(@NotNull BulkResponse response2) {
                    Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                    AcknowledgeHandler.access$onBulkResponse(this.this$0, response2);
                }

                public void onFailure(@NotNull Exception t) {
                    Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                    AcknowledgeHandler.access$getActionListener$p(this.this$0).onFailure((Exception)AlertingException.Companion.wrap(t));
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        private final void onBulkResponse(BulkResponse response2) {
            void var8_11;
            Set missing = CollectionsKt.toMutableSet((Iterable)this.request.getAlertIds());
            List acknowledged = new ArrayList();
            List failed = new ArrayList();
            Object[] $this$forEach$iv = (BulkItemResponse[])this.alerts.values();
            boolean $i$f$forEach = false;
            for (Object t : $this$forEach$iv) {
                Alert it = (Alert)t;
                boolean bl = false;
                if (it.getState() == Alert.State.ACTIVE) continue;
                missing.remove(it.getId());
                failed.add(it);
            }
            $this$forEach$iv = response2.getItems();
            Intrinsics.checkNotNullExpressionValue((Object)$this$forEach$iv, (String)"response.items");
            $this$forEach$iv = $this$forEach$iv;
            $i$f$forEach = false;
            Object[] objectArray = $this$forEach$iv;
            boolean bl = false;
            int n = objectArray.length;
            while (var8_11 < n) {
                BulkItemResponse element$iv = objectArray[var8_11];
                ++var8_11;
                BulkItemResponse item = element$iv;
                boolean bl2 = false;
                missing.remove(item.getId());
                if (item.isFailed()) {
                    Alert alert = this.getAlerts().get(item.getId());
                    Intrinsics.checkNotNull((Object)alert);
                    failed.add(alert);
                    continue;
                }
                Alert alert = this.getAlerts().get(item.getId());
                Intrinsics.checkNotNull((Object)alert);
                acknowledged.add(alert);
            }
            this.actionListener.onResponse((Object)new AcknowledgeAlertResponse(CollectionsKt.toList((Iterable)acknowledged), CollectionsKt.toList((Iterable)failed), CollectionsKt.toList((Iterable)missing)));
        }

        public static final /* synthetic */ void access$onSearchResponse(AcknowledgeHandler $this, SearchResponse response2) {
            $this.onSearchResponse(response2);
        }

        public static final /* synthetic */ ActionListener access$getActionListener$p(AcknowledgeHandler $this) {
            return $this.actionListener;
        }

        public static final /* synthetic */ void access$onBulkResponse(AcknowledgeHandler $this, BulkResponse response2) {
            $this.onBulkResponse(response2);
        }
    }
}

