/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting.resthandler;

import java.io.IOException;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.opensearch.action.ActionListener;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.alerting.AlertingPlugin;
import org.opensearch.alerting.action.IndexEmailGroupAction;
import org.opensearch.alerting.action.IndexEmailGroupRequest;
import org.opensearch.alerting.action.IndexEmailGroupResponse;
import org.opensearch.alerting.model.destination.email.EmailGroup;
import org.opensearch.client.node.NodeClient;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.common.xcontent.XContentParserUtils;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.rest.RestStatus;
import org.opensearch.rest.action.RestResponseListener;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u001e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0016J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0016\u00a8\u0006\u0018"}, d2={"Lorg/opensearch/alerting/resthandler/RestIndexEmailGroupAction;", "Lorg/opensearch/rest/BaseRestHandler;", "()V", "getName", "", "indexEmailGroupResponse", "Lorg/opensearch/rest/action/RestResponseListener;", "Lorg/opensearch/alerting/action/IndexEmailGroupResponse;", "channel", "Lorg/opensearch/rest/RestChannel;", "restMethod", "Lorg/opensearch/rest/RestRequest$Method;", "prepareRequest", "Lorg/opensearch/rest/BaseRestHandler$RestChannelConsumer;", "request", "Lorg/opensearch/rest/RestRequest;", "client", "Lorg/opensearch/client/node/NodeClient;", "replacedRoutes", "", "Lorg/opensearch/rest/RestHandler$ReplacedRoute;", "routes", "", "Lorg/opensearch/rest/RestHandler$Route;", "opensearch-alerting"})
public final class RestIndexEmailGroupAction
extends BaseRestHandler {
    @NotNull
    public String getName() {
        return "index_email_group_action";
    }

    @NotNull
    public List<RestHandler.Route> routes() {
        return CollectionsKt.emptyList();
    }

    @NotNull
    public List<RestHandler.ReplacedRoute> replacedRoutes() {
        Object[] objectArray = new RestHandler.ReplacedRoute[]{new RestHandler.ReplacedRoute(RestRequest.Method.POST, AlertingPlugin.EMAIL_GROUP_BASE_URI, RestRequest.Method.POST, AlertingPlugin.LEGACY_OPENDISTRO_EMAIL_GROUP_BASE_URI), new RestHandler.ReplacedRoute(RestRequest.Method.PUT, AlertingPlugin.EMAIL_GROUP_BASE_URI + "/{emailGroupID}", RestRequest.Method.PUT, AlertingPlugin.LEGACY_OPENDISTRO_EMAIL_GROUP_BASE_URI + "/{emailGroupID}")};
        return CollectionsKt.mutableListOf((Object[])objectArray);
    }

    @NotNull
    protected BaseRestHandler.RestChannelConsumer prepareRequest(@NotNull RestRequest request, @NotNull NodeClient client) throws IOException {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        String id = request.param("emailGroupID", "");
        if (request.method() == RestRequest.Method.PUT && Intrinsics.areEqual((Object)"", (Object)id)) {
            throw new IllegalArgumentException("Missing email group ID");
        }
        XContentParser xcp = request.contentParser();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.nextToken(), (XContentParser)xcp);
        Intrinsics.checkNotNullExpressionValue((Object)xcp, (String)"xcp");
        Intrinsics.checkNotNullExpressionValue((Object)id, (String)"id");
        EmailGroup emailGroup = EmailGroup.Companion.parse$default(EmailGroup.Companion, xcp, id, 0L, 4, null);
        long seqNo = request.paramAsLong("if_seq_no", -2L);
        long primaryTerm = request.paramAsLong("if_primary_term", 0L);
        WriteRequest.RefreshPolicy refreshPolicy = request.hasParam("refresh") ? WriteRequest.RefreshPolicy.parse((String)request.param("refresh")) : WriteRequest.RefreshPolicy.IMMEDIATE;
        Intrinsics.checkNotNullExpressionValue((Object)refreshPolicy, (String)"refreshPolicy");
        RestRequest.Method method = request.method();
        Intrinsics.checkNotNullExpressionValue((Object)method, (String)"request.method()");
        IndexEmailGroupRequest indexEmailGroupRequest = new IndexEmailGroupRequest(id, seqNo, primaryTerm, refreshPolicy, method, emailGroup);
        return arg_0 -> RestIndexEmailGroupAction.prepareRequest$lambda-0(client, indexEmailGroupRequest, this, request, arg_0);
    }

    private final RestResponseListener<IndexEmailGroupResponse> indexEmailGroupResponse(RestChannel channel, RestRequest.Method restMethod) {
        return (RestResponseListener)new RestResponseListener<IndexEmailGroupResponse>(channel, restMethod){
            final /* synthetic */ RestChannel $channel;
            final /* synthetic */ RestRequest.Method $restMethod;
            {
                this.$channel = $channel;
                this.$restMethod = $restMethod;
                super($channel);
            }

            @NotNull
            public RestResponse buildResponse(@NotNull IndexEmailGroupResponse response2) throws Exception {
                Intrinsics.checkNotNullParameter((Object)((Object)response2), (String)"response");
                RestStatus returnStatus = RestStatus.CREATED;
                if (this.$restMethod == RestRequest.Method.PUT) {
                    returnStatus = RestStatus.OK;
                }
                XContentBuilder xContentBuilder = this.$channel.newBuilder();
                Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"channel.newBuilder()");
                XContentBuilder xContentBuilder2 = xContentBuilder;
                xContentBuilder = ToXContent.EMPTY_PARAMS;
                Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"EMPTY_PARAMS");
                BytesRestResponse restResponse = new BytesRestResponse(returnStatus, response2.toXContent(xContentBuilder2, (ToXContent.Params)xContentBuilder));
                if (returnStatus == RestStatus.CREATED) {
                    String location = AlertingPlugin.EMAIL_GROUP_BASE_URI + "/" + response2.getId();
                    restResponse.addHeader("Location", location);
                }
                return (RestResponse)restResponse;
            }
        };
    }

    private static final void prepareRequest$lambda-0(NodeClient $client, IndexEmailGroupRequest $indexEmailGroupRequest, RestIndexEmailGroupAction this$0, RestRequest $request, RestChannel channel) {
        Intrinsics.checkNotNullParameter((Object)$client, (String)"$client");
        Intrinsics.checkNotNullParameter((Object)((Object)$indexEmailGroupRequest), (String)"$indexEmailGroupRequest");
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$request, (String)"$request");
        ActionType actionType = IndexEmailGroupAction.Companion.getINSTANCE();
        ActionRequest actionRequest = $indexEmailGroupRequest;
        Intrinsics.checkNotNullExpressionValue((Object)channel, (String)"channel");
        RestRequest.Method method = $request.method();
        Intrinsics.checkNotNullExpressionValue((Object)method, (String)"request.method()");
        $client.execute(actionType, actionRequest, (ActionListener)this$0.indexEmailGroupResponse(channel, method));
    }
}

