/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting.resthandler;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.opensearch.action.ActionListener;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.alerting.AlertingPlugin;
import org.opensearch.alerting.action.GetDestinationsAction;
import org.opensearch.alerting.action.GetDestinationsRequest;
import org.opensearch.alerting.model.Table;
import org.opensearch.alerting.util.RestHandlerUtilsKt;
import org.opensearch.client.node.NodeClient;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestActions;
import org.opensearch.rest.action.RestToXContentListener;
import org.opensearch.search.fetch.subphase.FetchSourceContext;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0016R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/opensearch/alerting/resthandler/RestGetDestinationsAction;", "Lorg/opensearch/rest/BaseRestHandler;", "()V", "log", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "getName", "", "prepareRequest", "Lorg/opensearch/rest/BaseRestHandler$RestChannelConsumer;", "request", "Lorg/opensearch/rest/RestRequest;", "client", "Lorg/opensearch/client/node/NodeClient;", "replacedRoutes", "", "Lorg/opensearch/rest/RestHandler$ReplacedRoute;", "routes", "", "Lorg/opensearch/rest/RestHandler$Route;", "opensearch-alerting"})
public final class RestGetDestinationsAction
extends BaseRestHandler {
    private final Logger log = LogManager.getLogger(RestGetDestinationsAction.class);

    @NotNull
    public String getName() {
        return "get_destinations_action";
    }

    @NotNull
    public List<RestHandler.Route> routes() {
        return CollectionsKt.emptyList();
    }

    @NotNull
    public List<RestHandler.ReplacedRoute> replacedRoutes() {
        Object[] objectArray = new RestHandler.ReplacedRoute[]{new RestHandler.ReplacedRoute(RestRequest.Method.GET, AlertingPlugin.DESTINATION_BASE_URI + "/{destinationID}", RestRequest.Method.GET, AlertingPlugin.LEGACY_OPENDISTRO_DESTINATION_BASE_URI + "/{destinationID}"), new RestHandler.ReplacedRoute(RestRequest.Method.GET, AlertingPlugin.DESTINATION_BASE_URI, RestRequest.Method.GET, AlertingPlugin.LEGACY_OPENDISTRO_DESTINATION_BASE_URI)};
        return CollectionsKt.mutableListOf((Object[])objectArray);
    }

    @NotNull
    protected BaseRestHandler.RestChannelConsumer prepareRequest(@NotNull RestRequest request, @NotNull NodeClient client) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        this.log.debug(request.method() + " " + request.path());
        String destinationId = request.param("destinationID");
        FetchSourceContext srcContext = RestHandlerUtilsKt.context(request);
        if (request.method() == RestRequest.Method.HEAD) {
            srcContext = FetchSourceContext.DO_NOT_FETCH_SOURCE;
        }
        String sortString = request.param("sortString", "destination.name.keyword");
        String sortOrder = request.param("sortOrder", "asc");
        String missing = request.param("missing");
        int size = request.paramAsInt("size", 20);
        int startIndex = request.paramAsInt("startIndex", 0);
        String searchString = request.param("searchString", "");
        String destinationType = request.param("destinationType", "ALL");
        Intrinsics.checkNotNullExpressionValue((Object)sortOrder, (String)"sortOrder");
        Intrinsics.checkNotNullExpressionValue((Object)sortString, (String)"sortString");
        Table table = new Table(sortOrder, sortString, missing, size, startIndex, searchString);
        long l = RestActions.parseVersion((RestRequest)request);
        Intrinsics.checkNotNullExpressionValue((Object)destinationType, (String)"destinationType");
        GetDestinationsRequest getDestinationsRequest = new GetDestinationsRequest(destinationId, l, srcContext, table, destinationType);
        return arg_0 -> RestGetDestinationsAction.prepareRequest$lambda-0(client, getDestinationsRequest, arg_0);
    }

    private static final void prepareRequest$lambda-0(NodeClient $client, GetDestinationsRequest $getDestinationsRequest, RestChannel channel) {
        Intrinsics.checkNotNullParameter((Object)$client, (String)"$client");
        Intrinsics.checkNotNullParameter((Object)((Object)$getDestinationsRequest), (String)"$getDestinationsRequest");
        $client.execute((ActionType)GetDestinationsAction.Companion.getINSTANCE(), (ActionRequest)$getDestinationsRequest, (ActionListener)new RestToXContentListener(channel));
    }
}

