/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting.model;

import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.alerting.alerts.AlertError;
import org.opensearch.alerting.model.ActionExecutionResult;
import org.opensearch.alerting.model.AggregationResultBucket;
import org.opensearch.alerting.model.BucketLevelTrigger;
import org.opensearch.alerting.model.Monitor;
import org.opensearch.alerting.model.QueryLevelTrigger;
import org.opensearch.alerting.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.io.stream.Writeable;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.common.xcontent.XContentParserUtils;
import org.opensearch.commons.authuser.User;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\"\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\b\u0018\u0000 p2\u00020\u00012\u00020\u0002:\u0002pqBi\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\b\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r\u0012\u000e\b\u0002\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u0012\u000e\b\u0002\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u000f\u0012\b\b\u0002\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\u0002\u0010\u0015Bi\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\b\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r\u0012\u000e\b\u0002\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u0012\u000e\b\u0002\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u000f\u0012\b\b\u0002\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\u0002\u0010\u0017Bq\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\b\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r\u0012\u000e\b\u0002\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u0012\u000e\b\u0002\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u000f\u0012\b\b\u0002\u0010\u0013\u001a\u00020\u0014\u0012\u0006\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\u0002\u0010\u001aB\u000f\b\u0016\u0012\u0006\u0010\u001b\u001a\u00020\u001c\u00a2\u0006\u0002\u0010\u001dB\u00c5\u0001\u0012\b\b\u0002\u0010\u001e\u001a\u00020\r\u0012\b\b\u0002\u0010\u001f\u001a\u00020 \u0012\b\b\u0002\u0010\u0013\u001a\u00020\u0014\u0012\u0006\u0010!\u001a\u00020\r\u0012\u0006\u0010\"\u001a\u00020\r\u0012\u0006\u0010#\u001a\u00020 \u0012\b\u0010$\u001a\u0004\u0018\u00010%\u0012\u0006\u0010&\u001a\u00020\r\u0012\u0006\u0010'\u001a\u00020\r\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\n\b\u0002\u0010(\u001a\u0004\u0018\u00010\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\b\u0012\n\b\u0002\u0010)\u001a\u0004\u0018\u00010\b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r\u0012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u0012\u0006\u0010*\u001a\u00020\r\u0012\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u000f\u0012\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0019\u00a2\u0006\u0002\u0010+J\u0014\u0010G\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010I0HJ\t\u0010J\u001a\u00020\rH\u00c6\u0003J\t\u0010K\u001a\u00020\u000bH\u00c6\u0003J\t\u0010L\u001a\u00020\bH\u00c6\u0003J\u000b\u0010M\u001a\u0004\u0018\u00010\bH\u00c6\u0003J\u000b\u0010N\u001a\u0004\u0018\u00010\bH\u00c6\u0003J\u000b\u0010O\u001a\u0004\u0018\u00010\bH\u00c6\u0003J\u000b\u0010P\u001a\u0004\u0018\u00010\rH\u00c6\u0003J\u000f\u0010Q\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u00c6\u0003J\t\u0010R\u001a\u00020\rH\u00c6\u0003J\u000f\u0010S\u001a\b\u0012\u0004\u0012\u00020\u00120\u000fH\u00c6\u0003J\u000b\u0010T\u001a\u0004\u0018\u00010\u0019H\u00c6\u0003J\t\u0010U\u001a\u00020 H\u00c6\u0003J\t\u0010V\u001a\u00020\u0014H\u00c6\u0003J\t\u0010W\u001a\u00020\rH\u00c6\u0003J\t\u0010X\u001a\u00020\rH\u00c6\u0003J\t\u0010Y\u001a\u00020 H\u00c6\u0003J\u000b\u0010Z\u001a\u0004\u0018\u00010%H\u00c6\u0003J\t\u0010[\u001a\u00020\rH\u00c6\u0003J\t\u0010\\\u001a\u00020\rH\u00c6\u0003J\u00df\u0001\u0010]\u001a\u00020\u00002\b\b\u0002\u0010\u001e\u001a\u00020\r2\b\b\u0002\u0010\u001f\u001a\u00020 2\b\b\u0002\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010!\u001a\u00020\r2\b\b\u0002\u0010\"\u001a\u00020\r2\b\b\u0002\u0010#\u001a\u00020 2\n\b\u0002\u0010$\u001a\u0004\u0018\u00010%2\b\b\u0002\u0010&\u001a\u00020\r2\b\b\u0002\u0010'\u001a\u00020\r2\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010(\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010)\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r2\u000e\b\u0002\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\b\b\u0002\u0010*\u001a\u00020\r2\u000e\b\u0002\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u000f2\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u00c6\u0001J\u0018\u0010^\u001a\u00020_2\u0006\u0010`\u001a\u00020_2\u0006\u0010a\u001a\u00020bH\u0002J\u0013\u0010c\u001a\u00020b2\b\u0010d\u001a\u0004\u0018\u00010IH\u00d6\u0003J\t\u0010e\u001a\u00020\u0014H\u00d6\u0001J\u0006\u0010f\u001a\u00020bJ\t\u0010g\u001a\u00020\rH\u00d6\u0001J\u0018\u0010h\u001a\u00020_2\u0006\u0010`\u001a\u00020_2\u0006\u0010i\u001a\u00020jH\u0016J\u000e\u0010k\u001a\u00020_2\u0006\u0010`\u001a\u00020_J\u0010\u0010l\u001a\u00020m2\u0006\u0010n\u001a\u00020oH\u0016R\u0013\u0010)\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R\u0013\u0010\u0018\u001a\u0004\u0018\u00010\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R\u0013\u0010(\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u0010-R\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u0010/R\u0013\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00105R\u0011\u0010\u001e\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u00105R\u0013\u0010\t\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u0010-R\u0011\u0010!\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u00105R\u0011\u0010\"\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u00105R\u0013\u0010$\u001a\u0004\u0018\u00010%\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u0010;R\u0011\u0010#\u001a\u00020 \u00a2\u0006\b\n\u0000\u001a\u0004\b<\u0010=R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u0010?R\u0011\u0010*\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b@\u00105R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\bA\u0010-R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\bB\u0010CR\u0011\u0010&\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\bD\u00105R\u0011\u0010'\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\bE\u00105R\u0011\u0010\u001f\u001a\u00020 \u00a2\u0006\b\n\u0000\u001a\u0004\bF\u0010=\u00a8\u0006r"}, d2={"Lorg/opensearch/alerting/model/Alert;", "Lorg/opensearch/common/io/stream/Writeable;", "Lorg/opensearch/common/xcontent/ToXContent;", "monitor", "Lorg/opensearch/alerting/model/Monitor;", "trigger", "Lorg/opensearch/alerting/model/QueryLevelTrigger;", "startTime", "Ljava/time/Instant;", "lastNotificationTime", "state", "Lorg/opensearch/alerting/model/Alert$State;", "errorMessage", "", "errorHistory", "", "Lorg/opensearch/alerting/alerts/AlertError;", "actionExecutionResults", "Lorg/opensearch/alerting/model/ActionExecutionResult;", "schemaVersion", "", "(Lorg/opensearch/alerting/model/Monitor;Lorg/opensearch/alerting/model/QueryLevelTrigger;Ljava/time/Instant;Ljava/time/Instant;Lorg/opensearch/alerting/model/Alert$State;Ljava/lang/String;Ljava/util/List;Ljava/util/List;I)V", "Lorg/opensearch/alerting/model/BucketLevelTrigger;", "(Lorg/opensearch/alerting/model/Monitor;Lorg/opensearch/alerting/model/BucketLevelTrigger;Ljava/time/Instant;Ljava/time/Instant;Lorg/opensearch/alerting/model/Alert$State;Ljava/lang/String;Ljava/util/List;Ljava/util/List;I)V", "aggregationResultBucket", "Lorg/opensearch/alerting/model/AggregationResultBucket;", "(Lorg/opensearch/alerting/model/Monitor;Lorg/opensearch/alerting/model/BucketLevelTrigger;Ljava/time/Instant;Ljava/time/Instant;Lorg/opensearch/alerting/model/Alert$State;Ljava/lang/String;Ljava/util/List;Ljava/util/List;ILorg/opensearch/alerting/model/AggregationResultBucket;)V", "sin", "Lorg/opensearch/common/io/stream/StreamInput;", "(Lorg/opensearch/common/io/stream/StreamInput;)V", "id", "version", "", "monitorId", "monitorName", "monitorVersion", "monitorUser", "Lorg/opensearch/commons/authuser/User;", "triggerId", "triggerName", "endTime", "acknowledgedTime", "severity", "(Ljava/lang/String;JILjava/lang/String;Ljava/lang/String;JLorg/opensearch/commons/authuser/User;Ljava/lang/String;Ljava/lang/String;Lorg/opensearch/alerting/model/Alert$State;Ljava/time/Instant;Ljava/time/Instant;Ljava/time/Instant;Ljava/time/Instant;Ljava/lang/String;Ljava/util/List;Ljava/lang/String;Ljava/util/List;Lorg/opensearch/alerting/model/AggregationResultBucket;)V", "getAcknowledgedTime", "()Ljava/time/Instant;", "getActionExecutionResults", "()Ljava/util/List;", "getAggregationResultBucket", "()Lorg/opensearch/alerting/model/AggregationResultBucket;", "getEndTime", "getErrorHistory", "getErrorMessage", "()Ljava/lang/String;", "getId", "getLastNotificationTime", "getMonitorId", "getMonitorName", "getMonitorUser", "()Lorg/opensearch/commons/authuser/User;", "getMonitorVersion", "()J", "getSchemaVersion", "()I", "getSeverity", "getStartTime", "getState", "()Lorg/opensearch/alerting/model/Alert$State;", "getTriggerId", "getTriggerName", "getVersion", "asTemplateArg", "", "", "component1", "component10", "component11", "component12", "component13", "component14", "component15", "component16", "component17", "component18", "component19", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "createXContentBuilder", "Lorg/opensearch/common/xcontent/XContentBuilder;", "builder", "secure", "", "equals", "other", "hashCode", "isAcknowledged", "toString", "toXContent", "params", "Lorg/opensearch/common/xcontent/ToXContent$Params;", "toXContentWithUser", "writeTo", "", "out", "Lorg/opensearch/common/io/stream/StreamOutput;", "Companion", "State", "opensearch-alerting"})
public final class Alert
implements Writeable,
ToXContent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String id;
    private final long version;
    private final int schemaVersion;
    @NotNull
    private final String monitorId;
    @NotNull
    private final String monitorName;
    private final long monitorVersion;
    @Nullable
    private final User monitorUser;
    @NotNull
    private final String triggerId;
    @NotNull
    private final String triggerName;
    @NotNull
    private final State state;
    @NotNull
    private final Instant startTime;
    @Nullable
    private final Instant endTime;
    @Nullable
    private final Instant lastNotificationTime;
    @Nullable
    private final Instant acknowledgedTime;
    @Nullable
    private final String errorMessage;
    @NotNull
    private final List<AlertError> errorHistory;
    @NotNull
    private final String severity;
    @NotNull
    private final List<ActionExecutionResult> actionExecutionResults;
    @Nullable
    private final AggregationResultBucket aggregationResultBucket;
    @NotNull
    public static final String ALERT_ID_FIELD = "id";
    @NotNull
    public static final String SCHEMA_VERSION_FIELD = "schema_version";
    @NotNull
    public static final String ALERT_VERSION_FIELD = "version";
    @NotNull
    public static final String MONITOR_ID_FIELD = "monitor_id";
    @NotNull
    public static final String MONITOR_VERSION_FIELD = "monitor_version";
    @NotNull
    public static final String MONITOR_NAME_FIELD = "monitor_name";
    @NotNull
    public static final String MONITOR_USER_FIELD = "monitor_user";
    @NotNull
    public static final String TRIGGER_ID_FIELD = "trigger_id";
    @NotNull
    public static final String TRIGGER_NAME_FIELD = "trigger_name";
    @NotNull
    public static final String STATE_FIELD = "state";
    @NotNull
    public static final String START_TIME_FIELD = "start_time";
    @NotNull
    public static final String LAST_NOTIFICATION_TIME_FIELD = "last_notification_time";
    @NotNull
    public static final String END_TIME_FIELD = "end_time";
    @NotNull
    public static final String ACKNOWLEDGED_TIME_FIELD = "acknowledged_time";
    @NotNull
    public static final String ERROR_MESSAGE_FIELD = "error_message";
    @NotNull
    public static final String ALERT_HISTORY_FIELD = "alert_history";
    @NotNull
    public static final String SEVERITY_FIELD = "severity";
    @NotNull
    public static final String ACTION_EXECUTION_RESULTS_FIELD = "action_execution_results";
    @NotNull
    public static final String BUCKET_KEYS = "bucket_keys";
    @NotNull
    public static final String PARENTS_BUCKET_PATH = "parent_bucket_path";
    @NotNull
    public static final String NO_ID = "";
    public static final long NO_VERSION = -1L;

    public Alert(@NotNull String id, long version, int schemaVersion, @NotNull String monitorId, @NotNull String monitorName, long monitorVersion, @Nullable User monitorUser, @NotNull String triggerId, @NotNull String triggerName, @NotNull State state, @NotNull Instant startTime, @Nullable Instant endTime, @Nullable Instant lastNotificationTime, @Nullable Instant acknowledgedTime, @Nullable String errorMessage, @NotNull List<AlertError> errorHistory, @NotNull String severity, @NotNull List<ActionExecutionResult> actionExecutionResults, @Nullable AggregationResultBucket aggregationResultBucket) {
        Intrinsics.checkNotNullParameter((Object)id, (String)ALERT_ID_FIELD);
        Intrinsics.checkNotNullParameter((Object)monitorId, (String)"monitorId");
        Intrinsics.checkNotNullParameter((Object)monitorName, (String)"monitorName");
        Intrinsics.checkNotNullParameter((Object)triggerId, (String)"triggerId");
        Intrinsics.checkNotNullParameter((Object)triggerName, (String)"triggerName");
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)STATE_FIELD);
        Intrinsics.checkNotNullParameter((Object)startTime, (String)"startTime");
        Intrinsics.checkNotNullParameter(errorHistory, (String)"errorHistory");
        Intrinsics.checkNotNullParameter((Object)severity, (String)SEVERITY_FIELD);
        Intrinsics.checkNotNullParameter(actionExecutionResults, (String)"actionExecutionResults");
        this.id = id;
        this.version = version;
        this.schemaVersion = schemaVersion;
        this.monitorId = monitorId;
        this.monitorName = monitorName;
        this.monitorVersion = monitorVersion;
        this.monitorUser = monitorUser;
        this.triggerId = triggerId;
        this.triggerName = triggerName;
        this.state = state;
        this.startTime = startTime;
        this.endTime = endTime;
        this.lastNotificationTime = lastNotificationTime;
        this.acknowledgedTime = acknowledgedTime;
        this.errorMessage = errorMessage;
        this.errorHistory = errorHistory;
        this.severity = severity;
        this.actionExecutionResults = actionExecutionResults;
        this.aggregationResultBucket = aggregationResultBucket;
        if (this.errorMessage != null && !(this.state == State.DELETED || this.state == State.ERROR)) {
            boolean bl = false;
            String string = "Attempt to create an alert with an error in state: " + this.getState();
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ Alert(String string, long l, int n, String string2, String string3, long l2, User user, String string4, String string5, State state, Instant instant, Instant instant2, Instant instant3, Instant instant4, String string6, List list, String string7, List list2, AggregationResultBucket aggregationResultBucket, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            string = NO_ID;
        }
        if ((n2 & 2) != 0) {
            l = -1L;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        if ((n2 & 0x800) != 0) {
            instant2 = null;
        }
        if ((n2 & 0x1000) != 0) {
            instant3 = null;
        }
        if ((n2 & 0x2000) != 0) {
            instant4 = null;
        }
        if ((n2 & 0x4000) != 0) {
            string6 = null;
        }
        if ((n2 & 0x40000) != 0) {
            aggregationResultBucket = null;
        }
        this(string, l, n, string2, string3, l2, user, string4, string5, state, instant, instant2, instant3, instant4, string6, list, string7, list2, aggregationResultBucket);
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    public final long getVersion() {
        return this.version;
    }

    public final int getSchemaVersion() {
        return this.schemaVersion;
    }

    @NotNull
    public final String getMonitorId() {
        return this.monitorId;
    }

    @NotNull
    public final String getMonitorName() {
        return this.monitorName;
    }

    public final long getMonitorVersion() {
        return this.monitorVersion;
    }

    @Nullable
    public final User getMonitorUser() {
        return this.monitorUser;
    }

    @NotNull
    public final String getTriggerId() {
        return this.triggerId;
    }

    @NotNull
    public final String getTriggerName() {
        return this.triggerName;
    }

    @NotNull
    public final State getState() {
        return this.state;
    }

    @NotNull
    public final Instant getStartTime() {
        return this.startTime;
    }

    @Nullable
    public final Instant getEndTime() {
        return this.endTime;
    }

    @Nullable
    public final Instant getLastNotificationTime() {
        return this.lastNotificationTime;
    }

    @Nullable
    public final Instant getAcknowledgedTime() {
        return this.acknowledgedTime;
    }

    @Nullable
    public final String getErrorMessage() {
        return this.errorMessage;
    }

    @NotNull
    public final List<AlertError> getErrorHistory() {
        return this.errorHistory;
    }

    @NotNull
    public final String getSeverity() {
        return this.severity;
    }

    @NotNull
    public final List<ActionExecutionResult> getActionExecutionResults() {
        return this.actionExecutionResults;
    }

    @Nullable
    public final AggregationResultBucket getAggregationResultBucket() {
        return this.aggregationResultBucket;
    }

    public Alert(@NotNull Monitor monitor, @NotNull QueryLevelTrigger trigger, @NotNull Instant startTime, @Nullable Instant lastNotificationTime, @NotNull State state, @Nullable String errorMessage, @NotNull List<AlertError> errorHistory, @NotNull List<ActionExecutionResult> actionExecutionResults, int schemaVersion) {
        Intrinsics.checkNotNullParameter((Object)monitor, (String)"monitor");
        Intrinsics.checkNotNullParameter((Object)trigger, (String)"trigger");
        Intrinsics.checkNotNullParameter((Object)startTime, (String)"startTime");
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)STATE_FIELD);
        Intrinsics.checkNotNullParameter(errorHistory, (String)"errorHistory");
        Intrinsics.checkNotNullParameter(actionExecutionResults, (String)"actionExecutionResults");
        String string = monitor.getId();
        String string2 = monitor.getName();
        long l = monitor.getVersion();
        User user = monitor.getUser();
        String string3 = trigger.getId();
        String string4 = trigger.getName();
        String string5 = trigger.getSeverity();
        this(null, 0L, schemaVersion, string, string2, l, user, string3, string4, state, startTime, null, lastNotificationTime, null, errorMessage, errorHistory, string5, actionExecutionResults, null, 10243, null);
    }

    public /* synthetic */ Alert(Monitor monitor, QueryLevelTrigger queryLevelTrigger, Instant instant, Instant instant2, State state, String string, List list, List list2, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x10) != 0) {
            state = State.ACTIVE;
        }
        if ((n2 & 0x20) != 0) {
            string = null;
        }
        if ((n2 & 0x40) != 0) {
            list = new ArrayList();
        }
        if ((n2 & 0x80) != 0) {
            list2 = new ArrayList();
        }
        if ((n2 & 0x100) != 0) {
            n = 0;
        }
        this(monitor, queryLevelTrigger, instant, instant2, state, string, (List<AlertError>)list, (List<ActionExecutionResult>)list2, n);
    }

    public Alert(@NotNull Monitor monitor, @NotNull BucketLevelTrigger trigger, @NotNull Instant startTime, @Nullable Instant lastNotificationTime, @NotNull State state, @Nullable String errorMessage, @NotNull List<AlertError> errorHistory, @NotNull List<ActionExecutionResult> actionExecutionResults, int schemaVersion) {
        Intrinsics.checkNotNullParameter((Object)monitor, (String)"monitor");
        Intrinsics.checkNotNullParameter((Object)trigger, (String)"trigger");
        Intrinsics.checkNotNullParameter((Object)startTime, (String)"startTime");
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)STATE_FIELD);
        Intrinsics.checkNotNullParameter(errorHistory, (String)"errorHistory");
        Intrinsics.checkNotNullParameter(actionExecutionResults, (String)"actionExecutionResults");
        String string = monitor.getId();
        String string2 = monitor.getName();
        long l = monitor.getVersion();
        User user = monitor.getUser();
        String string3 = trigger.getId();
        String string4 = trigger.getName();
        String string5 = trigger.getSeverity();
        this(null, 0L, schemaVersion, string, string2, l, user, string3, string4, state, startTime, null, lastNotificationTime, null, errorMessage, errorHistory, string5, actionExecutionResults, null, 10243, null);
    }

    public /* synthetic */ Alert(Monitor monitor, BucketLevelTrigger bucketLevelTrigger, Instant instant, Instant instant2, State state, String string, List list, List list2, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x10) != 0) {
            state = State.ACTIVE;
        }
        if ((n2 & 0x20) != 0) {
            string = null;
        }
        if ((n2 & 0x40) != 0) {
            list = new ArrayList();
        }
        if ((n2 & 0x80) != 0) {
            list2 = new ArrayList();
        }
        if ((n2 & 0x100) != 0) {
            n = 0;
        }
        this(monitor, bucketLevelTrigger, instant, instant2, state, string, (List<AlertError>)list, (List<ActionExecutionResult>)list2, n);
    }

    public Alert(@NotNull Monitor monitor, @NotNull BucketLevelTrigger trigger, @NotNull Instant startTime, @Nullable Instant lastNotificationTime, @NotNull State state, @Nullable String errorMessage, @NotNull List<AlertError> errorHistory, @NotNull List<ActionExecutionResult> actionExecutionResults, int schemaVersion, @NotNull AggregationResultBucket aggregationResultBucket) {
        Intrinsics.checkNotNullParameter((Object)monitor, (String)"monitor");
        Intrinsics.checkNotNullParameter((Object)trigger, (String)"trigger");
        Intrinsics.checkNotNullParameter((Object)startTime, (String)"startTime");
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)STATE_FIELD);
        Intrinsics.checkNotNullParameter(errorHistory, (String)"errorHistory");
        Intrinsics.checkNotNullParameter(actionExecutionResults, (String)"actionExecutionResults");
        Intrinsics.checkNotNullParameter((Object)aggregationResultBucket, (String)"aggregationResultBucket");
        String string = monitor.getId();
        String string2 = monitor.getName();
        long l = monitor.getVersion();
        User user = monitor.getUser();
        String string3 = trigger.getId();
        String string4 = trigger.getName();
        String string5 = trigger.getSeverity();
        this(null, 0L, schemaVersion, string, string2, l, user, string3, string4, state, startTime, null, lastNotificationTime, null, errorMessage, errorHistory, string5, actionExecutionResults, aggregationResultBucket, 10243, null);
    }

    public /* synthetic */ Alert(Monitor monitor, BucketLevelTrigger bucketLevelTrigger, Instant instant, Instant instant2, State state, String string, List list, List list2, int n, AggregationResultBucket aggregationResultBucket, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x10) != 0) {
            state = State.ACTIVE;
        }
        if ((n2 & 0x20) != 0) {
            string = null;
        }
        if ((n2 & 0x40) != 0) {
            list = new ArrayList();
        }
        if ((n2 & 0x80) != 0) {
            list2 = new ArrayList();
        }
        if ((n2 & 0x100) != 0) {
            n = 0;
        }
        this(monitor, bucketLevelTrigger, instant, instant2, state, string, list, list2, n, aggregationResultBucket);
    }

    public Alert(@NotNull StreamInput sin) throws IOException {
        Intrinsics.checkNotNullParameter((Object)sin, (String)"sin");
        Object object = sin.readString();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"sin.readString()");
        String string = object;
        long l = sin.readLong();
        int n = sin.readInt();
        object = sin.readString();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"sin.readString()");
        String string2 = object;
        object = sin.readString();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"sin.readString()");
        String string3 = object;
        long l2 = sin.readLong();
        User user = sin.readBoolean() ? new User(sin) : null;
        object = sin.readString();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"sin.readString()");
        String string4 = object;
        object = sin.readString();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"sin.readString()");
        String string5 = object;
        object = sin.readEnum(State.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"sin.readEnum(State::class.java)");
        State state = (State)((Object)object);
        object = sin.readInstant();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"sin.readInstant()");
        Object object2 = object;
        Instant instant = sin.readOptionalInstant();
        Instant instant2 = sin.readOptionalInstant();
        Instant instant3 = sin.readOptionalInstant();
        String string6 = sin.readOptionalString();
        object = sin.readList(AlertError::new);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"sin.readList(::AlertError)");
        Object object3 = object;
        object = sin.readString();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"sin.readString()");
        Object object4 = object;
        object = sin.readList(ActionExecutionResult::new);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"sin.readList(::ActionExecutionResult)");
        this(string, l, n, string2, string3, l2, user, string4, string5, state, (Instant)object2, instant, instant2, instant3, string6, (List<AlertError>)object3, (String)object4, (List<ActionExecutionResult>)object, sin.readBoolean() ? new AggregationResultBucket(sin) : null);
    }

    public final boolean isAcknowledged() {
        return this.state == State.ACKNOWLEDGED;
    }

    public void writeTo(@NotNull StreamOutput out) throws IOException {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.writeString(this.id);
        out.writeLong(this.version);
        out.writeInt(this.schemaVersion);
        out.writeString(this.monitorId);
        out.writeString(this.monitorName);
        out.writeLong(this.monitorVersion);
        out.writeBoolean(this.monitorUser != null);
        User user = this.monitorUser;
        if (user != null) {
            user.writeTo(out);
        }
        out.writeString(this.triggerId);
        out.writeString(this.triggerName);
        out.writeEnum((Enum)this.state);
        out.writeInstant(this.startTime);
        out.writeOptionalInstant(this.endTime);
        out.writeOptionalInstant(this.lastNotificationTime);
        out.writeOptionalInstant(this.acknowledgedTime);
        out.writeOptionalString(this.errorMessage);
        out.writeCollection((Collection)this.errorHistory);
        out.writeString(this.severity);
        out.writeCollection((Collection)this.actionExecutionResults);
        if (this.aggregationResultBucket != null) {
            out.writeBoolean(true);
            this.aggregationResultBucket.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
    }

    @NotNull
    public XContentBuilder toXContent(@NotNull XContentBuilder builder, @NotNull ToXContent.Params params) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        return this.createXContentBuilder(builder, true);
    }

    @NotNull
    public final XContentBuilder toXContentWithUser(@NotNull XContentBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        return this.createXContentBuilder(builder, false);
    }

    private final XContentBuilder createXContentBuilder(XContentBuilder builder, boolean secure) {
        builder.startObject().field(ALERT_ID_FIELD, this.id).field(ALERT_VERSION_FIELD, this.version).field(MONITOR_ID_FIELD, this.monitorId).field(SCHEMA_VERSION_FIELD, this.schemaVersion).field(MONITOR_VERSION_FIELD, this.monitorVersion).field(MONITOR_NAME_FIELD, this.monitorName);
        if (!secure) {
            OpenSearchExtensionsKt.optionalUserField((XContentBuilder)builder, (String)MONITOR_USER_FIELD, (User)this.monitorUser);
        }
        Collection $this$toTypedArray$iv = this.errorHistory;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        AlertError[] alertErrorArray = thisCollection$iv.toArray(new AlertError[0]);
        if (alertErrorArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        $this$toTypedArray$iv = this.actionExecutionResults;
        $i$f$toTypedArray = false;
        thisCollection$iv = $this$toTypedArray$iv;
        ActionExecutionResult[] actionExecutionResultArray = thisCollection$iv.toArray(new ActionExecutionResult[0]);
        if (actionExecutionResultArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        XContentBuilder xContentBuilder = builder.field(TRIGGER_ID_FIELD, this.triggerId).field(TRIGGER_NAME_FIELD, this.triggerName).field(STATE_FIELD, (Object)this.state).field(ERROR_MESSAGE_FIELD, this.errorMessage).field(ALERT_HISTORY_FIELD, (Object)alertErrorArray).field(SEVERITY_FIELD, this.severity).field(ACTION_EXECUTION_RESULTS_FIELD, (Object)actionExecutionResultArray);
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"builder.field(TRIGGER_ID\u2026onResults.toTypedArray())");
        OpenSearchExtensionsKt.optionalTimeField((XContentBuilder)OpenSearchExtensionsKt.optionalTimeField((XContentBuilder)OpenSearchExtensionsKt.optionalTimeField((XContentBuilder)OpenSearchExtensionsKt.optionalTimeField((XContentBuilder)xContentBuilder, (String)START_TIME_FIELD, (Instant)this.startTime), (String)LAST_NOTIFICATION_TIME_FIELD, (Instant)this.lastNotificationTime), (String)END_TIME_FIELD, (Instant)this.endTime), (String)ACKNOWLEDGED_TIME_FIELD, (Instant)this.acknowledgedTime);
        AggregationResultBucket aggregationResultBucket = this.aggregationResultBucket;
        if (aggregationResultBucket != null) {
            aggregationResultBucket.innerXContent(builder);
        }
        builder.endObject();
        return builder;
    }

    @NotNull
    public final Map<String, Object> asTemplateArg() {
        String string;
        Pair[] pairArray = new Pair[11];
        Instant instant = this.acknowledgedTime;
        pairArray[0] = TuplesKt.to((Object)ACKNOWLEDGED_TIME_FIELD, (Object)(instant == null ? null : Long.valueOf(instant.toEpochMilli())));
        pairArray[1] = TuplesKt.to((Object)ALERT_ID_FIELD, (Object)this.id);
        pairArray[2] = TuplesKt.to((Object)ALERT_VERSION_FIELD, (Object)this.version);
        Instant instant2 = this.endTime;
        pairArray[3] = TuplesKt.to((Object)END_TIME_FIELD, (Object)(instant2 == null ? null : Long.valueOf(instant2.toEpochMilli())));
        pairArray[4] = TuplesKt.to((Object)ERROR_MESSAGE_FIELD, (Object)this.errorMessage);
        Instant instant3 = this.lastNotificationTime;
        pairArray[5] = TuplesKt.to((Object)LAST_NOTIFICATION_TIME_FIELD, (Object)(instant3 == null ? null : Long.valueOf(instant3.toEpochMilli())));
        pairArray[6] = TuplesKt.to((Object)SEVERITY_FIELD, (Object)this.severity);
        pairArray[7] = TuplesKt.to((Object)START_TIME_FIELD, (Object)this.startTime.toEpochMilli());
        pairArray[8] = TuplesKt.to((Object)STATE_FIELD, (Object)this.state.toString());
        AggregationResultBucket aggregationResultBucket = this.aggregationResultBucket;
        if (aggregationResultBucket == null) {
            string = null;
        } else {
            List<String> list = aggregationResultBucket.getBucketKeys();
            string = list == null ? null : CollectionsKt.joinToString$default((Iterable)list, (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
        }
        pairArray[9] = TuplesKt.to((Object)BUCKET_KEYS, string);
        AggregationResultBucket aggregationResultBucket2 = this.aggregationResultBucket;
        pairArray[10] = TuplesKt.to((Object)PARENTS_BUCKET_PATH, (Object)(aggregationResultBucket2 == null ? null : aggregationResultBucket2.getParentBucketPath()));
        return MapsKt.mapOf((Pair[])pairArray);
    }

    @NotNull
    public final String component1() {
        return this.id;
    }

    public final long component2() {
        return this.version;
    }

    public final int component3() {
        return this.schemaVersion;
    }

    @NotNull
    public final String component4() {
        return this.monitorId;
    }

    @NotNull
    public final String component5() {
        return this.monitorName;
    }

    public final long component6() {
        return this.monitorVersion;
    }

    @Nullable
    public final User component7() {
        return this.monitorUser;
    }

    @NotNull
    public final String component8() {
        return this.triggerId;
    }

    @NotNull
    public final String component9() {
        return this.triggerName;
    }

    @NotNull
    public final State component10() {
        return this.state;
    }

    @NotNull
    public final Instant component11() {
        return this.startTime;
    }

    @Nullable
    public final Instant component12() {
        return this.endTime;
    }

    @Nullable
    public final Instant component13() {
        return this.lastNotificationTime;
    }

    @Nullable
    public final Instant component14() {
        return this.acknowledgedTime;
    }

    @Nullable
    public final String component15() {
        return this.errorMessage;
    }

    @NotNull
    public final List<AlertError> component16() {
        return this.errorHistory;
    }

    @NotNull
    public final String component17() {
        return this.severity;
    }

    @NotNull
    public final List<ActionExecutionResult> component18() {
        return this.actionExecutionResults;
    }

    @Nullable
    public final AggregationResultBucket component19() {
        return this.aggregationResultBucket;
    }

    @NotNull
    public final Alert copy(@NotNull String id, long version, int schemaVersion, @NotNull String monitorId, @NotNull String monitorName, long monitorVersion, @Nullable User monitorUser, @NotNull String triggerId, @NotNull String triggerName, @NotNull State state, @NotNull Instant startTime, @Nullable Instant endTime, @Nullable Instant lastNotificationTime, @Nullable Instant acknowledgedTime, @Nullable String errorMessage, @NotNull List<AlertError> errorHistory, @NotNull String severity, @NotNull List<ActionExecutionResult> actionExecutionResults, @Nullable AggregationResultBucket aggregationResultBucket) {
        Intrinsics.checkNotNullParameter((Object)id, (String)ALERT_ID_FIELD);
        Intrinsics.checkNotNullParameter((Object)monitorId, (String)"monitorId");
        Intrinsics.checkNotNullParameter((Object)monitorName, (String)"monitorName");
        Intrinsics.checkNotNullParameter((Object)triggerId, (String)"triggerId");
        Intrinsics.checkNotNullParameter((Object)triggerName, (String)"triggerName");
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)STATE_FIELD);
        Intrinsics.checkNotNullParameter((Object)startTime, (String)"startTime");
        Intrinsics.checkNotNullParameter(errorHistory, (String)"errorHistory");
        Intrinsics.checkNotNullParameter((Object)severity, (String)SEVERITY_FIELD);
        Intrinsics.checkNotNullParameter(actionExecutionResults, (String)"actionExecutionResults");
        return new Alert(id, version, schemaVersion, monitorId, monitorName, monitorVersion, monitorUser, triggerId, triggerName, state, startTime, endTime, lastNotificationTime, acknowledgedTime, errorMessage, errorHistory, severity, actionExecutionResults, aggregationResultBucket);
    }

    public static /* synthetic */ Alert copy$default(Alert alert, String string, long l, int n, String string2, String string3, long l2, User user, String string4, String string5, State state, Instant instant, Instant instant2, Instant instant3, Instant instant4, String string6, List list, String string7, List list2, AggregationResultBucket aggregationResultBucket, int n2, Object object) {
        if ((n2 & 1) != 0) {
            string = alert.id;
        }
        if ((n2 & 2) != 0) {
            l = alert.version;
        }
        if ((n2 & 4) != 0) {
            n = alert.schemaVersion;
        }
        if ((n2 & 8) != 0) {
            string2 = alert.monitorId;
        }
        if ((n2 & 0x10) != 0) {
            string3 = alert.monitorName;
        }
        if ((n2 & 0x20) != 0) {
            l2 = alert.monitorVersion;
        }
        if ((n2 & 0x40) != 0) {
            user = alert.monitorUser;
        }
        if ((n2 & 0x80) != 0) {
            string4 = alert.triggerId;
        }
        if ((n2 & 0x100) != 0) {
            string5 = alert.triggerName;
        }
        if ((n2 & 0x200) != 0) {
            state = alert.state;
        }
        if ((n2 & 0x400) != 0) {
            instant = alert.startTime;
        }
        if ((n2 & 0x800) != 0) {
            instant2 = alert.endTime;
        }
        if ((n2 & 0x1000) != 0) {
            instant3 = alert.lastNotificationTime;
        }
        if ((n2 & 0x2000) != 0) {
            instant4 = alert.acknowledgedTime;
        }
        if ((n2 & 0x4000) != 0) {
            string6 = alert.errorMessage;
        }
        if ((n2 & 0x8000) != 0) {
            list = alert.errorHistory;
        }
        if ((n2 & 0x10000) != 0) {
            string7 = alert.severity;
        }
        if ((n2 & 0x20000) != 0) {
            list2 = alert.actionExecutionResults;
        }
        if ((n2 & 0x40000) != 0) {
            aggregationResultBucket = alert.aggregationResultBucket;
        }
        return alert.copy(string, l, n, string2, string3, l2, user, string4, string5, state, instant, instant2, instant3, instant4, string6, list, string7, list2, aggregationResultBucket);
    }

    @NotNull
    public String toString() {
        return "Alert(id=" + this.id + ", version=" + this.version + ", schemaVersion=" + this.schemaVersion + ", monitorId=" + this.monitorId + ", monitorName=" + this.monitorName + ", monitorVersion=" + this.monitorVersion + ", monitorUser=" + this.monitorUser + ", triggerId=" + this.triggerId + ", triggerName=" + this.triggerName + ", state=" + this.state + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", lastNotificationTime=" + this.lastNotificationTime + ", acknowledgedTime=" + this.acknowledgedTime + ", errorMessage=" + this.errorMessage + ", errorHistory=" + this.errorHistory + ", severity=" + this.severity + ", actionExecutionResults=" + this.actionExecutionResults + ", aggregationResultBucket=" + this.aggregationResultBucket + ")";
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = result * 31 + Long.hashCode(this.version);
        result = result * 31 + Integer.hashCode(this.schemaVersion);
        result = result * 31 + this.monitorId.hashCode();
        result = result * 31 + this.monitorName.hashCode();
        result = result * 31 + Long.hashCode(this.monitorVersion);
        result = result * 31 + (this.monitorUser == null ? 0 : this.monitorUser.hashCode());
        result = result * 31 + this.triggerId.hashCode();
        result = result * 31 + this.triggerName.hashCode();
        result = result * 31 + this.state.hashCode();
        result = result * 31 + this.startTime.hashCode();
        result = result * 31 + (this.endTime == null ? 0 : this.endTime.hashCode());
        result = result * 31 + (this.lastNotificationTime == null ? 0 : this.lastNotificationTime.hashCode());
        result = result * 31 + (this.acknowledgedTime == null ? 0 : this.acknowledgedTime.hashCode());
        result = result * 31 + (this.errorMessage == null ? 0 : this.errorMessage.hashCode());
        result = result * 31 + ((Object)this.errorHistory).hashCode();
        result = result * 31 + this.severity.hashCode();
        result = result * 31 + ((Object)this.actionExecutionResults).hashCode();
        result = result * 31 + (this.aggregationResultBucket == null ? 0 : this.aggregationResultBucket.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Alert)) {
            return false;
        }
        Alert alert = (Alert)other;
        if (!Intrinsics.areEqual((Object)this.id, (Object)alert.id)) {
            return false;
        }
        if (this.version != alert.version) {
            return false;
        }
        if (this.schemaVersion != alert.schemaVersion) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.monitorId, (Object)alert.monitorId)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.monitorName, (Object)alert.monitorName)) {
            return false;
        }
        if (this.monitorVersion != alert.monitorVersion) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.monitorUser, (Object)alert.monitorUser)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.triggerId, (Object)alert.triggerId)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.triggerName, (Object)alert.triggerName)) {
            return false;
        }
        if (this.state != alert.state) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.startTime, (Object)alert.startTime)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.endTime, (Object)alert.endTime)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.lastNotificationTime, (Object)alert.lastNotificationTime)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.acknowledgedTime, (Object)alert.acknowledgedTime)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.errorMessage, (Object)alert.errorMessage)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.errorHistory, alert.errorHistory)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.severity, (Object)alert.severity)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.actionExecutionResults, alert.actionExecutionResults)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.aggregationResultBucket, (Object)alert.aggregationResultBucket);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Alert parse(@NotNull XContentParser xcp, @NotNull String id, long version) throws IOException {
        return Companion.parse(xcp, id, version);
    }

    @JvmStatic
    @NotNull
    public static final Alert readFrom(@NotNull StreamInput sin) throws IOException {
        return Companion.readFrom(sin);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Alert parse(@NotNull XContentParser xcp, @NotNull String id) throws IOException {
        return Companion.parse(xcp, id);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Alert parse(@NotNull XContentParser xcp) throws IOException {
        return Companion.parse(xcp);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lorg/opensearch/alerting/model/Alert$State;", "", "(Ljava/lang/String;I)V", "ACTIVE", "ACKNOWLEDGED", "COMPLETED", "ERROR", "DELETED", "opensearch-alerting"})
    public static final class State
    extends Enum<State> {
        public static final /* enum */ State ACTIVE = new State();
        public static final /* enum */ State ACKNOWLEDGED = new State();
        public static final /* enum */ State COMPLETED = new State();
        public static final /* enum */ State ERROR = new State();
        public static final /* enum */ State DELETED = new State();
        private static final /* synthetic */ State[] $VALUES;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String value) {
            return Enum.valueOf(State.class, value);
        }

        static {
            $VALUES = stateArray = new State[]{State.ACTIVE, State.ACKNOWLEDGED, State.COMPLETED, State.ERROR, State.DELETED};
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\b\b\u0002\u0010\u001f\u001a\u00020\u00042\b\b\u0002\u0010 \u001a\u00020\u0013H\u0007J\u0010\u0010!\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020#H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/opensearch/alerting/model/Alert$Companion;", "", "()V", "ACKNOWLEDGED_TIME_FIELD", "", "ACTION_EXECUTION_RESULTS_FIELD", "ALERT_HISTORY_FIELD", "ALERT_ID_FIELD", "ALERT_VERSION_FIELD", "BUCKET_KEYS", "END_TIME_FIELD", "ERROR_MESSAGE_FIELD", "LAST_NOTIFICATION_TIME_FIELD", "MONITOR_ID_FIELD", "MONITOR_NAME_FIELD", "MONITOR_USER_FIELD", "MONITOR_VERSION_FIELD", "NO_ID", "NO_VERSION", "", "PARENTS_BUCKET_PATH", "SCHEMA_VERSION_FIELD", "SEVERITY_FIELD", "START_TIME_FIELD", "STATE_FIELD", "TRIGGER_ID_FIELD", "TRIGGER_NAME_FIELD", "parse", "Lorg/opensearch/alerting/model/Alert;", "xcp", "Lorg/opensearch/common/xcontent/XContentParser;", "id", "version", "readFrom", "sin", "Lorg/opensearch/common/io/stream/StreamInput;", "opensearch-alerting"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Alert parse(@NotNull XContentParser xcp, @NotNull String id, long version) throws IOException {
            String string;
            Object object;
            Intrinsics.checkNotNullParameter((Object)xcp, (String)"xcp");
            Intrinsics.checkNotNullParameter((Object)id, (String)Alert.ALERT_ID_FIELD);
            String monitorId = null;
            int schemaVersion = 0;
            String monitorName = null;
            long monitorVersion = -1L;
            User monitorUser = null;
            String triggerId = null;
            String triggerName = null;
            State state = null;
            Instant startTime = null;
            String severity = null;
            Instant endTime = null;
            Instant lastNotificationTime = null;
            Instant acknowledgedTime = null;
            String errorMessage = null;
            List errorHistory = new ArrayList();
            List actionExecutionResults = new ArrayList();
            AggregationResultBucket aggAlertBucket = null;
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
            while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
                String fieldName = xcp.currentName();
                xcp.nextToken();
                String string2 = fieldName;
                if (string2 == null) continue;
                int n = -1;
                switch (string2.hashCode()) {
                    case 1505271864: {
                        if (string2.equals(Alert.LAST_NOTIFICATION_TIME_FIELD)) {
                            n = 1;
                        }
                        break;
                    }
                    case -1938755376: {
                        if (string2.equals(Alert.ERROR_MESSAGE_FIELD)) {
                            n = 2;
                        }
                        break;
                    }
                    case 1478300413: {
                        if (string2.equals(Alert.SEVERITY_FIELD)) {
                            n = 3;
                        }
                        break;
                    }
                    case 1852079648: {
                        if (string2.equals(Alert.MONITOR_ID_FIELD)) {
                            n = 4;
                        }
                        break;
                    }
                    case -516454669: {
                        if (string2.equals(Alert.MONITOR_VERSION_FIELD)) {
                            n = 5;
                        }
                        break;
                    }
                    case -589289628: {
                        if (string2.equals(Alert.ACKNOWLEDGED_TIME_FIELD)) {
                            n = 6;
                        }
                        break;
                    }
                    case 1757600774: {
                        if (string2.equals(Alert.ACTION_EXECUTION_RESULTS_FIELD)) {
                            n = 7;
                        }
                        break;
                    }
                    case 408418481: {
                        if (string2.equals(Alert.ALERT_HISTORY_FIELD)) {
                            n = 8;
                        }
                        break;
                    }
                    case 1363517698: {
                        if (string2.equals(Alert.TRIGGER_ID_FIELD)) {
                            n = 9;
                        }
                        break;
                    }
                    case 1725551537: {
                        if (string2.equals(Alert.END_TIME_FIELD)) {
                            n = 10;
                        }
                        break;
                    }
                    case 1685208536: {
                        if (string2.equals("agg_alert_content")) {
                            n = 11;
                        }
                        break;
                    }
                    case 1732230736: {
                        if (string2.equals(Alert.MONITOR_NAME_FIELD)) {
                            n = 12;
                        }
                        break;
                    }
                    case 1684719674: {
                        if (string2.equals(Alert.SCHEMA_VERSION_FIELD)) {
                            n = 13;
                        }
                        break;
                    }
                    case 375632050: {
                        if (string2.equals(Alert.TRIGGER_NAME_FIELD)) {
                            n = 14;
                        }
                        break;
                    }
                    case -1573145462: {
                        if (string2.equals(Alert.START_TIME_FIELD)) {
                            n = 15;
                        }
                        break;
                    }
                    case 1732456336: {
                        if (string2.equals(Alert.MONITOR_USER_FIELD)) {
                            n = 16;
                        }
                        break;
                    }
                    case 109757585: {
                        if (string2.equals(Alert.STATE_FIELD)) {
                            n = 17;
                        }
                        break;
                    }
                }
                switch (n) {
                    case 4: {
                        String string3 = xcp.text();
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"xcp.text()");
                        monitorId = string3;
                        break;
                    }
                    case 13: {
                        schemaVersion = xcp.intValue();
                        break;
                    }
                    case 12: {
                        String string3 = xcp.text();
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"xcp.text()");
                        monitorName = string3;
                        break;
                    }
                    case 5: {
                        monitorVersion = xcp.longValue();
                        break;
                    }
                    case 16: {
                        monitorUser = xcp.currentToken() == XContentParser.Token.VALUE_NULL ? null : User.parse((XContentParser)xcp);
                        break;
                    }
                    case 9: {
                        String string3 = xcp.text();
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"xcp.text()");
                        triggerId = string3;
                        break;
                    }
                    case 17: {
                        String string3 = xcp.text();
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"xcp.text()");
                        state = State.valueOf(string3);
                        break;
                    }
                    case 14: {
                        String string3 = xcp.text();
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"xcp.text()");
                        triggerName = string3;
                        break;
                    }
                    case 15: {
                        if (OpenSearchExtensionsKt.instant((XContentParser)xcp) == null) {
                            String string4 = "Required value was null.";
                            throw new IllegalArgumentException(string4.toString());
                        }
                        break;
                    }
                    case 10: {
                        endTime = OpenSearchExtensionsKt.instant((XContentParser)xcp);
                        break;
                    }
                    case 1: {
                        lastNotificationTime = OpenSearchExtensionsKt.instant((XContentParser)xcp);
                        break;
                    }
                    case 6: {
                        acknowledgedTime = OpenSearchExtensionsKt.instant((XContentParser)xcp);
                        break;
                    }
                    case 2: {
                        errorMessage = xcp.textOrNull();
                        break;
                    }
                    case 8: {
                        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                        while (xcp.nextToken() != XContentParser.Token.END_ARRAY) {
                            errorHistory.add(AlertError.Companion.parse(xcp));
                        }
                        break;
                    }
                    case 3: {
                        String string3 = xcp.text();
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"xcp.text()");
                        severity = string3;
                        break;
                    }
                    case 7: {
                        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                        while (xcp.nextToken() != XContentParser.Token.END_ARRAY) {
                            actionExecutionResults.add(ActionExecutionResult.Companion.parse(xcp));
                        }
                        break;
                    }
                    case 11: {
                        aggAlertBucket = xcp.currentToken() == XContentParser.Token.VALUE_NULL ? (AggregationResultBucket)null : AggregationResultBucket.Companion.parse(xcp);
                    }
                }
            }
            String string5 = monitorId;
            if (string5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"monitorId");
                string5 = null;
            }
            String string6 = object = string5;
            String string7 = monitorName;
            if (string7 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"monitorName");
                string7 = null;
            }
            String string8 = object = string7;
            String string9 = triggerId;
            if (string9 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"triggerId");
                string9 = null;
            }
            String string10 = object = string9;
            String string11 = triggerName;
            if (string11 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"triggerName");
                string11 = null;
            }
            String string12 = object = string11;
            State state2 = state;
            if (state2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)Alert.STATE_FIELD);
                state2 = null;
            }
            Object object2 = object = state2;
            Object object3 = startTime;
            if (object3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"startTime");
                object3 = object = null;
            }
            if ((string = severity) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)Alert.SEVERITY_FIELD);
                string = null;
            }
            return new Alert(id, version, schemaVersion, string6, string8, monitorVersion, monitorUser, string10, string12, (State)((Object)object2), (Instant)object, endTime, lastNotificationTime, acknowledgedTime, errorMessage, errorHistory, string, actionExecutionResults, aggAlertBucket);
        }

        public static /* synthetic */ Alert parse$default(Companion companion, XContentParser xContentParser, String string, long l, int n, Object object) throws IOException {
            if ((n & 2) != 0) {
                string = Alert.NO_ID;
            }
            if ((n & 4) != 0) {
                l = -1L;
            }
            return companion.parse(xContentParser, string, l);
        }

        @JvmStatic
        @NotNull
        public final Alert readFrom(@NotNull StreamInput sin) throws IOException {
            Intrinsics.checkNotNullParameter((Object)sin, (String)"sin");
            return new Alert(sin);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Alert parse(@NotNull XContentParser xcp, @NotNull String id) throws IOException {
            Intrinsics.checkNotNullParameter((Object)xcp, (String)"xcp");
            Intrinsics.checkNotNullParameter((Object)id, (String)Alert.ALERT_ID_FIELD);
            return org.opensearch.alerting.model.Alert$Companion.parse$default(this, xcp, id, 0L, 4, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Alert parse(@NotNull XContentParser xcp) throws IOException {
            Intrinsics.checkNotNullParameter((Object)xcp, (String)"xcp");
            return org.opensearch.alerting.model.Alert$Companion.parse$default(this, xcp, null, 0L, 6, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

