/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting.alerts;

import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.net.URL;
import java.nio.charset.Charset;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.Charsets;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.ResourceAlreadyExistsException;
import org.opensearch.action.ActionListener;
import org.opensearch.action.admin.cluster.state.ClusterStateRequest;
import org.opensearch.action.admin.cluster.state.ClusterStateResponse;
import org.opensearch.action.admin.indices.alias.Alias;
import org.opensearch.action.admin.indices.create.CreateIndexRequest;
import org.opensearch.action.admin.indices.create.CreateIndexResponse;
import org.opensearch.action.admin.indices.delete.DeleteIndexRequest;
import org.opensearch.action.admin.indices.exists.indices.IndicesExistsRequest;
import org.opensearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.opensearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.opensearch.action.admin.indices.rollover.RolloverRequest;
import org.opensearch.action.admin.indices.rollover.RolloverResponse;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.action.support.master.AcknowledgedResponse;
import org.opensearch.alerting.alerts.AlertIndices;
import org.opensearch.alerting.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.alerting.settings.AlertingSettings;
import org.opensearch.alerting.util.IndexUtils;
import org.opensearch.client.Client;
import org.opensearch.client.IndicesAdminClient;
import org.opensearch.client.OpenSearchClient;
import org.opensearch.cluster.ClusterChangedEvent;
import org.opensearch.cluster.ClusterStateListener;
import org.opensearch.cluster.metadata.AliasMetadata;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.threadpool.Scheduler;
import org.opensearch.threadpool.ThreadPool;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u0000 A2\u00020\u0001:\u0001AB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0016J%\u0010%\u001a\u00020\f2\u0006\u0010&\u001a\u00020'2\n\b\u0002\u0010(\u001a\u0004\u0018\u00010'H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010)J\u0011\u0010*\u001a\u00020\"H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010+J\u0011\u0010,\u001a\u00020\"H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010+J\u0016\u0010-\u001a\u00020\"2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020'0/H\u0002J\u0016\u00100\u001a\u00020\"2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020'0/H\u0002J\b\u00101\u001a\u00020\"H\u0002J\b\u00102\u001a\u00020'H\u0002J\u0016\u00103\u001a\b\u0012\u0004\u0012\u00020'0/2\u0006\u00104\u001a\u000205H\u0002J\u0006\u00106\u001a\u00020\fJ\u0006\u00107\u001a\u00020\fJ\u0006\u00108\u001a\u00020\"J\u0006\u00109\u001a\u00020\"J\b\u0010:\u001a\u00020\"H\u0002J\b\u0010;\u001a\u00020\"H\u0002J\b\u0010<\u001a\u00020\"H\u0002J\u0018\u0010=\u001a\u00020\"2\u0006\u0010&\u001a\u00020'2\u0006\u0010>\u001a\u00020'H\u0002J#\u0010?\u001a\u00020\"2\u0006\u0010&\u001a\u00020'2\b\b\u0002\u0010(\u001a\u00020\fH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010@R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\r\u001a\n \u000e*\u0004\u0018\u00010\f0\fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n \u000e*\u0004\u0018\u00010\u00120\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0013\u001a\n \u000e*\u0004\u0018\u00010\u00140\u0014X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0015R\u0016\u0010\u0016\u001a\n \u000e*\u0004\u0018\u00010\u00120\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0017\u001a\n \u000e*\u0004\u0018\u00010\u00120\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0019\u001a\u0004\u0018\u00010\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u0016\u0010\u001e\u001a\n \u000e*\u0004\u0018\u00010\u00120\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001f\u001a\u0004\u0018\u00010 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006B"}, d2={"Lorg/opensearch/alerting/alerts/AlertIndices;", "Lorg/opensearch/cluster/ClusterStateListener;", "settings", "Lorg/opensearch/common/settings/Settings;", "client", "Lorg/opensearch/client/Client;", "threadPool", "Lorg/opensearch/threadpool/ThreadPool;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "(Lorg/opensearch/common/settings/Settings;Lorg/opensearch/client/Client;Lorg/opensearch/threadpool/ThreadPool;Lorg/opensearch/cluster/service/ClusterService;)V", "alertIndexInitialized", "", "historyEnabled", "kotlin.jvm.PlatformType", "Ljava/lang/Boolean;", "historyIndexInitialized", "historyMaxAge", "Lorg/opensearch/common/unit/TimeValue;", "historyMaxDocs", "", "Ljava/lang/Long;", "historyRetentionPeriod", "historyRolloverPeriod", "isMaster", "lastRolloverTime", "getLastRolloverTime", "()Lorg/opensearch/common/unit/TimeValue;", "setLastRolloverTime", "(Lorg/opensearch/common/unit/TimeValue;)V", "requestTimeout", "scheduledRollover", "Lorg/opensearch/threadpool/Scheduler$Cancellable;", "clusterChanged", "", "event", "Lorg/opensearch/cluster/ClusterChangedEvent;", "createIndex", "index", "", "alias", "(Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createOrUpdateAlertIndex", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createOrUpdateInitialHistoryIndex", "deleteAllOldHistoryIndices", "indicesToDelete", "", "deleteOldHistoryIndex", "deleteOldHistoryIndices", "executorName", "getIndicesToDelete", "clusterStateResponse", "Lorg/opensearch/action/admin/cluster/state/ClusterStateResponse;", "isHistoryEnabled", "isInitialized", "offMaster", "onMaster", "rescheduleRollover", "rolloverAndDeleteHistoryIndices", "rolloverHistoryIndex", "setIndexUpdateFlag", "targetIndex", "updateIndexMapping", "(Ljava/lang/String;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "opensearch-alerting"})
public final class AlertIndices
implements ClusterStateListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Client client;
    @NotNull
    private final ThreadPool threadPool;
    @NotNull
    private final ClusterService clusterService;
    private volatile Boolean historyEnabled;
    private volatile Long historyMaxDocs;
    private volatile TimeValue historyMaxAge;
    private volatile TimeValue historyRolloverPeriod;
    private volatile TimeValue historyRetentionPeriod;
    private volatile TimeValue requestTimeout;
    private volatile boolean isMaster;
    @Nullable
    private TimeValue lastRolloverTime;
    private boolean historyIndexInitialized;
    private boolean alertIndexInitialized;
    @Nullable
    private Scheduler.Cancellable scheduledRollover;
    @NotNull
    public static final String ALERT_INDEX = ".opendistro-alerting-alerts";
    @NotNull
    public static final String HISTORY_WRITE_INDEX = ".opendistro-alerting-alert-history-write";
    @NotNull
    public static final String HISTORY_ALL = ".opendistro-alerting-alert-history*";
    @NotNull
    public static final String HISTORY_INDEX_PATTERN = "<.opendistro-alerting-alert-history-{now/d}-1>";
    @NotNull
    public static final String ALL_INDEX_PATTERN = ".opendistro-alerting-alert*";
    private static final Logger logger = LogManager.getLogger(AlertIndices.class);

    public AlertIndices(@NotNull Settings settings, @NotNull Client client, @NotNull ThreadPool threadPool, @NotNull ClusterService clusterService) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)threadPool, (String)"threadPool");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        this.client = client;
        this.threadPool = threadPool;
        this.clusterService = clusterService;
        this.clusterService.addListener((ClusterStateListener)this);
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(AlertingSettings.Companion.getALERT_HISTORY_ENABLED(), arg_0 -> AlertIndices._init_$lambda-0(this, arg_0));
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(AlertingSettings.Companion.getALERT_HISTORY_MAX_DOCS(), arg_0 -> AlertIndices._init_$lambda-1(this, arg_0));
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(AlertingSettings.Companion.getALERT_HISTORY_INDEX_MAX_AGE(), arg_0 -> AlertIndices._init_$lambda-2(this, arg_0));
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(AlertingSettings.Companion.getALERT_HISTORY_ROLLOVER_PERIOD(), arg_0 -> AlertIndices._init_$lambda-3(this, arg_0));
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(AlertingSettings.Companion.getALERT_HISTORY_RETENTION_PERIOD(), arg_0 -> AlertIndices._init_$lambda-4(this, arg_0));
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(AlertingSettings.Companion.getREQUEST_TIMEOUT(), arg_0 -> AlertIndices._init_$lambda-5(this, arg_0));
        this.historyEnabled = (Boolean)AlertingSettings.Companion.getALERT_HISTORY_ENABLED().get(settings);
        this.historyMaxDocs = (Long)AlertingSettings.Companion.getALERT_HISTORY_MAX_DOCS().get(settings);
        this.historyMaxAge = (TimeValue)AlertingSettings.Companion.getALERT_HISTORY_INDEX_MAX_AGE().get(settings);
        this.historyRolloverPeriod = (TimeValue)AlertingSettings.Companion.getALERT_HISTORY_ROLLOVER_PERIOD().get(settings);
        this.historyRetentionPeriod = (TimeValue)AlertingSettings.Companion.getALERT_HISTORY_RETENTION_PERIOD().get(settings);
        this.requestTimeout = (TimeValue)AlertingSettings.Companion.getREQUEST_TIMEOUT().get(settings);
    }

    @Nullable
    public final TimeValue getLastRolloverTime() {
        return this.lastRolloverTime;
    }

    public final void setLastRolloverTime(@Nullable TimeValue timeValue) {
        this.lastRolloverTime = timeValue;
    }

    public final void onMaster() {
        try {
            this.rolloverHistoryIndex();
            this.scheduledRollover = this.threadPool.scheduleWithFixedDelay(() -> AlertIndices.onMaster$lambda-6(this), this.historyRolloverPeriod, this.executorName());
        }
        catch (Exception e) {
            logger.error("Error creating alert indices. Alerts can't be recorded until master node is restarted.", (Throwable)e);
        }
    }

    public final void offMaster() {
        Scheduler.Cancellable cancellable = this.scheduledRollover;
        if (cancellable != null) {
            cancellable.cancel();
        }
    }

    private final String executorName() {
        return "management";
    }

    public void clusterChanged(@NotNull ClusterChangedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.isMaster != event.localNodeMaster()) {
            this.isMaster = event.localNodeMaster();
            if (this.isMaster) {
                this.onMaster();
            } else {
                this.offMaster();
            }
        }
        this.alertIndexInitialized = event.state().routingTable().hasIndex(ALERT_INDEX);
        this.historyIndexInitialized = event.state().metadata().hasAlias(HISTORY_WRITE_INDEX);
    }

    private final void rescheduleRollover() {
        if (this.clusterService.state().getNodes().isLocalNodeElectedMaster()) {
            Scheduler.Cancellable cancellable = this.scheduledRollover;
            if (cancellable != null) {
                cancellable.cancel();
            }
            this.scheduledRollover = this.threadPool.scheduleWithFixedDelay(() -> AlertIndices.rescheduleRollover$lambda-7(this), this.historyRolloverPeriod, this.executorName());
        }
    }

    public final boolean isInitialized() {
        return this.alertIndexInitialized && this.historyIndexInitialized;
    }

    public final boolean isHistoryEnabled() {
        Boolean bl = this.historyEnabled;
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"historyEnabled");
        return bl;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object createOrUpdateAlertIndex(@NotNull Continuation<? super Unit> var1_1) {
        if (!(var1_1 instanceof createOrUpdateAlertIndex.1)) ** GOTO lbl-1000
        var4_2 = var1_1;
        if ((var4_2.label & -2147483648) != 0) {
            var4_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ AlertIndices this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.createOrUpdateAlertIndex((Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var5_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (this.alertIndexInitialized) break;
                var2_5 = this;
                $continuation.L$0 = this;
                $continuation.L$1 = var2_5;
                $continuation.label = 1;
                v0 = AlertIndices.createIndex$default(this, ".opendistro-alerting-alerts", null, (Continuation)$continuation, 2, null);
                if (v0 == var5_4) {
                    return var5_4;
                }
                ** GOTO lbl26
            }
            case 1: {
                var2_5 = (AlertIndices)$continuation.L$1;
                this = (AlertIndices)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl26:
                // 2 sources

                var2_5.alertIndexInitialized = (Boolean)v0;
                if (this.alertIndexInitialized) {
                    IndexUtils.Companion.alertIndexUpdated();
                }
                ** GOTO lbl42
            }
        }
        if (!IndexUtils.Companion.getAlertIndexUpdated()) {
            $continuation.L$0 = this;
            $continuation.label = 2;
            v1 = AlertIndices.updateIndexMapping$default(this, ".opendistro-alerting-alerts", false, (Continuation)$continuation, 2, null);
            if (v1 == var5_4) {
                return var5_4;
            }
        }
        ** GOTO lbl42
        {
            case 2: {
                this = (AlertIndices)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl42:
                // 3 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object createOrUpdateInitialHistoryIndex(@NotNull Continuation<? super Unit> var1_1) {
        if (!(var1_1 instanceof createOrUpdateInitialHistoryIndex.1)) ** GOTO lbl-1000
        var5_2 = var1_1;
        if ((var5_2.label & -2147483648) != 0) {
            var5_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ AlertIndices this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.createOrUpdateInitialHistoryIndex((Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var6_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (this.historyIndexInitialized) break;
                var3_5 = this;
                $continuation.L$0 = this;
                $continuation.L$1 = var3_5;
                $continuation.label = 1;
                v0 = this.createIndex("<.opendistro-alerting-alert-history-{now/d}-1>", ".opendistro-alerting-alert-history-write", (Continuation<? super Boolean>)$continuation);
                if (v0 == var6_4) {
                    return var6_4;
                }
                ** GOTO lbl26
            }
            case 1: {
                var3_5 = (AlertIndices)$continuation.L$1;
                this = (AlertIndices)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl26:
                // 2 sources

                var3_5.historyIndexInitialized = (Boolean)v0;
                if (this.historyIndexInitialized) {
                    var2_6 = this.clusterService.state();
                    Intrinsics.checkNotNullExpressionValue((Object)var2_6, (String)"clusterService.state()");
                    IndexUtils.Companion.setLastUpdatedHistoryIndex(IndexUtils.Companion.getIndexNameWithAlias(var2_6, ".opendistro-alerting-alert-history-write"));
                }
                ** GOTO lbl43
            }
        }
        $continuation.L$0 = this;
        $continuation.label = 2;
        v1 = this.updateIndexMapping(".opendistro-alerting-alert-history-write", true, (Continuation<? super Unit>)$continuation);
        if (v1 == var6_4) {
            return var6_4;
        }
        ** GOTO lbl43
        {
            case 2: {
                this = (AlertIndices)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl43:
                // 3 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object createIndex(String var1_1, String var2_2, Continuation<? super Boolean> var3_3) {
        if (!(var3_3 instanceof createIndex.1)) ** GOTO lbl-1000
        var9_4 = var3_3;
        if ((var9_4.label & -2147483648) != 0) {
            var9_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ AlertIndices this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return AlertIndices.access$createIndex(this.this$0, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var10_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = this;
                $continuation.L$1 = index;
                $continuation.L$2 = alias;
                $continuation.label = 1;
                v0 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)((OpenSearchClient)this.client.admin().indices()), (Function2)((Function2)new Function2<IndicesAdminClient, ActionListener<IndicesExistsResponse>, Unit>(index){
                    final /* synthetic */ String $index;
                    {
                        this.$index = $index;
                        super(2);
                    }

                    public final void invoke(IndicesAdminClient $this$suspendUntil, @NotNull ActionListener<IndicesExistsResponse> it) {
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        String[] stringArray = new String[]{this.$index};
                        $this$suspendUntil.exists((IndicesExistsRequest)new IndicesExistsRequest(stringArray).local(true), it);
                    }
                }), (Continuation)$continuation);
                if (v0 == var10_6) {
                    return var10_6;
                }
                ** GOTO lbl26
            }
            case 1: {
                alias = (String)$continuation.L$2;
                index = (String)$continuation.L$1;
                this = (AlertIndices)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl26:
                // 2 sources

                if ((existsResponse = (IndicesExistsResponse)v0).isExists()) {
                    return Boxing.boxBoolean((boolean)true);
                }
                request = new CreateIndexRequest(index).mapping(AlertIndices.Companion.alertMapping()).settings(Settings.builder().put("index.hidden", true).build());
                if (alias != null) {
                    request.alias(new Alias(alias));
                }
                $continuation.L$0 = null;
                $continuation.L$1 = null;
                $continuation.L$2 = null;
                $continuation.label = 2;
                v1 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)((OpenSearchClient)this.client.admin().indices()), (Function2)((Function2)new Function2<IndicesAdminClient, ActionListener<CreateIndexResponse>, Unit>(request){
                    final /* synthetic */ CreateIndexRequest $request;
                    {
                        this.$request = $request;
                        super(2);
                    }

                    public final void invoke(IndicesAdminClient $this$suspendUntil, @NotNull ActionListener<CreateIndexResponse> it) {
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        $this$suspendUntil.create(this.$request, it);
                    }
                }), (Continuation)$continuation);
                ** if (v1 != var10_6) goto lbl41
lbl40:
                // 1 sources

                return var10_6;
lbl41:
                // 1 sources

                ** GOTO lbl47
            }
            case 2: {
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl47:
                    // 2 sources

                    createIndexResponse = (CreateIndexResponse)v1;
                    var6_10 = createIndexResponse.isAcknowledged();
                }
                catch (ResourceAlreadyExistsException var7_11) {
                    var6_10 = true;
                }
                return Boxing.boxBoolean((boolean)(var6_10 != false));
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    static /* synthetic */ Object createIndex$default(AlertIndices alertIndices, String string, String string2, Continuation continuation, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return alertIndices.createIndex(string, string2, (Continuation<? super Boolean>)continuation);
    }

    /*
     * Unable to fully structure code
     */
    private final Object updateIndexMapping(String var1_1, boolean var2_2, Continuation<? super Unit> var3_3) {
        if (!(var3_3 instanceof updateIndexMapping.1)) ** GOTO lbl-1000
        var11_4 = var3_3;
        if ((var11_4.label & -2147483648) != 0) {
            var11_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ AlertIndices this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return AlertIndices.access$updateIndexMapping(this.this$0, null, false, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var12_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                clusterState = this.clusterService.state();
                mapping = AlertIndices.Companion.alertMapping();
                targetIndex = index;
                if (alias != false) {
                    Intrinsics.checkNotNullExpressionValue((Object)clusterState, (String)"clusterState");
                    targetIndex = IndexUtils.Companion.getIndexNameWithAlias(clusterState, index);
                }
                if (Intrinsics.areEqual((Object)targetIndex, (Object)IndexUtils.Companion.getLastUpdatedHistoryIndex())) {
                    return Unit.INSTANCE;
                }
                putMappingRequest = new Ref.ObjectRef();
                var9_11 = new String[]{targetIndex};
                var8_12 = new PutMappingRequest(var9_11).source(mapping, XContentType.JSON);
                Intrinsics.checkNotNullExpressionValue((Object)var8_12, (String)"PutMappingRequest(target\u2026pping, XContentType.JSON)");
                putMappingRequest.element = var8_12;
                $continuation.L$0 = this;
                $continuation.L$1 = index;
                $continuation.L$2 = targetIndex;
                $continuation.label = 1;
                v0 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)((OpenSearchClient)this.client.admin().indices()), (Function2)((Function2)new Function2<IndicesAdminClient, ActionListener<AcknowledgedResponse>, Unit>((Ref.ObjectRef<PutMappingRequest>)putMappingRequest){
                    final /* synthetic */ Ref.ObjectRef<PutMappingRequest> $putMappingRequest;
                    {
                        this.$putMappingRequest = $putMappingRequest;
                        super(2);
                    }

                    public final void invoke(IndicesAdminClient $this$suspendUntil, @NotNull ActionListener<AcknowledgedResponse> it) {
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        $this$suspendUntil.putMapping((PutMappingRequest)this.$putMappingRequest.element, it);
                    }
                }), (Continuation)$continuation);
                if (v0 == var12_6) {
                    return var12_6;
                }
                ** GOTO lbl39
            }
            case 1: {
                targetIndex = (String)$continuation.L$2;
                index = (String)$continuation.L$1;
                this = (AlertIndices)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl39:
                // 2 sources

                if ((updateResponse = (AcknowledgedResponse)v0).isAcknowledged()) {
                    AlertIndices.logger.info("Index mapping of " + targetIndex + " is updated");
                    this.setIndexUpdateFlag(index, targetIndex);
                } else {
                    AlertIndices.logger.info("Failed to update index mapping of " + targetIndex);
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    static /* synthetic */ Object updateIndexMapping$default(AlertIndices alertIndices, String string, boolean bl, Continuation continuation, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return alertIndices.updateIndexMapping(string, bl, (Continuation<? super Unit>)continuation);
    }

    private final void setIndexUpdateFlag(String index, String targetIndex) {
        String string = index;
        if (Intrinsics.areEqual((Object)string, (Object)ALERT_INDEX)) {
            IndexUtils.Companion.alertIndexUpdated();
        } else if (Intrinsics.areEqual((Object)string, (Object)HISTORY_WRITE_INDEX)) {
            IndexUtils.Companion.setLastUpdatedHistoryIndex(targetIndex);
        }
    }

    private final void rolloverAndDeleteHistoryIndices() {
        Boolean bl = this.historyEnabled;
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"historyEnabled");
        if (bl.booleanValue()) {
            this.rolloverHistoryIndex();
        }
        this.deleteOldHistoryIndices();
    }

    private final void rolloverHistoryIndex() {
        if (!this.historyIndexInitialized) {
            return;
        }
        RolloverRequest request = new RolloverRequest(HISTORY_WRITE_INDEX, null);
        request.getCreateIndexRequest().index(HISTORY_INDEX_PATTERN).mapping(Companion.alertMapping()).settings(Settings.builder().put("index.hidden", true).build());
        Long l = this.historyMaxDocs;
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"historyMaxDocs");
        request.addMaxIndexDocsCondition(((Number)l).longValue());
        request.addMaxIndexAgeCondition(this.historyMaxAge);
        this.client.admin().indices().rolloverIndex(request, (ActionListener)new ActionListener<RolloverResponse>(this){
            final /* synthetic */ AlertIndices this$0;
            {
                this.this$0 = $receiver;
            }

            public void onResponse(@NotNull RolloverResponse response2) {
                Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                if (!response2.isRolledOver()) {
                    AlertIndices.access$getLogger$cp().info(".opendistro-alerting-alert-history-write not rolled over. Conditions were: " + response2.getConditionStatus());
                } else {
                    this.this$0.setLastRolloverTime(TimeValue.timeValueMillis((long)AlertIndices.access$getThreadPool$p(this.this$0).absoluteTimeInMillis()));
                }
            }

            public void onFailure(@NotNull Exception e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                AlertIndices.access$getLogger$cp().error(".opendistro-alerting-alert-history-write not roll over failed.");
            }
        });
    }

    private final void deleteOldHistoryIndices() {
        String[] stringArray = new String[]{HISTORY_ALL};
        ClusterStateRequest clusterStateRequest = ((ClusterStateRequest)new ClusterStateRequest().clear().indices(stringArray).metadata(true).local(true)).indicesOptions(IndicesOptions.strictExpand());
        this.client.admin().cluster().state(clusterStateRequest, (ActionListener)new ActionListener<ClusterStateResponse>(this){
            final /* synthetic */ AlertIndices this$0;
            {
                this.this$0 = $receiver;
            }

            public void onResponse(@NotNull ClusterStateResponse clusterStateResponse) {
                Intrinsics.checkNotNullParameter((Object)clusterStateResponse, (String)"clusterStateResponse");
                if (!clusterStateResponse.getState().getMetadata().getIndices().isEmpty()) {
                    List indicesToDelete = AlertIndices.access$getIndicesToDelete(this.this$0, clusterStateResponse);
                    AlertIndices.access$getLogger$cp().info("Deleting old history indices viz " + indicesToDelete);
                    AlertIndices.access$deleteAllOldHistoryIndices(this.this$0, indicesToDelete);
                } else {
                    AlertIndices.access$getLogger$cp().info("No Old History Indices to delete");
                }
            }

            public void onFailure(@NotNull Exception e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                AlertIndices.access$getLogger$cp().error("Error fetching cluster state");
            }
        });
    }

    private final List<String> getIndicesToDelete(ClusterStateResponse clusterStateResponse) {
        List indicesToDelete = new ArrayList();
        for (ObjectObjectCursor entry : clusterStateResponse.getState().getMetadata().getIndices()) {
            Object v0;
            Object object;
            IndexMetadata indexMetaData;
            block3: {
                indexMetaData = (IndexMetadata)entry.value;
                long creationTime = indexMetaData.getCreationDate();
                if (Instant.now().toEpochMilli() - creationTime <= this.historyRetentionPeriod.getMillis()) continue;
                object = indexMetaData.getAliases();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"indexMetaData.aliases");
                Iterable $this$firstOrNull$iv = (Iterable)object;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    ObjectObjectCursor it = (ObjectObjectCursor)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)HISTORY_WRITE_INDEX, (Object)((AliasMetadata)it.value).getAlias())) continue;
                    v0 = element$iv;
                    break block3;
                }
                v0 = null;
            }
            ObjectObjectCursor alias = v0;
            if (alias != null) {
                object = this.historyEnabled;
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"historyEnabled");
                if (((Boolean)object).booleanValue()) continue;
                this.historyIndexInitialized = false;
            }
            object = indexMetaData.getIndex().getName();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"indexMetaData.index.name");
            indicesToDelete.add(object);
        }
        return indicesToDelete;
    }

    private final void deleteAllOldHistoryIndices(List<String> indicesToDelete) {
        if (!((Collection)indicesToDelete).isEmpty()) {
            Collection $this$toTypedArray$iv = indicesToDelete;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            if (stringArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            }
            String[] stringArray2 = stringArray;
            DeleteIndexRequest deleteIndexRequest = new DeleteIndexRequest(Arrays.copyOf(stringArray2, stringArray2.length));
            this.client.admin().indices().delete(deleteIndexRequest, (ActionListener)new ActionListener<AcknowledgedResponse>(indicesToDelete, this){
                final /* synthetic */ List<String> $indicesToDelete;
                final /* synthetic */ AlertIndices this$0;
                {
                    this.$indicesToDelete = $indicesToDelete;
                    this.this$0 = $receiver;
                }

                public void onResponse(@NotNull AcknowledgedResponse deleteIndicesResponse) {
                    Intrinsics.checkNotNullParameter((Object)deleteIndicesResponse, (String)"deleteIndicesResponse");
                    if (!deleteIndicesResponse.isAcknowledged()) {
                        AlertIndices.access$getLogger$cp().error("Could not delete one or more Alerting history indices: " + this.$indicesToDelete + ". Retrying one by one.");
                        AlertIndices.access$deleteOldHistoryIndex(this.this$0, this.$indicesToDelete);
                    }
                }

                public void onFailure(@NotNull Exception e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    AlertIndices.access$getLogger$cp().error("Delete for Alerting History Indices " + this.$indicesToDelete + " Failed. Retrying one By one.");
                    AlertIndices.access$deleteOldHistoryIndex(this.this$0, this.$indicesToDelete);
                }
            });
        }
    }

    private final void deleteOldHistoryIndex(List<String> indicesToDelete) {
        for (String index : indicesToDelete) {
            String[] stringArray;
            Collection $this$toTypedArray$iv = indicesToDelete;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            if (thisCollection$iv.toArray(new String[0]) == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            }
            DeleteIndexRequest singleDeleteRequest = new DeleteIndexRequest(Arrays.copyOf(stringArray, stringArray.length));
            this.client.admin().indices().delete(singleDeleteRequest, (ActionListener)new ActionListener<AcknowledgedResponse>(index){
                final /* synthetic */ String $index;
                {
                    this.$index = $index;
                }

                public void onResponse(@Nullable AcknowledgedResponse acknowledgedResponse) {
                    if (acknowledgedResponse != null && !acknowledgedResponse.isAcknowledged()) {
                        AlertIndices.access$getLogger$cp().error("Could not delete one or more Alerting history indices: " + this.$index);
                    }
                }

                public void onFailure(@NotNull Exception e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    AlertIndices.access$getLogger$cp().debug("Exception " + e.getMessage() + " while deleting the index " + this.$index);
                }
            });
        }
    }

    private static final void _init_$lambda-0(AlertIndices this$0, Boolean it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.historyEnabled = it;
    }

    private static final void _init_$lambda-1(AlertIndices this$0, Long it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.historyMaxDocs = it;
    }

    private static final void _init_$lambda-2(AlertIndices this$0, TimeValue it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.historyMaxAge = it;
    }

    private static final void _init_$lambda-3(AlertIndices this$0, TimeValue it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.historyRolloverPeriod = it;
        this$0.rescheduleRollover();
    }

    private static final void _init_$lambda-4(AlertIndices this$0, TimeValue it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.historyRetentionPeriod = it;
    }

    private static final void _init_$lambda-5(AlertIndices this$0, TimeValue it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.requestTimeout = it;
    }

    private static final void onMaster$lambda-6(AlertIndices this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.rolloverAndDeleteHistoryIndices();
    }

    private static final void rescheduleRollover$lambda-7(AlertIndices this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.rolloverAndDeleteHistoryIndices();
    }

    @JvmStatic
    @NotNull
    public static final String alertMapping() {
        return Companion.alertMapping();
    }

    public static final /* synthetic */ Object access$createIndex(AlertIndices $this, String index, String alias, Continuation $completion) {
        return $this.createIndex(index, alias, (Continuation<? super Boolean>)$completion);
    }

    public static final /* synthetic */ Object access$updateIndexMapping(AlertIndices $this, String index, boolean alias, Continuation $completion) {
        return $this.updateIndexMapping(index, alias, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    public static final /* synthetic */ ThreadPool access$getThreadPool$p(AlertIndices $this) {
        return $this.threadPool;
    }

    public static final /* synthetic */ List access$getIndicesToDelete(AlertIndices $this, ClusterStateResponse clusterStateResponse) {
        return $this.getIndicesToDelete(clusterStateResponse);
    }

    public static final /* synthetic */ void access$deleteAllOldHistoryIndices(AlertIndices $this, List indicesToDelete) {
        $this.deleteAllOldHistoryIndices(indicesToDelete);
    }

    public static final /* synthetic */ void access$deleteOldHistoryIndex(AlertIndices $this, List indicesToDelete) {
        $this.deleteOldHistoryIndex(indicesToDelete);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\f\u001a\u00020\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/opensearch/alerting/alerts/AlertIndices$Companion;", "", "()V", "ALERT_INDEX", "", "ALL_INDEX_PATTERN", "HISTORY_ALL", "HISTORY_INDEX_PATTERN", "HISTORY_WRITE_INDEX", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "alertMapping", "opensearch-alerting"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final String alertMapping() {
            URL uRL = AlertIndices.class.getResource("alert_mapping.json");
            Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"AlertIndices::class.java\u2026rce(\"alert_mapping.json\")");
            Charset charset = Charsets.UTF_8;
            byte[] byArray = TextStreamsKt.readBytes((URL)uRL);
            return new String(byArray, charset);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

