/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.SupervisorKt;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.action.bulk.BackoffPolicy;
import org.opensearch.alerting.AlertService;
import org.opensearch.alerting.InputService;
import org.opensearch.alerting.MonitorRunner;
import org.opensearch.alerting.TriggerService;
import org.opensearch.alerting.alerts.AlertError;
import org.opensearch.alerting.alerts.AlertIndices;
import org.opensearch.alerting.alerts.AlertMoverKt;
import org.opensearch.alerting.core.JobRunner;
import org.opensearch.alerting.core.model.ScheduledJob;
import org.opensearch.alerting.model.ActionExecutionResult;
import org.opensearch.alerting.model.ActionRunResult;
import org.opensearch.alerting.model.Alert;
import org.opensearch.alerting.model.AlertingConfigAccessor;
import org.opensearch.alerting.model.BucketLevelTrigger;
import org.opensearch.alerting.model.BucketLevelTriggerRunResult;
import org.opensearch.alerting.model.InputRunResults;
import org.opensearch.alerting.model.Monitor;
import org.opensearch.alerting.model.MonitorRunResult;
import org.opensearch.alerting.model.QueryLevelTrigger;
import org.opensearch.alerting.model.QueryLevelTriggerRunResult;
import org.opensearch.alerting.model.Trigger;
import org.opensearch.alerting.model.action.Action;
import org.opensearch.alerting.model.action.ActionExecutionScope;
import org.opensearch.alerting.model.action.AlertCategory;
import org.opensearch.alerting.model.action.PerAlertActionScope;
import org.opensearch.alerting.model.action.PerExecutionActionScope;
import org.opensearch.alerting.model.destination.Destination;
import org.opensearch.alerting.model.destination.DestinationContext;
import org.opensearch.alerting.model.destination.DestinationContextFactory;
import org.opensearch.alerting.opensearchapi.InjectorContextElement;
import org.opensearch.alerting.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.alerting.script.BucketLevelTriggerExecutionContext;
import org.opensearch.alerting.script.QueryLevelTriggerExecutionContext;
import org.opensearch.alerting.script.TriggerExecutionContext;
import org.opensearch.alerting.settings.AlertingSettings;
import org.opensearch.alerting.settings.DestinationSettings;
import org.opensearch.alerting.settings.LegacyOpenDistroDestinationSettings;
import org.opensearch.alerting.util.AlertingUtilsKt;
import org.opensearch.alerting.util.AnomalyDetectionUtilsKt;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.Strings;
import org.opensearch.common.component.AbstractLifecycleComponent;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.xcontent.NamedXContentRegistry;
import org.opensearch.script.Script;
import org.opensearch.script.ScriptService;
import org.opensearch.script.TemplateScript;
import org.opensearch.threadpool.ThreadPool;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0092\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u0018\u00100\u001a\u00020\u000b2\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u000204H\u0002J\u0010\u00105\u001a\n \u001e*\u0004\u0018\u00010606H\u0002J0\u00107\u001a\u0002082\u0006\u00109\u001a\u00020\u000b2\u0006\u0010:\u001a\u00020\u000b2\u0006\u0010;\u001a\u00020<2\u000e\u0010=\u001a\n\u0018\u00010>j\u0004\u0018\u0001`?H\u0002J\b\u0010@\u001a\u00020AH\u0014J\b\u0010B\u001a\u00020AH\u0014J\b\u0010C\u001a\u00020AH\u0014J0\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u00020I2\u0006\u00103\u001a\u00020E2\u000e\u0010J\u001a\n\u0018\u00010>j\u0004\u0018\u0001`?H\u0002J\u0016\u0010K\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010L\u001a\u00020MH\u0002J\u001a\u0010N\u001a\u0002082\u0006\u0010O\u001a\u00020P2\b\u0010H\u001a\u0004\u0018\u00010IH\u0002J\u0010\u0010Q\u001a\u00020A2\u0006\u0010R\u001a\u00020\u000bH\u0016J\u0010\u0010S\u001a\u00020A2\u0006\u0010T\u001a\u00020UH\u0016J\u000e\u0010V\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010W\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010X\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010Y\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010Z\u001a\u00020\u0000J\u0006\u0010[\u001a\u00020\u0000J\u000e\u0010\\\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010]\u001a\u00020\u00002\u0006\u0010.\u001a\u00020/J\u000e\u0010^\u001a\u00020\u00002\u0006\u0010&\u001a\u00020'J\u000e\u0010_\u001a\u00020\u00002\u0006\u0010(\u001a\u00020)J\u000e\u0010`\u001a\u00020\u00002\u0006\u0010*\u001a\u00020+J\u000e\u0010a\u001a\u00020\u00002\u0006\u0010,\u001a\u00020-J\u000e\u0010b\u001a\u00020A2\u0006\u0010(\u001a\u00020)J)\u0010c\u001a\u00020d2\u0006\u0010O\u001a\u00020P2\u0006\u00103\u001a\u00020E2\u0006\u0010e\u001a\u000208H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010fJ)\u0010c\u001a\u00020d2\u0006\u0010O\u001a\u00020P2\u0006\u00103\u001a\u00020g2\u0006\u0010e\u001a\u000208H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010hJ9\u0010i\u001a\b\u0012\u0004\u0012\u00020k0j2\u0006\u0010L\u001a\u00020M2\u0006\u0010l\u001a\u0002062\u0006\u0010m\u001a\u0002062\b\b\u0002\u0010e\u001a\u000208H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010nJ \u0010o\u001a\u00020A2\u0006\u0010T\u001a\u00020U2\u0006\u0010l\u001a\u0002062\u0006\u0010m\u001a\u000206H\u0016J9\u0010p\u001a\b\u0012\u0004\u0012\u00020q0j2\u0006\u0010L\u001a\u00020M2\u0006\u0010l\u001a\u0002062\u0006\u0010m\u001a\u0002062\b\b\u0002\u0010e\u001a\u000208H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010nR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00180\u0017X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082.\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001c\u001a\n \u001e*\u0004\u0018\u00010\u001d0\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\"X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020'X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020)X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020+X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020-X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020/X\u0082.\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006r"}, d2={"Lorg/opensearch/alerting/MonitorRunner;", "Lorg/opensearch/alerting/core/JobRunner;", "Lkotlinx/coroutines/CoroutineScope;", "Lorg/opensearch/common/component/AbstractLifecycleComponent;", "()V", "alertIndices", "Lorg/opensearch/alerting/alerts/AlertIndices;", "alertService", "Lorg/opensearch/alerting/AlertService;", "allowList", "", "", "client", "Lorg/opensearch/client/Client;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "coroutineContext", "Lkotlin/coroutines/CoroutineContext;", "getCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "destinationContextFactory", "Lorg/opensearch/alerting/model/destination/DestinationContextFactory;", "destinationSettings", "", "Lorg/opensearch/alerting/settings/DestinationSettings$Companion$SecureDestinationSettings;", "hostDenyList", "inputService", "Lorg/opensearch/alerting/InputService;", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "maxActionableAlertCount", "", "moveAlertsRetryPolicy", "Lorg/opensearch/action/bulk/BackoffPolicy;", "retryPolicy", "runnerSupervisor", "Lkotlinx/coroutines/Job;", "scriptService", "Lorg/opensearch/script/ScriptService;", "settings", "Lorg/opensearch/common/settings/Settings;", "threadPool", "Lorg/opensearch/threadpool/ThreadPool;", "triggerService", "Lorg/opensearch/alerting/TriggerService;", "xContentRegistry", "Lorg/opensearch/common/xcontent/NamedXContentRegistry;", "compileTemplate", "template", "Lorg/opensearch/script/Script;", "ctx", "Lorg/opensearch/alerting/script/TriggerExecutionContext;", "currentTime", "Ljava/time/Instant;", "defaultToPerExecutionAction", "", "monitorId", "triggerId", "totalActionableAlertCount", "", "monitorOrTriggerError", "Ljava/lang/Exception;", "Lkotlin/Exception;", "doClose", "", "doStart", "doStop", "getActionContextForAlertCategory", "Lorg/opensearch/alerting/script/BucketLevelTriggerExecutionContext;", "alertCategory", "Lorg/opensearch/alerting/model/action/AlertCategory;", "alert", "Lorg/opensearch/alerting/model/Alert;", "error", "getRolesForMonitor", "monitor", "Lorg/opensearch/alerting/model/Monitor;", "isActionActionable", "action", "Lorg/opensearch/alerting/model/action/Action;", "postDelete", "jobId", "postIndex", "job", "Lorg/opensearch/alerting/core/model/ScheduledJob;", "registerAlertIndices", "registerAlertService", "registerClient", "registerClusterService", "registerConsumers", "registerDestinationSettings", "registerInputService", "registerNamedXContentRegistry", "registerScriptService", "registerSettings", "registerThreadPool", "registerTriggerService", "reloadDestinationSettings", "runAction", "Lorg/opensearch/alerting/model/ActionRunResult;", "dryrun", "(Lorg/opensearch/alerting/model/action/Action;Lorg/opensearch/alerting/script/BucketLevelTriggerExecutionContext;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Lorg/opensearch/alerting/script/QueryLevelTriggerExecutionContext;", "(Lorg/opensearch/alerting/model/action/Action;Lorg/opensearch/alerting/script/QueryLevelTriggerExecutionContext;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "runBucketLevelMonitor", "Lorg/opensearch/alerting/model/MonitorRunResult;", "Lorg/opensearch/alerting/model/BucketLevelTriggerRunResult;", "periodStart", "periodEnd", "(Lorg/opensearch/alerting/model/Monitor;Ljava/time/Instant;Ljava/time/Instant;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "runJob", "runQueryLevelMonitor", "Lorg/opensearch/alerting/model/QueryLevelTriggerRunResult;", "opensearch-alerting"})
public final class MonitorRunner
extends AbstractLifecycleComponent
implements JobRunner,
CoroutineScope {
    @NotNull
    public static final MonitorRunner INSTANCE = new MonitorRunner();
    private static final Logger logger = LogManager.getLogger(((Object)((Object)INSTANCE)).getClass());
    private static ClusterService clusterService;
    private static Client client;
    private static NamedXContentRegistry xContentRegistry;
    private static ScriptService scriptService;
    private static Settings settings;
    private static ThreadPool threadPool;
    private static AlertIndices alertIndices;
    private static InputService inputService;
    private static TriggerService triggerService;
    private static AlertService alertService;
    private static volatile BackoffPolicy retryPolicy;
    private static volatile BackoffPolicy moveAlertsRetryPolicy;
    @NotNull
    private static volatile List<String> allowList;
    @NotNull
    private static volatile List<String> hostDenyList;
    private static volatile Map<String, DestinationSettings.Companion.SecureDestinationSettings> destinationSettings;
    private static volatile DestinationContextFactory destinationContextFactory;
    private static volatile long maxActionableAlertCount;
    private static Job runnerSupervisor;

    private MonitorRunner() {
    }

    @NotNull
    public CoroutineContext getCoroutineContext() {
        CoroutineDispatcher coroutineDispatcher = Dispatchers.getDefault();
        Job job = runnerSupervisor;
        if (job == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"runnerSupervisor");
            job = null;
        }
        return coroutineDispatcher.plus((CoroutineContext)job);
    }

    @NotNull
    public final MonitorRunner registerClusterService(@NotNull ClusterService clusterService) {
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        MonitorRunner.clusterService = clusterService;
        return this;
    }

    @NotNull
    public final MonitorRunner registerClient(@NotNull Client client) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        MonitorRunner.client = client;
        return this;
    }

    @NotNull
    public final MonitorRunner registerNamedXContentRegistry(@NotNull NamedXContentRegistry xContentRegistry) {
        Intrinsics.checkNotNullParameter((Object)xContentRegistry, (String)"xContentRegistry");
        MonitorRunner.xContentRegistry = xContentRegistry;
        return this;
    }

    @NotNull
    public final MonitorRunner registerScriptService(@NotNull ScriptService scriptService) {
        Intrinsics.checkNotNullParameter((Object)scriptService, (String)"scriptService");
        MonitorRunner.scriptService = scriptService;
        return this;
    }

    @NotNull
    public final MonitorRunner registerSettings(@NotNull Settings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        MonitorRunner.settings = settings;
        return this;
    }

    @NotNull
    public final MonitorRunner registerThreadPool(@NotNull ThreadPool threadPool) {
        Intrinsics.checkNotNullParameter((Object)threadPool, (String)"threadPool");
        MonitorRunner.threadPool = threadPool;
        return this;
    }

    @NotNull
    public final MonitorRunner registerAlertIndices(@NotNull AlertIndices alertIndices) {
        Intrinsics.checkNotNullParameter((Object)alertIndices, (String)"alertIndices");
        MonitorRunner.alertIndices = alertIndices;
        return this;
    }

    @NotNull
    public final MonitorRunner registerInputService(@NotNull InputService inputService) {
        Intrinsics.checkNotNullParameter((Object)inputService, (String)"inputService");
        MonitorRunner.inputService = inputService;
        return this;
    }

    @NotNull
    public final MonitorRunner registerTriggerService(@NotNull TriggerService triggerService) {
        Intrinsics.checkNotNullParameter((Object)triggerService, (String)"triggerService");
        MonitorRunner.triggerService = triggerService;
        return this;
    }

    @NotNull
    public final MonitorRunner registerAlertService(@NotNull AlertService alertService) {
        Intrinsics.checkNotNullParameter((Object)alertService, (String)"alertService");
        MonitorRunner.alertService = alertService;
        return this;
    }

    @NotNull
    public final MonitorRunner registerConsumers() {
        Setting<TimeValue> setting = AlertingSettings.Companion.getALERT_BACKOFF_MILLIS();
        Settings settings = MonitorRunner.settings;
        if (settings == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
            settings = null;
        }
        TimeValue timeValue = (TimeValue)setting.get(settings);
        Setting<Integer> setting2 = AlertingSettings.Companion.getALERT_BACKOFF_COUNT();
        Settings settings2 = MonitorRunner.settings;
        if (settings2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
            settings2 = null;
        }
        Object object = setting2.get(settings2);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ALERT_BACKOFF_COUNT.get(settings)");
        Object object2 = BackoffPolicy.constantBackoff((TimeValue)timeValue, (int)((Number)object).intValue());
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"constantBackoff(ALERT_BA\u2026KOFF_COUNT.get(settings))");
        retryPolicy = object2;
        ClusterService clusterService = MonitorRunner.clusterService;
        if (clusterService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"clusterService");
            clusterService = null;
        }
        clusterService.getClusterSettings().addSettingsUpdateConsumer(AlertingSettings.Companion.getALERT_BACKOFF_MILLIS(), AlertingSettings.Companion.getALERT_BACKOFF_COUNT(), MonitorRunner::registerConsumers$lambda-0);
        Setting<TimeValue> setting3 = AlertingSettings.Companion.getMOVE_ALERTS_BACKOFF_MILLIS();
        Settings settings3 = MonitorRunner.settings;
        if (settings3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
            settings3 = null;
        }
        TimeValue timeValue2 = (TimeValue)setting3.get(settings3);
        Setting<Integer> setting4 = AlertingSettings.Companion.getMOVE_ALERTS_BACKOFF_COUNT();
        Settings settings4 = MonitorRunner.settings;
        if (settings4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
            settings4 = null;
        }
        object = setting4.get(settings4);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"MOVE_ALERTS_BACKOFF_COUNT.get(settings)");
        object2 = BackoffPolicy.exponentialBackoff((TimeValue)timeValue2, (int)((Number)object).intValue());
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"exponentialBackoff(MOVE_\u2026KOFF_COUNT.get(settings))");
        moveAlertsRetryPolicy = object2;
        ClusterService clusterService2 = MonitorRunner.clusterService;
        if (clusterService2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"clusterService");
            clusterService2 = null;
        }
        clusterService2.getClusterSettings().addSettingsUpdateConsumer(AlertingSettings.Companion.getMOVE_ALERTS_BACKOFF_MILLIS(), AlertingSettings.Companion.getMOVE_ALERTS_BACKOFF_COUNT(), MonitorRunner::registerConsumers$lambda-1);
        Setting<List<String>> setting5 = DestinationSettings.Companion.getALLOW_LIST();
        Settings settings5 = MonitorRunner.settings;
        if (settings5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
            settings5 = null;
        }
        object2 = setting5.get(settings5);
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"ALLOW_LIST.get(settings)");
        allowList = (List)object2;
        ClusterService clusterService3 = MonitorRunner.clusterService;
        if (clusterService3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"clusterService");
            clusterService3 = null;
        }
        clusterService3.getClusterSettings().addSettingsUpdateConsumer(DestinationSettings.Companion.getALLOW_LIST(), MonitorRunner::registerConsumers$lambda-2);
        Setting<List<String>> setting6 = DestinationSettings.Companion.getHOST_DENY_LIST();
        Settings settings6 = MonitorRunner.settings;
        if (settings6 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
            settings6 = null;
        }
        object2 = setting6.get(settings6);
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"HOST_DENY_LIST.get(settings)");
        hostDenyList = (List)object2;
        Setting<Long> setting7 = AlertingSettings.Companion.getMAX_ACTIONABLE_ALERT_COUNT();
        Settings settings7 = MonitorRunner.settings;
        if (settings7 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
            settings7 = null;
        }
        object2 = setting7.get(settings7);
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"MAX_ACTIONABLE_ALERT_COUNT.get(settings)");
        maxActionableAlertCount = ((Number)object2).longValue();
        ClusterService clusterService4 = MonitorRunner.clusterService;
        if (clusterService4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"clusterService");
            clusterService4 = null;
        }
        clusterService4.getClusterSettings().addSettingsUpdateConsumer(AlertingSettings.Companion.getMAX_ACTIONABLE_ALERT_COUNT(), MonitorRunner::registerConsumers$lambda-3);
        return this;
    }

    @NotNull
    public final MonitorRunner registerDestinationSettings() {
        Map<String, DestinationSettings.Companion.SecureDestinationSettings> map;
        NamedXContentRegistry namedXContentRegistry;
        Settings settings = MonitorRunner.settings;
        if (settings == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
            settings = null;
        }
        destinationSettings = DestinationSettings.Companion.loadDestinationSettings(settings);
        Client client = MonitorRunner.client;
        if (client == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"client");
            client = null;
        }
        if ((namedXContentRegistry = xContentRegistry) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"xContentRegistry");
            namedXContentRegistry = null;
        }
        if ((map = destinationSettings) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"destinationSettings");
            map = null;
        }
        destinationContextFactory = new DestinationContextFactory(client, namedXContentRegistry, map);
        return this;
    }

    public final void reloadDestinationSettings(@NotNull Settings settings) {
        Map<String, DestinationSettings.Companion.SecureDestinationSettings> map;
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        destinationSettings = DestinationSettings.Companion.loadDestinationSettings(settings);
        DestinationContextFactory destinationContextFactory = MonitorRunner.destinationContextFactory;
        if (destinationContextFactory == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"destinationContextFactory");
            destinationContextFactory = null;
        }
        if ((map = destinationSettings) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"destinationSettings");
            map = null;
        }
        destinationContextFactory.updateDestinationSettings(map);
    }

    protected void doStart() {
        runnerSupervisor = SupervisorKt.SupervisorJob$default(null, (int)1, null);
    }

    protected void doStop() {
        Job job = runnerSupervisor;
        if (job == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"runnerSupervisor");
            job = null;
        }
        job.cancel();
    }

    protected void doClose() {
    }

    public void postIndex(@NotNull ScheduledJob job) {
        Intrinsics.checkNotNullParameter((Object)job, (String)"job");
        if (!(job instanceof Monitor)) {
            throw new IllegalArgumentException("Invalid job type");
        }
        BuildersKt.launch$default((CoroutineScope)this, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(job, null){
            int label;
            final /* synthetic */ ScheduledJob $job;
            {
                this.$job = $job;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        BackoffPolicy backoffPolicy = MonitorRunner.access$getMoveAlertsRetryPolicy$p();
                        if (backoffPolicy == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"moveAlertsRetryPolicy");
                            backoffPolicy = null;
                        }
                        Logger logger = MonitorRunner.access$getLogger$p();
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"logger");
                        this.label = 1;
                        Object object3 = OpenSearchExtensionsKt.retry$default((BackoffPolicy)backoffPolicy, (Logger)logger, null, (Function1)((Function1)new Function1<Continuation<? super Unit>, Object>(this.$job, null){
                            int label;
                            final /* synthetic */ ScheduledJob $job;
                            {
                                this.$job = $job;
                                super(1, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        AlertIndices alertIndices = MonitorRunner.access$getAlertIndices$p();
                                        if (alertIndices == null) {
                                            Intrinsics.throwUninitializedPropertyAccessException((String)"alertIndices");
                                            alertIndices = null;
                                        }
                                        if (!alertIndices.isInitialized()) return Unit.INSTANCE;
                                        Client client = MonitorRunner.access$getClient$p();
                                        if (client == null) {
                                            Intrinsics.throwUninitializedPropertyAccessException((String)"client");
                                            client = null;
                                        }
                                        this.label = 1;
                                        Object object3 = AlertMoverKt.moveAlerts(client, this.$job.getId(), (Monitor)this.$job, (Continuation<? super Unit>)((Continuation)this));
                                        if (object3 != object2) return Unit.INSTANCE;
                                        return object2;
                                    }
                                    case 1: {
                                        void $result;
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object3 = $result;
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@Nullable Continuation<? super Unit> p1) {
                                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this), (int)2, null);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        Object object3;
                        try {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            object3 = $result;
                            return Unit.INSTANCE;
                        }
                        catch (Exception e) {
                            MonitorRunner.access$getLogger$p().error("Failed to move active alerts for monitor [" + this.$job.getId() + "].", (Throwable)e);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public void postDelete(@NotNull String jobId) {
        Intrinsics.checkNotNullParameter((Object)jobId, (String)"jobId");
        BuildersKt.launch$default((CoroutineScope)this, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(jobId, null){
            int label;
            final /* synthetic */ String $jobId;
            {
                this.$jobId = $jobId;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        BackoffPolicy backoffPolicy = MonitorRunner.access$getMoveAlertsRetryPolicy$p();
                        if (backoffPolicy == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"moveAlertsRetryPolicy");
                            backoffPolicy = null;
                        }
                        Logger logger = MonitorRunner.access$getLogger$p();
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"logger");
                        this.label = 1;
                        Object object3 = OpenSearchExtensionsKt.retry$default((BackoffPolicy)backoffPolicy, (Logger)logger, null, (Function1)((Function1)new Function1<Continuation<? super Unit>, Object>(this.$jobId, null){
                            int label;
                            final /* synthetic */ String $jobId;
                            {
                                this.$jobId = $jobId;
                                super(1, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        AlertIndices alertIndices = MonitorRunner.access$getAlertIndices$p();
                                        if (alertIndices == null) {
                                            Intrinsics.throwUninitializedPropertyAccessException((String)"alertIndices");
                                            alertIndices = null;
                                        }
                                        if (!alertIndices.isInitialized()) return Unit.INSTANCE;
                                        Client client = MonitorRunner.access$getClient$p();
                                        if (client == null) {
                                            Intrinsics.throwUninitializedPropertyAccessException((String)"client");
                                            client = null;
                                        }
                                        this.label = 1;
                                        Object object3 = AlertMoverKt.moveAlerts(client, this.$jobId, null, (Continuation<? super Unit>)((Continuation)this));
                                        if (object3 != object2) return Unit.INSTANCE;
                                        return object2;
                                    }
                                    case 1: {
                                        void $result;
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object3 = $result;
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@Nullable Continuation<? super Unit> p1) {
                                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this), (int)2, null);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        Object object3;
                        try {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            object3 = $result;
                            return Unit.INSTANCE;
                        }
                        catch (Exception e) {
                            MonitorRunner.access$getLogger$p().error("Failed to move active alerts for monitor [" + this.$jobId + "].", (Throwable)e);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public void runJob(@NotNull ScheduledJob job, @NotNull Instant periodStart, @NotNull Instant periodEnd) {
        Intrinsics.checkNotNullParameter((Object)job, (String)"job");
        Intrinsics.checkNotNullParameter((Object)periodStart, (String)"periodStart");
        Intrinsics.checkNotNullParameter((Object)periodEnd, (String)"periodEnd");
        if (!(job instanceof Monitor)) {
            throw new IllegalArgumentException("Invalid job type");
        }
        BuildersKt.launch$default((CoroutineScope)this, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(job, periodStart, periodEnd, null){
            int label;
            final /* synthetic */ ScheduledJob $job;
            final /* synthetic */ Instant $periodStart;
            final /* synthetic */ Instant $periodEnd;
            {
                this.$job = $job;
                this.$periodStart = $periodStart;
                this.$periodEnd = $periodEnd;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                void $result;
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        if (!AlertingUtilsKt.isBucketLevelMonitor((Monitor)this.$job)) break;
                        this.label = 1;
                        Object object3 = MonitorRunner.runBucketLevelMonitor$default(MonitorRunner.INSTANCE, (Monitor)this.$job, this.$periodStart, this.$periodEnd, false, (Continuation)this, 8, null);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                this.label = 2;
                Object object4 = MonitorRunner.runQueryLevelMonitor$default(MonitorRunner.INSTANCE, (Monitor)this.$job, this.$periodStart, this.$periodEnd, false, (Continuation)this, 8, null);
                if (object4 != object2) return Unit.INSTANCE;
                return object2;
                {
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        object4 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object runQueryLevelMonitor(@NotNull Monitor var1_1, @NotNull Instant var2_2, @NotNull Instant var3_3, boolean var4_4, @NotNull Continuation<? super MonitorRunResult<QueryLevelTriggerRunResult>> var5_5) {
        block41: {
            if (!(var5_5 instanceof runQueryLevelMonitor.1)) ** GOTO lbl-1000
            var30_6 = var5_5;
            if ((var30_6.label & -2147483648) != 0) {
                var30_6.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, var5_5){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    Object L$3;
                    Object L$4;
                    Object L$5;
                    Object L$6;
                    Object L$7;
                    Object L$8;
                    Object L$9;
                    Object L$10;
                    Object L$11;
                    Object L$12;
                    boolean Z$0;
                    /* synthetic */ Object result;
                    final /* synthetic */ MonitorRunner this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.runQueryLevelMonitor(null, null, null, false, (Continuation<? super MonitorRunResult<QueryLevelTriggerRunResult>>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var31_8 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            block4 : switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    roles = this.getRolesForMonitor(monitor);
                    MonitorRunner.logger.debug("Running monitor: " + monitor.getName() + " with roles: " + roles + " Thread: " + Thread.currentThread().getName());
                    if (Intrinsics.areEqual((Object)periodStart, (Object)periodEnd)) {
                        MonitorRunner.logger.warn("Start and end time are the same: " + periodStart + ". This monitor will probably only run once.");
                    }
                    monitorResult = new Ref.ObjectRef();
                    monitorResult.element = new MonitorRunResult<TriggerResult>(monitor.getName(), periodStart, periodEnd, null, null, null, 56, null);
                    v0 = MonitorRunner.alertIndices;
                    if (v0 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"alertIndices");
                        v0 = null;
                    }
                    $continuation.L$0 = this;
                    $continuation.L$1 = monitor;
                    $continuation.L$2 = periodStart;
                    $continuation.L$3 = periodEnd;
                    $continuation.L$4 = roles;
                    $continuation.L$5 = monitorResult;
                    $continuation.Z$0 = dryrun;
                    $continuation.label = 1;
                    v1 = v0.createOrUpdateAlertIndex((Continuation<? super Unit>)$continuation);
                    ** if (v1 != var31_8) goto lbl35
lbl34:
                    // 1 sources

                    return var31_8;
lbl35:
                    // 1 sources

                    ** GOTO lbl48
                }
                case 1: {
                    dryrun = $continuation.Z$0;
                    monitorResult = (Ref.ObjectRef)$continuation.L$5;
                    roles = (List)$continuation.L$4;
                    periodEnd = (Instant)$continuation.L$3;
                    periodStart = (Instant)$continuation.L$2;
                    monitor = (Monitor)$continuation.L$1;
                    this = (MonitorRunner)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl48:
                    // 2 sources

                    if ((v2 = MonitorRunner.alertIndices) == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"alertIndices");
                        v2 = null;
                    }
                    $continuation.L$0 = this;
                    $continuation.L$1 = monitor;
                    $continuation.L$2 = periodStart;
                    $continuation.L$3 = periodEnd;
                    $continuation.L$4 = roles;
                    $continuation.L$5 = monitorResult;
                    $continuation.Z$0 = dryrun;
                    $continuation.label = 2;
                    v3 = v2.createOrUpdateInitialHistoryIndex((Continuation<? super Unit>)$continuation);
                    ** if (v3 != var31_8) goto lbl62
lbl61:
                    // 1 sources

                    return var31_8;
lbl62:
                    // 1 sources

                    ** GOTO lbl75
                }
                case 2: {
                    dryrun = $continuation.Z$0;
                    monitorResult = (Ref.ObjectRef)$continuation.L$5;
                    roles = (List)$continuation.L$4;
                    periodEnd = (Instant)$continuation.L$3;
                    periodStart = (Instant)$continuation.L$2;
                    monitor = (Monitor)$continuation.L$1;
                    this = (MonitorRunner)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v3 = $result;
lbl75:
                    // 2 sources

                    if ((v4 = MonitorRunner.alertService) == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"alertService");
                        v4 = null;
                    }
                    $continuation.L$0 = this;
                    $continuation.L$1 = monitor;
                    $continuation.L$2 = periodStart;
                    $continuation.L$3 = periodEnd;
                    $continuation.L$4 = roles;
                    $continuation.L$5 = monitorResult;
                    $continuation.Z$0 = dryrun;
                    $continuation.label = 3;
                    v5 = v4.loadCurrentAlertsForQueryLevelMonitor(monitor, (Continuation<? super Map<Trigger, Alert>>)$continuation);
                    ** if (v5 != var31_8) goto lbl89
lbl88:
                    // 1 sources

                    return var31_8;
lbl89:
                    // 1 sources

                    ** GOTO lbl102
                }
                case 3: {
                    dryrun = $continuation.Z$0;
                    monitorResult = (Ref.ObjectRef)$continuation.L$5;
                    roles = (List)$continuation.L$4;
                    periodEnd = (Instant)$continuation.L$3;
                    periodStart = (Instant)$continuation.L$2;
                    monitor = (Monitor)$continuation.L$1;
                    this = (MonitorRunner)$continuation.L$0;
                    try {
                        ResultKt.throwOnFailure((Object)$result);
                        v5 = $result;
lbl102:
                        // 2 sources

                        var9_11 = (Map)v5;
                    }
                    catch (Exception e) {
                        id = ((CharSequence)StringsKt.trim((CharSequence)monitor.getId()).toString()).length() == 0 != false ? "_na_" : monitor.getId();
                        MonitorRunner.logger.error("Error loading alerts for monitor: " + id, (Throwable)e);
                        return MonitorRunResult.copy$default((MonitorRunResult)monitorResult.element, null, null, null, e, null, null, 55, null);
                    }
                    currentAlerts = var9_11;
                    if (AnomalyDetectionUtilsKt.isADMonitor(monitor)) break;
                    v6 = monitor.getId();
                    v7 = MonitorRunner.settings;
                    if (v7 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
                        v7 = null;
                    }
                    if ((v8 = MonitorRunner.threadPool) == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"threadPool");
                        v8 = null;
                    }
                    var9_11 = v8.getThreadContext();
                    Intrinsics.checkNotNullExpressionValue((Object)var9_11, (String)"threadPool.threadContext");
                    $continuation.L$0 = this;
                    $continuation.L$1 = monitor;
                    $continuation.L$2 = monitorResult;
                    $continuation.L$3 = currentAlerts;
                    $continuation.L$4 = null;
                    $continuation.L$5 = null;
                    $continuation.Z$0 = dryrun;
                    $continuation.label = 4;
                    v9 = OpenSearchExtensionsKt.withClosableContext((InjectorContextElement)new InjectorContextElement(v6, v7, (ThreadContext)var9_11, roles), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((Ref.ObjectRef<MonitorRunResult<QueryLevelTriggerRunResult>>)monitorResult, monitor, periodStart, periodEnd, null){
                        Object L$0;
                        Object L$1;
                        int label;
                        final /* synthetic */ Ref.ObjectRef<MonitorRunResult<QueryLevelTriggerRunResult>> $monitorResult;
                        final /* synthetic */ Monitor $monitor;
                        final /* synthetic */ Instant $periodStart;
                        final /* synthetic */ Instant $periodEnd;
                        {
                            this.$monitorResult = $monitorResult;
                            this.$monitor = $monitor;
                            this.$periodStart = $periodStart;
                            this.$periodEnd = $periodEnd;
                            super(2, $completion);
                        }

                        /*
                         * Unable to fully structure code
                         */
                        @Nullable
                        public final Object invokeSuspend(@NotNull Object var1_1) {
                            var9_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)var1_1);
                                    var7_3 = null;
                                    var6_4 = null;
                                    var5_5 = null;
                                    var4_6 = null;
                                    var3_7 = (MonitorRunResult)this.$monitorResult.element;
                                    var2_8 = this.$monitorResult;
                                    v0 = MonitorRunner.access$getInputService$p();
                                    if (v0 == null) {
                                        Intrinsics.throwUninitializedPropertyAccessException((String)"inputService");
                                        v0 = null;
                                    }
                                    this.L$0 = var2_8;
                                    this.L$1 = var3_7;
                                    this.label = 1;
                                    v1 = InputService.collectInputResults$default(v0, this.$monitor, this.$periodStart, this.$periodEnd, null, (Continuation)this, 8, null);
                                    if (v1 == var9_2) {
                                        return var9_2;
                                    }
                                    ** GOTO lbl31
                                }
                                case 1: {
                                    var7_3 = null;
                                    var6_4 = null;
                                    var5_5 = null;
                                    var4_6 = null;
                                    var3_7 = (MonitorRunResult)this.L$1;
                                    var2_8 = (Ref.ObjectRef<MonitorRunResult<QueryLevelTriggerRunResult>>)this.L$0;
                                    ResultKt.throwOnFailure((Object)$result);
                                    v1 = $result;
lbl31:
                                    // 2 sources

                                    var8_9 = v1;
                                    var2_8.element = MonitorRunResult.copy$default(var3_7, var4_6, var5_5, var6_4, var7_3, (InputRunResults)var8_9, null, 47, null);
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        @Nullable
                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (Continuation)$continuation);
                    if (v9 == var31_8) {
                        return var31_8;
                    }
                    ** GOTO lbl179
                }
                case 4: {
                    dryrun = $continuation.Z$0;
                    currentAlerts = (Map)$continuation.L$3;
                    monitorResult = (Ref.ObjectRef)$continuation.L$2;
                    monitor = (Monitor)$continuation.L$1;
                    this = (MonitorRunner)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v9 = $result;
                    ** GOTO lbl179
                }
            }
            var27_17 = null;
            var26_18 = null;
            var25_19 = null;
            var24_20 = null;
            var23_21 = (MonitorRunResult)monitorResult.element;
            var22_22 = monitorResult;
            v10 = MonitorRunner.inputService;
            if (v10 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"inputService");
                v10 = null;
            }
            $continuation.L$0 = this;
            $continuation.L$1 = monitor;
            $continuation.L$2 = monitorResult;
            $continuation.L$3 = currentAlerts;
            $continuation.L$4 = var22_22;
            $continuation.L$5 = var23_21;
            $continuation.Z$0 = dryrun;
            $continuation.label = 5;
            v11 = v10.collectInputResultsForADMonitor(monitor, periodStart, periodEnd, (Continuation<? super InputRunResults>)$continuation);
            if (v11 == var31_8) {
                return var31_8;
            }
            ** GOTO lbl177
            {
                case 5: {
                    dryrun = $continuation.Z$0;
                    var27_17 = null;
                    var26_18 = null;
                    var25_19 = null;
                    var24_20 = null;
                    var23_21 = (MonitorRunResult)$continuation.L$5;
                    var22_22 = (Ref.ObjectRef)$continuation.L$4;
                    currentAlerts = (Map)$continuation.L$3;
                    monitorResult = (Ref.ObjectRef)$continuation.L$2;
                    monitor = (Monitor)$continuation.L$1;
                    this = (MonitorRunner)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v11 = $result;
lbl177:
                    // 2 sources

                    var28_23 = v11;
                    var22_22.element = MonitorRunResult.copy$default(var23_21, var24_20, var25_19, var26_18, var27_17, (InputRunResults)var28_23, null, 47, null);
lbl179:
                    // 3 sources

                    updatedAlerts = new ArrayList<E>();
                    triggerResults = new LinkedHashMap<K, V>();
                    var11_15 = monitor.getTriggers().iterator();
lbl182:
                    // 3 sources

                    while (var11_15.hasNext()) {
                        trigger = var11_15.next();
                        currentAlert = (Alert)currentAlerts.get(trigger);
                        triggerCtx = new QueryLevelTriggerExecutionContext(monitor, (QueryLevelTrigger)trigger, (MonitorRunResult)monitorResult.element, currentAlert);
                        v12 = MonitorRunner.triggerService;
                        if (v12 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"triggerService");
                            v12 = null;
                        }
                        triggerResult = v12.runQueryLevelTrigger(monitor, (QueryLevelTrigger)trigger, triggerCtx);
                        var16_28 = triggerResults;
                        var17_29 = trigger.getId();
                        var16_28.put(var17_29, triggerResult);
                        v13 = MonitorRunner.triggerService;
                        if (v13 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"triggerService");
                            v13 = null;
                        }
                        if (!v13.isQueryLevelTriggerActionable(triggerCtx, triggerResult)) break block4;
                        v14 = ((MonitorRunResult)monitorResult.element).getError();
                        if (v14 == null) {
                            v14 = triggerResult.getError();
                        }
                        actionCtx = QueryLevelTriggerExecutionContext.copy$default(triggerCtx, null, null, null, null, null, null, v14, 63, null);
                        var17_29 = trigger.getActions().iterator();
lbl205:
                        // 2 sources

                        while (var17_29.hasNext()) {
                            action = (Action)var17_29.next();
                            var19_31 = triggerResult.getActionResults();
                            var20_32 = action.getId();
                            $continuation.L$0 = this;
                            $continuation.L$1 = monitor;
                            $continuation.L$2 = monitorResult;
                            $continuation.L$3 = currentAlerts;
                            $continuation.L$4 = updatedAlerts;
                            $continuation.L$5 = triggerResults;
                            $continuation.L$6 = var11_15;
                            $continuation.L$7 = triggerCtx;
                            $continuation.L$8 = triggerResult;
                            $continuation.L$9 = actionCtx;
                            $continuation.L$10 = var17_29;
                            $continuation.L$11 = var19_31;
                            $continuation.L$12 = var20_32;
                            $continuation.Z$0 = dryrun;
                            $continuation.label = 6;
                            v15 = this.runAction(action, actionCtx, dryrun != false, (Continuation<? super ActionRunResult>)$continuation);
                            if (v15 == var31_8) {
                                return var31_8;
                            }
                            ** GOTO lbl247
                        }
                        break block4;
                    }
                    break block41;
                }
                case 6: {
                    dryrun = $continuation.Z$0;
                    var20_32 = (String)$continuation.L$12;
                    var19_31 = (Map<String, ActionRunResult>)$continuation.L$11;
                    var17_29 = (Iterator)$continuation.L$10;
                    actionCtx = (QueryLevelTriggerExecutionContext)$continuation.L$9;
                    triggerResult = (QueryLevelTriggerRunResult)$continuation.L$8;
                    triggerCtx = (QueryLevelTriggerExecutionContext)$continuation.L$7;
                    var11_15 = (Iterator<Trigger>)$continuation.L$6;
                    triggerResults = (Map)$continuation.L$5;
                    updatedAlerts = (List)$continuation.L$4;
                    currentAlerts = (Map)$continuation.L$3;
                    monitorResult = (Ref.ObjectRef)$continuation.L$2;
                    monitor = (Monitor)$continuation.L$1;
                    this = (MonitorRunner)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v15 = $result;
lbl247:
                    // 2 sources

                    var21_33 = v15;
                    var19_31.put(var20_32, (ActionRunResult)var21_33);
                    ** GOTO lbl205
                }
            }
            if ((v16 = MonitorRunner.alertService) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"alertService");
                v16 = null;
            }
            if ((v17 = ((MonitorRunResult)monitorResult.element).alertError()) == null) {
                v17 = triggerResult.alertError();
            }
            if ((updatedAlert = v16.composeQueryLevelAlert(triggerCtx, triggerResult, v17)) == null) ** GOTO lbl182
            ((Collection)updatedAlerts).add(updatedAlert);
            ** GOTO lbl182
        }
        if (!dryrun && !Intrinsics.areEqual((Object)monitor.getId(), (Object)"")) {
            v18 = MonitorRunner.alertService;
            if (v18 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"alertService");
                v18 = null;
            }
            if ((v19 = MonitorRunner.retryPolicy) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"retryPolicy");
                v19 = null;
            }
            $continuation.L$0 = monitorResult;
            $continuation.L$1 = triggerResults;
            $continuation.L$2 = null;
            $continuation.L$3 = null;
            $continuation.L$4 = null;
            $continuation.L$5 = null;
            $continuation.L$6 = null;
            $continuation.L$7 = null;
            $continuation.L$8 = null;
            $continuation.L$9 = null;
            $continuation.L$10 = null;
            $continuation.L$11 = null;
            $continuation.L$12 = null;
            $continuation.label = 7;
            v20 = AlertService.saveAlerts$default(v18, updatedAlerts, v19, false, (Continuation)$continuation, 4, null);
            if (v20 == var31_8) {
                return var31_8;
            }
        }
        ** GOTO lbl292
        {
            case 7: {
                triggerResults = (Map)$continuation.L$1;
                monitorResult = (Ref.ObjectRef)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v20 = $result;
lbl292:
                // 2 sources

                return MonitorRunResult.copy$default((MonitorRunResult)monitorResult.element, null, null, null, null, null, triggerResults, 31, null);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static /* synthetic */ Object runQueryLevelMonitor$default(MonitorRunner monitorRunner, Monitor monitor, Instant instant, Instant instant2, boolean bl, Continuation continuation, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        return monitorRunner.runQueryLevelMonitor(monitor, instant, instant2, bl, (Continuation<? super MonitorRunResult<QueryLevelTriggerRunResult>>)continuation);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Nullable
    public final Object runBucketLevelMonitor(@NotNull Monitor var1_1, @NotNull Instant var2_2, @NotNull Instant var3_3, boolean var4_4, @NotNull Continuation<? super MonitorRunResult<BucketLevelTriggerRunResult>> var5_5) {
        block84: {
            block82: {
                block85: {
                    block83: {
                        if (!(var5_5 instanceof runBucketLevelMonitor.1)) ** GOTO lbl-1000
                        var45_6 = var5_5;
                        if ((var45_6.label & -2147483648) != 0) {
                            var45_6.label -= -2147483648;
                        } else lbl-1000:
                        // 2 sources

                        {
                            $continuation = new ContinuationImpl(this, var5_5){
                                Object L$0;
                                Object L$1;
                                Object L$2;
                                Object L$3;
                                Object L$4;
                                Object L$5;
                                Object L$6;
                                Object L$7;
                                Object L$8;
                                Object L$9;
                                Object L$10;
                                Object L$11;
                                Object L$12;
                                Object L$13;
                                Object L$14;
                                Object L$15;
                                Object L$16;
                                Object L$17;
                                Object L$18;
                                Object L$19;
                                Object L$20;
                                Object L$21;
                                Object L$22;
                                Object L$23;
                                Object L$24;
                                boolean Z$0;
                                boolean Z$1;
                                /* synthetic */ Object result;
                                final /* synthetic */ MonitorRunner this$0;
                                int label;
                                {
                                    this.this$0 = this$0;
                                    super($completion);
                                }

                                @Nullable
                                public final Object invokeSuspend(@NotNull Object $result) {
                                    this.result = $result;
                                    this.label |= Integer.MIN_VALUE;
                                    return this.this$0.runBucketLevelMonitor(null, null, null, false, (Continuation<? super MonitorRunResult<BucketLevelTriggerRunResult>>)((Continuation)this));
                                }
                            };
                        }
                        $result = $continuation.result;
                        var46_8 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch ($continuation.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                roles = this.getRolesForMonitor(monitor);
                                MonitorRunner.logger.debug("Running monitor: " + monitor.getName() + " with roles: " + roles + " Thread: " + Thread.currentThread().getName());
                                if (Intrinsics.areEqual((Object)periodStart, (Object)periodEnd)) {
                                    MonitorRunner.logger.warn("Start and end time are the same: " + periodStart + ". This monitor will probably only run once.");
                                }
                                monitorResult = new Ref.ObjectRef();
                                monitorResult.element = new MonitorRunResult<TriggerResult>(monitor.getName(), periodStart, periodEnd, null, null, null, 56, null);
                                var9_11 = MonitorRunner.alertIndices;
                                v0 = var9_11;
                                if (v0 == null) {
                                    Intrinsics.throwUninitializedPropertyAccessException((String)"alertIndices");
                                    v0 = null;
                                }
                                $continuation.L$0 = this;
                                $continuation.L$1 = monitor;
                                $continuation.L$2 = periodStart;
                                $continuation.L$3 = periodEnd;
                                $continuation.L$4 = roles;
                                $continuation.L$5 = monitorResult;
                                $continuation.Z$0 = dryrun;
                                $continuation.label = 1;
                                v1 = v0.createOrUpdateAlertIndex((Continuation<? super Unit>)$continuation);
                                ** if (v1 != var46_8) goto lbl36
lbl35:
                                // 1 sources

                                return var46_8;
lbl36:
                                // 1 sources

                                ** GOTO lbl49
                            }
                            case 1: {
                                dryrun = $continuation.Z$0;
                                monitorResult = (Ref.ObjectRef)$continuation.L$5;
                                roles = (List)$continuation.L$4;
                                periodEnd = (Instant)$continuation.L$3;
                                periodStart = (Instant)$continuation.L$2;
                                monitor = (Monitor)$continuation.L$1;
                                this = (MonitorRunner)$continuation.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v1 = $result;
lbl49:
                                // 2 sources

                                if ((v2 = (var9_11 = MonitorRunner.alertIndices)) == null) {
                                    Intrinsics.throwUninitializedPropertyAccessException((String)"alertIndices");
                                    v2 = null;
                                }
                                $continuation.L$0 = this;
                                $continuation.L$1 = monitor;
                                $continuation.L$2 = periodStart;
                                $continuation.L$3 = periodEnd;
                                $continuation.L$4 = roles;
                                $continuation.L$5 = monitorResult;
                                $continuation.Z$0 = dryrun;
                                $continuation.label = 2;
                                v3 = v2.createOrUpdateInitialHistoryIndex((Continuation<? super Unit>)$continuation);
                                ** if (v3 != var46_8) goto lbl63
lbl62:
                                // 1 sources

                                return var46_8;
lbl63:
                                // 1 sources

                                ** GOTO lbl76
                            }
                            case 2: {
                                dryrun = $continuation.Z$0;
                                monitorResult = (Ref.ObjectRef)$continuation.L$5;
                                roles = (List)$continuation.L$4;
                                periodEnd = (Instant)$continuation.L$3;
                                periodStart = (Instant)$continuation.L$2;
                                monitor = (Monitor)$continuation.L$1;
                                this = (MonitorRunner)$continuation.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v3 = $result;
lbl76:
                                // 2 sources

                                if ((v4 = (var9_11 = MonitorRunner.alertService)) == null) {
                                    Intrinsics.throwUninitializedPropertyAccessException((String)"alertService");
                                    v4 = null;
                                }
                                $continuation.L$0 = this;
                                $continuation.L$1 = monitor;
                                $continuation.L$2 = periodStart;
                                $continuation.L$3 = periodEnd;
                                $continuation.L$4 = roles;
                                $continuation.L$5 = monitorResult;
                                $continuation.Z$0 = dryrun;
                                $continuation.label = 3;
                                v5 = v4.loadCurrentAlertsForBucketLevelMonitor(monitor, (Continuation<? super Map<Trigger, ? extends Map<String, Alert>>>)$continuation);
                                ** if (v5 != var46_8) goto lbl90
lbl89:
                                // 1 sources

                                return var46_8;
lbl90:
                                // 1 sources

                                ** GOTO lbl103
                            }
                            case 3: {
                                dryrun = $continuation.Z$0;
                                monitorResult = (Ref.ObjectRef)$continuation.L$5;
                                roles = (List)$continuation.L$4;
                                periodEnd = (Instant)$continuation.L$3;
                                periodStart = (Instant)$continuation.L$2;
                                monitor = (Monitor)$continuation.L$1;
                                this = (MonitorRunner)$continuation.L$0;
                                try {
                                    ResultKt.throwOnFailure((Object)$result);
                                    v5 = $result;
lbl103:
                                    // 2 sources

                                    var9_11 = (Map)v5;
                                }
                                catch (Exception e) {
                                    var12_14 = monitor.getId();
                                    var12_14 = StringsKt.trim((CharSequence)var12_14).toString();
                                    id = var12_14.length() == 0 != false ? "_na_" : monitor.getId();
                                    MonitorRunner.logger.error("Error loading alerts for monitor: " + id, (Throwable)e);
                                    return MonitorRunResult.copy$default((MonitorRunResult)monitorResult.element, null, null, null, e, null, null, 55, null);
                                }
                                currentAlerts = var9_11;
                                triggerResults = new LinkedHashMap<K, V>();
                                triggerContexts = new LinkedHashMap<K, V>();
                                nextAlerts = new LinkedHashMap<K, V>();
                                firstIteration = new Ref.BooleanRef();
                                firstIteration.element = true;
                                firstPageOfInputResults = new Ref.ObjectRef();
                                firstPageOfInputResults.element = new InputRunResults(CollectionsKt.emptyList(), null, null, 4, null);
lbl119:
                                // 2 sources

                                while (true) {
                                    v6 = monitor.getId();
                                    var14_20 /* !! */  = MonitorRunner.settings;
                                    v7 /* !! */  = var14_20 /* !! */ ;
                                    if (v7 /* !! */  == null) {
                                        Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
                                        v7 /* !! */  = null;
                                    }
                                    if ((v8 = (var15_21 = MonitorRunner.threadPool)) == null) {
                                        Intrinsics.throwUninitializedPropertyAccessException((String)"threadPool");
                                        v8 = null;
                                    }
                                    var14_20 /* !! */  = v8.getThreadContext();
                                    Intrinsics.checkNotNullExpressionValue((Object)var14_20 /* !! */ , (String)"threadPool.threadContext");
                                    $continuation.L$0 = this;
                                    $continuation.L$1 = monitor;
                                    $continuation.L$2 = periodStart;
                                    $continuation.L$3 = periodEnd;
                                    $continuation.L$4 = roles;
                                    $continuation.L$5 = monitorResult;
                                    $continuation.L$6 = currentAlerts;
                                    $continuation.L$7 = triggerResults;
                                    $continuation.L$8 = triggerContexts;
                                    $continuation.L$9 = nextAlerts;
                                    $continuation.L$10 = firstIteration;
                                    $continuation.L$11 = firstPageOfInputResults;
                                    $continuation.L$12 = null;
                                    $continuation.L$13 = null;
                                    $continuation.L$14 = null;
                                    $continuation.Z$0 = dryrun;
                                    $continuation.label = 4;
                                    v9 = OpenSearchExtensionsKt.withClosableContext((InjectorContextElement)new InjectorContextElement(v6, v7 /* !! */ , (ThreadContext)var14_20 /* !! */ , roles), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(monitor, periodStart, periodEnd, (Ref.ObjectRef<MonitorRunResult<BucketLevelTriggerRunResult>>)monitorResult, firstIteration, (Ref.ObjectRef<InputRunResults>)firstPageOfInputResults, null){
                                        int label;
                                        final /* synthetic */ Monitor $monitor;
                                        final /* synthetic */ Instant $periodStart;
                                        final /* synthetic */ Instant $periodEnd;
                                        final /* synthetic */ Ref.ObjectRef<MonitorRunResult<BucketLevelTriggerRunResult>> $monitorResult;
                                        final /* synthetic */ Ref.BooleanRef $firstIteration;
                                        final /* synthetic */ Ref.ObjectRef<InputRunResults> $firstPageOfInputResults;
                                        {
                                            this.$monitor = $monitor;
                                            this.$periodStart = $periodStart;
                                            this.$periodEnd = $periodEnd;
                                            this.$monitorResult = $monitorResult;
                                            this.$firstIteration = $firstIteration;
                                            this.$firstPageOfInputResults = $firstPageOfInputResults;
                                            super(2, $completion);
                                        }

                                        /*
                                         * Unable to fully structure code
                                         */
                                        @Nullable
                                        public final Object invokeSuspend(@NotNull Object var1_1) {
                                            var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                            switch (this.label) {
                                                case 0: {
                                                    ResultKt.throwOnFailure((Object)var1_1);
                                                    v0 = MonitorRunner.access$getInputService$p();
                                                    if (v0 == null) {
                                                        Intrinsics.throwUninitializedPropertyAccessException((String)"inputService");
                                                        v0 = null;
                                                    }
                                                    this.label = 1;
                                                    v1 = v0.collectInputResults(this.$monitor, this.$periodStart, this.$periodEnd, ((MonitorRunResult)this.$monitorResult.element).getInputResults(), (Continuation<? super InputRunResults>)((Continuation)this));
                                                    if (v1 == var3_2) {
                                                        return var3_2;
                                                    }
                                                    ** GOTO lbl17
                                                }
                                                case 1: {
                                                    ResultKt.throwOnFailure((Object)$result);
                                                    v1 = $result;
lbl17:
                                                    // 2 sources

                                                    inputResults = (InputRunResults)v1;
                                                    if (this.$firstIteration.element) {
                                                        this.$firstPageOfInputResults.element = inputResults;
                                                        this.$firstIteration.element = false;
                                                    }
                                                    this.$monitorResult.element = MonitorRunResult.copy$default((MonitorRunResult)this.$monitorResult.element, null, null, null, null, inputResults, null, 47, null);
                                                    return Unit.INSTANCE;
                                                }
                                            }
                                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                        }

                                        @NotNull
                                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                        }

                                        @Nullable
                                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                        }
                                    }), (Continuation)$continuation);
                                    if (v9 == var46_8) {
                                        return var46_8;
                                    }
                                    ** GOTO lbl168
                                    break;
                                }
                            }
                            case 4: {
                                dryrun = $continuation.Z$0;
                                firstPageOfInputResults = (Ref.ObjectRef)$continuation.L$11;
                                firstIteration = (Ref.BooleanRef)$continuation.L$10;
                                nextAlerts = (Map)$continuation.L$9;
                                triggerContexts = (Map)$continuation.L$8;
                                triggerResults = (Map)$continuation.L$7;
                                currentAlerts = (Map)$continuation.L$6;
                                monitorResult = (Ref.ObjectRef)$continuation.L$5;
                                roles = (List)$continuation.L$4;
                                periodEnd = (Instant)$continuation.L$3;
                                periodStart = (Instant)$continuation.L$2;
                                monitor = (Monitor)$continuation.L$1;
                                this = (MonitorRunner)$continuation.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v9 = $result;
lbl168:
                                // 2 sources

                                var14_20 /* !! */  = monitor.getTriggers().iterator();
lbl169:
                                // 4 sources

                                while (var14_20 /* !! */ .hasNext()) {
                                    trigger = var14_20 /* !! */ .next();
                                    v10 = currentAlerts.get(trigger);
                                    Intrinsics.checkNotNull(v10);
                                    currentAlertsForTrigger = (Map)v10;
                                    triggerCtx = new BucketLevelTriggerExecutionContext(monitor, (BucketLevelTrigger)trigger, (MonitorRunResult)monitorResult.element, null, null, null, 56, null);
                                    var18_27 = triggerContexts;
                                    var19_28 = trigger.getId();
                                    var18_27.put(var19_28, triggerCtx);
                                    var19_28 = MonitorRunner.triggerService;
                                    v11 = var19_28;
                                    if (v11 == null) {
                                        Intrinsics.throwUninitializedPropertyAccessException((String)"triggerService");
                                        v11 = null;
                                    }
                                    triggerResult = v11.runBucketLevelTrigger(monitor, (BucketLevelTrigger)trigger, triggerCtx);
                                    var19_28 = triggerResults;
                                    var20_32 = trigger.getId();
                                    var21_33 = AlertingUtilsKt.getCombinedTriggerRunResult(triggerResult, (BucketLevelTriggerRunResult)triggerResults.get(trigger.getId()));
                                    var19_28.put(var20_32, var21_33);
                                    v12 = var19_28 = (BucketLevelTriggerRunResult)triggerResults.get(trigger.getId());
                                    if ((v12 == null ? null : v12.getError()) != null) continue;
                                    var20_32 = MonitorRunner.alertService;
                                    v13 = var20_32;
                                    if (v13 == null) {
                                        Intrinsics.throwUninitializedPropertyAccessException((String)"alertService");
                                        v13 = null;
                                    }
                                    categorizedAlerts = MapsKt.toMutableMap(v13.getCategorizedAlertsForBucketLevelMonitor(monitor, (BucketLevelTrigger)trigger, (Map<String, Alert>)currentAlertsForTrigger, CollectionsKt.toList((Iterable)triggerResult.getAggregationResultBuckets().values())));
                                    dedupedAlerts = categorizedAlerts.getOrDefault((Object)AlertCategory.DEDUPED, CollectionsKt.emptyList());
                                    newAlerts = categorizedAlerts.getOrDefault((Object)AlertCategory.NEW, CollectionsKt.emptyList());
                                    if (dryrun || Intrinsics.areEqual((Object)monitor.getId(), (Object)"")) ** GOTO lbl300
                                    var22_34 = MonitorRunner.alertService;
                                    v14 = var22_34;
                                    if (v14 == null) {
                                        Intrinsics.throwUninitializedPropertyAccessException((String)"alertService");
                                        v14 = null;
                                    }
                                    if ((v15 = (var22_34 = MonitorRunner.retryPolicy)) == null) {
                                        Intrinsics.throwUninitializedPropertyAccessException((String)"retryPolicy");
                                        v15 = null;
                                    }
                                    $continuation.L$0 = this;
                                    $continuation.L$1 = monitor;
                                    $continuation.L$2 = periodStart;
                                    $continuation.L$3 = periodEnd;
                                    $continuation.L$4 = roles;
                                    $continuation.L$5 = monitorResult;
                                    $continuation.L$6 = currentAlerts;
                                    $continuation.L$7 = triggerResults;
                                    $continuation.L$8 = triggerContexts;
                                    $continuation.L$9 = nextAlerts;
                                    $continuation.L$10 = firstIteration;
                                    $continuation.L$11 = firstPageOfInputResults;
                                    $continuation.L$12 = var14_20 /* !! */ ;
                                    $continuation.L$13 = trigger;
                                    $continuation.L$14 = dedupedAlerts;
                                    $continuation.L$15 = newAlerts;
                                    $continuation.Z$0 = dryrun;
                                    $continuation.label = 5;
                                    v16 = v14.saveAlerts(dedupedAlerts, (BackoffPolicy)v15, true, (Continuation<? super Unit>)$continuation);
                                    if (v16 == var46_8) {
                                        return var46_8;
                                    }
                                    ** GOTO lbl252
                                }
                                break;
                            }
                            case 5: {
                                dryrun = $continuation.Z$0;
                                newAlerts = (List)$continuation.L$15;
                                dedupedAlerts = (List)$continuation.L$14;
                                trigger = (Trigger)$continuation.L$13;
                                var14_20 /* !! */  = (Iterator)$continuation.L$12;
                                firstPageOfInputResults = (Ref.ObjectRef)$continuation.L$11;
                                firstIteration = (Ref.BooleanRef)$continuation.L$10;
                                nextAlerts = (Map)$continuation.L$9;
                                triggerContexts = (Map)$continuation.L$8;
                                triggerResults = (Map)$continuation.L$7;
                                currentAlerts = (Map)$continuation.L$6;
                                monitorResult = (Ref.ObjectRef)$continuation.L$5;
                                roles = (List)$continuation.L$4;
                                periodEnd = (Instant)$continuation.L$3;
                                periodStart = (Instant)$continuation.L$2;
                                monitor = (Monitor)$continuation.L$1;
                                this = (MonitorRunner)$continuation.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v16 = $result;
lbl252:
                                // 2 sources

                                if ((v17 = (var22_34 = MonitorRunner.alertService)) == null) {
                                    Intrinsics.throwUninitializedPropertyAccessException((String)"alertService");
                                    v17 = null;
                                }
                                if ((v18 = (var22_34 = MonitorRunner.retryPolicy)) == null) {
                                    Intrinsics.throwUninitializedPropertyAccessException((String)"retryPolicy");
                                    v18 = null;
                                }
                                $continuation.L$0 = this;
                                $continuation.L$1 = monitor;
                                $continuation.L$2 = periodStart;
                                $continuation.L$3 = periodEnd;
                                $continuation.L$4 = roles;
                                $continuation.L$5 = monitorResult;
                                $continuation.L$6 = currentAlerts;
                                $continuation.L$7 = triggerResults;
                                $continuation.L$8 = triggerContexts;
                                $continuation.L$9 = nextAlerts;
                                $continuation.L$10 = firstIteration;
                                $continuation.L$11 = firstPageOfInputResults;
                                $continuation.L$12 = var14_20 /* !! */ ;
                                $continuation.L$13 = trigger;
                                $continuation.L$14 = dedupedAlerts;
                                $continuation.L$15 = null;
                                $continuation.Z$0 = dryrun;
                                $continuation.label = 6;
                                v19 = v17.saveNewAlerts(newAlerts, (BackoffPolicy)v18, (Continuation<? super List<Alert>>)$continuation);
                                if (v19 == var46_8) {
                                    return var46_8;
                                }
                                ** GOTO lbl299
                            }
                            case 6: {
                                dryrun = $continuation.Z$0;
                                dedupedAlerts = (List)$continuation.L$14;
                                trigger = (Trigger)$continuation.L$13;
                                var14_20 /* !! */  = (Iterator)$continuation.L$12;
                                firstPageOfInputResults = (Ref.ObjectRef)$continuation.L$11;
                                firstIteration = (Ref.BooleanRef)$continuation.L$10;
                                nextAlerts = (Map)$continuation.L$9;
                                triggerContexts = (Map)$continuation.L$8;
                                triggerResults = (Map)$continuation.L$7;
                                currentAlerts = (Map)$continuation.L$6;
                                monitorResult = (Ref.ObjectRef)$continuation.L$5;
                                roles = (List)$continuation.L$4;
                                periodEnd = (Instant)$continuation.L$3;
                                periodStart = (Instant)$continuation.L$2;
                                monitor = (Monitor)$continuation.L$1;
                                this = (MonitorRunner)$continuation.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v19 = $result;
lbl299:
                                // 2 sources

                                newAlerts = (List)v19;
lbl300:
                                // 2 sources

                                if (!nextAlerts.containsKey(trigger.getId())) {
                                    var22_34 = nextAlerts;
                                    var23_35 = trigger.getId();
                                    var24_36 = new Pair[]{TuplesKt.to((Object)AlertCategory.DEDUPED, (Object)new ArrayList<E>()), TuplesKt.to((Object)AlertCategory.NEW, (Object)new ArrayList<E>()), TuplesKt.to((Object)AlertCategory.COMPLETED, (Object)new ArrayList<E>())};
                                    var24_36 = MapsKt.mutableMapOf((Pair[])var24_36);
                                    var22_34.put(var23_35, var24_36);
                                }
                                v20 = var22_34 = (Map)nextAlerts.get(trigger.getId());
                                if (v20 == null) {
                                    v21 = null;
                                } else {
                                    v22 = var23_35 = (List)v20.get((Object)AlertCategory.DEDUPED);
                                    v21 = v22 == null ? null : Boxing.boxBoolean((boolean)v22.addAll(dedupedAlerts));
                                }
                                v23 = var22_34 = (Map)nextAlerts.get(trigger.getId());
                                if (v23 != null) ** GOTO lbl317
                                v24 = null;
                                ** GOTO lbl169
lbl317:
                                // 1 sources

                                v25 = var23_35 = (List)v23.get((Object)AlertCategory.NEW);
                                v24 = v25 == null ? null : Boxing.boxBoolean((boolean)v25.addAll(newAlerts));
                                ** GOTO lbl169
                            }
                        }
                        ** while (((MonitorRunResult)monitorResult.element).getInputResults().afterKeysPresent())
lbl321:
                        // 1 sources

                        $this$forEach$iv = currentAlerts;
                        $i$f$forEach = false;
                        currentAlertsForTrigger = $this$forEach$iv.entrySet().iterator();
                        while (currentAlertsForTrigger.hasNext()) {
                            $dstr$trigger$keysToAlertsMap = element$iv = (Map.Entry)currentAlertsForTrigger.next();
                            $i$a$-forEach-MonitorRunner$runBucketLevelMonitor$3 = false;
                            trigger = (Trigger)$dstr$trigger$keysToAlertsMap.getKey();
                            keysToAlertsMap = (Map)$dstr$trigger$keysToAlertsMap.getValue();
                            v26 = var22_34 = (BucketLevelTriggerRunResult)triggerResults.get(trigger.getId());
                            if ((v26 == null ? null : v26.getError()) != null) continue;
                            v27 = var22_34 = (Map)nextAlerts.get(trigger.getId());
                            if (v27 == null) {
                                v28 = null;
                                continue;
                            }
                            v29 = var23_35 = (List)v27.get((Object)AlertCategory.COMPLETED);
                            if (v29 == null) {
                                v28 = null;
                                continue;
                            }
                            var24_36 = MonitorRunner.alertService;
                            v30 = var24_36;
                            if (v30 == null) {
                                Intrinsics.throwUninitializedPropertyAccessException((String)"alertService");
                                v30 = null;
                            }
                            v28 = Boxing.boxBoolean((boolean)v29.addAll((Collection)v30.convertToCompletedAlerts((Map<String, Alert>)keysToAlertsMap)));
                        }
                        var14_20 /* !! */  = monitor.getTriggers().iterator();
lbl348:
                        // 4 sources

                        while (var14_20 /* !! */ .hasNext()) {
                            trigger = (Trigger)var14_20 /* !! */ .next();
                            alertsToUpdate = new LinkedHashSet<E>();
                            completedAlertsToUpdate = new LinkedHashSet<E>();
                            trigger = (Map)nextAlerts.get(trigger.getId());
                            if (trigger == null) {
                                v31 = null;
                            } else {
                                keysToAlertsMap = (List)trigger.get((Object)AlertCategory.DEDUPED);
                                if (keysToAlertsMap == null) {
                                    v31 = null;
                                } else {
                                    $this$filterNot$iv = (Iterable)keysToAlertsMap;
                                    $i$f$filterNot = false;
                                    var25_41 = $this$filterNot$iv;
                                    destination$iv$iv = new ArrayList<E>();
                                    $i$f$filterNotTo = false;
                                    var28_45 = $this$filterNotTo$iv$iv.iterator();
                                    while (var28_45.hasNext()) {
                                        element$iv$iv = var28_45.next();
                                        it = (Alert)element$iv$iv;
                                        $i$a$-filterNot-MonitorRunner$runBucketLevelMonitor$dedupedAlerts$1 = false;
                                        if (it.getState() == Alert.State.ACKNOWLEDGED) continue;
                                        destination$iv$iv.add(element$iv$iv);
                                    }
                                    var22_34 = (List)destination$iv$iv;
                                    v31 = CollectionsKt.toMutableList((Collection)((Collection)var22_34));
                                }
                            }
                            $i$a$-forEach-MonitorRunner$runBucketLevelMonitor$3 = v31;
                            dedupedAlerts = $i$a$-forEach-MonitorRunner$runBucketLevelMonitor$3 == null ? (List)new ArrayList<E>() : $i$a$-forEach-MonitorRunner$runBucketLevelMonitor$3;
                            v32 = $i$a$-forEach-MonitorRunner$runBucketLevelMonitor$3 = (Map)nextAlerts.get(trigger.getId());
                            if (v32 == null) {
                                v33 = null;
                            } else {
                                trigger = v32;
                                keysToAlertsMap = AlertCategory.DEDUPED;
                                trigger.put(keysToAlertsMap, dedupedAlerts);
                                v33 = Unit.INSTANCE;
                            }
                            v34 = keysToAlertsMap = (Map)nextAlerts.get(trigger.getId());
                            trigger = v34 == null ? null : (List)v34.get((Object)AlertCategory.NEW);
                            newAlerts = trigger == null ? (List)new ArrayList<E>() : trigger;
                            v35 = var22_34 = (Map)nextAlerts.get(trigger.getId());
                            keysToAlertsMap = v35 == null ? null : (List)v35.get((Object)AlertCategory.COMPLETED);
                            completedAlerts = keysToAlertsMap == null ? (List)new ArrayList<E>() : keysToAlertsMap;
                            completedAlertsToUpdate.addAll((Collection)completedAlerts);
                            v36 = triggerContexts.get(trigger.getId());
                            Intrinsics.checkNotNull(v36);
                            triggerCtx = (BucketLevelTriggerExecutionContext)v36;
                            v37 = triggerResults.get(trigger.getId());
                            Intrinsics.checkNotNull(v37);
                            triggerResult = (BucketLevelTriggerRunResult)v37;
                            $i$f$filterNot = ((MonitorRunResult)monitorResult.element).getError();
                            v38 = $i$f$filterNot;
                            if (v38 == null) {
                                v38 = triggerResult.getError();
                            }
                            monitorOrTriggerError = v38;
                            shouldDefaultToPerExecution = this.defaultToPerExecutionAction(monitor.getId(), trigger.getId(), dedupedAlerts.size() + newAlerts.size() + completedAlerts.size(), monitorOrTriggerError);
                            $this$filterNotTo$iv$iv = trigger.getActions().iterator();
lbl408:
                            // 4 sources

                            while ($this$filterNotTo$iv$iv.hasNext()) {
                                action = (Action)$this$filterNotTo$iv$iv.next();
                                v39 = AlertingUtilsKt.getActionExecutionPolicy(action, monitor);
                                Intrinsics.checkNotNull((Object)v39);
                                actionExecutionScope = v39.getActionExecutionScope();
                                if (!(actionExecutionScope instanceof PerAlertActionScope) || shouldDefaultToPerExecution) break block82;
                                var28_45 = ((PerAlertActionScope)actionExecutionScope).getActionableAlerts().iterator();
                                while (var28_45.hasNext()) {
                                    alertCategory /* !! */  = (AlertCategory)var28_45.next();
                                    v40 = var32_52 = (Map)nextAlerts.get(trigger.getId());
                                    var31_51 = v40 == null ? null : (List)v40.get((Object)alertCategory /* !! */ );
                                    alertsToExecuteActionsFor = var31_51 == null ? (List)new ArrayList<E>() : var31_51;
                                    var31_51 = alertsToExecuteActionsFor.iterator();
lbl421:
                                    // 2 sources

                                    while (var31_51.hasNext()) {
                                        alert = (Alert)var31_51.next();
                                        actionCtx = this.getActionContextForAlertCategory(alertCategory /* !! */ , (Alert)alert, triggerCtx, monitorOrTriggerError);
                                        v41 = alert.getAggregationResultBucket();
                                        Intrinsics.checkNotNull((Object)v41);
                                        alertBucketKeysHash = AlertingUtilsKt.getBucketKeysHash(v41);
                                        if (!triggerResult.getActionResultsMap().containsKey(alertBucketKeysHash)) {
                                            var35_59 = triggerResult.getActionResultsMap();
                                            var36_60 = new LinkedHashMap<K, V>();
                                            var35_59.put(alertBucketKeysHash, (Map<String, ActionRunResult>)var36_60);
                                        }
                                        if (!this.isActionActionable(action, (Alert)alert)) break block83;
                                        $continuation.L$0 = this;
                                        $continuation.L$1 = monitor;
                                        $continuation.L$2 = monitorResult;
                                        $continuation.L$3 = currentAlerts;
                                        $continuation.L$4 = triggerResults;
                                        $continuation.L$5 = triggerContexts;
                                        $continuation.L$6 = nextAlerts;
                                        $continuation.L$7 = firstPageOfInputResults;
                                        $continuation.L$8 = var14_20 /* !! */ ;
                                        $continuation.L$9 = trigger;
                                        $continuation.L$10 = alertsToUpdate;
                                        $continuation.L$11 = completedAlertsToUpdate;
                                        $continuation.L$12 = dedupedAlerts;
                                        $continuation.L$13 = newAlerts;
                                        $continuation.L$14 = completedAlerts;
                                        $continuation.L$15 = triggerCtx;
                                        $continuation.L$16 = triggerResult;
                                        $continuation.L$17 = monitorOrTriggerError;
                                        $continuation.L$18 = $this$filterNotTo$iv$iv;
                                        $continuation.L$19 = action;
                                        $continuation.L$20 = var28_45;
                                        $continuation.L$21 = alertCategory /* !! */ ;
                                        $continuation.L$22 = var31_51;
                                        $continuation.L$23 = alert;
                                        $continuation.L$24 = alertBucketKeysHash;
                                        $continuation.Z$0 = dryrun;
                                        $continuation.Z$1 = shouldDefaultToPerExecution;
                                        $continuation.label = 7;
                                        v42 = this.runAction(action, actionCtx, dryrun != false, (Continuation<? super ActionRunResult>)$continuation);
                                        if (v42 == var46_8) {
                                            return var46_8;
                                        }
                                        ** GOTO lbl499
                                    }
                                }
                            }
                            break block84;
                        }
                        {
                            break;
                            case 7: {
                                shouldDefaultToPerExecution = $continuation.Z$1;
                                dryrun = $continuation.Z$0;
                                alertBucketKeysHash = (String)$continuation.L$24;
                                alert = (Alert)$continuation.L$23;
                                var31_51 = (Iterator<E>)$continuation.L$22;
                                alertCategory /* !! */  = (AlertCategory)$continuation.L$21;
                                var28_45 = (Iterator<T>)$continuation.L$20;
                                action = (Action)$continuation.L$19;
                                $this$filterNotTo$iv$iv = (Iterator)$continuation.L$18;
                                monitorOrTriggerError = (Exception)$continuation.L$17;
                                triggerResult = (BucketLevelTriggerRunResult)$continuation.L$16;
                                triggerCtx = (BucketLevelTriggerExecutionContext)$continuation.L$15;
                                completedAlerts = (List)$continuation.L$14;
                                newAlerts = (List)$continuation.L$13;
                                dedupedAlerts = (List)$continuation.L$12;
                                completedAlertsToUpdate = (Set)$continuation.L$11;
                                alertsToUpdate = (Set)$continuation.L$10;
                                trigger = (Trigger)$continuation.L$9;
                                var14_20 /* !! */  = (Iterator)$continuation.L$8;
                                firstPageOfInputResults = (Ref.ObjectRef)$continuation.L$7;
                                nextAlerts = (Map)$continuation.L$6;
                                triggerContexts = (Map)$continuation.L$5;
                                triggerResults = (Map)$continuation.L$4;
                                currentAlerts = (Map)$continuation.L$3;
                                monitorResult = (Ref.ObjectRef)$continuation.L$2;
                                monitor = (Monitor)$continuation.L$1;
                                this = (MonitorRunner)$continuation.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v42 = $result;
lbl499:
                                // 2 sources

                                v43 = (ActionRunResult)v42;
                                break block85;
                            }
                        }
                    }
                    v43 = new ActionRunResult(action.getId(), action.getName(), MapsKt.emptyMap(), true, null, null);
                }
                actionResult = v43;
                var36_60 = triggerResult.getActionResultsMap().get(alertBucketKeysHash);
                if (var36_60 == null) {
                    v44 = null;
                } else {
                    var38_64 = action.getId();
                    var37_61.put((String)var38_64, (ActionRunResult)actionResult);
                    v44 = Unit.INSTANCE;
                }
                alertsToUpdate.add(alert);
                completedAlertsToUpdate.remove(alert);
                ** GOTO lbl421
            }
            if (!(actionExecutionScope instanceof PerExecutionActionScope) && !shouldDefaultToPerExecution || monitorOrTriggerError == null && dedupedAlerts.isEmpty() && newAlerts.isEmpty() && completedAlerts.isEmpty()) ** GOTO lbl408
            alertCategory /* !! */  = ((MonitorRunResult)monitorResult.element).getError();
            v45 /* !! */  = alertCategory /* !! */ ;
            if (v45 /* !! */  == null) {
                v45 /* !! */  = triggerResult.getError();
            }
            actionCtx = BucketLevelTriggerExecutionContext.copy$default(triggerCtx, null, null, null, null, null, dedupedAlerts, (List)newAlerts, (List)completedAlerts, (Exception)v45 /* !! */ , 31, null);
            $continuation.L$0 = this;
            $continuation.L$1 = monitor;
            $continuation.L$2 = monitorResult;
            $continuation.L$3 = currentAlerts;
            $continuation.L$4 = triggerResults;
            $continuation.L$5 = triggerContexts;
            $continuation.L$6 = nextAlerts;
            $continuation.L$7 = firstPageOfInputResults;
            $continuation.L$8 = var14_20 /* !! */ ;
            $continuation.L$9 = trigger;
            $continuation.L$10 = alertsToUpdate;
            $continuation.L$11 = completedAlertsToUpdate;
            $continuation.L$12 = dedupedAlerts;
            $continuation.L$13 = newAlerts;
            $continuation.L$14 = completedAlerts;
            $continuation.L$15 = triggerCtx;
            $continuation.L$16 = triggerResult;
            $continuation.L$17 = monitorOrTriggerError;
            $continuation.L$18 = $this$filterNotTo$iv$iv;
            $continuation.L$19 = action;
            $continuation.L$20 = null;
            $continuation.L$21 = null;
            $continuation.L$22 = null;
            $continuation.L$23 = null;
            $continuation.L$24 = null;
            $continuation.Z$0 = dryrun;
            $continuation.Z$1 = shouldDefaultToPerExecution;
            $continuation.label = 8;
            v46 = this.runAction(action, (BucketLevelTriggerExecutionContext)actionCtx, dryrun != false, (Continuation<? super ActionRunResult>)$continuation);
            if (v46 == var46_8) {
                return var46_8;
            }
            ** GOTO lbl582
            {
                case 8: {
                    shouldDefaultToPerExecution = $continuation.Z$1;
                    dryrun = $continuation.Z$0;
                    action = (Action)$continuation.L$19;
                    $this$filterNotTo$iv$iv = (Iterator<Action>)$continuation.L$18;
                    monitorOrTriggerError = (Exception)$continuation.L$17;
                    triggerResult = (BucketLevelTriggerRunResult)$continuation.L$16;
                    triggerCtx = (BucketLevelTriggerExecutionContext)$continuation.L$15;
                    completedAlerts = (List)$continuation.L$14;
                    newAlerts = (List)$continuation.L$13;
                    dedupedAlerts = (List)$continuation.L$12;
                    completedAlertsToUpdate = (Set)$continuation.L$11;
                    alertsToUpdate = (Set)$continuation.L$10;
                    trigger = (Trigger)$continuation.L$9;
                    var14_20 /* !! */  = (Iterator)$continuation.L$8;
                    firstPageOfInputResults = (Ref.ObjectRef)$continuation.L$7;
                    nextAlerts = (Map)$continuation.L$6;
                    triggerContexts = (Map)$continuation.L$5;
                    triggerResults = (Map)$continuation.L$4;
                    currentAlerts = (Map)$continuation.L$3;
                    monitorResult = (Ref.ObjectRef)$continuation.L$2;
                    monitor = (Monitor)$continuation.L$1;
                    this = (MonitorRunner)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v46 = $result;
lbl582:
                    // 2 sources

                    actionResult = (ActionRunResult)v46;
                    if (monitorOrTriggerError == null) {
                        v47 = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)dedupedAlerts, (Iterable)((Iterable)newAlerts)), (Iterable)((Iterable)completedAlerts));
                    } else {
                        alert = (Map)currentAlerts.get(trigger);
                        if (alert == null) {
                            v48 = null;
                        } else {
                            $i$f$map = false;
                            actionResult = $this$map$iv;
                            destination$iv$iv = new ArrayList<E>($this$map$iv.size());
                            $i$f$mapTo = false;
                            var38_64 = $this$mapTo$iv$iv.entrySet().iterator();
                            while (var38_64.hasNext()) {
                                var40_66 = item$iv$iv = var38_64.next();
                                var42_68 = destination$iv$iv;
                                $i$a$-map-MonitorRunner$runBucketLevelMonitor$alertsToIterate$1 = false;
                                var43_69 = (Alert)it.getValue();
                                var42_68.add(var43_69);
                            }
                            v48 = (List)destination$iv$iv;
                        }
                        var31_51 = v48;
                        v47 = var31_51 == null ? CollectionsKt.emptyList() : var31_51;
                    }
                    alertsToIterate = v47;
                    for (Object alert : alertsToIterate) {
                        v49 = alert.getAggregationResultBucket();
                        Intrinsics.checkNotNull((Object)v49);
                        alertBucketKeysHash = AlertingUtilsKt.getBucketKeysHash(v49);
                        if (!triggerResult.getActionResultsMap().containsKey(alertBucketKeysHash)) {
                            $i$f$map = triggerResult.getActionResultsMap();
                            $this$mapTo$iv$iv = (Map<String, ActionRunResult>)new LinkedHashMap<K, V>();
                            $i$f$map.put((String)alertBucketKeysHash, $this$mapTo$iv$iv);
                        }
                        if (($i$f$map = triggerResult.getActionResultsMap().get(alertBucketKeysHash)) == null) {
                            v50 = null;
                        } else {
                            var36_60 = action.getId();
                            $this$mapTo$iv$iv.put((String)var36_60, actionResult);
                            v50 = Unit.INSTANCE;
                        }
                        alertsToUpdate.add(alert);
                        completedAlertsToUpdate.remove(alert);
                    }
                    ** GOTO lbl408
                }
            }
        }
        $this$map$iv = alertsToUpdate;
        $i$f$map = false;
        actionCtx = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            alertBucketKeysHash = (Alert)item$iv$iv;
            var42_68 = destination$iv$iv;
            $i$a$-map-MonitorRunner$runBucketLevelMonitor$updatedAlerts$1 = false;
            v51 = alert.getAggregationResultBucket();
            Intrinsics.checkNotNull((Object)v51);
            bucketKeysHash = AlertingUtilsKt.getBucketKeysHash(v51);
            var36_60 = triggerResult.getActionResultsMap();
            var37_63 = MapsKt.emptyMap();
            actionResults = var36_60.getOrDefault(bucketKeysHash, (Map<String, ActionRunResult>)var37_63);
            var36_60 = MonitorRunner.alertService;
            v52 = var36_60;
            if (v52 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"alertService");
                v52 = null;
            }
            v53 = Alert.copy$default((Alert)alert, null, 0L, 0, null, null, 0L, null, null, null, null, null, null, MonitorRunner.INSTANCE.currentTime(), null, null, null, null, null, null, 520191, null);
            var36_60 = ((MonitorRunResult)monitorResult.element).alertError();
            v54 = var36_60;
            if (v54 == null) {
                v54 = triggerResult.alertError();
            }
            var43_69 = v52.updateActionResultsForBucketLevelAlert(v53, actionResults, (AlertError)v54);
            var42_68.add(var43_69);
        }
        updatedAlerts = (List)destination$iv$iv;
        if (dryrun || Intrinsics.areEqual((Object)monitor.getId(), (Object)"")) ** GOTO lbl348
        var26_42 = MonitorRunner.alertService;
        v55 = var26_42;
        if (v55 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"alertService");
            v55 = null;
        }
        if ((v56 = (var26_42 = MonitorRunner.retryPolicy)) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"retryPolicy");
            v56 = null;
        }
        $continuation.L$0 = this;
        $continuation.L$1 = monitor;
        $continuation.L$2 = monitorResult;
        $continuation.L$3 = currentAlerts;
        $continuation.L$4 = triggerResults;
        $continuation.L$5 = triggerContexts;
        $continuation.L$6 = nextAlerts;
        $continuation.L$7 = firstPageOfInputResults;
        $continuation.L$8 = var14_20 /* !! */ ;
        $continuation.L$9 = completedAlertsToUpdate;
        $continuation.L$10 = null;
        $continuation.L$11 = null;
        $continuation.L$12 = null;
        $continuation.L$13 = null;
        $continuation.L$14 = null;
        $continuation.L$15 = null;
        $continuation.L$16 = null;
        $continuation.L$17 = null;
        $continuation.L$18 = null;
        $continuation.L$19 = null;
        $continuation.L$20 = null;
        $continuation.L$21 = null;
        $continuation.L$22 = null;
        $continuation.L$23 = null;
        $continuation.L$24 = null;
        $continuation.Z$0 = dryrun;
        $continuation.label = 9;
        v57 = v55.saveAlerts(updatedAlerts, (BackoffPolicy)v56, false, (Continuation<? super Unit>)$continuation);
        if (v57 == var46_8) {
            return var46_8;
        }
        ** GOTO lbl715
        {
            case 9: {
                dryrun = $continuation.Z$0;
                completedAlertsToUpdate = (Set)$continuation.L$9;
                var14_20 /* !! */  = (Iterator)$continuation.L$8;
                firstPageOfInputResults = (Ref.ObjectRef)$continuation.L$7;
                nextAlerts = (Map)$continuation.L$6;
                triggerContexts = (Map)$continuation.L$5;
                triggerResults = (Map)$continuation.L$4;
                currentAlerts = (Map)$continuation.L$3;
                monitorResult = (Ref.ObjectRef)$continuation.L$2;
                monitor = (Monitor)$continuation.L$1;
                this = (MonitorRunner)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v57 = $result;
lbl715:
                // 2 sources

                if ((v58 = (var26_42 = MonitorRunner.alertService)) == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"alertService");
                    v58 = null;
                }
                v59 = CollectionsKt.toList((Iterable)completedAlertsToUpdate);
                var26_42 = MonitorRunner.retryPolicy;
                v60 = var26_42;
                if (v60 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"retryPolicy");
                    v60 = null;
                }
                $continuation.L$0 = this;
                $continuation.L$1 = monitor;
                $continuation.L$2 = monitorResult;
                $continuation.L$3 = currentAlerts;
                $continuation.L$4 = triggerResults;
                $continuation.L$5 = triggerContexts;
                $continuation.L$6 = nextAlerts;
                $continuation.L$7 = firstPageOfInputResults;
                $continuation.L$8 = var14_20 /* !! */ ;
                $continuation.L$9 = null;
                $continuation.Z$0 = dryrun;
                $continuation.label = 10;
                v61 = v58.saveAlerts(v59, (BackoffPolicy)v60, false, (Continuation<? super Unit>)$continuation);
                if (v61 != var46_8) ** GOTO lbl348
                return var46_8;
            }
            case 10: {
                dryrun = $continuation.Z$0;
                var14_20 /* !! */  = (Settings)$continuation.L$8;
                firstPageOfInputResults = (Ref.ObjectRef)$continuation.L$7;
                nextAlerts = (Map)$continuation.L$6;
                triggerContexts = (Map)$continuation.L$5;
                triggerResults = (Map)$continuation.L$4;
                currentAlerts = (Map)$continuation.L$3;
                monitorResult = (Ref.ObjectRef)$continuation.L$2;
                monitor = (Monitor)$continuation.L$1;
                this = (MonitorRunner)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v61 = $result;
                ** GOTO lbl348
            }
        }
        return MonitorRunResult.copy$default((MonitorRunResult)monitorResult.element, null, null, null, null, (InputRunResults)firstPageOfInputResults.element, triggerResults, 15, null);
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static /* synthetic */ Object runBucketLevelMonitor$default(MonitorRunner monitorRunner, Monitor monitor, Instant instant, Instant instant2, boolean bl, Continuation continuation, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        return monitorRunner.runBucketLevelMonitor(monitor, instant, instant2, bl, (Continuation<? super MonitorRunResult<BucketLevelTriggerRunResult>>)continuation);
    }

    private final boolean defaultToPerExecutionAction(String monitorId, String triggerId, int totalActionableAlertCount, Exception monitorOrTriggerError) {
        if (monitorOrTriggerError != null) {
            logger.debug("Trigger [" + triggerId + "] in monitor [" + monitorId + "] encountered an error. Defaulting to [" + ActionExecutionScope.Type.PER_EXECUTION + "] for action execution to communicate error.");
            return true;
        }
        if (maxActionableAlertCount < 0L) {
            return false;
        }
        if ((long)totalActionableAlertCount > maxActionableAlertCount) {
            logger.debug("The total actionable alerts for trigger [" + triggerId + "] in monitor [" + monitorId + "] is [" + totalActionableAlertCount + "] which exceeds the maximum of [" + maxActionableAlertCount + "]. Defaulting to [" + ActionExecutionScope.Type.PER_EXECUTION + "] for action execution.");
            return true;
        }
        return false;
    }

    private final List<String> getRolesForMonitor(Monitor monitor) {
        List list;
        if (monitor.getUser() == null) {
            Settings settings = MonitorRunner.settings;
            if (settings == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
                settings = null;
            }
            Object[] objectArray = new String[]{"all_access", "AmazonES_all_access"};
            List list2 = settings.getAsList("", CollectionsKt.listOf((Object[])objectArray));
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"{\n            // fixme: \u2026S_all_access\"))\n        }");
            list = list2;
        } else {
            List list3 = monitor.getUser().getRoles();
            Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"{\n            monitor.user.roles\n        }");
            list = list3;
        }
        return list;
    }

    private final Instant currentTime() {
        ThreadPool threadPool = MonitorRunner.threadPool;
        if (threadPool == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"threadPool");
            threadPool = null;
        }
        return Instant.ofEpochMilli(threadPool.absoluteTimeInMillis());
    }

    private final boolean isActionActionable(Action action, Alert alert) {
        if (alert == null || action.getThrottle() == null) {
            return true;
        }
        if (action.getThrottleEnabled()) {
            ActionExecutionResult result;
            Object v0;
            block3: {
                Iterable $this$firstOrNull$iv = alert.getActionExecutionResults();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    ActionExecutionResult r = (ActionExecutionResult)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)r.getActionId(), (Object)action.getId())) continue;
                    v0 = element$iv;
                    break block3;
                }
                v0 = null;
            }
            ActionExecutionResult actionExecutionResult = result = (ActionExecutionResult)v0;
            Instant lastExecutionTime = actionExecutionResult == null ? null : actionExecutionResult.getLastExecutionTime();
            Instant throttledTimeBound = this.currentTime().minus(action.getThrottle().getValue(), action.getThrottle().getUnit());
            return lastExecutionTime == null || lastExecutionTime.isBefore(throttledTimeBound);
        }
        return true;
    }

    private final BucketLevelTriggerExecutionContext getActionContextForAlertCategory(AlertCategory alertCategory, Alert alert, BucketLevelTriggerExecutionContext ctx, Exception error) {
        BucketLevelTriggerExecutionContext bucketLevelTriggerExecutionContext;
        switch (WhenMappings.$EnumSwitchMapping$0[alertCategory.ordinal()]) {
            case 1: {
                bucketLevelTriggerExecutionContext = BucketLevelTriggerExecutionContext.copy$default(ctx, null, null, null, null, null, CollectionsKt.listOf((Object)alert), CollectionsKt.emptyList(), CollectionsKt.emptyList(), error, 31, null);
                break;
            }
            case 2: {
                bucketLevelTriggerExecutionContext = BucketLevelTriggerExecutionContext.copy$default(ctx, null, null, null, null, null, CollectionsKt.emptyList(), CollectionsKt.listOf((Object)alert), CollectionsKt.emptyList(), error, 31, null);
                break;
            }
            case 3: {
                bucketLevelTriggerExecutionContext = BucketLevelTriggerExecutionContext.copy$default(ctx, null, null, null, null, null, CollectionsKt.emptyList(), CollectionsKt.emptyList(), CollectionsKt.listOf((Object)alert), error, 31, null);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bucketLevelTriggerExecutionContext;
    }

    /*
     * Unable to fully structure code
     */
    private final Object runAction(Action var1_1, QueryLevelTriggerExecutionContext var2_2, boolean var3_3, Continuation<? super ActionRunResult> var4_4) {
        if (!(var4_4 instanceof runAction.1)) ** GOTO lbl-1000
        var8_5 = var4_4;
        if ((var8_5.label & -2147483648) != 0) {
            var8_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var4_4){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ MonitorRunner this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return MonitorRunner.access$runAction(this.this$0, null, null, false, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var9_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (!this.isActionActionable(action, ctx.getAlert())) {
                    return new ActionRunResult(action.getId(), action.getName(), MapsKt.emptyMap(), true, null, null);
                }
                actionOutput = new LinkedHashMap<K, V>();
                actionOutput.put("subject", action.getSubjectTemplate() != null ? this.compileTemplate(action.getSubjectTemplate(), (TriggerExecutionContext)ctx) : "");
                actionOutput.put("message", this.compileTemplate(action.getMessageTemplate(), var2_2));
                if (Strings.isNullOrEmpty((String)((String)actionOutput.get("message")))) {
                    throw new IllegalStateException("Message content missing in the Destination with id: " + action.getDestinationId());
                }
                if (dryrun != false) ** GOTO lbl40
                $continuation.L$0 = this;
                $continuation.L$1 = action;
                $continuation.L$2 = actionOutput;
                $continuation.label = 1;
                v0 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(action, (Map<String, String>)actionOutput, null){
                    Object L$0;
                    int label;
                    final /* synthetic */ Action $action;
                    final /* synthetic */ Map<String, String> $actionOutput;
                    {
                        this.$action = $action;
                        this.$actionOutput = $actionOutput;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object var1_1) {
                        var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)var1_1);
                                v0 = MonitorRunner.access$getClient$p();
                                if (v0 == null) {
                                    Intrinsics.throwUninitializedPropertyAccessException((String)"client");
                                    v0 = null;
                                }
                                if ((v1 = MonitorRunner.access$getXContentRegistry$p()) == null) {
                                    Intrinsics.throwUninitializedPropertyAccessException((String)"xContentRegistry");
                                    v1 = null;
                                }
                                this.label = 1;
                                v2 = AlertingConfigAccessor.Companion.getDestinationInfo(v0, v1, this.$action.getDestinationId(), (Continuation<? super Destination>)((Continuation)this));
                                if (v2 == var4_2) {
                                    return var4_2;
                                }
                                ** GOTO lbl20
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                v2 = $result;
lbl20:
                                // 2 sources

                                if (!AlertingUtilsKt.isAllowed(destination = (Destination)v2, MonitorRunner.access$getAllowList$p())) {
                                    throw new IllegalStateException("Monitor contains a Destination type that is not allowed: " + destination.getType());
                                }
                                v3 = MonitorRunner.access$getDestinationContextFactory$p();
                                if (v3 == null) {
                                    Intrinsics.throwUninitializedPropertyAccessException((String)"destinationContextFactory");
                                    v3 = null;
                                }
                                this.L$0 = destination;
                                this.label = 2;
                                v4 = v3.getDestinationContext(destination, (Continuation<? super DestinationContext>)((Continuation)this));
                                if (v4 == var4_2) {
                                    return var4_2;
                                }
                                ** GOTO lbl36
                            }
                            case 2: {
                                destination = (Destination)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v4 = $result;
lbl36:
                                // 2 sources

                                destinationCtx = (DestinationContext)v4;
                                v5 = this.$actionOutput.get("message");
                                Intrinsics.checkNotNull((Object)v5);
                                this.$actionOutput.put("messageId", destination.publish(this.$actionOutput.get("subject"), v5, destinationCtx, MonitorRunner.access$getHostDenyList$p()));
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                ** if (v0 != var9_7) goto lbl31
lbl30:
                // 1 sources

                return var9_7;
lbl31:
                // 1 sources

                ** GOTO lbl40
            }
            case 1: {
                actionOutput = (Map)$continuation.L$2;
                action = (Action)$continuation.L$1;
                this = (MonitorRunner)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl40:
                    // 3 sources

                    var5_8 = new ActionRunResult(action.getId(), action.getName(), actionOutput, false, this.currentTime(), null);
                }
                catch (Exception e) {
                    var5_8 = new ActionRunResult(action.getId(), action.getName(), MapsKt.emptyMap(), false, this.currentTime(), e);
                }
                return var5_8;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object runAction(Action var1_1, BucketLevelTriggerExecutionContext var2_2, boolean var3_3, Continuation<? super ActionRunResult> var4_4) {
        if (!(var4_4 instanceof runAction.3)) ** GOTO lbl-1000
        var8_5 = var4_4;
        if ((var8_5.label & -2147483648) != 0) {
            var8_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var4_4){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ MonitorRunner this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return MonitorRunner.access$runAction(this.this$0, null, null, false, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var9_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                actionOutput = new LinkedHashMap<K, V>();
                actionOutput.put("subject", action.getSubjectTemplate() != null ? this.compileTemplate(action.getSubjectTemplate(), (TriggerExecutionContext)ctx) : "");
                actionOutput.put("message", this.compileTemplate(action.getMessageTemplate(), var2_2));
                if (Strings.isNullOrEmpty((String)((String)actionOutput.get("message")))) {
                    throw new IllegalStateException("Message content missing in the Destination with id: " + action.getDestinationId());
                }
                if (dryrun != false) ** GOTO lbl38
                $continuation.L$0 = this;
                $continuation.L$1 = action;
                $continuation.L$2 = actionOutput;
                $continuation.label = 1;
                v0 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(action, (Map<String, String>)actionOutput, null){
                    Object L$0;
                    int label;
                    final /* synthetic */ Action $action;
                    final /* synthetic */ Map<String, String> $actionOutput;
                    {
                        this.$action = $action;
                        this.$actionOutput = $actionOutput;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object var1_1) {
                        var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)var1_1);
                                v0 = MonitorRunner.access$getClient$p();
                                if (v0 == null) {
                                    Intrinsics.throwUninitializedPropertyAccessException((String)"client");
                                    v0 = null;
                                }
                                if ((v1 = MonitorRunner.access$getXContentRegistry$p()) == null) {
                                    Intrinsics.throwUninitializedPropertyAccessException((String)"xContentRegistry");
                                    v1 = null;
                                }
                                this.label = 1;
                                v2 = AlertingConfigAccessor.Companion.getDestinationInfo(v0, v1, this.$action.getDestinationId(), (Continuation<? super Destination>)((Continuation)this));
                                if (v2 == var4_2) {
                                    return var4_2;
                                }
                                ** GOTO lbl20
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                v2 = $result;
lbl20:
                                // 2 sources

                                if (!AlertingUtilsKt.isAllowed(destination = (Destination)v2, MonitorRunner.access$getAllowList$p())) {
                                    throw new IllegalStateException("Monitor contains a Destination type that is not allowed: " + destination.getType());
                                }
                                v3 = MonitorRunner.access$getDestinationContextFactory$p();
                                if (v3 == null) {
                                    Intrinsics.throwUninitializedPropertyAccessException((String)"destinationContextFactory");
                                    v3 = null;
                                }
                                this.L$0 = destination;
                                this.label = 2;
                                v4 = v3.getDestinationContext(destination, (Continuation<? super DestinationContext>)((Continuation)this));
                                if (v4 == var4_2) {
                                    return var4_2;
                                }
                                ** GOTO lbl36
                            }
                            case 2: {
                                destination = (Destination)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v4 = $result;
lbl36:
                                // 2 sources

                                destinationCtx = (DestinationContext)v4;
                                v5 = this.$actionOutput.get("message");
                                Intrinsics.checkNotNull((Object)v5);
                                this.$actionOutput.put("messageId", destination.publish(this.$actionOutput.get("subject"), v5, destinationCtx, MonitorRunner.access$getHostDenyList$p()));
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                ** if (v0 != var9_7) goto lbl29
lbl28:
                // 1 sources

                return var9_7;
lbl29:
                // 1 sources

                ** GOTO lbl38
            }
            case 1: {
                actionOutput = (Map)$continuation.L$2;
                action = (Action)$continuation.L$1;
                this = (MonitorRunner)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl38:
                    // 3 sources

                    var5_8 = new ActionRunResult(action.getId(), action.getName(), actionOutput, false, this.currentTime(), null);
                }
                catch (Exception e) {
                    var5_8 = new ActionRunResult(action.getId(), action.getName(), MapsKt.emptyMap(), false, this.currentTime(), e);
                }
                return var5_8;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final String compileTemplate(Script template, TriggerExecutionContext ctx) {
        ScriptService scriptService = MonitorRunner.scriptService;
        if (scriptService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"scriptService");
            scriptService = null;
        }
        TemplateScript.Factory factory = (TemplateScript.Factory)scriptService.compile(template, TemplateScript.CONTEXT);
        Map map = template.getParams();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"template.params");
        String string = factory.newInstance(MapsKt.plus((Map)map, (Map)MapsKt.mapOf((Pair)TuplesKt.to((Object)"ctx", ctx.asTemplateArg())))).execute();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"scriptService.compile(te\u2026))\n            .execute()");
        return string;
    }

    private static final void registerConsumers$lambda-0(TimeValue millis, Integer count) {
        Intrinsics.checkNotNullExpressionValue((Object)count, (String)"count");
        BackoffPolicy backoffPolicy = BackoffPolicy.constantBackoff((TimeValue)millis, (int)count);
        Intrinsics.checkNotNullExpressionValue((Object)backoffPolicy, (String)"constantBackoff(millis, count)");
        retryPolicy = backoffPolicy;
    }

    private static final void registerConsumers$lambda-1(TimeValue millis, Integer count) {
        Intrinsics.checkNotNullExpressionValue((Object)count, (String)"count");
        BackoffPolicy backoffPolicy = BackoffPolicy.exponentialBackoff((TimeValue)millis, (int)count);
        Intrinsics.checkNotNullExpressionValue((Object)backoffPolicy, (String)"exponentialBackoff(millis, count)");
        moveAlertsRetryPolicy = backoffPolicy;
    }

    private static final void registerConsumers$lambda-2(List it) {
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        allowList = it;
    }

    private static final void registerConsumers$lambda-3(Long it) {
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        maxActionableAlertCount = it;
    }

    public static final /* synthetic */ BackoffPolicy access$getMoveAlertsRetryPolicy$p() {
        return moveAlertsRetryPolicy;
    }

    public static final /* synthetic */ Logger access$getLogger$p() {
        return logger;
    }

    public static final /* synthetic */ AlertIndices access$getAlertIndices$p() {
        return alertIndices;
    }

    public static final /* synthetic */ Client access$getClient$p() {
        return client;
    }

    public static final /* synthetic */ InputService access$getInputService$p() {
        return inputService;
    }

    public static final /* synthetic */ Object access$runAction(MonitorRunner $this, Action action, QueryLevelTriggerExecutionContext ctx, boolean dryrun, Continuation $completion) {
        return $this.runAction(action, ctx, dryrun, (Continuation<? super ActionRunResult>)$completion);
    }

    public static final /* synthetic */ NamedXContentRegistry access$getXContentRegistry$p() {
        return xContentRegistry;
    }

    public static final /* synthetic */ List access$getAllowList$p() {
        return allowList;
    }

    public static final /* synthetic */ DestinationContextFactory access$getDestinationContextFactory$p() {
        return destinationContextFactory;
    }

    public static final /* synthetic */ List access$getHostDenyList$p() {
        return hostDenyList;
    }

    public static final /* synthetic */ Object access$runAction(MonitorRunner $this, Action action, BucketLevelTriggerExecutionContext ctx, boolean dryrun, Continuation $completion) {
        return $this.runAction(action, ctx, dryrun, (Continuation<? super ActionRunResult>)$completion);
    }

    static {
        allowList = DestinationSettings.Companion.getALLOW_LIST_NONE();
        hostDenyList = LegacyOpenDistroDestinationSettings.Companion.getHOST_DENY_LIST_NONE();
        maxActionableAlertCount = 50L;
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AlertCategory.values().length];
            nArray[AlertCategory.DEDUPED.ordinal()] = 1;
            nArray[AlertCategory.NEW.ordinal()] = 2;
            nArray[AlertCategory.COMPLETED.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

