/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.tree;

import com.amazon.randomcutforest.CommonUtils;
import com.amazon.randomcutforest.tree.AbstractBoundingBox;
import com.amazon.randomcutforest.tree.AbstractRandomCutTree;
import com.amazon.randomcutforest.tree.BoundingBox;
import com.amazon.randomcutforest.tree.Cut;
import com.amazon.randomcutforest.tree.INode;
import com.amazon.randomcutforest.tree.Node;
import java.util.Arrays;
import java.util.Random;

public class RandomCutTree
extends AbstractRandomCutTree<double[], Node, double[]> {
    public static final int DEFAULT_OUTPUT_AFTER = 64;

    public static Builder<?> builder() {
        return new Builder();
    }

    public static RandomCutTree defaultTree(long randomSeed) {
        return ((Builder)RandomCutTree.builder().randomSeed(randomSeed)).build();
    }

    public static RandomCutTree defaultTree() {
        return ((Builder)RandomCutTree.builder().random(new Random())).build();
    }

    public boolean centerOfMassEnabled() {
        return this.centerOfMassEnabled;
    }

    public boolean storeSequenceIndexesEnabled() {
        return this.storeSequenceIndexesEnabled;
    }

    protected RandomCutTree(Builder<?> builder) {
        super(builder);
        this.root = null;
        this.outputAfter = builder.outputAfter.orElse(64);
    }

    @Override
    protected boolean leftOf(double[] point, int cutDimension, double cutValue) {
        return point[cutDimension] <= cutValue;
    }

    @Override
    protected boolean equals(double[] oldPoint, double[] point) {
        return Arrays.equals(oldPoint, point);
    }

    @Override
    protected boolean referenceEquals(double[] oldPointRef, double[] pointRef) {
        return this.equals(oldPointRef, pointRef);
    }

    @Override
    protected String toString(double[] doubles) {
        return Arrays.toString(doubles);
    }

    @Override
    void setCachedBox(Node node, AbstractBoundingBox<double[]> savedBox) {
        if (this.cacheRandom.nextDouble() < this.boundingBoxCacheFraction) {
            node.setBoundingBox((BoundingBox)savedBox);
        }
    }

    @Override
    void addToBox(Node node, double[] point) {
        node.addToBox(point);
    }

    @Override
    void recomputePointSum(Node node) {
        node.recomputePointSum();
    }

    @Override
    protected double[] getPoint(Node node) {
        return node.getLeafPoint();
    }

    @Override
    protected INode<Node> getNode(Node node) {
        return node;
    }

    @Override
    protected AbstractBoundingBox<double[]> getInternalTwoPointBox(double[] first, double[] second) {
        return new BoundingBox(first, second);
    }

    BoundingBox constructBoxInPlace(BoundingBox currentBox, Node nodeReference) {
        return nodeReference.constructBoxInPlace(currentBox);
    }

    BoundingBox recomputeBox(Node nodeReference) {
        return nodeReference.recomputeBox();
    }

    protected BoundingBox getLeafBoxFromLeafNode(Node node) {
        return new BoundingBox(node.getLeafPoint());
    }

    protected BoundingBox getMutableLeafBoxFromLeafNode(Node node) {
        double[] leafPoint = node.getLeafPoint();
        return new BoundingBox(Arrays.copyOf(leafPoint, leafPoint.length), Arrays.copyOf(leafPoint, leafPoint.length), 0.0);
    }

    protected BoundingBox constructBoxInPlace(Node node) {
        return node.constructBoxInPlace();
    }

    @Override
    double[] getPointFromLeafNode(Node node) {
        CommonUtils.checkState(node.isLeaf(), "Incorrect use");
        return node.getLeafPoint();
    }

    @Override
    double[] getPointFromPointReference(double[] pointIndex) {
        return pointIndex;
    }

    @Override
    double[] getPointReference(Node node) {
        return node.getLeafPoint();
    }

    @Override
    protected boolean isLeaf(Node node) {
        return node.isLeaf();
    }

    @Override
    protected int decrementMass(Node node) {
        return node.decrementMass();
    }

    @Override
    protected int incrementMass(Node node) {
        return node.incrementMass();
    }

    @Override
    protected Node getSibling(Node node) {
        Node parent = node.getParent();
        if (parent.getLeftChild() == node) {
            return parent.getRightChild();
        }
        if (parent.getRightChild() == node) {
            return parent.getLeftChild();
        }
        throw new IllegalStateException(" incorrect state ");
    }

    @Override
    protected Node getParent(Node node) {
        return node.getParent();
    }

    @Override
    protected void setParent(Node node, Node parent) {
        node.setParent(parent);
    }

    @Override
    protected void delete(Node node) {
    }

    @Override
    protected int getCutDimension(Node node) {
        return node.getCutDimension();
    }

    @Override
    protected double getCutValue(Node node) {
        return node.getCut().getValue();
    }

    @Override
    protected Node getLeftChild(Node node) {
        return node.getLeftChild();
    }

    @Override
    protected Node getRightChild(Node node) {
        return node.getRightChild();
    }

    @Override
    void replaceChild(Node parent, Node child, Node otherNode) {
        if (parent.getLeftChild() == child) {
            parent.setLeftChild(otherNode);
        } else if (parent.getRightChild() == child) {
            parent.setRightChild(otherNode);
        } else {
            throw new IllegalStateException(" incorrect state ");
        }
        otherNode.setParent(parent);
    }

    @Override
    protected void replaceNodeBySibling(Node grandParent, Node parent, Node node) {
        this.replaceChild(grandParent, parent, this.getSibling(node));
    }

    @Override
    protected Node addLeaf(double[] pointIndex) {
        Node candidate = new Node(pointIndex);
        candidate.setMass(1);
        return candidate;
    }

    @Override
    protected Node addNode(Node leftChild, Node rightChild, int cutDimension, double cutValue, int mass) {
        Node candidate = new Node(leftChild, rightChild, new Cut(cutDimension, cutValue), null, this.centerOfMassEnabled);
        candidate.setMass(mass);
        return candidate;
    }

    @Override
    protected void increaseMassOfAncestors(Node mergedNode) {
        for (Node parent = mergedNode.getParent(); parent != null; parent = parent.getParent()) {
            parent.incrementMass();
        }
    }

    @Override
    protected void decreaseMassOfAncestors(Node mergedNode) {
        for (Node parent = mergedNode.getParent(); parent != null; parent = parent.getParent()) {
            parent.decrementMass();
        }
    }

    @Override
    void setLeafPointReference(Node node, double[] point) {
    }

    @Override
    protected int getMass(Node node) {
        return node.getMass();
    }

    @Override
    protected void addSequenceIndex(Node node, long uniqueSequenceNumber) {
        node.addSequenceIndex(uniqueSequenceNumber);
    }

    @Override
    protected void deleteSequenceIndex(Node node, long uniqueSequenceNumber) {
        if (this.storeSequenceIndexesEnabled && !node.getSequenceIndexes().contains(uniqueSequenceNumber)) {
            throw new IllegalStateException("Error in sequence index. Inconsistency in trees in delete step.");
        }
        node.deleteSequenceIndex(uniqueSequenceNumber);
    }

    public static class Builder<T extends Builder<T>>
    extends AbstractRandomCutTree.Builder<T> {
        public RandomCutTree build() {
            return new RandomCutTree(this);
        }
    }
}

