/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.tree;

import com.amazon.randomcutforest.CommonUtils;
import com.amazon.randomcutforest.tree.AbstractBoundingBox;
import com.amazon.randomcutforest.tree.BoundingBox;
import com.amazon.randomcutforest.tree.Cut;
import com.amazon.randomcutforest.tree.INode;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class Node
implements INode<Node> {
    private final double[] leafPoint;
    private double[] pointSum;
    private Node parent;
    private Node rightChild;
    private Node leftChild;
    private Cut cut;
    private BoundingBox boundingBox;
    private int mass;
    private Map<Long, Integer> sequenceIndexes;

    public Node(Node leftChild, Node rightChild, Cut cut, BoundingBox boundingBox, boolean enableCenterOfMass) {
        this.rightChild = rightChild;
        this.leftChild = leftChild;
        this.cut = cut;
        this.boundingBox = boundingBox;
        this.sequenceIndexes = null;
        if (!enableCenterOfMass) {
            this.pointSum = null;
        } else {
            int dimensions = this.getLeftChild().isLeaf() ? this.getLeftChild().leafPoint.length : this.getLeftChild().pointSum.length;
            this.pointSum = new double[dimensions];
        }
        this.leafPoint = null;
    }

    public Node(Node leftChild, Node rightChild, Cut cut, BoundingBox boundingBox) {
        this(leftChild, rightChild, cut, boundingBox, false);
    }

    public Node(double[] leafPoint) {
        this.leafPoint = leafPoint;
        this.sequenceIndexes = null;
        this.pointSum = null;
        this.boundingBox = null;
        this.rightChild = null;
        this.leftChild = null;
    }

    public static boolean isLeftOf(double[] point, Node node) {
        return Cut.isLeftOf(point, node.cut);
    }

    public Node getParent() {
        return this.parent;
    }

    protected void setParent(Node parent) {
        this.parent = parent;
    }

    public Node getRightChild() {
        return this.rightChild;
    }

    protected void setRightChild(Node rightChild) {
        CommonUtils.checkState(!this.isLeaf(), "Cannot assign child to a leaf node");
        this.rightChild = rightChild;
    }

    public Node getLeftChild() {
        return this.leftChild;
    }

    protected void setLeftChild(Node leftChild) {
        CommonUtils.checkState(!this.isLeaf(), "Cannot assign child to a leaf node");
        this.leftChild = leftChild;
    }

    @Override
    public BoundingBox getBoundingBox() {
        if (this.isLeaf()) {
            return new BoundingBox(this.getLeafPoint());
        }
        if (this.boundingBox != null) {
            return this.boundingBox;
        }
        return this.constructBoxInPlace();
    }

    protected void setBoundingBox(BoundingBox boundingBox) {
        this.boundingBox = boundingBox;
    }

    public boolean leafPointEquals(double[] point) {
        return Arrays.equals(this.leafPoint, point);
    }

    @Override
    public double[] getLeafPoint() {
        CommonUtils.checkState(this.isLeaf(), "Not a leaf node");
        return Arrays.copyOf(this.leafPoint, this.leafPoint.length);
    }

    public double getLeafPoint(int i) {
        CommonUtils.checkState(this.isLeaf(), "Not a leaf node");
        return this.leafPoint[i];
    }

    @Override
    public int getMass() {
        return this.mass;
    }

    protected void setMass(int mass) {
        this.mass = mass;
    }

    protected void addMass(int massDelta) {
        this.mass += massDelta;
    }

    protected int incrementMass() {
        this.addMass(1);
        return this.getMass();
    }

    protected int decrementMass() {
        this.addMass(-1);
        return this.getMass();
    }

    public Cut getCut() {
        return this.cut;
    }

    @Override
    public boolean isLeaf() {
        return this.leafPoint != null;
    }

    protected void subtractFromPointSum(double[] point) {
        CommonUtils.checkState(this.pointSum != null, "center of mass computation is disabled");
        for (int i = 0; i < point.length; ++i) {
            int n = i;
            this.pointSum[n] = this.pointSum[n] - point[i];
        }
    }

    protected void addToPointSum(double[] point) {
        CommonUtils.checkState(this.pointSum != null, "center of mass computation is disabled");
        for (int i = 0; i < point.length; ++i) {
            int n = i;
            this.pointSum[n] = this.pointSum[n] + point[i];
        }
    }

    public double[] getPointSum() {
        int dimensions = this.isLeaf() ? this.leafPoint.length : (this.pointSum != null ? this.pointSum.length : this.boundingBox.getDimensions());
        double[] result = new double[dimensions];
        if (this.leafPoint != null) {
            for (int i = 0; i < dimensions; ++i) {
                result[i] = (double)this.mass * this.leafPoint[i];
            }
        } else if (this.pointSum != null && this.pointSum.length > 0) {
            System.arraycopy(this.pointSum, 0, result, 0, this.pointSum.length);
        }
        return result;
    }

    public double[] getCenterOfMass() {
        if (this.leafPoint != null) {
            return Arrays.copyOf(this.leafPoint, this.leafPoint.length);
        }
        if (this.pointSum == null) {
            this.recomputePointSum();
        }
        double[] result = new double[this.pointSum.length];
        for (int i = 0; i < this.pointSum.length; ++i) {
            result[i] = this.pointSum[i] / (double)this.mass;
        }
        return result;
    }

    @Override
    public Set<Long> getSequenceIndexes() {
        if (this.sequenceIndexes != null) {
            return this.sequenceIndexes.keySet();
        }
        return Collections.emptySet();
    }

    protected void addSequenceIndex(long sequenceIndex) {
        if (this.sequenceIndexes == null) {
            this.sequenceIndexes = new HashMap<Long, Integer>();
        }
        int num = 0;
        if (this.sequenceIndexes.containsKey(sequenceIndex)) {
            num = this.sequenceIndexes.get(sequenceIndex);
        }
        this.sequenceIndexes.put(sequenceIndex, num + 1);
    }

    protected void deleteSequenceIndex(long sequenceIndex) {
        if (this.sequenceIndexes != null) {
            int num = this.sequenceIndexes.get(sequenceIndex);
            if (num == 1) {
                this.sequenceIndexes.remove(sequenceIndex);
            } else {
                this.sequenceIndexes.put(sequenceIndex, num - 1);
            }
        }
    }

    @Override
    public BoundingBox getSiblingBoundingBox(double[] point) {
        Node siblingOfPath = Node.isLeftOf(point, this) ? this.getRightChild() : this.getLeftChild();
        return siblingOfPath == null ? null : siblingOfPath.getBoundingBox();
    }

    @Override
    public int getCutDimension() {
        return this.getCut().getDimension();
    }

    @Override
    public double getCutValue() {
        return this.getCut().getValue();
    }

    public BoundingBox constructBoxInPlace() {
        if (this.isLeaf()) {
            return new BoundingBox(Arrays.copyOf(this.leafPoint, this.leafPoint.length), Arrays.copyOf(this.leafPoint, this.leafPoint.length), 0.0);
        }
        BoundingBox currentBox = this.getLeftChild().constructBoxInPlace();
        return this.getRightChild().constructBoxInPlace(currentBox);
    }

    BoundingBox constructBoxInPlace(BoundingBox currentBox) {
        if (this.isLeaf()) {
            return currentBox.addPoint(this.getLeafPoint());
        }
        if (this.boundingBox != null) {
            return currentBox.addBox((AbstractBoundingBox)this.boundingBox);
        }
        return this.getRightChild().constructBoxInPlace(this.getLeftChild().constructBoxInPlace(currentBox));
    }

    BoundingBox recomputeBox() {
        if (this.boundingBox != null) {
            this.boundingBox = this.constructBoxInPlace();
        }
        return this.boundingBox;
    }

    void recomputePointSum() {
        if (!this.isLeaf()) {
            double[] leftSum = this.getLeftChild().getPointSum();
            double[] rightSum = this.getRightChild().getPointSum();
            assert (leftSum.length == rightSum.length) : "incorrect state";
            if (this.pointSum == null) {
                this.pointSum = new double[leftSum.length];
            }
            for (int i = 0; i < leftSum.length; ++i) {
                this.pointSum[i] = leftSum[i] + rightSum[i];
            }
        }
    }

    void addToBox(double[] point) {
        if (this.boundingBox != null) {
            this.boundingBox.addPoint(point);
        }
    }
}

