/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.tree;

import com.amazon.randomcutforest.CommonUtils;
import com.amazon.randomcutforest.config.Precision;
import com.amazon.randomcutforest.store.IPointStoreView;
import com.amazon.randomcutforest.tree.AbstractBoundingBox;
import com.amazon.randomcutforest.tree.AbstractCompactRandomCutTree;
import com.amazon.randomcutforest.tree.BoundingBoxFloat;
import com.amazon.randomcutforest.tree.BoxCacheFloat;
import com.amazon.randomcutforest.tree.Cut;
import java.util.Arrays;
import java.util.Random;

public class CompactRandomCutTreeFloat
extends AbstractCompactRandomCutTree<float[]> {
    public static Builder builder() {
        return new Builder();
    }

    protected CompactRandomCutTreeFloat(Builder builder) {
        super(builder);
        CommonUtils.checkNotNull(builder.pointStoreView, "pointStore must not be null");
        this.pointStore = builder.pointStoreView;
        this.boxCache = new BoxCacheFloat(0L, this.boundingBoxCacheFraction, this.maxSize - 1);
        if (builder.centerOfMassEnabled) {
            this.pointSum = (Object[])new float[this.maxSize - 1][];
        }
    }

    @Override
    protected String toString(float[] point) {
        return Arrays.toString(point);
    }

    @Override
    protected AbstractBoundingBox<float[]> getLeafBoxFromLeafNode(Integer pointIndex) {
        return new BoundingBoxFloat((float[])this.pointStore.get(this.getPointReference(pointIndex)));
    }

    @Override
    protected AbstractBoundingBox<float[]> getMutableLeafBoxFromLeafNode(Integer nodeReference) {
        float[] leafPoint = (float[])this.pointStore.get(this.getPointReference(nodeReference));
        return new BoundingBoxFloat(leafPoint, Arrays.copyOf(leafPoint, leafPoint.length), 0.0);
    }

    @Override
    protected AbstractBoundingBox<float[]> getInternalTwoPointBox(Integer firstRef, Integer secondRef) {
        float[] first = (float[])this.getPointFromPointReference(firstRef);
        float[] second = (float[])this.getPointFromPointReference(secondRef);
        return new BoundingBoxFloat(first, second);
    }

    @Override
    protected boolean equals(float[] oldPoint, float[] point) {
        return Arrays.equals(oldPoint, point);
    }

    @Override
    protected boolean leftOf(float[] point, int dimension, double val) {
        return (double)point[dimension] <= val;
    }

    @Override
    protected double[] getPoint(Integer nodeOffset) {
        return CommonUtils.toDoubleArray((float[])this.getPointFromLeafNode(nodeOffset));
    }

    @Override
    void recomputePointSum(Integer node) {
        if (((float[][])this.pointSum)[node] == null) {
            ((float[][])this.pointSum)[node.intValue()] = new float[this.pointStore.getDimensions()];
        }
        float[] leftSum = (float[])this.getPointSum(this.getLeftChild(node));
        float[] rightSum = (float[])this.getPointSum(this.getRightChild(node));
        for (int i = 0; i < this.pointStore.getDimensions(); ++i) {
            ((float[][])this.pointSum)[node.intValue()][i] = leftSum[i] + rightSum[i];
        }
    }

    @Override
    protected Cut randomCut(Random random, AbstractBoundingBox<?> box) {
        double rangeSum = box.getRangeSum();
        CommonUtils.checkArgument(rangeSum > 0.0, "box.getRangeSum() must be greater than 0");
        double breakPoint = random.nextDouble() * rangeSum;
        for (int i = 0; i < box.getDimensions(); ++i) {
            double range = box.getRange(i);
            if (breakPoint <= range) {
                float cutValue = (float)(box.getMinValue(i) + breakPoint);
                if ((double)cutValue >= box.getMaxValue(i) && box.getMinValue(i) < box.getMaxValue(i)) {
                    cutValue = Math.nextAfter((float)box.getMaxValue(i), box.getMinValue(i));
                }
                if (cutValue < (float)box.getMinValue(i)) {
                    throw new IllegalStateException(" precision error in single precision cuts");
                }
                return new Cut(i, cutValue);
            }
            breakPoint -= range;
        }
        throw new IllegalStateException("The break point did not lie inside the expected range");
    }

    public int getDimension() {
        return this.dimension;
    }

    public static class Builder
    extends AbstractCompactRandomCutTree.Builder<Builder> {
        private IPointStoreView<float[]> pointStoreView;

        public Builder pointStore(IPointStoreView<float[]> pointStoreView) {
            this.pointStoreView = pointStoreView;
            return this;
        }

        public CompactRandomCutTreeFloat build() {
            if (this.pointStoreView == null) {
                throw new IllegalArgumentException("pointstore cannot be null for compact trees");
            }
            this.dimension = this.pointStoreView.getDimensions();
            this.precision = Precision.FLOAT_32;
            return new CompactRandomCutTreeFloat(this);
        }
    }
}

