/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.tree;

import com.amazon.randomcutforest.CommonUtils;
import com.amazon.randomcutforest.config.Precision;
import com.amazon.randomcutforest.store.IPointStoreView;
import com.amazon.randomcutforest.tree.AbstractBoundingBox;
import com.amazon.randomcutforest.tree.AbstractCompactRandomCutTree;
import com.amazon.randomcutforest.tree.BoundingBox;
import com.amazon.randomcutforest.tree.BoxCacheDouble;
import java.util.Arrays;

public class CompactRandomCutTreeDouble
extends AbstractCompactRandomCutTree<double[]> {
    public static Builder builder() {
        return new Builder();
    }

    protected CompactRandomCutTreeDouble(Builder builder) {
        super(builder);
        CommonUtils.checkNotNull(builder.pointStoreView, "pointStore must not be null");
        this.pointStore = builder.pointStoreView;
        this.boxCache = new BoxCacheDouble(0L, this.boundingBoxCacheFraction, this.maxSize - 1);
        if (builder.centerOfMassEnabled) {
            this.pointSum = (Object[])new double[this.maxSize - 1][];
        }
    }

    @Override
    protected String toString(double[] point) {
        return Arrays.toString(point);
    }

    @Override
    protected AbstractBoundingBox<double[]> getInternalTwoPointBox(Integer firstRef, Integer secondRef) {
        double[] first = (double[])this.getPointFromPointReference(firstRef);
        double[] second = (double[])this.getPointFromPointReference(secondRef);
        return new BoundingBox(first, second);
    }

    @Override
    protected boolean equals(double[] oldPoint, double[] point) {
        return Arrays.equals(oldPoint, point);
    }

    @Override
    protected AbstractBoundingBox<double[]> getLeafBoxFromLeafNode(Integer nodeReference) {
        return new BoundingBox((double[])this.pointStore.get(this.getPointReference(nodeReference)));
    }

    @Override
    protected AbstractBoundingBox<double[]> getMutableLeafBoxFromLeafNode(Integer nodeReference) {
        double[] leafPoint = (double[])this.pointStore.get(this.getPointReference(nodeReference));
        return new BoundingBox(leafPoint, Arrays.copyOf(leafPoint, leafPoint.length), 0.0);
    }

    @Override
    protected boolean leftOf(double[] point, int dimension, double val) {
        return point[dimension] <= val;
    }

    @Override
    protected double[] getPoint(Integer node) {
        return (double[])this.pointStore.get(this.getPointReference(node));
    }

    @Override
    void recomputePointSum(Integer node) {
        if (((double[][])this.pointSum)[node] == null) {
            ((double[][])this.pointSum)[node.intValue()] = new double[this.pointStore.getDimensions()];
        }
        double[] leftSum = (double[])this.getPointSum(this.getLeftChild(node));
        double[] rightSum = (double[])this.getPointSum(this.getRightChild(node));
        for (int i = 0; i < this.pointStore.getDimensions(); ++i) {
            ((double[][])this.pointSum)[node.intValue()][i] = leftSum[i] + rightSum[i];
        }
    }

    public static class Builder
    extends AbstractCompactRandomCutTree.Builder<Builder> {
        private IPointStoreView<double[]> pointStoreView;

        public Builder pointStore(IPointStoreView<double[]> pointStoreView) {
            this.pointStoreView = pointStoreView;
            return this;
        }

        public CompactRandomCutTreeDouble build() {
            if (this.pointStoreView == null) {
                throw new IllegalArgumentException("pointstore cannot be null for compact trees");
            }
            this.precision = Precision.FLOAT_64;
            return new CompactRandomCutTreeDouble(this);
        }
    }
}

