/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.tree;

import com.amazon.randomcutforest.CommonUtils;
import com.amazon.randomcutforest.store.INodeStore;
import com.amazon.randomcutforest.tree.AbstractBoundingBox;
import com.amazon.randomcutforest.tree.AbstractCompactRandomCutTree;
import com.amazon.randomcutforest.tree.IBoundingBoxView;
import com.amazon.randomcutforest.tree.IBoxCache;
import com.amazon.randomcutforest.tree.INode;
import java.util.Collections;
import java.util.Set;

public class CompactNodeView<Point>
implements INode<Integer> {
    final AbstractCompactRandomCutTree<Point> tree;
    int currentNodeOffset;
    IBoxCache<Point> boxCache;
    INodeStore nodeStore;

    public CompactNodeView(AbstractCompactRandomCutTree<Point> tree, int initialNodeIndex) {
        this.tree = tree;
        this.currentNodeOffset = initialNodeIndex;
        this.boxCache = tree.boxCache;
        this.nodeStore = tree.nodeStore;
    }

    @Override
    public int getMass() {
        return this.nodeStore.getMass(this.currentNodeOffset);
    }

    @Override
    public IBoundingBoxView getBoundingBox() {
        return this.getBox(this.currentNodeOffset);
    }

    IBoundingBoxView getBox(int node) {
        AbstractBoundingBox<Point> box;
        if (!this.nodeStore.isLeaf(node) && (box = this.boxCache.getBox(node)) != null) {
            return box;
        }
        return this.tree.getBoundingBox(node);
    }

    @Override
    public IBoundingBoxView getSiblingBoundingBox(double[] point) {
        if (this.tree.leftOf(point, this.currentNodeOffset)) {
            return this.getBox(this.nodeStore.getRightIndex(this.currentNodeOffset));
        }
        return this.getBox(this.nodeStore.getLeftIndex(this.currentNodeOffset));
    }

    @Override
    public int getCutDimension() {
        return this.nodeStore.getCutDimension(this.currentNodeOffset);
    }

    @Override
    public double getCutValue() {
        return this.nodeStore.getCutValue(this.currentNodeOffset);
    }

    @Override
    public double[] getLeafPoint() {
        return this.tree.projectToTree(this.tree.getPoint(this.currentNodeOffset));
    }

    @Override
    public double[] getLiftedLeafPoint() {
        return this.tree.getPoint(this.currentNodeOffset);
    }

    @Override
    public Set<Long> getSequenceIndexes() {
        CommonUtils.checkArgument(this.nodeStore.isLeaf(this.currentNodeOffset), " not a leaf node");
        return this.tree.storeSequenceIndexesEnabled ? this.tree.sequenceIndexes[this.nodeStore.computeLeafIndex(this.currentNodeOffset)].keySet() : Collections.emptySet();
    }

    @Override
    public boolean isLeaf() {
        return this.nodeStore.isLeaf(this.currentNodeOffset);
    }

    @Override
    public INode<Integer> getLeftChild() {
        return new CompactNodeView<Point>(this.tree, this.nodeStore.getLeftIndex(this.currentNodeOffset));
    }

    @Override
    public INode<Integer> getRightChild() {
        return new CompactNodeView<Point>(this.tree, this.nodeStore.getRightIndex(this.currentNodeOffset));
    }

    @Override
    public INode<Integer> getParent() {
        return new CompactNodeView<Point>(this.tree, this.nodeStore.getParentIndex(this.currentNodeOffset));
    }
}

