/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.tree;

import com.amazon.randomcutforest.CommonUtils;
import com.amazon.randomcutforest.tree.BoundingBoxFloat;
import com.amazon.randomcutforest.tree.BoxCache;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Random;

public class BoxCacheFloat
extends BoxCache<float[]> {
    public BoxCacheFloat(long seed, double cacheFraction, int maxSize) {
        super(seed, cacheFraction, maxSize);
    }

    @Override
    void initialize() {
        this.random = new Random(this.randomSeed);
        if (this.cacheFraction < 1.0 && this.cacheFraction > 0.0) {
            if (this.isDirectMap()) {
                this.bitSet = new BitSet(this.maxSize);
                this.cachedBoxes = new BoundingBoxFloat[this.maxSize];
                int exclude = (int)Math.floor((1.0 - this.cacheFraction) * (double)this.maxSize);
                for (int i = 0; i < exclude; ++i) {
                    this.bitSet.set(this.random.nextInt(this.maxSize));
                }
            } else {
                this.cacheMap = new HashMap();
                int include = (int)Math.ceil(this.cacheFraction * (double)this.maxSize);
                this.cachedBoxes = new BoundingBoxFloat[include];
                int count = 0;
                for (int i = 0; i < include; ++i) {
                    this.cacheMap.put(this.random.nextInt(this.maxSize), count++);
                }
            }
        } else if (this.cacheFraction == 1.0) {
            this.cachedBoxes = new BoundingBoxFloat[this.maxSize];
        } else if (this.cacheFraction == 0.0) {
            this.cachedBoxes = null;
        }
    }

    @Override
    void remap(int[] map) {
        CommonUtils.checkArgument(this.isDirectMap(), "incorrect invocation of remap");
        BoundingBoxFloat[] newArray = new BoundingBoxFloat[this.maxSize];
        for (int i = 0; i < this.maxSize; ++i) {
            if (map[i] == -1) continue;
            newArray[map[i]] = (BoundingBoxFloat)this.cachedBoxes[i];
        }
        this.cachedBoxes = newArray;
    }
}

