/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.tree;

import com.amazon.randomcutforest.CommonUtils;
import com.amazon.randomcutforest.tree.BoundingBox;
import com.amazon.randomcutforest.tree.BoxCache;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Random;

public class BoxCacheDouble
extends BoxCache<double[]> {
    public BoxCacheDouble(long seed, double cacheFraction, int maxSize) {
        super(seed, cacheFraction, maxSize);
    }

    @Override
    void initialize() {
        this.random = new Random(this.randomSeed);
        if (this.cacheFraction < 1.0 && this.cacheFraction > 0.0) {
            if (this.isDirectMap()) {
                this.bitSet = new BitSet(this.maxSize);
                this.cachedBoxes = new BoundingBox[this.maxSize];
                int exclude = (int)Math.floor((1.0 - this.cacheFraction) * (double)this.maxSize);
                for (int i = 0; i < exclude; ++i) {
                    this.bitSet.set(this.random.nextInt(this.maxSize));
                }
            } else {
                this.cacheMap = new HashMap();
                int include = (int)Math.ceil(this.cacheFraction * (double)this.maxSize);
                this.cachedBoxes = new BoundingBox[include];
                int count = 0;
                for (int i = 0; i < include; ++i) {
                    this.cacheMap.put(this.random.nextInt(this.maxSize), count++);
                }
            }
        } else if (this.cacheFraction == 1.0) {
            this.cachedBoxes = new BoundingBox[this.maxSize];
        } else if (this.cacheFraction == 0.0) {
            this.cachedBoxes = null;
        }
    }

    @Override
    void remap(int[] map) {
        CommonUtils.checkArgument(this.isDirectMap(), "incorrect invocation of remap");
        BoundingBox[] newArray = new BoundingBox[this.maxSize];
        for (int i = 0; i < this.maxSize; ++i) {
            if (map[i] == -1) continue;
            newArray[map[i]] = (BoundingBox)this.cachedBoxes[i];
        }
        this.cachedBoxes = newArray;
    }
}

